/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import net.optifine.Config;
import net.optifine.config.ConfigUtils;
import net.optifine.shaders.ShadersTextureType;
import net.optifine.shaders.TextureFormatLabPbr;
import net.optifine.texture.IColorBlender;

public interface ITextureFormat {
    public IColorBlender getColorBlender(ShadersTextureType var1);

    public boolean isTextureBlend(ShadersTextureType var1);

    public String getMacroName();

    public String getMacroVersion();

    public static ITextureFormat readConfiguration() {
        if (!Config.isShaders()) {
            return null;
        }
        String formatStr = ConfigUtils.readString("optifine/texture.properties", "format");
        if (formatStr != null) {
            String ver;
            String[] parts = Config.tokenize(formatStr, "/");
            String name = parts[0];
            String string = ver = parts.length > 1 ? parts[1] : null;
            if (name.equals("lab-pbr")) {
                return new TextureFormatLabPbr(ver);
            }
            Config.warn("Unknown texture format: " + formatStr);
            return null;
        }
        return null;
    }
}

