/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_4668;

public class RenderStateManager {
    private static boolean cacheEnabled;
    private static final class_4668[] PENDING_CLEAR_STATES;

    public static void setupRenderStates(List<class_4668> renderStates) {
        if (cacheEnabled) {
            RenderStateManager.setupCached(renderStates);
            return;
        }
        renderStates.forEach(class_4668::method_23516);
    }

    public static void clearRenderStates(List<class_4668> renderStates) {
        if (cacheEnabled) {
            RenderStateManager.clearCached(renderStates);
            return;
        }
        renderStates.forEach(class_4668::method_23518);
    }

    private static void setupCached(List<class_4668> renderStates) {
        for (int i = 0; i < renderStates.size(); ++i) {
            class_4668 state = renderStates.get(i);
            RenderStateManager.setupCached(state, i);
        }
    }

    private static void clearCached(List<class_4668> renderStates) {
        for (int i = 0; i < renderStates.size(); ++i) {
            class_4668 state = renderStates.get(i);
            RenderStateManager.clearCached(state, i);
        }
    }

    private static void setupCached(class_4668 state, int index) {
        class_4668 pendingClearState = PENDING_CLEAR_STATES[index];
        if (pendingClearState != null) {
            if (state == pendingClearState) {
                RenderStateManager.PENDING_CLEAR_STATES[index] = null;
                return;
            }
            pendingClearState.method_23518();
            RenderStateManager.PENDING_CLEAR_STATES[index] = null;
        }
        state.method_23516();
    }

    private static void clearCached(class_4668 state, int index) {
        class_4668 pendingClearState = PENDING_CLEAR_STATES[index];
        if (pendingClearState != null) {
            pendingClearState.method_23518();
        }
        RenderStateManager.PENDING_CLEAR_STATES[index] = state;
    }

    public static void enableCache() {
        if (cacheEnabled) {
            return;
        }
        cacheEnabled = true;
        Arrays.fill(PENDING_CLEAR_STATES, null);
    }

    public static void disableCache() {
        if (!cacheEnabled) {
            return;
        }
        cacheEnabled = false;
        for (int i = 0; i < PENDING_CLEAR_STATES.length; ++i) {
            class_4668 pendingClearState = PENDING_CLEAR_STATES[i];
            if (pendingClearState == null) continue;
            pendingClearState.method_23518();
        }
        Arrays.fill(PENDING_CLEAR_STATES, null);
    }

    static {
        PENDING_CLEAR_STATES = new class_4668[class_1921.getCountRenderStates()];
    }
}

