/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_1093;
import net.minecraft.class_1160;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4970;
import net.minecraft.class_777;
import net.minecraft.class_783;
import net.minecraft.class_787;
import net.minecraft.class_789;
import net.minecraft.class_796;
import net.minecraft.class_806;
import net.minecraft.class_809;
import net.optifine.Config;
import net.optifine.model.BakedQuadRetextured;
import net.optifine.model.ModelUtils;

public class BlockModelUtils {
    private static final float VERTEX_COORD_ACCURACY = 1.0E-6f;
    private static final Random RANDOM = new Random(0L);

    public static class_1087 makeModelCube(String spriteName, int tintIndex) {
        class_1058 sprite = Config.getTextureMap().getUploadedSprite(spriteName);
        return BlockModelUtils.makeModelCube(sprite, tintIndex);
    }

    public static class_1087 makeModelCube(class_1058 sprite, int tintIndex) {
        ArrayList generalQuads = new ArrayList();
        class_2350[] facings = class_2350.field_11040;
        HashMap faceQuads = new HashMap();
        for (int i = 0; i < facings.length; ++i) {
            class_2350 facing = facings[i];
            ArrayList<class_777> quads = new ArrayList<class_777>();
            quads.add(BlockModelUtils.makeBakedQuad(facing, sprite, tintIndex));
            faceQuads.put(facing, quads);
        }
        class_806 itemOverrideList = class_806.field_4292;
        class_1093 bakedModel = new class_1093(generalQuads, faceQuads, true, true, true, sprite, class_809.field_4301, itemOverrideList);
        return bakedModel;
    }

    public static class_1087 joinModelsCube(class_1087 modelBase, class_1087 modelAdd) {
        ArrayList generalQuads = new ArrayList();
        generalQuads.addAll(modelBase.method_4707(null, null, RANDOM));
        generalQuads.addAll(modelAdd.method_4707(null, null, RANDOM));
        class_2350[] facings = class_2350.field_11040;
        HashMap faceQuads = new HashMap();
        for (int i = 0; i < facings.length; ++i) {
            class_2350 facing = facings[i];
            ArrayList quads = new ArrayList();
            quads.addAll(modelBase.method_4707(null, facing, RANDOM));
            quads.addAll(modelAdd.method_4707(null, facing, RANDOM));
            faceQuads.put(facing, quads);
        }
        boolean ao = modelBase.method_4708();
        boolean builtIn = modelBase.method_4713();
        class_1058 sprite = modelBase.method_4711();
        class_809 transforms = modelBase.method_4709();
        class_806 itemOverrideList = modelBase.method_4710();
        class_1093 bakedModel = new class_1093(generalQuads, faceQuads, ao, builtIn, true, sprite, transforms, itemOverrideList);
        return bakedModel;
    }

    public static class_777 makeBakedQuad(class_2350 facing, class_1058 sprite, int tintIndex) {
        class_1160 posFrom = new class_1160(0.0f, 0.0f, 0.0f);
        class_1160 posTo = new class_1160(16.0f, 16.0f, 16.0f);
        class_787 uv = new class_787(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        class_783 face = new class_783(facing, tintIndex, "#" + facing.method_15434(), uv);
        class_1086 modelRotation = class_1086.field_5350;
        class_789 partRotation = null;
        boolean shade = true;
        class_2960 modelLoc = sprite.method_4598();
        class_796 faceBakery = new class_796();
        class_777 quad = faceBakery.method_3468(posFrom, posTo, face, sprite, facing, (class_3665)modelRotation, partRotation, shade, modelLoc);
        return quad;
    }

    public static class_1087 makeModel(String modelName, String spriteOldName, String spriteNewName) {
        class_1059 textureMap = Config.getTextureMap();
        class_1058 spriteOld = textureMap.getUploadedSprite(spriteOldName);
        class_1058 spriteNew = textureMap.getUploadedSprite(spriteNewName);
        return BlockModelUtils.makeModel(modelName, spriteOld, spriteNew);
    }

    public static class_1087 makeModel(String modelName, class_1058 spriteOld, class_1058 spriteNew) {
        if (spriteOld == null || spriteNew == null) {
            return null;
        }
        class_1092 modelManager = Config.getModelManager();
        if (modelManager == null) {
            return null;
        }
        class_1091 mrl = new class_1091(modelName, "");
        class_1087 model = modelManager.method_4742(mrl);
        if (model == null || model == modelManager.method_4744()) {
            return null;
        }
        class_1087 modelNew = ModelUtils.duplicateModel(model);
        class_2350[] faces = class_2350.field_11040;
        for (int i = 0; i < faces.length; ++i) {
            class_2350 face = faces[i];
            List quads = modelNew.method_4707(null, face, RANDOM);
            BlockModelUtils.replaceTexture(quads, spriteOld, spriteNew);
        }
        List quadsGeneral = modelNew.method_4707(null, null, RANDOM);
        BlockModelUtils.replaceTexture(quadsGeneral, spriteOld, spriteNew);
        return modelNew;
    }

    private static void replaceTexture(List<class_777> quads, class_1058 spriteOld, class_1058 spriteNew) {
        ArrayList<class_777> quadsNew = new ArrayList<class_777>();
        for (class_777 quad : quads) {
            if (quad.method_35788() == spriteOld) {
                quad = new BakedQuadRetextured(quad, spriteNew);
            }
            quadsNew.add(quad);
        }
        quads.clear();
        quads.addAll(quadsNew);
    }

    public static void snapVertexPosition(class_1160 pos) {
        pos.method_4949(BlockModelUtils.snapVertexCoord(pos.method_4943()), BlockModelUtils.snapVertexCoord(pos.method_4945()), BlockModelUtils.snapVertexCoord(pos.method_4947()));
    }

    private static float snapVertexCoord(float x) {
        if (x > -1.0E-6f && x < 1.0E-6f) {
            return 0.0f;
        }
        if (x > 0.999999f && x < 1.000001f) {
            return 1.0f;
        }
        return x;
    }

    public static class_238 getOffsetBoundingBox(class_238 aabb, class_4970.class_2250 offsetType, class_2338 pos) {
        int x = pos.method_10263();
        int z = pos.method_10260();
        long k = (long)(x * 3129871) ^ (long)z * 116129781L;
        k = k * k * 42317861L + k * 11L;
        double dx = ((double)((float)(k >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dz = ((double)((float)(k >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dy = 0.0;
        if (offsetType == class_4970.class_2250.field_10655) {
            dy = ((double)((float)(k >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        }
        return aabb.method_989(dx, dy, dz);
    }
}

