/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model.anim;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_2586;
import net.minecraft.class_2741;
import net.minecraft.class_310;
import net.minecraft.class_759;
import net.minecraft.class_824;
import net.minecraft.class_898;
import net.minecraft.class_918;
import net.optifine.expr.IExpressionBool;
import net.optifine.reflect.Reflector;
import net.optifine.util.BlockUtils;

public enum RenderEntityParameterBool implements IExpressionBool
{
    IS_ALIVE("is_alive"),
    IS_BURNING("is_burning"),
    IS_CHILD("is_child"),
    IS_GLOWING("is_glowing"),
    IS_HURT("is_hurt"),
    IS_IN_HAND("is_in_hand", true),
    IS_IN_GROUND("is_in_ground"),
    IS_IN_GUI("is_in_gui", true),
    IS_IN_LAVA("is_in_lava"),
    IS_IN_WATER("is_in_water", true),
    IS_INVISIBLE("is_invisible"),
    IS_ON_GROUND("is_on_ground"),
    IS_RIDDEN("is_ridden"),
    IS_RIDING("is_riding"),
    IS_SNEAKING("is_sneaking"),
    IS_SPRINTING("is_sprinting"),
    IS_WET("is_wet");

    private String name;
    private boolean blockEntity;
    private class_898 renderManager;
    private static final RenderEntityParameterBool[] VALUES;

    private RenderEntityParameterBool(String name) {
        this(name, false);
    }

    private RenderEntityParameterBool(String name, boolean blockEntity) {
        this.name = name;
        this.blockEntity = blockEntity;
        this.renderManager = class_310.method_1551().method_1561();
    }

    public String getName() {
        return this.name;
    }

    public boolean isBlockEntity() {
        return this.blockEntity;
    }

    @Override
    public boolean eval() {
        class_1297 entity;
        switch (this) {
            case IS_IN_HAND: {
                return class_759.isRenderItemHand();
            }
            case IS_IN_GUI: {
                return class_918.isRenderItemGui();
            }
        }
        class_2586 blockEntity = class_824.tileEntityRendered;
        if (blockEntity != null) {
            switch (this) {
                case IS_IN_WATER: {
                    return BlockUtils.isPropertyTrue(blockEntity.method_11010(), class_2741.field_12508);
                }
            }
        }
        if ((entity = this.renderManager.renderEntity) == null) {
            return false;
        }
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            switch (this) {
                case IS_CHILD: {
                    return livingEntity.method_6109();
                }
                case IS_HURT: {
                    return livingEntity.field_6235 > 0;
                }
            }
        }
        if (entity instanceof class_1665) {
            class_1665 arrowEntity = (class_1665)entity;
            switch (this) {
                case IS_IN_GROUND: {
                    return Reflector.getFieldValueBoolean(arrowEntity, Reflector.AbstractArrow_inGround, false);
                }
            }
        }
        switch (this) {
            case IS_ALIVE: {
                return entity.method_5805();
            }
            case IS_BURNING: {
                return entity.method_5809();
            }
            case IS_GLOWING: {
                return entity.method_36361();
            }
            case IS_IN_LAVA: {
                return entity.method_5771();
            }
            case IS_IN_WATER: {
                return entity.method_5799();
            }
            case IS_INVISIBLE: {
                return entity.method_5767();
            }
            case IS_ON_GROUND: {
                return entity.method_24828();
            }
            case IS_RIDDEN: {
                return entity.method_5782();
            }
            case IS_RIDING: {
                return entity.method_5765();
            }
            case IS_SNEAKING: {
                return entity.method_18276();
            }
            case IS_SPRINTING: {
                return entity.method_5624();
            }
            case IS_WET: {
                return entity.method_5721();
            }
        }
        return false;
    }

    public static RenderEntityParameterBool parse(String str) {
        if (str == null) {
            return null;
        }
        for (int i = 0; i < VALUES.length; ++i) {
            RenderEntityParameterBool type = VALUES[i];
            if (!type.getName().equals(str)) continue;
            return type;
        }
        return null;
    }

    static {
        VALUES = RenderEntityParameterBool.values();
    }
}

