/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.IndigoRenderer;
import net.fabricmc.fabric.impl.client.indigo.renderer.RenderMaterialImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.EncodingFormat;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MeshImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractQuadRenderer;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractRenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_325;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_777;
import net.minecraft.class_809;
import net.minecraft.class_918;

public class ItemRenderContext
extends AbstractRenderContext
implements RenderContext {
    private static final long ITEM_RANDOM_SEED = 42L;
    private final class_325 colorMap;
    private final Random random = new Random();
    private final Consumer<class_1087> fallbackConsumer;
    private final class_1160 normalVec = new class_1160();
    private class_4587 matrixStack;
    private class_1159 matrix;
    private class_4597 vertexConsumerProvider;
    private class_4588 modelVertexConsumer;
    private BlendMode quadBlendMode;
    private class_4588 quadVertexConsumer;
    private class_809.class_811 transformMode;
    private int lightmap;
    private int overlay;
    private class_1799 itemStack;
    private VanillaQuadHandler vanillaHandler;
    private final Supplier<Random> randomSupplier = () -> {
        Random result = this.random;
        result.setSeed(42L);
        return this.random;
    };
    private final int[] quadData = new int[EncodingFormat.TOTAL_STRIDE];
    private final Maker editorQuad = new Maker();
    private final Consumer<Mesh> meshConsumer = mesh -> {
        MeshImpl m = (MeshImpl)mesh;
        int[] data = m.data();
        int limit = data.length;
        for (int index = 0; index < limit; index += EncodingFormat.TOTAL_STRIDE) {
            System.arraycopy(data, index, this.editorQuad.data(), 0, EncodingFormat.TOTAL_STRIDE);
            this.editorQuad.load();
            this.renderQuad();
        }
    };

    public ItemRenderContext(class_325 colorMap) {
        this.colorMap = colorMap;
        this.fallbackConsumer = this::fallbackConsumer;
    }

    public void renderModel(class_1799 itemStack, class_809.class_811 transformMode, boolean invert, class_4587 matrixStack, class_4597 vertexConsumerProvider, int lightmap, int overlay, FabricBakedModel model, VanillaQuadHandler vanillaHandler) {
        this.lightmap = lightmap;
        this.overlay = overlay;
        this.itemStack = itemStack;
        this.vertexConsumerProvider = vertexConsumerProvider;
        this.matrixStack = matrixStack;
        this.transformMode = transformMode;
        this.vanillaHandler = vanillaHandler;
        this.quadBlendMode = BlendMode.DEFAULT;
        this.modelVertexConsumer = this.selectVertexConsumer(class_4696.method_23678((class_1799)itemStack, (transformMode != class_809.class_811.field_4318 ? 1 : 0) != 0));
        matrixStack.method_22903();
        ((class_1087)model).method_4709().method_3503(transformMode).method_23075(invert, matrixStack);
        matrixStack.method_22904(-0.5, -0.5, -0.5);
        this.matrix = matrixStack.method_23760().method_23761();
        this.normalMatrix = matrixStack.method_23760().method_23762();
        model.emitItemQuads(itemStack, this.randomSupplier, (RenderContext)this);
        matrixStack.method_22909();
        this.matrixStack = null;
        this.itemStack = null;
        this.vanillaHandler = null;
        this.modelVertexConsumer = null;
    }

    private class_4588 selectVertexConsumer(class_1921 layerIn) {
        class_1921 layer = this.transformMode == class_809.class_811.field_4317 ? class_4722.method_24076() : layerIn;
        return class_918.method_27952((class_4597)this.vertexConsumerProvider, (class_1921)layer, (boolean)true, (boolean)this.itemStack.method_7958());
    }

    private int indexColor() {
        int colorIndex = this.editorQuad.colorIndex();
        return colorIndex == -1 ? -1 : this.colorMap.method_1704(this.itemStack, colorIndex) | 0xFF000000;
    }

    private void renderQuad() {
        Maker quad = this.editorQuad;
        if (!this.transform((MutableQuadView)this.editorQuad)) {
            return;
        }
        RenderMaterialImpl.Value mat = quad.material();
        int quadColor = mat.disableColorIndex(0) ? -1 : this.indexColor();
        int lightmap = mat.emissive(0) ? 0xF000F0 : this.lightmap;
        for (int i = 0; i < 4; ++i) {
            int c = quad.spriteColor(i, 0);
            c = ColorHelper.multiplyColor(quadColor, c);
            quad.spriteColor(i, 0, ColorHelper.swapRedBlueIfNeeded(c));
            quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), lightmap));
        }
        AbstractQuadRenderer.bufferQuad(this.quadVertexConsumer(mat.blendMode(0)), quad, this.matrix, this.overlay, this.normalMatrix, this.normalVec);
    }

    private class_4588 quadVertexConsumer(BlendMode blendMode) {
        if (blendMode == BlendMode.DEFAULT) {
            return this.modelVertexConsumer;
        }
        if (blendMode != BlendMode.TRANSLUCENT) {
            blendMode = BlendMode.CUTOUT;
        }
        if (blendMode == this.quadBlendMode) {
            return this.quadVertexConsumer;
        }
        if (blendMode == BlendMode.TRANSLUCENT) {
            this.quadVertexConsumer = this.selectVertexConsumer(class_4722.method_24076());
            this.quadBlendMode = BlendMode.TRANSLUCENT;
        } else {
            this.quadVertexConsumer = this.selectVertexConsumer(class_4722.method_24074());
            this.quadBlendMode = BlendMode.CUTOUT;
        }
        return this.quadVertexConsumer;
    }

    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    private void fallbackConsumer(class_1087 model) {
        if (this.hasTransform()) {
            for (int i = 0; i <= 6; ++i) {
                this.random.setSeed(42L);
                class_2350 cullFace = ModelHelper.faceFromIndex((int)i);
                this.renderFallbackWithTransform(model.method_4707((class_2680)null, cullFace, this.random), cullFace);
            }
        } else {
            for (int i = 0; i <= 6; ++i) {
                this.vanillaHandler.accept(model, this.itemStack, this.lightmap, this.overlay, this.matrixStack, this.modelVertexConsumer);
            }
        }
    }

    private void renderFallbackWithTransform(List<class_777> quads, class_2350 cullFace) {
        if (quads.isEmpty()) {
            return;
        }
        Maker editorQuad = this.editorQuad;
        for (class_777 q : quads) {
            editorQuad.fromVanilla(q, IndigoRenderer.MATERIAL_STANDARD, cullFace);
            this.renderQuad();
        }
    }

    public Consumer<class_1087> fallbackConsumer() {
        return this.fallbackConsumer;
    }

    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    private class Maker
    extends MutableQuadViewImpl
    implements QuadEmitter {
        private Maker() {
            this.data = ItemRenderContext.this.quadData;
            this.clear();
        }

        public Maker emit() {
            this.computeGeometry();
            ItemRenderContext.this.renderQuad();
            this.clear();
            return this;
        }
    }

    @FunctionalInterface
    public static interface VanillaQuadHandler {
        public void accept(class_1087 var1, class_1799 var2, int var3, int var4, class_4587 var5, class_4588 var6);
    }
}

