/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar.resource;

import com.google.gson.annotations.Expose;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_897;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;

public class EntityIconDefinition {
    public static final class_2960 MODEL_TYPE = new class_2960("xaerominimap", "entity/icon/model");
    public static final class_2960 DOT_TYPE = new class_2960("xaerominimap", "entity/icon/dot");
    @Expose
    private HashMap<String, String> variants;
    @Expose
    private ArrayList<EntityIconModelConfig> modelConfigs;
    private HashMap<String, class_2960> variantTypes;
    private HashMap<String, EntityIconModelConfig> variantModelConfigs;
    @Expose
    private String variantIdBuilderMethod;
    private Method variantIdBuilderMethodReflect;
    @Expose
    private String variantIdMethod;
    private Method variantIdMethodReflect;

    public class_2960 getVariantType(String variantId) {
        if (this.variantTypes == null) {
            return MODEL_TYPE;
        }
        return this.variantTypes.get(variantId);
    }

    public EntityIconModelConfig getModelConfig(String variantId) {
        if (this.variantModelConfigs == null) {
            return null;
        }
        return this.variantModelConfigs.get(variantId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onConstruct(class_2960 entityId) {
        if (this.variantIdBuilderMethod != null) {
            this.variantIdBuilderMethodReflect = this.convertStringToMethod(this.variantIdBuilderMethod, entityId.toString(), "variant ID builder", Void.TYPE, StringBuilder.class, class_897.class, class_1297.class);
        }
        if (this.variantIdMethod != null) {
            this.variantIdMethodReflect = this.convertStringToMethod(this.variantIdMethod, entityId.toString(), "variant ID", String.class, class_897.class, class_1297.class);
        }
        if (this.variants == null) {
            this.variants = new HashMap();
        }
        if (this.variants.get("default") == null) {
            this.variants.put("default", "model");
        }
        Iterator<Map.Entry<String, String>> iterator = this.variants.entrySet().iterator();
        while (true) {
            class_2960 type;
            Map.Entry<String, String> entry;
            block17: {
                block18: {
                    String iconType;
                    String[] valueSplit;
                    String value;
                    block20: {
                        block19: {
                            if (!iterator.hasNext()) {
                                return;
                            }
                            entry = iterator.next();
                            value = entry.getValue();
                            if (value.equals("model")) break block18;
                            valueSplit = value.split(":");
                            iconType = valueSplit[0];
                            if (!iconType.equals("sprite")) break block19;
                            if (valueSplit.length != 2) {
                                System.out.println("Skipping invalid icon type: " + value + " for " + entityId);
                                continue;
                            }
                            type = new class_2960("xaerominimap", "entity/icon/sprite/" + valueSplit[1]);
                            break block17;
                        }
                        if (!iconType.equals("dot")) break block20;
                        if (valueSplit.length != 1) {
                            System.out.println("Skipping invalid icon type: " + value + " for " + entityId);
                            continue;
                        }
                        type = DOT_TYPE;
                        break block17;
                    }
                    if (iconType.equals("model")) {
                        EntityIconModelConfig referencedModelConfig;
                        if (valueSplit.length != 2) {
                            System.out.println("Skipping invalid icon type: " + value + " for " + entityId);
                            continue;
                        }
                        type = MODEL_TYPE;
                        int configIndex = 0;
                        try {
                            configIndex = Integer.parseInt(valueSplit[1]);
                        }
                        catch (NumberFormatException nfe) {
                            nfe.printStackTrace();
                        }
                        EntityIconModelConfig entityIconModelConfig = referencedModelConfig = this.modelConfigs != null && configIndex >= 0 && configIndex < this.modelConfigs.size() ? this.modelConfigs.get(configIndex) : null;
                        if (referencedModelConfig == null) {
                            System.out.println("Specified model config is not defined: " + value + " for " + entityId);
                            break block17;
                        } else {
                            if (this.variantModelConfigs == null) {
                                this.variantModelConfigs = new HashMap();
                            }
                            this.variantModelConfigs.put(entry.getKey(), referencedModelConfig);
                        }
                        break block17;
                    } else {
                        System.out.println("Skipping invalid icon type: " + value + " for " + entityId);
                        continue;
                    }
                }
                type = MODEL_TYPE;
            }
            if (this.variantTypes == null) {
                this.variantTypes = new HashMap();
            }
            this.variantTypes.put(entry.getKey(), type);
        }
    }

    public String getVariantIdBuilderMethodString() {
        return this.variantIdBuilderMethod;
    }

    public Method getVariantIdBuilderMethod() {
        return this.variantIdBuilderMethodReflect;
    }

    public void setVariantIdBuilderMethod(Method variantIdBuilderMethodReflect) {
        this.variantIdBuilderMethodReflect = variantIdBuilderMethodReflect;
    }

    private Method convertStringToMethod(String methodPath, String entityId, String methodDisplayName, Class<?> returnType, Class<?> ... parameterTypes) {
        Method result = null;
        if (methodPath != null) {
            int lastDot = methodPath.lastIndexOf(46);
            String classPath = methodPath.substring(0, lastDot);
            String methodName = methodPath.substring(lastDot + 1);
            try {
                Class<?> c = Class.forName(classPath);
                result = c.getDeclaredMethod(methodName, parameterTypes);
                if (result.getReturnType() != returnType) {
                    System.out.println(String.format("The return type of the %s method for %s is not %s. Can't use it.", methodDisplayName, entityId, returnType));
                    result = null;
                }
            }
            catch (Exception e) {
                System.out.println(String.format("Could not find %s method %s defined for %s", methodDisplayName, this.variantIdBuilderMethod, entityId));
                e.printStackTrace();
            }
        }
        return result;
    }

    public String getOldVariantIdMethodString() {
        return this.variantIdMethod;
    }

    public Method getOldVariantIdMethod() {
        return this.variantIdMethodReflect;
    }

    public void setOldVariantIdMethod(Method variantIdMethodReflect) {
        this.variantIdMethodReflect = variantIdMethodReflect;
    }
}

