/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.lookup.block;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerBlockEntityEvents;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.impl.lookup.block.BlockApiLookupImpl;
import net.fabricmc.fabric.impl.lookup.block.ServerWorldCache;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public final class BlockApiCacheImpl<A, C>
implements BlockApiCache<A, C> {
    private final BlockApiLookupImpl<A, C> lookup;
    private final class_3218 world;
    private final class_2338 pos;
    private boolean blockEntityCacheValid = false;
    private class_2586 cachedBlockEntity = null;
    private class_2680 lastState = null;
    private BlockApiLookup.BlockApiProvider<A, C> cachedProvider = null;

    public BlockApiCacheImpl(BlockApiLookupImpl<A, C> lookup, class_3218 world, class_2338 pos) {
        ((ServerWorldCache)world).fabric_registerCache(pos, this);
        this.lookup = lookup;
        this.world = world;
        this.pos = pos.method_10062();
    }

    public void invalidate() {
        this.blockEntityCacheValid = false;
        this.cachedBlockEntity = null;
        this.lastState = null;
        this.cachedProvider = null;
    }

    @Override
    @Nullable
    public A find(@Nullable class_2680 state, C context) {
        if (!this.blockEntityCacheValid) {
            this.cachedBlockEntity = this.world.method_8321(this.pos);
            this.blockEntityCacheValid = true;
        }
        if (state == null) {
            state = this.cachedBlockEntity != null ? this.cachedBlockEntity.method_11010() : this.world.method_8320(this.pos);
        }
        if (this.lastState != state) {
            this.cachedProvider = this.lookup.getProvider(state.method_26204());
            this.lastState = state;
        }
        A instance = null;
        if (this.cachedProvider != null) {
            instance = this.cachedProvider.find((class_1937)this.world, this.pos, state, this.cachedBlockEntity, context);
        }
        if (instance != null) {
            return instance;
        }
        for (BlockApiLookup.BlockApiProvider<A, C> fallbackProvider : this.lookup.getFallbackProviders()) {
            instance = fallbackProvider.find((class_1937)this.world, this.pos, state, this.cachedBlockEntity, context);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    static {
        ServerBlockEntityEvents.BLOCK_ENTITY_LOAD.register((blockEntity, world) -> ((ServerWorldCache)world).fabric_invalidateCache(blockEntity.method_11016()));
        ServerBlockEntityEvents.BLOCK_ENTITY_UNLOAD.register((blockEntity, world) -> ((ServerWorldCache)world).fabric_invalidateCache(blockEntity.method_11016()));
    }
}

