/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.PngInfo;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SpriteCoordinateExpander;
import net.minecraft.client.renderer.texture.MipmapGenerator;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.client.extensions.IForgeTextureAtlasSprite;
import net.optifine.Config;
import net.optifine.SmartAnimations;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersTextureType;
import net.optifine.texture.IColorBlender;
import net.optifine.util.CounterInt;
import net.optifine.util.TextureUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureAtlasSprite
implements AutoCloseable,
IForgeTextureAtlasSprite {
    private static final Logger f_211646_ = LogManager.getLogger();
    private final TextureAtlas f_118343_;
    private final ResourceLocation f_211647_;
    final int f_211648_;
    final int f_211649_;
    protected final NativeImage[] f_118342_;
    @Nullable
    private final AnimatedTexture f_211650_;
    private final int f_118349_;
    private final int f_118350_;
    private final float f_118351_;
    private final float f_118352_;
    private final float f_118353_;
    private final float f_118354_;
    private int indexInMap = -1;
    public float baseU;
    public float baseV;
    public int sheetWidth;
    public int sheetHeight;
    public int glSpriteTextureId = -1;
    public TextureAtlasSprite spriteSingle = null;
    public boolean isSpriteSingle = false;
    public static final String SUFFIX_SPRITE_SINGLE = ".sprite_single";
    public int mipmapLevels = 0;
    public TextureAtlasSprite spriteNormal = null;
    public TextureAtlasSprite spriteSpecular = null;
    public ShadersTextureType spriteShadersType = null;
    public TextureAtlasSprite spriteEmissive = null;
    public boolean isSpriteEmissive = false;
    private int animationIndex = -1;
    private boolean animationActive = false;
    private boolean usesParentAnimationTime = false;
    private boolean terrain;
    private boolean shaders;
    private boolean multiTexture;
    private ResourceManager resourceManager;
    private final int imageWidth;
    private final int imageHeight;
    private final AnimationMetadataSection animationMetadata;

    public TextureAtlasSprite(ResourceLocation name) {
        this.f_118343_ = null;
        this.f_211647_ = name;
        this.f_211648_ = 0;
        this.f_211649_ = 0;
        this.animationMetadata = null;
        this.f_118342_ = null;
        this.f_118349_ = 0;
        this.f_118350_ = 0;
        this.f_118351_ = 0.0f;
        this.f_118352_ = 0.0f;
        this.f_118353_ = 0.0f;
        this.f_118354_ = 0.0f;
        this.f_211650_ = null;
        this.imageWidth = 0;
        this.imageHeight = 0;
    }

    private TextureAtlasSprite(TextureAtlasSprite parent) {
        this.f_118343_ = parent.f_118343_;
        this.f_211647_ = parent.m_118413_();
        this.f_211648_ = parent.m_118405_();
        this.f_211649_ = parent.m_118408_();
        this.imageWidth = parent.imageWidth;
        this.imageHeight = parent.imageHeight;
        this.animationMetadata = parent.animationMetadata;
        this.usesParentAnimationTime = true;
        this.f_118342_ = parent.f_118342_;
        Info info = new Info(this.f_211647_, this.f_211648_, this.f_211649_, this.animationMetadata);
        this.f_211650_ = this.m_211669_(info, this.imageWidth, this.imageHeight, parent.mipmapLevels);
        if (this.f_211650_ != null && this.f_211650_.f_211698_ != null && parent.f_211650_ != null && parent.f_211650_.f_211698_ != null) {
            InterpolationData.access$102(this.f_211650_.f_211698_, parent.f_211650_.f_211698_.f_118443_);
        }
        this.f_118349_ = 0;
        this.f_118350_ = 0;
        this.f_118351_ = 0.0f;
        this.f_118352_ = 1.0f;
        this.f_118353_ = 0.0f;
        this.f_118354_ = 1.0f;
        this.indexInMap = parent.indexInMap;
        this.baseU = parent.baseU;
        this.baseV = parent.baseV;
        this.sheetWidth = parent.sheetWidth;
        this.sheetHeight = parent.sheetHeight;
        this.isSpriteSingle = true;
        this.mipmapLevels = parent.mipmapLevels;
        this.animationIndex = parent.animationIndex;
        this.animationActive = parent.animationActive;
    }

    protected TextureAtlasSprite(TextureAtlas atlasTextureIn, Info spriteInfoIn, int mipmapLevelsIn, int atlasWidthIn, int atlasHeightIn, int xIn, int yIn, NativeImage imageIn) {
        this(atlasTextureIn, spriteInfoIn, mipmapLevelsIn, atlasWidthIn, atlasHeightIn, xIn, yIn, imageIn, null);
    }

    protected TextureAtlasSprite(TextureAtlas atlasTextureIn, Info spriteInfoIn, int mipmapLevelsIn, int atlasWidthIn, int atlasHeightIn, int xIn, int yIn, NativeImage imageIn, ShadersTextureType spriteShadersTypeIn) {
        int widthScaled;
        NativeImage imageScaled;
        this.f_118343_ = atlasTextureIn;
        this.f_211648_ = spriteInfoIn.f_118423_;
        this.f_211649_ = spriteInfoIn.f_118424_;
        this.f_211647_ = spriteInfoIn.f_118422_;
        this.imageWidth = imageIn.m_84982_();
        this.imageHeight = imageIn.m_85084_();
        this.animationMetadata = spriteInfoIn.getSpriteAnimationMetadata();
        this.f_118349_ = xIn;
        this.f_118350_ = yIn;
        this.f_118351_ = (float)xIn / (float)atlasWidthIn;
        this.f_118352_ = (float)(xIn + this.f_211648_) / (float)atlasWidthIn;
        this.f_118353_ = (float)yIn / (float)atlasHeightIn;
        this.f_118354_ = (float)(yIn + this.f_211649_) / (float)atlasHeightIn;
        if (spriteInfoIn.scaleFactor > 1.0 && (imageScaled = TextureUtils.scaleImage((NativeImage)imageIn, (int)(widthScaled = (int)Math.round((double)imageIn.m_84982_() * spriteInfoIn.scaleFactor)))) != imageIn) {
            imageIn.close();
            imageIn = imageScaled;
        }
        this.spriteShadersType = spriteShadersTypeIn;
        IColorBlender colorBlender = this.f_118343_.getShadersColorBlender(this.spriteShadersType);
        if (this.spriteShadersType == null && !spriteInfoIn.m_118431_().m_135815_().endsWith("_leaves")) {
            this.fixTransparentColor(imageIn);
        }
        NativeImage imageInF = imageIn;
        this.f_211650_ = this.m_211669_(spriteInfoIn, imageIn.m_84982_(), imageIn.m_85084_(), mipmapLevelsIn);
        try {
            try {
                this.f_118342_ = MipmapGenerator.generateMipmaps(imageIn, mipmapLevelsIn, colorBlender);
            }
            catch (Throwable throwable) {
                CrashReport crashreport1 = CrashReport.m_127521_(throwable, "Generating mipmaps for frame");
                CrashReportCategory crashreportcategory1 = crashreport1.m_127514_("Frame being iterated");
                crashreportcategory1.m_128165_("First frame", () -> {
                    StringBuilder stringbuilder = new StringBuilder();
                    if (stringbuilder.length() > 0) {
                        stringbuilder.append(", ");
                    }
                    stringbuilder.append(imageInF.m_84982_()).append("x").append(imageInF.m_85084_());
                    return stringbuilder.toString();
                });
                throw new ReportedException(crashreport1);
            }
        }
        catch (Throwable throwable1) {
            CrashReport crashreport = CrashReport.m_127521_(throwable1, "Applying mipmap");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Sprite being mipmapped");
            crashreportcategory.m_128165_("Sprite name", this.f_211647_::toString);
            crashreportcategory.m_128165_("Sprite size", () -> this.f_211648_ + " x " + this.f_211649_);
            crashreportcategory.m_128165_("Sprite frames", () -> this.m_118415_() + " frames");
            crashreportcategory.m_128159_("Mipmap levels", (Object)mipmapLevelsIn);
            throw new ReportedException(crashreport);
        }
        this.mipmapLevels = mipmapLevelsIn;
        this.baseU = Math.min(this.f_118351_, this.f_118352_);
        this.baseV = Math.min(this.f_118353_, this.f_118354_);
        this.sheetWidth = atlasWidthIn;
        this.sheetHeight = atlasHeightIn;
    }

    private int m_118415_() {
        return this.f_211650_ != null ? this.f_211650_.f_211696_.size() : 1;
    }

    @Nullable
    private AnimatedTexture m_211669_(Info infoIn, int widthIn, int heightIn, int mipmapsIn) {
        AnimationMetadataSection animationmetadatasection = infoIn.f_118425_;
        int i = widthIn / animationmetadatasection.m_119031_(infoIn.f_118423_);
        int j = heightIn / animationmetadatasection.m_119026_(infoIn.f_118424_);
        int k = i * j;
        ArrayList list = Lists.newArrayList();
        animationmetadatasection.m_212078_((indexIn, timeIn) -> list.add(new FrameInfo(indexIn, timeIn)));
        if (list.isEmpty()) {
            for (int l = 0; l < k; ++l) {
                list.add(new FrameInfo(l, animationmetadatasection.m_119030_()));
            }
        } else {
            int i1 = 0;
            IntOpenHashSet intset = new IntOpenHashSet();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FrameInfo textureatlassprite$frameinfo = (FrameInfo)iterator.next();
                boolean flag = true;
                if (textureatlassprite$frameinfo.f_211736_ <= 0) {
                    f_211646_.warn("Invalid frame duration on sprite {} frame {}: {}", (Object)this.f_211647_, (Object)i1, (Object)textureatlassprite$frameinfo.f_211736_);
                    flag = false;
                }
                if (textureatlassprite$frameinfo.f_211735_ < 0 || textureatlassprite$frameinfo.f_211735_ >= k) {
                    f_211646_.warn("Invalid frame index on sprite {} frame {}: {}", (Object)this.f_211647_, (Object)i1, (Object)textureatlassprite$frameinfo.f_211735_);
                    flag = false;
                }
                if (flag) {
                    intset.add(textureatlassprite$frameinfo.f_211735_);
                } else {
                    iterator.remove();
                }
                ++i1;
            }
            int[] aint = IntStream.range(0, k).filter(arg_0 -> TextureAtlasSprite.lambda$createTicker$4((IntSet)intset, arg_0)).toArray();
            if (aint.length > 0) {
                f_211646_.warn("Unused frames in sprite {}: {}", (Object)this.f_211647_, (Object)Arrays.toString(aint));
            }
        }
        if (list.size() <= 1) {
            return null;
        }
        InterpolationData textureatlassprite$interpolationdata = animationmetadatasection.m_119036_() ? new InterpolationData(infoIn, mipmapsIn) : null;
        return new AnimatedTexture((List<FrameInfo>)ImmutableList.copyOf((Collection)list), i, textureatlassprite$interpolationdata);
    }

    void m_118375_(int xOffsetIn, int yOffsetIn, NativeImage[] framesIn) {
        boolean blur = false;
        boolean clamp = this.isSpriteSingle;
        for (int i = 0; i < framesIn.length && this.m_118405_() >> i > 0 && this.m_118408_() >> i > 0; ++i) {
            framesIn[i].m_85003_(i, this.f_118349_ >> i, this.f_118350_ >> i, xOffsetIn >> i, yOffsetIn >> i, this.f_211648_ >> i, this.f_211649_ >> i, framesIn.length > 1, false);
        }
    }

    public int m_316689_() {
        return this.f_118349_;
    }

    public int m_316690_() {
        return this.f_118350_;
    }

    public int m_118405_() {
        return this.f_211648_;
    }

    public int m_118408_() {
        return this.f_211649_;
    }

    public float m_118409_() {
        return this.f_118351_;
    }

    public float m_118410_() {
        return this.f_118352_;
    }

    public float m_118367_(double u) {
        float f = this.f_118352_ - this.f_118351_;
        return this.f_118351_ + f * (float)u / 16.0f;
    }

    public float m_316685_(float u) {
        float f = this.f_118352_ - this.f_118351_;
        return (u - this.f_118351_) / f * 16.0f;
    }

    public float m_118411_() {
        return this.f_118353_;
    }

    public float m_118412_() {
        return this.f_118354_;
    }

    public float m_118393_(double v) {
        float f = this.f_118354_ - this.f_118353_;
        return this.f_118353_ + f * (float)v / 16.0f;
    }

    public float m_316687_(float v) {
        float f = this.f_118354_ - this.f_118353_;
        return (v - this.f_118353_) / f * 16.0f;
    }

    public ResourceLocation m_118413_() {
        return this.f_211647_;
    }

    public TextureAtlas m_118414_() {
        return this.f_118343_;
    }

    public IntStream m_211691_() {
        return this.f_211650_ != null ? this.f_211650_.m_211720_() : IntStream.of(1);
    }

    @Override
    public void close() {
        for (NativeImage nativeimage : this.f_118342_) {
            if (nativeimage == null) continue;
            nativeimage.close();
        }
        if (this.f_211650_ != null) {
            this.f_211650_.close();
        }
        if (this.spriteSingle != null) {
            // empty if block
        }
        if (this.spriteNormal != null) {
            this.spriteNormal.close();
        }
        if (this.spriteSpecular != null) {
            this.spriteSpecular.close();
        }
    }

    public String toString() {
        return "TextureAtlasSprite{name='" + this.f_211647_ + "', frameCount=" + this.m_118415_() + ", x=" + this.f_118349_ + ", y=" + this.f_118350_ + ", height=" + this.f_211649_ + ", width=" + this.f_211648_ + ", u0=" + this.f_118351_ + ", u1=" + this.f_118352_ + ", v0=" + this.f_118353_ + ", v1=" + this.f_118354_ + "}";
    }

    public boolean m_118371_(int frameIndex, int pixelX, int pixelY) {
        int i = pixelX;
        int j = pixelY;
        if (this.f_211650_ != null) {
            i = pixelX + this.f_211650_.m_211711_(frameIndex) * this.f_211648_;
            j = pixelY + this.f_211650_.m_211721_(frameIndex) * this.f_211649_;
        }
        return (this.f_118342_[0].m_84985_(i, j) >> 24 & 0xFF) == 0;
    }

    public void m_118416_() {
        if (this.f_211650_ != null) {
            this.f_211650_.m_211710_();
        } else {
            this.m_118375_(0, 0, this.f_118342_);
        }
    }

    private float m_118366_() {
        float f = (float)this.f_211648_ / (this.f_118352_ - this.f_118351_);
        float f1 = (float)this.f_211649_ / (this.f_118354_ - this.f_118353_);
        return Math.max(f1, f);
    }

    public float m_118417_() {
        return 4.0f / this.m_118366_();
    }

    @Nullable
    public Tickable m_211692_() {
        return this.f_211650_;
    }

    public VertexConsumer m_118381_(VertexConsumer bufferIn) {
        MultiBufferSource.BufferSource rtb;
        if (this.m_118413_() == TextureUtils.LOCATION_SPRITE_EMPTY && (rtb = bufferIn.getRenderTypeBuffer()) != null) {
            return rtb.getDummyBuffer();
        }
        return new SpriteCoordinateExpander(bufferIn, this);
    }

    public int getIndexInMap() {
        return this.indexInMap;
    }

    public void updateIndexInMap(CounterInt counterInt) {
        TextureAtlasSprite registeredSprite;
        if (this.indexInMap >= 0) {
            return;
        }
        if (this.f_118343_ != null && (registeredSprite = this.f_118343_.getRegisteredSprite(this.m_118413_())) != null) {
            this.indexInMap = registeredSprite.getIndexInMap();
        }
        if (this.indexInMap < 0) {
            this.indexInMap = counterInt.nextValue();
        }
    }

    public int getAnimationIndex() {
        return this.animationIndex;
    }

    public void setAnimationIndex(int animationIndex) {
        this.animationIndex = animationIndex;
        if (this.spriteSingle != null) {
            this.spriteSingle.setAnimationIndex(animationIndex);
        }
        if (this.spriteNormal != null) {
            this.spriteNormal.setAnimationIndex(animationIndex);
        }
        if (this.spriteSpecular != null) {
            this.spriteSpecular.setAnimationIndex(animationIndex);
        }
    }

    public boolean isAnimationActive() {
        return this.animationActive;
    }

    private void fixTransparentColor(NativeImage ni) {
        int[] data = new int[ni.m_84982_() * ni.m_85084_()];
        ni.getBufferRGBA().get(data);
        this.fixTransparentColor(data);
        ni.getBufferRGBA().put(data);
    }

    private void fixTransparentColor(int[] data) {
        if (data == null) {
            return;
        }
        long redSum = 0L;
        long greenSum = 0L;
        long blueSum = 0L;
        long count = 0L;
        for (int i = 0; i < data.length; ++i) {
            int col = data[i];
            int alpha = col >> 24 & 0xFF;
            if (alpha < 16) continue;
            int red = col >> 16 & 0xFF;
            int green = col >> 8 & 0xFF;
            int blue = col & 0xFF;
            redSum += (long)red;
            greenSum += (long)green;
            blueSum += (long)blue;
            ++count;
        }
        if (count <= 0L) {
            return;
        }
        int redAvg = (int)(redSum / count);
        int greenAvg = (int)(greenSum / count);
        int blueAvg = (int)(blueSum / count);
        int colAvg = redAvg << 16 | greenAvg << 8 | blueAvg;
        for (int i = 0; i < data.length; ++i) {
            int col = data[i];
            int alpha = col >> 24 & 0xFF;
            if (alpha > 16) continue;
            data[i] = colAvg;
        }
    }

    public double getSpriteU16(float atlasU) {
        float dU = this.f_118352_ - this.f_118351_;
        return (atlasU - this.f_118351_) / dU * 16.0f;
    }

    public double getSpriteV16(float atlasV) {
        float dV = this.f_118354_ - this.f_118353_;
        return (atlasV - this.f_118353_) / dV * 16.0f;
    }

    public void bindSpriteTexture() {
        if (this.glSpriteTextureId < 0) {
            this.glSpriteTextureId = TextureUtil.m_85280_();
            TextureUtil.m_85287_((int)this.glSpriteTextureId, (int)this.mipmapLevels, (int)this.m_118405_(), (int)this.m_118408_());
            boolean blend = this.f_118343_.isTextureBlend(this.spriteShadersType);
            if (blend) {
                TextureUtils.applyAnisotropicLevel();
            } else {
                GlStateManager.m_84160_((int)3553, (int)34046, (float)1.0f);
                int minFilter = this.mipmapLevels > 0 ? 9984 : 9728;
                GlStateManager.m_84331_((int)3553, (int)10241, (int)minFilter);
                GlStateManager.m_84331_((int)3553, (int)10240, (int)9728);
            }
        }
        TextureUtils.bindTexture(this.glSpriteTextureId);
    }

    public void deleteSpriteTexture() {
        if (this.glSpriteTextureId < 0) {
            return;
        }
        TextureUtil.m_85281_((int)this.glSpriteTextureId);
        this.glSpriteTextureId = -1;
    }

    public float toSingleU(float u) {
        u -= this.baseU;
        float ku = (float)this.sheetWidth / (float)this.m_118405_();
        return u *= ku;
    }

    public float toSingleV(float v) {
        v -= this.baseV;
        float kv = (float)this.sheetHeight / (float)this.m_118408_();
        return v *= kv;
    }

    public NativeImage[] getMipmapImages() {
        return this.f_118342_;
    }

    public AnimationMetadataSection getAnimationMetadata() {
        return this.animationMetadata;
    }

    public int getOriginX() {
        return this.f_118349_;
    }

    public int getOriginY() {
        return this.f_118350_;
    }

    public float getUnInterpolatedU(float u) {
        float f = this.f_118352_ - this.f_118351_;
        return (u - this.f_118351_) / f * 16.0f;
    }

    public float getUnInterpolatedV(float v) {
        float f = this.f_118354_ - this.f_118353_;
        return (v - this.f_118353_) / f * 16.0f;
    }

    public TextureAtlasSprite makeSpriteSingle() {
        TextureAtlasSprite ss = new TextureAtlasSprite(this);
        ss.isSpriteSingle = true;
        return ss;
    }

    public TextureAtlasSprite makeSpriteShaders(ShadersTextureType type, int colDef, AnimationMetadataSection parentAnimation) {
        String suffix = type.getSuffix();
        ResourceLocation loc = new ResourceLocation(this.m_118413_().m_135827_(), this.m_118413_().m_135815_() + suffix);
        ResourceLocation locPng = this.f_118343_.m_118324_(loc);
        TextureAtlasSprite ss = null;
        if (this.resourceManager.m_7165_(locPng)) {
            try (Resource iresource2 = this.resourceManager.m_223800_(locPng);){
                NativeImage imageScaled;
                Resource resPngSize = this.resourceManager.m_223800_(locPng);
                PngInfo pngSize = new PngInfo(locPng.toString(), resPngSize.m_6679_());
                AnimationMetadataSection animMeta = (AnimationMetadataSection)iresource2.m_5507_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_);
                if (animMeta == null) {
                    animMeta = AnimationMetadataSection.f_119012_;
                }
                Pair<Integer, Integer> sizePair = animMeta.m_7117_(pngSize.f_85207_, pngSize.f_85208_);
                Info infoShaders = new Info(loc, (Integer)sizePair.getFirst(), (Integer)sizePair.getSecond(), animMeta);
                NativeImage image = NativeImage.m_85058_(iresource2.m_6679_());
                if (image.m_84982_() != this.m_118405_() && (imageScaled = TextureUtils.scaleImage((NativeImage)image, (int)this.m_118405_())) != image) {
                    double scaleFactor = 1.0 * (double)this.m_118405_() / (double)image.m_84982_();
                    image.close();
                    image = imageScaled;
                    infoShaders = new Info(loc, (int)((double)((Integer)sizePair.getFirst()).intValue() * scaleFactor), (int)((double)((Integer)sizePair.getSecond()).intValue() * scaleFactor), animMeta);
                }
                ss = new TextureAtlasSprite(this.f_118343_, infoShaders, this.mipmapLevels, this.sheetWidth, this.sheetHeight, this.f_118349_, this.f_118350_, image, type);
            }
            catch (IOException iresource2) {
                // empty catch block
            }
        }
        if (ss == null) {
            NativeImage image = new NativeImage(this.m_118405_(), this.m_118408_(), false);
            int colAbgr = TextureUtils.toAbgr(colDef);
            image.m_84997_(0, 0, image.m_84982_(), image.m_85084_(), colAbgr);
            Info infoShaders = new Info(loc, this.m_118405_(), this.m_118408_(), AnimationMetadataSection.f_119012_);
            ss = new TextureAtlasSprite(this.f_118343_, infoShaders, this.mipmapLevels, this.sheetWidth, this.sheetHeight, this.f_118349_, this.f_118350_, image, type);
        }
        if (this.terrain && this.multiTexture && !this.isSpriteSingle) {
            ss.spriteSingle = ss.makeSpriteSingle();
        }
        ss.usesParentAnimationTime = TextureAtlasSprite.matchesTiming(ss.animationMetadata, parentAnimation);
        return ss;
    }

    public boolean isTerrain() {
        return this.terrain;
    }

    private void setTerrain(boolean terrainIn) {
        this.terrain = terrainIn;
        this.multiTexture = false;
        this.shaders = false;
        if (this.spriteSingle != null) {
            this.deleteSpriteTexture();
            this.spriteSingle = null;
        }
        if (this.spriteNormal != null) {
            if (this.spriteNormal.spriteSingle != null) {
                this.spriteNormal.deleteSpriteTexture();
            }
            this.spriteNormal.close();
            this.spriteNormal = null;
        }
        if (this.spriteSpecular != null) {
            if (this.spriteSpecular.spriteSingle != null) {
                this.spriteSpecular.deleteSpriteTexture();
            }
            this.spriteSpecular.close();
            this.spriteSpecular = null;
        }
        this.multiTexture = Config.isMultiTexture();
        this.shaders = Config.isShaders();
        if (this.terrain && this.multiTexture && !this.isSpriteSingle) {
            this.spriteSingle = this.makeSpriteSingle();
        }
        if (this.shaders && !this.isSpriteSingle) {
            if (this.spriteNormal == null && Shaders.configNormalMap) {
                this.spriteNormal = this.makeSpriteShaders(ShadersTextureType.NORMAL, -8421377, this.animationMetadata);
            }
            if (this.spriteSpecular == null && Shaders.configSpecularMap) {
                this.spriteSpecular = this.makeSpriteShaders(ShadersTextureType.SPECULAR, 0, this.animationMetadata);
            }
        }
    }

    private static boolean matchesTiming(AnimationMetadataSection am1, AnimationMetadataSection am2) {
        if (am1 == am2) {
            return true;
        }
        if (am1 == null || am2 == null) {
            return false;
        }
        if (am1.m_119030_() != am2.m_119030_()) {
            return false;
        }
        if (am1.m_119036_() != am2.m_119036_()) {
            return false;
        }
        if (am1.getFrameCount() != am2.getFrameCount()) {
            return false;
        }
        for (int i = 0; i < am1.getFrameCount(); ++i) {
        }
        return true;
    }

    public void update(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.updateIndexInMap(this.f_118343_.getCounterIndexInMap());
        this.setTerrain(this.f_118343_.isTerrain());
    }

    public void updateAnimation() {
        if (this.f_211650_ != null) {
            this.f_211650_.m_7673_();
        }
    }

    public int getPixelRGBA(int frameIndex, int x, int y) {
        if (this.f_211650_ != null) {
            x += this.f_211650_.m_211711_(frameIndex) * this.f_211648_;
            y += this.f_211650_.m_211721_(frameIndex) * this.f_211649_;
        }
        return this.f_118342_[0].m_84985_(x, y);
    }

    private static /* synthetic */ boolean lambda$createTicker$4(IntSet intset, int intIn) {
        return !intset.contains(intIn);
    }

    final class InterpolationData
    implements AutoCloseable {
        private NativeImage[] f_118443_;

        public String toString() {
            return "interpolation:" + TextureAtlasSprite.this.toString();
        }

        InterpolationData(Info spriteInfoIn, int mipmapLevelsIn) {
            this.f_118443_ = new NativeImage[mipmapLevelsIn + 1];
            for (int i = 0; i < this.f_118443_.length; ++i) {
                int j = spriteInfoIn.f_118423_ >> i;
                int k = spriteInfoIn.f_118424_ >> i;
                if (this.f_118443_[i] != null) continue;
                this.f_118443_[i] = new NativeImage(j, k, false);
            }
        }

        void m_211769_(AnimatedTexture animatedTextureIn) {
            FrameInfo textureatlassprite$frameinfo = animatedTextureIn.f_211696_.get(animatedTextureIn.f_211694_);
            double d0 = 1.0 - (double)animatedTextureIn.f_211695_ / (double)textureatlassprite$frameinfo.f_211736_;
            int i = textureatlassprite$frameinfo.f_211735_;
            int j = animatedTextureIn.f_211696_.get((int)((animatedTextureIn.f_211694_ + 1) % animatedTextureIn.f_211696_.size())).f_211735_;
            if (i != j) {
                if (!TextureAtlasSprite.this.isSpriteSingle) {
                    for (int k = 0; k < this.f_118443_.length; ++k) {
                        int l = TextureAtlasSprite.this.f_211648_ >> k;
                        int i1 = TextureAtlasSprite.this.f_211649_ >> k;
                        for (int j1 = 0; j1 < i1; ++j1) {
                            for (int k1 = 0; k1 < l; ++k1) {
                                int l1 = this.m_211771_(animatedTextureIn, i, k, k1, j1);
                                int i2 = this.m_211771_(animatedTextureIn, j, k, k1, j1);
                                int j2 = this.m_118454_(d0, l1 >> 16 & 0xFF, i2 >> 16 & 0xFF);
                                int k2 = this.m_118454_(d0, l1 >> 8 & 0xFF, i2 >> 8 & 0xFF);
                                int l2 = this.m_118454_(d0, l1 & 0xFF, i2 & 0xFF);
                                this.f_118443_[k].m_84988_(k1, j1, l1 & 0xFF000000 | j2 << 16 | k2 << 8 | l2);
                            }
                        }
                    }
                }
                TextureAtlasSprite.this.m_118375_(0, 0, this.f_118443_);
            }
        }

        private int m_211771_(AnimatedTexture animatedTextureIn, int frameIndex, int mipmapLevel, int x, int y) {
            return TextureAtlasSprite.this.f_118342_[mipmapLevel].m_84985_(x + (animatedTextureIn.m_211711_(frameIndex) * TextureAtlasSprite.this.f_211648_ >> mipmapLevel), y + (animatedTextureIn.m_211721_(frameIndex) * TextureAtlasSprite.this.f_211649_ >> mipmapLevel));
        }

        private int m_118454_(double ratio, int val1, int val2) {
            return (int)(ratio * (double)val1 + (1.0 - ratio) * (double)val2);
        }

        @Override
        public void close() {
            for (NativeImage nativeimage : this.f_118443_) {
                if (nativeimage == null) continue;
                nativeimage.close();
            }
        }

        static /* synthetic */ NativeImage[] access$102(InterpolationData x0, NativeImage[] x1) {
            x0.f_118443_ = x1;
            return x1;
        }
    }

    public static final class Info {
        final ResourceLocation f_118422_;
        int f_118423_;
        int f_118424_;
        final AnimationMetadataSection f_118425_;
        private double scaleFactor = 1.0;

        public Info(ResourceLocation locationIn, int widthIn, int heightIn, AnimationMetadataSection animationMetadataIn) {
            this.f_118422_ = locationIn;
            this.f_118423_ = widthIn;
            this.f_118424_ = heightIn;
            this.f_118425_ = animationMetadataIn;
        }

        public ResourceLocation m_118431_() {
            return this.f_118422_;
        }

        public int m_118434_() {
            return this.f_118423_;
        }

        public int m_118437_() {
            return this.f_118424_;
        }

        public void setSpriteWidth(int spriteWidth) {
            this.f_118423_ = spriteWidth;
        }

        public void setSpriteHeight(int spriteHeight) {
            this.f_118424_ = spriteHeight;
        }

        public AnimationMetadataSection getSpriteAnimationMetadata() {
            return this.f_118425_;
        }

        public double getScaleFactor() {
            return this.scaleFactor;
        }

        public void setScaleFactor(double scaleFactor) {
            this.scaleFactor = scaleFactor;
        }

        public String toString() {
            return "" + this.f_118422_ + ", width: " + this.f_118423_ + ", height: " + this.f_118424_ + ", frames: " + this.f_118425_.getFrameCount() + ", scale: " + this.scaleFactor;
        }
    }

    static class FrameInfo {
        final int f_211735_;
        final int f_211736_;

        FrameInfo(int indexIn, int timeIn) {
            this.f_211735_ = indexIn;
            this.f_211736_ = timeIn;
        }
    }

    class AnimatedTexture
    implements Tickable,
    AutoCloseable {
        int f_211694_;
        int f_211695_;
        final List<FrameInfo> f_211696_;
        private final int f_211697_;
        @Nullable
        private final InterpolationData f_211698_;
        private TextureAtlasSprite sprite;

        AnimatedTexture(@Nullable List<FrameInfo> infosIn, int rowsIn, InterpolationData dataIn) {
            this.sprite = TextureAtlasSprite.this;
            this.f_211696_ = infosIn;
            this.f_211697_ = rowsIn;
            this.f_211698_ = dataIn;
        }

        int m_211711_(int frameIn) {
            return frameIn % this.f_211697_;
        }

        int m_211721_(int frameIn) {
            return frameIn / this.f_211697_;
        }

        private void m_211729_(int frameIn) {
            int i = this.m_211711_(frameIn) * TextureAtlasSprite.this.f_211648_;
            int j = this.m_211721_(frameIn) * TextureAtlasSprite.this.f_211649_;
            TextureAtlasSprite.this.m_118375_(i, j, TextureAtlasSprite.this.f_118342_);
        }

        @Override
        public void close() {
            if (this.f_211698_ != null) {
                this.f_211698_.close();
            }
        }

        public void m_7673_() {
            TextureAtlasSprite.this.animationActive = SmartAnimations.isActive() ? SmartAnimations.isSpriteRendered((TextureAtlasSprite)this.sprite) : true;
            if (this.f_211696_.size() <= 1) {
                TextureAtlasSprite.this.animationActive = false;
            }
            if (TextureAtlasSprite.this.spriteSingle != null && TextureAtlasSprite.this.spriteSingle.usesParentAnimationTime && TextureAtlasSprite.this.spriteSingle.f_211650_ != null) {
                ((TextureAtlasSprite)TextureAtlasSprite.this.spriteSingle).f_211650_.f_211694_ = this.f_211694_;
                ((TextureAtlasSprite)TextureAtlasSprite.this.spriteSingle).f_211650_.f_211695_ = this.f_211695_;
            }
            if (TextureAtlasSprite.this.spriteNormal != null && TextureAtlasSprite.this.spriteNormal.usesParentAnimationTime && TextureAtlasSprite.this.spriteNormal.f_211650_ != null) {
                ((TextureAtlasSprite)TextureAtlasSprite.this.spriteNormal).f_211650_.f_211694_ = this.f_211694_;
                ((TextureAtlasSprite)TextureAtlasSprite.this.spriteNormal).f_211650_.f_211695_ = this.f_211695_;
            }
            if (TextureAtlasSprite.this.spriteSpecular != null && TextureAtlasSprite.this.spriteSpecular.usesParentAnimationTime && TextureAtlasSprite.this.spriteSpecular.f_211650_ != null) {
                ((TextureAtlasSprite)TextureAtlasSprite.this.spriteSpecular).f_211650_.f_211694_ = this.f_211694_;
                ((TextureAtlasSprite)TextureAtlasSprite.this.spriteSpecular).f_211650_.f_211695_ = this.f_211695_;
            }
            ++this.f_211695_;
            FrameInfo textureatlassprite$frameinfo = this.f_211696_.get(this.f_211694_);
            if (this.f_211695_ >= textureatlassprite$frameinfo.f_211736_) {
                int i = textureatlassprite$frameinfo.f_211735_;
                this.f_211694_ = (this.f_211694_ + 1) % this.f_211696_.size();
                this.f_211695_ = 0;
                int j = this.f_211696_.get((int)this.f_211694_).f_211735_;
                if (!TextureAtlasSprite.this.animationActive) {
                    return;
                }
                if (i != j) {
                    this.m_211729_(j);
                }
            } else if (this.f_211698_ != null) {
                if (!TextureAtlasSprite.this.animationActive) {
                    return;
                }
                if (!RenderSystem.m_69586_()) {
                    RenderSystem.m_69879_(() -> this.f_211698_.m_211769_(this));
                } else {
                    this.f_211698_.m_211769_(this);
                }
            }
        }

        public void m_211710_() {
            this.m_211729_(this.f_211696_.get((int)0).f_211735_);
        }

        public IntStream m_211720_() {
            return this.f_211696_.stream().mapToInt(infoIn -> infoIn.f_211735_).distinct();
        }

        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        public String toString() {
            return "animation:" + TextureAtlasSprite.this.toString();
        }
    }
}

