/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ExperienceOrb;
import net.optifine.Config;
import net.optifine.CustomColors;

public class ExperienceOrbRenderer
extends EntityRenderer<ExperienceOrb> {
    private static final ResourceLocation f_114579_ = new ResourceLocation("textures/entity/experience_orb.png");
    private static final RenderType f_114580_ = RenderType.m_110467_(f_114579_);

    public ExperienceOrbRenderer(EntityRendererProvider.Context contextIn) {
        super(contextIn);
        this.f_114477_ = 0.15f;
        this.f_114478_ = 0.75f;
    }

    @Override
    protected int m_6086_(ExperienceOrb entityIn, BlockPos partialTicks) {
        return Mth.m_14045_(super.m_6086_(entityIn, partialTicks) + 7, 0, 15);
    }

    @Override
    public void m_7392_(ExperienceOrb entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        int col;
        matrixStackIn.m_85836_();
        int i = entityIn.m_20802_();
        float f = (float)(i % 4 * 16 + 0) / 64.0f;
        float f1 = (float)(i % 4 * 16 + 16) / 64.0f;
        float f2 = (float)(i / 4 * 16 + 0) / 64.0f;
        float f3 = (float)(i / 4 * 16 + 16) / 64.0f;
        float f4 = 1.0f;
        float f5 = 0.5f;
        float f6 = 0.25f;
        float f7 = 255.0f;
        float f8 = ((float)entityIn.f_19797_ + partialTicks) / 2.0f;
        if (Config.isCustomColors()) {
            f8 = CustomColors.getXpOrbTimer(f8);
        }
        int j = (int)((Mth.m_14031_(f8 + 0.0f) + 1.0f) * 0.5f * 255.0f);
        int k = 255;
        int l = (int)((Mth.m_14031_(f8 + 4.1887903f) + 1.0f) * 0.1f * 255.0f);
        matrixStackIn.m_85837_(0.0, 0.1f, 0.0);
        matrixStackIn.m_85845_(this.f_114476_.m_114470_());
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        float f9 = 0.3f;
        matrixStackIn.m_85841_(0.3f, 0.3f, 0.3f);
        VertexConsumer vertexconsumer = bufferIn.m_6299_(f_114580_);
        PoseStack.Pose posestack$pose = matrixStackIn.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_85861_();
        Matrix3f matrix3f = posestack$pose.m_85864_();
        int red = j;
        int green = 255;
        int blue = l;
        if (Config.isCustomColors() && (col = CustomColors.getXpOrbColor(f8)) >= 0) {
            red = col >> 16 & 0xFF;
            green = col >> 8 & 0xFF;
            blue = col >> 0 & 0xFF;
        }
        ExperienceOrbRenderer.m_114608_(vertexconsumer, matrix4f, matrix3f, -0.5f, -0.25f, red, green, blue, f, f3, packedLightIn);
        ExperienceOrbRenderer.m_114608_(vertexconsumer, matrix4f, matrix3f, 0.5f, -0.25f, red, green, blue, f1, f3, packedLightIn);
        ExperienceOrbRenderer.m_114608_(vertexconsumer, matrix4f, matrix3f, 0.5f, 0.75f, red, green, blue, f1, f2, packedLightIn);
        ExperienceOrbRenderer.m_114608_(vertexconsumer, matrix4f, matrix3f, -0.5f, 0.75f, red, green, blue, f, f2, packedLightIn);
        matrixStackIn.m_85849_();
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private static void m_114608_(VertexConsumer bufferIn, Matrix4f matrixIn, Matrix3f matrixNormalIn, float x, float y, int red, int green, int blue, float texU, float texV, int packedLight) {
        bufferIn.m_85982_(matrixIn, x, y, 0.0f).m_6122_(red, green, blue, 128).m_7421_(texU, texV).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(matrixNormalIn, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    @Override
    public ResourceLocation m_5478_(ExperienceOrb entity) {
        return f_114579_;
    }
}

