/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.FaceInfo;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockMath;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.optifine.Config;
import net.optifine.model.BlockModelUtils;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;

public class FaceBakery {
    public static final int f_316355_ = 8;
    private static final float f_111569_ = 1.0f / (float)Math.cos(0.3926991f) - 1.0f;
    private static final float f_111570_ = 1.0f / (float)Math.cos(0.7853981852531433) - 1.0f;
    public static final int f_316356_ = 4;
    private static final int f_316358_ = 3;
    public static final int f_316357_ = 4;

    public BakedQuad m_111600_(Vector3f posFrom, Vector3f posTo, BlockElementFace face, TextureAtlasSprite sprite, Direction facing, ModelState transformIn, @Nullable BlockElementRotation partRotation, boolean shade, ResourceLocation modelLocationIn) {
        BlockFaceUV blockfaceuv = face.f_111357_;
        if (transformIn.m_7538_()) {
            blockfaceuv = FaceBakery.m_111581_(face.f_111357_, facing, transformIn.m_6189_(), modelLocationIn);
        }
        float[] afloat = new float[blockfaceuv.f_111387_.length];
        System.arraycopy(blockfaceuv.f_111387_, 0, afloat, 0, afloat.length);
        float f = sprite.m_118417_();
        float f1 = (blockfaceuv.f_111387_[0] + blockfaceuv.f_111387_[0] + blockfaceuv.f_111387_[2] + blockfaceuv.f_111387_[2]) / 4.0f;
        float f2 = (blockfaceuv.f_111387_[1] + blockfaceuv.f_111387_[1] + blockfaceuv.f_111387_[3] + blockfaceuv.f_111387_[3]) / 4.0f;
        blockfaceuv.f_111387_[0] = Mth.m_14179_(f, blockfaceuv.f_111387_[0], f1);
        blockfaceuv.f_111387_[2] = Mth.m_14179_(f, blockfaceuv.f_111387_[2], f1);
        blockfaceuv.f_111387_[1] = Mth.m_14179_(f, blockfaceuv.f_111387_[1], f2);
        blockfaceuv.f_111387_[3] = Mth.m_14179_(f, blockfaceuv.f_111387_[3], f2);
        boolean quadShade = Reflector.ForgeHooksClient_fillNormal.exists() ? false : shade;
        int[] aint = this.m_111573_(blockfaceuv, sprite, facing, this.m_111592_(posFrom, posTo), transformIn.m_6189_(), partRotation, quadShade);
        Direction direction = FaceBakery.m_111612_(aint);
        System.arraycopy(afloat, 0, blockfaceuv.f_111387_, 0, afloat.length);
        if (partRotation == null) {
            this.m_111630_(aint, direction);
        }
        if (Reflector.ForgeHooksClient_fillNormal.exists()) {
            ReflectorForge.fillNormal((int[])aint, (Direction)direction);
            return new BakedQuad(aint, face.f_111355_, direction, sprite, shade);
        }
        return new BakedQuad(aint, face.f_111355_, direction, sprite, shade);
    }

    public static BlockFaceUV m_111581_(BlockFaceUV blockFaceUVIn, Direction facing, Transformation modelRotationIn, ResourceLocation modelLocationIn) {
        float f11;
        float f10;
        float f9;
        float f8;
        Matrix4f matrix4f = BlockMath.m_121844_((Transformation)modelRotationIn, (Direction)facing, () -> "Unable to resolve UVLock for model: " + modelLocationIn).m_121104_();
        float f = blockFaceUVIn.m_111392_(blockFaceUVIn.m_111398_(0));
        float f1 = blockFaceUVIn.m_111396_(blockFaceUVIn.m_111398_(0));
        Vector4f vector4f = new Vector4f(f / 16.0f, f1 / 16.0f, 0.0f, 1.0f);
        vector4f.m_123607_(matrix4f);
        float f2 = 16.0f * vector4f.m_123601_();
        float f3 = 16.0f * vector4f.m_123615_();
        float f4 = blockFaceUVIn.m_111392_(blockFaceUVIn.m_111398_(2));
        float f5 = blockFaceUVIn.m_111396_(blockFaceUVIn.m_111398_(2));
        Vector4f vector4f1 = new Vector4f(f4 / 16.0f, f5 / 16.0f, 0.0f, 1.0f);
        vector4f1.m_123607_(matrix4f);
        float f6 = 16.0f * vector4f1.m_123601_();
        float f7 = 16.0f * vector4f1.m_123615_();
        if (Math.signum(f4 - f) == Math.signum(f6 - f2)) {
            f8 = f2;
            f9 = f6;
        } else {
            f8 = f6;
            f9 = f2;
        }
        if (Math.signum(f5 - f1) == Math.signum(f7 - f3)) {
            f10 = f3;
            f11 = f7;
        } else {
            f10 = f7;
            f11 = f3;
        }
        float f12 = (float)Math.toRadians(blockFaceUVIn.f_111388_);
        Vector3f vector3f = new Vector3f(Mth.m_14089_(f12), Mth.m_14031_(f12), 0.0f);
        Matrix3f matrix3f = new Matrix3f(matrix4f);
        vector3f.m_122249_(matrix3f);
        int i = Math.floorMod(-((int)Math.round(Math.toDegrees(Math.atan2(vector3f.m_122260_(), vector3f.m_122239_())) / 90.0)) * 90, 360);
        return new BlockFaceUV(new float[]{f8, f10, f9, f11}, i);
    }

    private int[] m_111573_(BlockFaceUV uvs, TextureAtlasSprite sprite, Direction orientation, float[] posDiv16, Transformation rotationIn, @Nullable BlockElementRotation partRotation, boolean shade) {
        int vertexSize = Config.isShaders() ? DefaultVertexFormat.BLOCK_SHADERS_SIZE : DefaultVertexFormat.BLOCK_VANILLA_SIZE;
        int[] aint = new int[vertexSize];
        for (int i = 0; i < 4; ++i) {
            this.m_111620_(aint, i, orientation, uvs, posDiv16, sprite, rotationIn, partRotation, shade);
        }
        return aint;
    }

    private float[] m_111592_(Vector3f pos1, Vector3f pos2) {
        float[] afloat = new float[Direction.values().length];
        afloat[FaceInfo.Constants.f_108996_] = pos1.m_122239_() / 16.0f;
        afloat[FaceInfo.Constants.f_108995_] = pos1.m_122260_() / 16.0f;
        afloat[FaceInfo.Constants.f_108994_] = pos1.m_122269_() / 16.0f;
        afloat[FaceInfo.Constants.f_108993_] = pos2.m_122239_() / 16.0f;
        afloat[FaceInfo.Constants.f_108992_] = pos2.m_122260_() / 16.0f;
        afloat[FaceInfo.Constants.f_108991_] = pos2.m_122269_() / 16.0f;
        return afloat;
    }

    private void m_111620_(int[] vertexData, int vertexIndex, Direction facing, BlockFaceUV blockFaceUVIn, float[] posDiv16, TextureAtlasSprite sprite, Transformation rotationIn, @Nullable BlockElementRotation partRotation, boolean shade) {
        FaceInfo.VertexInfo faceinfo$vertexinfo = FaceInfo.m_108984_((Direction)facing).m_108982_(vertexIndex);
        Vector3f vector3f = new Vector3f(posDiv16[faceinfo$vertexinfo.f_108998_], posDiv16[faceinfo$vertexinfo.f_108999_], posDiv16[faceinfo$vertexinfo.f_109000_]);
        this.m_111586_(vector3f, partRotation);
        this.m_111589_(vector3f, rotationIn);
        BlockModelUtils.snapVertexPosition((Vector3f)vector3f);
        this.m_111614_(vertexData, vertexIndex, vector3f, sprite, blockFaceUVIn);
    }

    private void m_111614_(int[] faceData, int storeIndex, Vector3f positionIn, TextureAtlasSprite sprite, BlockFaceUV faceUV) {
        int step = faceData.length / 4;
        int i = storeIndex * step;
        faceData[i] = Float.floatToRawIntBits(positionIn.m_122239_());
        faceData[i + 1] = Float.floatToRawIntBits(positionIn.m_122260_());
        faceData[i + 2] = Float.floatToRawIntBits(positionIn.m_122269_());
        faceData[i + 3] = -1;
        faceData[i + 4] = Float.floatToRawIntBits(sprite.m_118367_(faceUV.m_111392_(storeIndex)));
        faceData[i + 4 + 1] = Float.floatToRawIntBits(sprite.m_118393_(faceUV.m_111396_(storeIndex)));
    }

    private void m_111586_(Vector3f vec, @Nullable BlockElementRotation partRotation) {
        if (partRotation != null) {
            Vector3f vector3f1;
            Vector3f vector3f;
            switch (partRotation.f_111379_) {
                case X: {
                    vector3f = Vector3f.f_122223_;
                    vector3f1 = new Vector3f(0.0f, 1.0f, 1.0f);
                    break;
                }
                case Y: {
                    vector3f = Vector3f.f_122225_;
                    vector3f1 = new Vector3f(1.0f, 0.0f, 1.0f);
                    break;
                }
                case Z: {
                    vector3f = Vector3f.f_122227_;
                    vector3f1 = new Vector3f(1.0f, 1.0f, 0.0f);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("There are only 3 axes");
                }
            }
            Quaternion quaternion = vector3f.m_122240_(partRotation.f_111380_);
            if (partRotation.f_111381_) {
                if (Math.abs(partRotation.f_111380_) == 22.5f) {
                    vector3f1.m_122261_(f_111569_);
                } else {
                    vector3f1.m_122261_(f_111570_);
                }
                vector3f1.m_122272_(1.0f, 1.0f, 1.0f);
            } else {
                vector3f1.m_122245_(1.0f, 1.0f, 1.0f);
            }
            this.m_111595_(vec, partRotation.f_111378_.m_122281_(), new Matrix4f(quaternion), vector3f1);
        }
    }

    public void m_111589_(Vector3f posIn, Transformation transformIn) {
        if (transformIn != Transformation.m_121093_()) {
            this.m_111595_(posIn, new Vector3f(0.5f, 0.5f, 0.5f), transformIn.m_121104_(), new Vector3f(1.0f, 1.0f, 1.0f));
        }
    }

    private void m_111595_(Vector3f posIn, Vector3f originIn, Matrix4f transformIn, Vector3f scaleIn) {
        Vector4f vector4f = new Vector4f(posIn.m_122239_() - originIn.m_122239_(), posIn.m_122260_() - originIn.m_122260_(), posIn.m_122269_() - originIn.m_122269_(), 1.0f);
        vector4f.m_123607_(transformIn);
        vector4f.m_123611_(scaleIn);
        posIn.m_122245_(vector4f.m_123601_() + originIn.m_122239_(), vector4f.m_123615_() + originIn.m_122260_(), vector4f.m_123616_() + originIn.m_122269_());
    }

    public static Direction m_111612_(int[] faceData) {
        int step = faceData.length / 4;
        int step2 = step * 2;
        Vector3f vector3f = new Vector3f(Float.intBitsToFloat(faceData[0]), Float.intBitsToFloat(faceData[1]), Float.intBitsToFloat(faceData[2]));
        Vector3f vector3f1 = new Vector3f(Float.intBitsToFloat(faceData[step]), Float.intBitsToFloat(faceData[step + 1]), Float.intBitsToFloat(faceData[step + 2]));
        Vector3f vector3f2 = new Vector3f(Float.intBitsToFloat(faceData[step2]), Float.intBitsToFloat(faceData[step2 + 1]), Float.intBitsToFloat(faceData[step2 + 2]));
        Vector3f vector3f3 = vector3f.m_122281_();
        vector3f3.m_122267_(vector3f1);
        Vector3f vector3f4 = vector3f2.m_122281_();
        vector3f4.m_122267_(vector3f1);
        Vector3f vector3f5 = vector3f4.m_122281_();
        vector3f5.m_122279_(vector3f3);
        vector3f5.m_122278_();
        Direction direction = null;
        float f = 0.0f;
        for (Direction direction1 : Direction.values()) {
            Vec3i vec3i = direction1.m_122436_();
            Vector3f vector3f6 = new Vector3f((float)vec3i.m_123341_(), (float)vec3i.m_123342_(), (float)vec3i.m_123343_());
            float f1 = vector3f5.m_122276_(vector3f6);
            if (!(f1 >= 0.0f) || !(f1 > f)) continue;
            f = f1;
            direction = direction1;
        }
        return direction == null ? Direction.UP : direction;
    }

    private void m_111630_(int[] vertexData, Direction directionIn) {
        int[] aint = new int[vertexData.length];
        System.arraycopy(vertexData, 0, aint, 0, vertexData.length);
        float[] afloat = new float[Direction.values().length];
        afloat[FaceInfo.Constants.f_108996_] = 999.0f;
        afloat[FaceInfo.Constants.f_108995_] = 999.0f;
        afloat[FaceInfo.Constants.f_108994_] = 999.0f;
        afloat[FaceInfo.Constants.f_108993_] = -999.0f;
        afloat[FaceInfo.Constants.f_108992_] = -999.0f;
        afloat[FaceInfo.Constants.f_108991_] = -999.0f;
        int step = vertexData.length / 4;
        for (int i = 0; i < 4; ++i) {
            int j = step * i;
            float f = Float.intBitsToFloat(aint[j]);
            float f1 = Float.intBitsToFloat(aint[j + 1]);
            float f2 = Float.intBitsToFloat(aint[j + 2]);
            if (f < afloat[FaceInfo.Constants.f_108996_]) {
                afloat[FaceInfo.Constants.f_108996_] = f;
            }
            if (f1 < afloat[FaceInfo.Constants.f_108995_]) {
                afloat[FaceInfo.Constants.f_108995_] = f1;
            }
            if (f2 < afloat[FaceInfo.Constants.f_108994_]) {
                afloat[FaceInfo.Constants.f_108994_] = f2;
            }
            if (f > afloat[FaceInfo.Constants.f_108993_]) {
                afloat[FaceInfo.Constants.f_108993_] = f;
            }
            if (f1 > afloat[FaceInfo.Constants.f_108992_]) {
                afloat[FaceInfo.Constants.f_108992_] = f1;
            }
            if (!(f2 > afloat[FaceInfo.Constants.f_108991_])) continue;
            afloat[FaceInfo.Constants.f_108991_] = f2;
        }
        FaceInfo faceinfo = FaceInfo.m_108984_((Direction)directionIn);
        for (int i1 = 0; i1 < 4; ++i1) {
            int j1 = step * i1;
            FaceInfo.VertexInfo faceinfo$vertexinfo = faceinfo.m_108982_(i1);
            float f8 = afloat[faceinfo$vertexinfo.f_108998_];
            float f3 = afloat[faceinfo$vertexinfo.f_108999_];
            float f4 = afloat[faceinfo$vertexinfo.f_109000_];
            vertexData[j1] = Float.floatToRawIntBits(f8);
            vertexData[j1 + 1] = Float.floatToRawIntBits(f3);
            vertexData[j1 + 2] = Float.floatToRawIntBits(f4);
            for (int k = 0; k < 4; ++k) {
                int l = step * k;
                float f5 = Float.intBitsToFloat(aint[l]);
                float f6 = Float.intBitsToFloat(aint[l + 1]);
                float f7 = Float.intBitsToFloat(aint[l + 2]);
                if (!Mth.m_14033_(f8, f5) || !Mth.m_14033_(f3, f6) || !Mth.m_14033_(f4, f7)) continue;
                vertexData[j1 + 4] = aint[l + 4];
                vertexData[j1 + 4 + 1] = aint[l + 4 + 1];
            }
        }
    }

    public static ResourceLocation getParentLocation(BlockModel blockModel) {
        return blockModel.f_111419_;
    }

    public static void setParentLocation(BlockModel blockModel, ResourceLocation location) {
        blockModel.f_111419_ = location;
    }

    public static Map<String, Either<Material, String>> getTextures(BlockModel blockModel) {
        return blockModel.f_111417_;
    }
}

