/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_3518;
import net.minecraft.class_3846;
import net.minecraft.class_5513;
import org.apache.commons.codec.binary.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_5514
implements AutoCloseable {
    private static final Logger field_26823 = LogManager.getLogger();
    private static final AtomicInteger field_26824 = new AtomicInteger(1);
    private static final ThreadFactory field_26825 = runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName("Chat-Filter-Worker-" + field_26824.getAndIncrement());
        return thread;
    };
    private final URL field_26826;
    final URL field_26827;
    final URL field_26828;
    private final String field_26829;
    private final int field_26830;
    private final String field_26831;
    final class_5515 field_26832;
    final ExecutorService field_26833;

    private class_5514(URI uRI, String string, int n, String string2, class_5515 class_55152, int n2) throws MalformedURLException {
        this.field_26829 = string;
        this.field_26830 = n;
        this.field_26831 = string2;
        this.field_26832 = class_55152;
        this.field_26826 = uRI.resolve("/v1/chat").toURL();
        this.field_26827 = uRI.resolve("/v1/join").toURL();
        this.field_26828 = uRI.resolve("/v1/leave").toURL();
        this.field_26833 = Executors.newFixedThreadPool(n2, field_26825);
    }

    @Nullable
    public static class_5514 method_33805(String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return null;
        }
        try {
            JsonObject jsonObject = class_3518.method_15285(string);
            URI \u00e2\u02dc\u01922 = new URI(class_3518.method_15265(jsonObject, "apiServer"));
            String \u00e2\u02dc\u01923 = class_3518.method_15265(jsonObject, "apiKey");
            if (\u00e2\u02dc\u01923.isEmpty()) {
                throw new IllegalArgumentException("Missing API key");
            }
            int \u00e2\u02dc\u01924 = class_3518.method_15282(jsonObject, "ruleId", 1);
            String \u00e2\u02dc\u01925 = class_3518.method_15253(jsonObject, "serverId", "");
            int \u00e2\u02dc\u01926 = class_3518.method_15282(jsonObject, "hashesToDrop", -1);
            int \u00e2\u02dc\u01927 = class_3518.method_15282(jsonObject, "maxConcurrentRequests", 7);
            class_5515 \u00e2\u02dc\u01928 = class_5515.method_33808(\u00e2\u02dc\u01926);
            return new class_5514(\u00e2\u02dc\u01922, new Base64().encodeToString(\u00e2\u02dc\u01923.getBytes(StandardCharsets.US_ASCII)), \u00e2\u02dc\u01924, \u00e2\u02dc\u01925, \u00e2\u02dc\u01928, \u00e2\u02dc\u01927);
        }
        catch (Exception exception) {
            field_26823.warn("Failed to parse chat filter config {}", (Object)string, (Object)exception);
            return null;
        }
    }

    void method_31299(GameProfile gameProfile, URL uRL, Executor executor) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("server", this.field_26831);
        jsonObject.addProperty("room", "Chat");
        jsonObject.addProperty("user_id", gameProfile.getId().toString());
        jsonObject.addProperty("user_display_name", gameProfile.getName());
        executor.execute(() -> {
            try {
                this.method_31304(jsonObject, uRL);
            }
            catch (Exception exception) {
                field_26823.warn("Failed to send join/leave packet to {} for player {}", (Object)uRL, (Object)gameProfile, (Object)exception);
            }
        });
    }

    CompletableFuture<class_5513.class_5837> method_31298(GameProfile gameProfile, String string, class_5515 class_55152, Executor executor) {
        if (string.isEmpty()) {
            return CompletableFuture.completedFuture(class_5513.class_5837.field_28863);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("rule", (Number)this.field_26830);
        jsonObject.addProperty("server", this.field_26831);
        jsonObject.addProperty("room", "Chat");
        jsonObject.addProperty("player", gameProfile.getId().toString());
        jsonObject.addProperty("player_display_name", gameProfile.getName());
        jsonObject.addProperty("text", string);
        return CompletableFuture.supplyAsync(() -> {
            try {
                JsonObject jsonObject2 = this.method_31295(jsonObject, this.field_26826);
                boolean \u00e2\u02dc\u01922 = class_3518.method_15258(jsonObject2, "response", false);
                if (\u00e2\u02dc\u01922) {
                    return class_5513.class_5837.method_33802(string);
                }
                String \u00e2\u02dc\u01923 = class_3518.method_15253(jsonObject2, "hashed", null);
                if (\u00e2\u02dc\u01923 == null) {
                    return class_5513.class_5837.method_33804(string);
                }
                int \u00e2\u02dc\u01924 = class_3518.method_15261(jsonObject2, "hashes").size();
                return class_55152.shouldIgnore(\u00e2\u02dc\u01923, \u00e2\u02dc\u01924) ? class_5513.class_5837.method_33804(string) : new class_5513.class_5837(string, \u00e2\u02dc\u01923);
            }
            catch (Exception exception) {
                field_26823.warn("Failed to validate message '{}'", (Object)string, (Object)exception);
                return class_5513.class_5837.method_33804(string);
            }
        }, executor);
    }

    @Override
    public void close() {
        this.field_26833.shutdownNow();
    }

    private void method_31300(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[1024];
        while (inputStream.read(byArray) != -1) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject method_31295(JsonObject jsonObject, URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = this.method_31306(jsonObject, uRL);
        try (InputStream \u00e2\u02dc\u01922 = httpURLConnection.getInputStream();){
            JsonObject jsonObject2;
            if (httpURLConnection.getResponseCode() == 204) {
                JsonObject jsonObject3 = new JsonObject();
                return jsonObject3;
            }
            try {
                jsonObject2 = Streams.parse((JsonReader)new JsonReader((Reader)new InputStreamReader(\u00e2\u02dc\u01922))).getAsJsonObject();
            }
            catch (Throwable throwable) {
                this.method_31300(\u00e2\u02dc\u01922);
                throw throwable;
            }
            this.method_31300(\u00e2\u02dc\u01922);
            return jsonObject2;
        }
    }

    private void method_31304(JsonObject jsonObject, URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = this.method_31306(jsonObject, uRL);
        try (InputStream \u00e2\u02dc\u01922 = httpURLConnection.getInputStream();){
            this.method_31300(\u00e2\u02dc\u01922);
        }
    }

    private HttpURLConnection method_31306(JsonObject jsonObject, URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.setReadTimeout(2000);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        httpURLConnection.setRequestProperty("Accept", "application/json");
        httpURLConnection.setRequestProperty("Authorization", "Basic " + this.field_26829);
        httpURLConnection.setRequestProperty("User-Agent", "Minecraft server" + class_155.method_16673().getName());
        try (OutputStreamWriter \u00e2\u02dc\u01922 = new OutputStreamWriter(httpURLConnection.getOutputStream(), StandardCharsets.UTF_8);
             JsonWriter jsonWriter = new JsonWriter((Writer)\u00e2\u02dc\u01922);){
            Streams.write((JsonElement)jsonObject, (JsonWriter)jsonWriter);
        }
        int \u00e2\u02dc\u01923 = httpURLConnection.getResponseCode();
        if (\u00e2\u02dc\u01923 < 200 || \u00e2\u02dc\u01923 >= 300) {
            throw new class_5517(\u00e2\u02dc\u01923 + " " + httpURLConnection.getResponseMessage());
        }
        return httpURLConnection;
    }

    public class_5513 method_31297(GameProfile gameProfile) {
        return new class_5516(gameProfile);
    }

    @FunctionalInterface
    public static interface class_5515 {
        public static final class_5515 field_26834 = (string, n) -> false;
        public static final class_5515 field_26835 = (string, n) -> string.length() == n;

        public static class_5515 method_33806(int n) {
            return (string, n2) -> n2 >= n;
        }

        public static class_5515 method_33808(int n) {
            switch (n) {
                case -1: {
                    return field_26834;
                }
                case 0: {
                    return field_26835;
                }
            }
            return class_5515.method_33806(n);
        }

        public boolean shouldIgnore(String var1, int var2);
    }

    public static class class_5517
    extends RuntimeException {
        class_5517(String string) {
            super(string);
        }
    }

    class class_5516
    implements class_5513 {
        private final GameProfile field_26837;
        private final Executor field_26838;

        class_5516(GameProfile gameProfile) {
            this.field_26837 = gameProfile;
            class_3846<Runnable> class_38462 = class_3846.method_16902(class_5514.this.field_26833, "chat stream for " + gameProfile.getName());
            this.field_26838 = class_38462::method_16901;
        }

        @Override
        public void method_31287() {
            class_5514.this.method_31299(this.field_26837, class_5514.this.field_26827, this.field_26838);
        }

        @Override
        public void method_31290() {
            class_5514.this.method_31299(this.field_26837, class_5514.this.field_26828, this.field_26838);
        }

        @Override
        public CompletableFuture<List<class_5513.class_5837>> method_31289(List<String> list) {
            List list2 = (List)list.stream().map(string -> class_5514.this.method_31298(this.field_26837, (String)string, class_5514.this.field_26832, this.field_26838)).collect(ImmutableList.toImmutableList());
            return class_156.method_652(list2).exceptionally(throwable -> ImmutableList.of());
        }

        @Override
        public CompletableFuture<class_5513.class_5837> method_31288(String string) {
            return class_5514.this.method_31298(this.field_26837, string, class_5514.this.field_26832, this.field_26838);
        }
    }
}

