/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3518;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class class_3255
implements class_3262 {
    private static final Logger field_14182 = LogManager.getLogger();
    public final File field_14181;

    public class_3255(File resourcePackFileIn) {
        this.field_14181 = resourcePackFileIn;
    }

    private static String method_14395(class_3264 type, class_2960 location) {
        return String.format("%s/%s/%s", type.method_14413(), location.method_12836(), location.method_12832());
    }

    protected static String method_14396(File file1, File file2) {
        return file1.toURI().relativize(file2.toURI()).getPath();
    }

    @Override
    public InputStream method_14405(class_3264 type, class_2960 location) throws IOException {
        return this.method_14391(class_3255.method_14395(type, location));
    }

    @Override
    public boolean method_14411(class_3264 type, class_2960 location) {
        return this.method_14393(class_3255.method_14395(type, location));
    }

    protected abstract InputStream method_14391(String var1) throws IOException;

    @Override
    public InputStream method_14410(String fileName) throws IOException {
        if (!fileName.contains("/") && !fileName.contains("\\")) {
            return this.method_14391(fileName);
        }
        throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
    }

    protected abstract boolean method_14393(String var1);

    protected void method_14394(String namespace) {
        field_14182.warn("ResourcePack: ignored non-lowercase namespace: {} in {}", (Object)namespace, (Object)this.field_14181);
    }

    @Override
    @Nullable
    public <T> T method_14407(class_3270<T> deserializer) throws IOException {
        T object;
        try (InputStream inputstream = this.method_14391("pack.mcmeta");){
            object = class_3255.method_14392(deserializer, inputstream);
        }
        return object;
    }

    @Nullable
    public static <T> T method_14392(class_3270<T> deserializer, InputStream inputStream) {
        JsonObject jsonobject;
        try (BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            jsonobject = class_3518.method_15255(bufferedreader);
        }
        catch (JsonParseException | IOException ioexception) {
            field_14182.error("Couldn't load {} metadata", (Object)deserializer.method_14420(), (Object)ioexception);
            return null;
        }
        if (!jsonobject.has(deserializer.method_14420())) {
            return null;
        }
        try {
            return deserializer.method_14421(class_3518.method_15296(jsonobject, deserializer.method_14420()));
        }
        catch (JsonParseException jsonparseexception) {
            field_14182.error("Couldn't load {} metadata", (Object)deserializer.method_14420(), (Object)jsonparseexception);
            return null;
        }
    }

    @Override
    public String method_14409() {
        return this.field_14181.getName();
    }
}

