/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1050;
import net.minecraft.class_1054;
import net.minecraft.class_1055;
import net.minecraft.class_1058;
import net.minecraft.class_1061;
import net.minecraft.class_1079;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_1723;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.optifine.Config;
import net.optifine.EmissiveTextures;
import net.optifine.SmartAnimations;
import net.optifine.reflect.Reflector;
import net.optifine.shaders.ITextureFormat;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersTex;
import net.optifine.shaders.ShadersTextureType;
import net.optifine.texture.ColorBlenderLinear;
import net.optifine.texture.IColorBlender;
import net.optifine.util.CounterInt;
import net.optifine.util.TextureUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_1059
extends class_1044
implements class_1061 {
    private static final Logger field_5278 = LogManager.getLogger();
    @Deprecated
    public static final class_2960 field_5275 = class_1723.field_21668;
    @Deprecated
    public static final class_2960 field_17898 = new class_2960("textures/atlas/particles.png");
    private static final String field_32957 = ".png";
    private final List<class_1061> field_5276 = Lists.newArrayList();
    private final Set<class_2960> field_5277 = Sets.newHashSet();
    private final Map<class_2960, class_1058> field_5280 = Maps.newHashMap();
    private final class_2960 field_21749;
    private final int field_17899;
    private Map<class_2960, class_1058> mapRegisteredSprites = new LinkedHashMap<class_2960, class_1058>();
    private Map<class_2960, class_1058> mapMissingSprites = new LinkedHashMap<class_2960, class_1058>();
    private class_1058[] iconGrid = null;
    private int iconGridSize = -1;
    private int iconGridCountX = -1;
    private int iconGridCountY = -1;
    private double iconGridSizeU = -1.0;
    private double iconGridSizeV = -1.0;
    private CounterInt counterIndexInMap = new CounterInt(0);
    public int atlasWidth = 0;
    public int atlasHeight = 0;
    public int mipmapLevel = 0;
    private int countAnimationsActive;
    private int frameCountAnimations;
    private boolean terrain;
    private boolean shaders;
    private boolean multiTexture;
    private ITextureFormat textureFormat;

    public class_1059(class_2960 textureLocationIn) {
        this.field_21749 = textureLocationIn;
        this.field_17899 = RenderSystem.maxSupportedTextureSize();
        this.terrain = textureLocationIn.equals(field_5275);
        this.shaders = Config.isShaders();
        this.multiTexture = Config.isMultiTexture();
        if (this.terrain) {
            Config.setTextureMap(this);
        }
    }

    @Override
    public void method_4625(class_3300 manager) {
    }

    public void method_18159(class_4007 sheetDataIn) {
        List<class_1058> listSprites;
        this.field_5277.clear();
        this.field_5277.addAll(sheetDataIn.field_17900);
        field_5278.info("Created: {}x{}x{} {}-atlas", (Object)sheetDataIn.field_17901, (Object)sheetDataIn.field_17902, (Object)sheetDataIn.field_21795, (Object)this.field_21749);
        TextureUtil.prepareImage(this.method_4624(), sheetDataIn.field_21795, sheetDataIn.field_17901, sheetDataIn.field_17902);
        this.atlasWidth = sheetDataIn.field_17901;
        this.atlasHeight = sheetDataIn.field_17902;
        this.mipmapLevel = sheetDataIn.field_21795;
        if (this.shaders) {
            ShadersTex.allocateTextureMapNS(sheetDataIn.field_21795, sheetDataIn.field_17901, sheetDataIn.field_17902, this);
        }
        this.method_4601();
        for (class_1058 textureatlassprite : sheetDataIn.field_17903) {
            this.field_5280.put(textureatlassprite.method_4598(), textureatlassprite);
            try {
                textureatlassprite.method_4584();
            }
            catch (Throwable throwable) {
                class_128 crashreport = class_128.method_560(throwable, "Stitching texture atlas");
                class_129 crashreportcategory = crashreport.method_562("Texture being stitched together");
                crashreportcategory.method_578("Atlas path", this.field_21749);
                crashreportcategory.method_578("Sprite", textureatlassprite);
                throw new class_148(crashreport);
            }
            class_1061 tickable = textureatlassprite.method_33443();
            if (tickable == null) continue;
            textureatlassprite.setAnimationIndex(this.field_5276.size());
            this.field_5276.add(tickable);
        }
        TextureUtils.refreshCustomSprites(this);
        Config.log("Animated sprites: " + this.field_5276.size());
        if (Config.isMultiTexture()) {
            listSprites = sheetDataIn.field_17903;
            for (class_1058 tas : listSprites) {
                class_1059.uploadMipmapsSingle(tas);
                if (tas.spriteNormal != null) {
                    class_1059.uploadMipmapsSingle(tas.spriteNormal);
                }
                if (tas.spriteSpecular == null) continue;
                class_1059.uploadMipmapsSingle(tas.spriteSpecular);
            }
            GlStateManager._bindTexture(this.method_4624());
        }
        if (Config.isShaders()) {
            listSprites = sheetDataIn.field_17903;
            if (Shaders.configNormalMap) {
                GlStateManager._bindTexture(this.getMultiTexID().norm);
                for (class_1058 tas : listSprites) {
                    class_1058 spriteNormal = tas.spriteNormal;
                    if (spriteNormal == null) continue;
                    spriteNormal.method_4584();
                }
            }
            if (Shaders.configSpecularMap) {
                GlStateManager._bindTexture(this.getMultiTexID().spec);
                for (class_1058 tas : listSprites) {
                    class_1058 spriteSpecular = tas.spriteSpecular;
                    if (spriteSpecular == null) continue;
                    spriteSpecular.method_4584();
                }
            }
            GlStateManager._bindTexture(this.method_4624());
        }
        Reflector.callVoid(Reflector.ForgeHooksClient_onTextureStitchedPost, this);
        this.updateIconGrid(sheetDataIn.field_17901, sheetDataIn.field_17902);
        if (Config.equals(System.getProperty("saveTextureMap"), "true")) {
            Config.dbg("Exporting texture map: " + this.field_21749);
            TextureUtils.saveGlTexture("debug/" + this.field_21749.method_12832().replaceAll("/", "_"), this.method_4624(), sheetDataIn.field_21795, sheetDataIn.field_17901, sheetDataIn.field_17902);
            if (this.shaders) {
                if (Shaders.configNormalMap) {
                    TextureUtils.saveGlTexture("debug/" + this.field_21749.method_12832().replaceAll("/", "_").replace(field_32957, "_n.png"), this.multiTex.norm, sheetDataIn.field_21795, sheetDataIn.field_17901, sheetDataIn.field_17902);
                }
                if (Shaders.configSpecularMap) {
                    TextureUtils.saveGlTexture("debug/" + this.field_21749.method_12832().replaceAll("/", "_").replace(field_32957, "_s.png"), this.multiTex.spec, sheetDataIn.field_21795, sheetDataIn.field_17901, sheetDataIn.field_17902);
                }
                GlStateManager._bindTexture(this.method_4624());
            }
        }
    }

    public class_4007 method_18163(class_3300 resourceManagerIn, Stream<class_2960> resourceLocationsIn, class_3695 profilerIn, int maxMipmapLevelIn) {
        int k1;
        int minSpriteSize;
        this.terrain = this.field_21749.equals(field_5275);
        this.shaders = Config.isShaders();
        this.multiTexture = Config.isMultiTexture();
        this.textureFormat = ITextureFormat.readConfiguration();
        int mipmapLevels = maxMipmapLevelIn;
        this.mapRegisteredSprites.clear();
        this.mapMissingSprites.clear();
        this.counterIndexInMap.reset();
        profilerIn.method_15396("preparing");
        Set<class_2960> set = resourceLocationsIn.peek(locIn -> {
            if (locIn == null) {
                throw new IllegalArgumentException("Location cannot be null!");
            }
        }).collect(Collectors.toSet());
        Config.dbg("Multitexture: " + Config.isMultiTexture());
        TextureUtils.registerCustomSprites(this);
        set.addAll(this.mapRegisteredSprites.keySet());
        Set<class_2960> locsEmissive = class_1059.newHashSet(set, this.mapRegisteredSprites.keySet());
        EmissiveTextures.updateIcons(this, locsEmissive);
        set.addAll(this.mapRegisteredSprites.keySet());
        if (mipmapLevels >= 4) {
            mipmapLevels = this.detectMaxMipmapLevel(set, resourceManagerIn);
            Config.log("Mipmap levels: " + mipmapLevels);
        }
        int i = TextureUtils.getGLMaximumTextureSize();
        class_1055 stitcher = new class_1055(i, i, maxMipmapLevelIn);
        int j = Integer.MAX_VALUE;
        this.iconGridSize = minSpriteSize = class_1059.getMinSpriteSize(mipmapLevels);
        int k = 1 << maxMipmapLevelIn;
        profilerIn.method_15405("extracting_frames");
        Reflector.callVoid(Reflector.ForgeHooksClient_onTextureStitchedPre, this, set);
        for (class_1058.class_4727 textureatlassprite$info : this.method_18164(resourceManagerIn, set)) {
            int ws = textureatlassprite$info.method_24123();
            int hs = textureatlassprite$info.method_24125();
            if (ws < 1 || hs < 1) {
                Config.warn("Invalid sprite size: " + textureatlassprite$info.method_24121());
                continue;
            }
            if (ws < minSpriteSize || mipmapLevels > 0) {
                int ws2;
                int n = ws2 = mipmapLevels > 0 ? TextureUtils.scaleToGrid(ws, minSpriteSize) : TextureUtils.scaleToMin(ws, minSpriteSize);
                if (ws2 != ws) {
                    if (!TextureUtils.isPowerOfTwo(ws)) {
                        Config.log("Scaled non power of 2: " + textureatlassprite$info.method_24121() + ", " + ws + " -> " + ws2);
                    } else {
                        Config.log("Scaled too small texture: " + textureatlassprite$info.method_24121() + ", " + ws + " -> " + ws2);
                    }
                    int hs2 = hs * ws2 / ws;
                    textureatlassprite$info.setSpriteWidth(ws2);
                    textureatlassprite$info.setSpriteHeight(hs2);
                    textureatlassprite$info.setScaleFactor((double)ws2 * 1.0 / (double)ws);
                }
            }
            j = Math.min(j, Math.min(textureatlassprite$info.method_24123(), textureatlassprite$info.method_24125()));
            int l = Math.min(Integer.lowestOneBit(textureatlassprite$info.method_24123()), Integer.lowestOneBit(textureatlassprite$info.method_24125()));
            if (l < k) {
                field_5278.warn("Texture {} with size {}x{} limits mip level from {} to {}", (Object)textureatlassprite$info.method_24121(), (Object)textureatlassprite$info.method_24123(), (Object)textureatlassprite$info.method_24125(), (Object)class_3532.method_15351(k), (Object)class_3532.method_15351(l));
                k = l;
            }
            stitcher.method_4553(textureatlassprite$info);
        }
        int i1 = Math.min(j, k);
        int j1 = class_3532.method_15351(i1);
        if (j1 < 0) {
            j1 = 0;
        }
        if (j1 < maxMipmapLevelIn) {
            field_5278.warn("{}: dropping miplevel from {} to {}, because of minimum power of two: {}", (Object)this.field_21749, (Object)maxMipmapLevelIn, (Object)j1, (Object)i1);
            k1 = j1;
        } else {
            k1 = maxMipmapLevelIn;
        }
        profilerIn.method_15405("register");
        class_1058.class_4727 missingInfo = class_1059.fixSpriteSize(class_1047.method_24104(), minSpriteSize);
        stitcher.method_4553(missingInfo);
        profilerIn.method_15405("stitching");
        try {
            stitcher.method_4557();
        }
        catch (class_1054 stitcherexception) {
            class_128 crashreport = class_128.method_560(stitcherexception, "Stitching");
            class_129 crashreportcategory = crashreport.method_562("Stitcher");
            crashreportcategory.method_578("Sprites", stitcherexception.method_21687().stream().map(infoIn -> String.format("%s[%dx%d]", infoIn.method_24121(), infoIn.method_24123(), infoIn.method_24125())).collect(Collectors.joining(",")));
            crashreportcategory.method_578("Max Texture Size", i);
            throw new class_148(crashreport);
        }
        profilerIn.method_15405("loading");
        List<class_1058> list = this.method_18161(resourceManagerIn, stitcher, k1);
        profilerIn.method_15407();
        return new class_4007(set, stitcher.method_4554(), stitcher.method_4555(), k1, list);
    }

    private Collection<class_1058.class_4727> method_18164(class_3300 resourceManagerIn, Set<class_2960> spriteLocationsIn) {
        ArrayList list = Lists.newArrayList();
        ConcurrentLinkedQueue<class_1058.class_4727> queue = new ConcurrentLinkedQueue<class_1058.class_4727>();
        for (class_2960 resourcelocation : spriteLocationsIn) {
            if (class_1047.method_4539().equals(resourcelocation)) continue;
            list.add(CompletableFuture.runAsync(() -> {
                class_1058.class_4727 textureatlassprite$info;
                class_2960 resourcelocation1 = this.method_4603(resourcelocation);
                try (class_3298 resource = resourceManagerIn.method_14486(resourcelocation1);){
                    class_1050 pnginfo = new class_1050(resource.toString(), resource.method_14482());
                    class_1079 animationmetadatasection = resource.method_14481(class_1079.field_5337);
                    if (animationmetadatasection == null) {
                        animationmetadatasection = class_1079.field_21768;
                    }
                    Pair<Integer, Integer> pair = animationmetadatasection.method_24141(pnginfo.field_5227, pnginfo.field_5226);
                    textureatlassprite$info = new class_1058.class_4727(resourcelocation, (Integer)pair.getFirst(), (Integer)pair.getSecond(), animationmetadatasection);
                }
                catch (RuntimeException runtimeexception) {
                    field_5278.error("Unable to parse metadata from {} : {}", (Object)resourcelocation1, (Object)runtimeexception);
                    this.onSpriteMissing(resourcelocation);
                    return;
                }
                catch (IOException ioexception) {
                    field_5278.error("Using missing texture, unable to load {} : {}", (Object)resourcelocation1, (Object)ioexception);
                    this.onSpriteMissing(resourcelocation);
                    return;
                }
                queue.add(textureatlassprite$info);
            }, class_156.method_18349()));
        }
        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).join();
        return queue;
    }

    private List<class_1058> method_18161(class_3300 resourceManagerIn, class_1055 stitcherIn, int mipmapLevelIn) {
        ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue();
        ArrayList list = Lists.newArrayList();
        stitcherIn.method_4549((p_211595_5_, p_211595_6_, p_211595_7_, p_211595_8_, p_211595_9_) -> {
            if (p_211595_5_.method_24121().equals(class_1047.method_24104().method_24121())) {
                class_1047 missingtextureatlassprite = new class_1047(this, p_211595_5_, mipmapLevelIn, p_211595_6_, p_211595_7_, p_211595_8_, p_211595_9_);
                missingtextureatlassprite.update(resourceManagerIn);
                queue.add(missingtextureatlassprite);
            } else {
                list.add(CompletableFuture.runAsync(() -> {
                    class_1058 textureatlassprite = this.method_4604(resourceManagerIn, p_211595_5_, p_211595_6_, p_211595_7_, mipmapLevelIn, p_211595_8_, p_211595_9_);
                    if (textureatlassprite != null) {
                        queue.add(textureatlassprite);
                    }
                }, class_156.method_18349()));
            }
        });
        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).join();
        return Lists.newArrayList(queue);
    }

    @Nullable
    private class_1058 method_4604(class_3300 resourceManagerIn, class_1058.class_4727 spriteInfoIn, int widthIn, int heightIn, int mipmapLevelIn, int originX, int originY) {
        class_2960 resourcelocation = this.method_4603(spriteInfoIn.method_24121());
        try {
            class_1058 textureatlassprite = null;
            try (class_3298 resource = resourceManagerIn.method_14486(resourcelocation);){
                class_1011 nativeimage = class_1011.method_4309(resource.method_14482());
                if (Reflector.ForgeHooksClient_loadTextureAtlasSprite.exists()) {
                    textureatlassprite = (class_1058)Reflector.ForgeHooksClient_loadTextureAtlasSprite.call(this, resourceManagerIn, spriteInfoIn, resource, widthIn, heightIn, originX, originY, mipmapLevelIn, nativeimage);
                }
                if (textureatlassprite == null) {
                    textureatlassprite = new class_1058(this, spriteInfoIn, mipmapLevelIn, widthIn, heightIn, originX, originY, nativeimage);
                }
                textureatlassprite.update(resourceManagerIn);
            }
            return textureatlassprite;
        }
        catch (RuntimeException runtimeexception) {
            field_5278.error("Unable to parse metadata from {}", (Object)resourcelocation, (Object)runtimeexception);
            return null;
        }
        catch (IOException ioexception) {
            field_5278.error("Using missing texture, unable to load {}", (Object)resourcelocation, (Object)ioexception);
            return null;
        }
    }

    public class_2960 method_4603(class_2960 location) {
        if (this.isAbsoluteLocation(location)) {
            return new class_2960(location.method_12836(), location.method_12832() + field_32957);
        }
        return new class_2960(location.method_12836(), String.format("textures/%s%s", location.method_12832(), field_32957));
    }

    public void method_4612() {
        class_1058 textureatlassprite;
        boolean hasNormal = false;
        boolean hasSpecular = false;
        if (!this.field_5276.isEmpty()) {
            this.method_23207();
        }
        int countActive = 0;
        for (class_1061 tickable : this.field_5276) {
            if (tickable instanceof class_1058.class_5790) {
                textureatlassprite = ((class_1058.class_5790)tickable).getSprite();
                if (!this.isAnimationEnabled(textureatlassprite)) continue;
                tickable.method_4622();
                if (textureatlassprite.isAnimationActive()) {
                    ++countActive;
                }
                if (textureatlassprite.spriteNormal != null) {
                    hasNormal = true;
                }
                if (textureatlassprite.spriteSpecular == null) continue;
                hasSpecular = true;
                continue;
            }
            tickable.method_4622();
        }
        if (Config.isShaders()) {
            if (hasNormal) {
                GlStateManager._bindTexture(this.getMultiTexID().norm);
                for (class_1061 tickable : this.field_5276) {
                    if (!(tickable instanceof class_1058.class_5790)) continue;
                    textureatlassprite = ((class_1058.class_5790)tickable).getSprite();
                    if (textureatlassprite.spriteNormal == null || !this.isAnimationEnabled(textureatlassprite) || !textureatlassprite.isAnimationActive()) continue;
                    textureatlassprite.spriteNormal.updateAnimation();
                    if (!textureatlassprite.spriteNormal.isAnimationActive()) continue;
                    ++countActive;
                }
            }
            if (hasSpecular) {
                GlStateManager._bindTexture(this.getMultiTexID().spec);
                for (class_1061 tickable : this.field_5276) {
                    if (!(tickable instanceof class_1058.class_5790)) continue;
                    textureatlassprite = ((class_1058.class_5790)tickable).getSprite();
                    if (textureatlassprite.spriteSpecular == null || !this.isAnimationEnabled(textureatlassprite) || !textureatlassprite.isAnimationActive()) continue;
                    textureatlassprite.spriteSpecular.updateAnimation();
                    if (!textureatlassprite.spriteSpecular.isAnimationActive()) continue;
                    ++countActive;
                }
            }
            if (hasNormal || hasSpecular) {
                GlStateManager._bindTexture(this.method_4624());
            }
        }
        if (Config.isMultiTexture()) {
            for (class_1061 tickable : this.field_5276) {
                class_1058 ts;
                if (!(tickable instanceof class_1058.class_5790) || !this.isAnimationEnabled(ts = ((class_1058.class_5790)tickable).getSprite()) || !ts.isAnimationActive()) continue;
                countActive += class_1059.updateAnimationSingle(ts);
                if (ts.spriteNormal != null) {
                    countActive += class_1059.updateAnimationSingle(ts.spriteNormal);
                }
                if (ts.spriteSpecular == null) continue;
                countActive += class_1059.updateAnimationSingle(ts.spriteSpecular);
            }
            GlStateManager._bindTexture(this.method_4624());
        }
        if (this.terrain) {
            int frameCount = Config.getMinecraft().field_1769.getFrameCount();
            if (frameCount != this.frameCountAnimations) {
                this.countAnimationsActive = countActive;
                this.frameCountAnimations = frameCount;
            }
            if (SmartAnimations.isActive()) {
                SmartAnimations.resetSpritesRendered(this);
            }
        }
    }

    @Override
    public void method_4622() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(this::method_4612);
        } else {
            this.method_4612();
        }
    }

    public class_1058 method_4608(class_2960 location) {
        class_1058 textureatlassprite = this.field_5280.get(location);
        return textureatlassprite == null ? this.field_5280.get(class_1047.method_4539()) : textureatlassprite;
    }

    public void method_4601() {
        for (class_1058 textureatlassprite : this.field_5280.values()) {
            textureatlassprite.close();
        }
        if (this.multiTexture) {
            for (class_1058 ts : this.field_5280.values()) {
                ts.deleteSpriteTexture();
                if (ts.spriteNormal != null) {
                    ts.spriteNormal.deleteSpriteTexture();
                }
                if (ts.spriteSpecular == null) continue;
                ts.spriteSpecular.deleteSpriteTexture();
            }
        }
        this.field_5280.clear();
        this.field_5276.clear();
    }

    public class_2960 method_24106() {
        return this.field_21749;
    }

    public void method_24198(class_4007 sheetDataIn) {
        this.method_4527(false, sheetDataIn.field_21795 > 0);
    }

    private boolean isAbsoluteLocation(class_2960 loc) {
        String path = loc.method_12832();
        return this.isAbsoluteLocationPath(path);
    }

    private boolean isAbsoluteLocationPath(String resPath) {
        String path = resPath.toLowerCase();
        return path.startsWith("optifine/");
    }

    public class_1058 getRegisteredSprite(String name) {
        class_2960 loc = new class_2960(name);
        return this.getRegisteredSprite(loc);
    }

    public class_1058 getRegisteredSprite(class_2960 loc) {
        return this.mapRegisteredSprites.get(loc);
    }

    public class_1058 getUploadedSprite(String name) {
        class_2960 loc = new class_2960(name);
        return this.getUploadedSprite(loc);
    }

    public class_1058 getUploadedSprite(class_2960 loc) {
        return this.field_5280.get(loc);
    }

    private boolean isAnimationEnabled(class_1058 ts) {
        if (!this.terrain) {
            return true;
        }
        if (ts == TextureUtils.iconWaterStill || ts == TextureUtils.iconWaterFlow) {
            return Config.isAnimatedWater();
        }
        if (ts == TextureUtils.iconLavaStill || ts == TextureUtils.iconLavaFlow) {
            return Config.isAnimatedLava();
        }
        if (ts == TextureUtils.iconFireLayer0 || ts == TextureUtils.iconFireLayer1) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconSoulFireLayer0 || ts == TextureUtils.iconSoulFireLayer1) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconCampFire || ts == TextureUtils.iconCampFireLogLit) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconSoulCampFire || ts == TextureUtils.iconSoulCampFireLogLit) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconPortal) {
            return Config.isAnimatedPortal();
        }
        return Config.isAnimatedTerrain();
    }

    private static void uploadMipmapsSingle(class_1058 tas) {
        class_1058 ss = tas.spriteSingle;
        if (ss != null) {
            ss.setAnimationIndex(tas.getAnimationIndex());
            tas.bindSpriteTexture();
            try {
                ss.method_4584();
            }
            catch (Exception e) {
                Config.dbg("Error uploading sprite single: " + ss + ", parent: " + tas);
                e.printStackTrace();
            }
        }
    }

    private static int updateAnimationSingle(class_1058 tas) {
        class_1058 spriteSingle = tas.spriteSingle;
        if (spriteSingle != null) {
            tas.bindSpriteTexture();
            spriteSingle.updateAnimation();
            if (spriteSingle.isAnimationActive()) {
                return 1;
            }
        }
        return 0;
    }

    public int getCountRegisteredSprites() {
        return this.counterIndexInMap.getValue();
    }

    private int detectMaxMipmapLevel(Set<class_2960> setSpriteLocations, class_3300 rm) {
        int minLevel;
        int minSize = this.detectMinimumSpriteSize(setSpriteLocations, rm, 20);
        if (minSize < 16) {
            minSize = 16;
        }
        if ((minSize = class_3532.method_15339(minSize)) > 16) {
            Config.log("Sprite size: " + minSize);
        }
        if ((minLevel = class_3532.method_15351(minSize)) < 4) {
            minLevel = 4;
        }
        return minLevel;
    }

    private int detectMinimumSpriteSize(Set<class_2960> setSpriteLocations, class_3300 rm, int percentScale) {
        int count;
        HashMap<Integer, Integer> mapSizeCounts = new HashMap<Integer, Integer>();
        for (class_2960 loc : setSpriteLocations) {
            class_2960 locComplete = this.method_4603(loc);
            try {
                InputStream in;
                class_3298 res = rm.method_14486(locComplete);
                if (res == null || (in = res.method_14482()) == null) continue;
                Dimension dim = TextureUtils.getImageSize(in, "png");
                in.close();
                if (dim == null) continue;
                int width = dim.width;
                int width2 = class_3532.method_15339(width);
                if (!mapSizeCounts.containsKey(width2)) {
                    mapSizeCounts.put(width2, 1);
                    continue;
                }
                count = (Integer)mapSizeCounts.get(width2);
                mapSizeCounts.put(width2, count + 1);
            }
            catch (Exception e) {}
        }
        int countSprites = 0;
        Set setSizes = mapSizeCounts.keySet();
        TreeSet setSizesSorted = new TreeSet(setSizes);
        Iterator it = setSizesSorted.iterator();
        while (it.hasNext()) {
            int size = (Integer)it.next();
            int count2 = (Integer)mapSizeCounts.get(size);
            countSprites += count2;
        }
        int minSize = 16;
        int countScale = 0;
        int countScaleMax = countSprites * percentScale / 100;
        Iterator it2 = setSizesSorted.iterator();
        while (it2.hasNext()) {
            int size = (Integer)it2.next();
            count = (Integer)mapSizeCounts.get(size);
            countScale += count;
            if (size > minSize) {
                minSize = size;
            }
            if (countScale <= countScaleMax) continue;
            return minSize;
        }
        return minSize;
    }

    private static int getMinSpriteSize(int mipmapLevels) {
        int minSize = 1 << mipmapLevels;
        if (minSize < 8) {
            minSize = 8;
        }
        return minSize;
    }

    private static class_1058.class_4727 fixSpriteSize(class_1058.class_4727 info, int minSpriteSize) {
        if (info.method_24123() >= minSpriteSize && info.method_24125() >= minSpriteSize) {
            return info;
        }
        int widthNew = Math.max(info.method_24123(), minSpriteSize);
        int heightNew = Math.max(info.method_24125(), minSpriteSize);
        class_1058.class_4727 infoNew = new class_1058.class_4727(info.method_24121(), widthNew, heightNew, info.getSpriteAnimationMetadata());
        return infoNew;
    }

    public boolean isTextureBound() {
        int texId;
        int boundTexId = GlStateManager.getBoundTexture();
        return boundTexId == (texId = this.method_4624());
    }

    private void updateIconGrid(int sheetWidth, int sheetHeight) {
        this.iconGridCountX = -1;
        this.iconGridCountY = -1;
        this.iconGrid = null;
        if (this.iconGridSize <= 0) {
            return;
        }
        this.iconGridCountX = sheetWidth / this.iconGridSize;
        this.iconGridCountY = sheetHeight / this.iconGridSize;
        this.iconGrid = new class_1058[this.iconGridCountX * this.iconGridCountY];
        this.iconGridSizeU = 1.0 / (double)this.iconGridCountX;
        this.iconGridSizeV = 1.0 / (double)this.iconGridCountY;
        for (class_1058 ts : this.field_5280.values()) {
            double deltaU = 0.5 / (double)sheetWidth;
            double deltaV = 0.5 / (double)sheetHeight;
            double uMin = (double)Math.min(ts.method_4594(), ts.method_4577()) + deltaU;
            double vMin = (double)Math.min(ts.method_4593(), ts.method_4575()) + deltaV;
            double uMax = (double)Math.max(ts.method_4594(), ts.method_4577()) - deltaU;
            double vMax = (double)Math.max(ts.method_4593(), ts.method_4575()) - deltaV;
            int iuMin = (int)(uMin / this.iconGridSizeU);
            int ivMin = (int)(vMin / this.iconGridSizeV);
            int iuMax = (int)(uMax / this.iconGridSizeU);
            int ivMax = (int)(vMax / this.iconGridSizeV);
            for (int iu = iuMin; iu <= iuMax; ++iu) {
                if (iu < 0 || iu >= this.iconGridCountX) {
                    Config.warn("Invalid grid U: " + iu + ", icon: " + ts.method_4598());
                    continue;
                }
                for (int iv = ivMin; iv <= ivMax; ++iv) {
                    if (iv < 0 || iv >= this.iconGridCountX) {
                        Config.warn("Invalid grid V: " + iv + ", icon: " + ts.method_4598());
                        continue;
                    }
                    int index = iv * this.iconGridCountX + iu;
                    this.iconGrid[index] = ts;
                }
            }
        }
    }

    public class_1058 getIconByUV(double u, double v) {
        if (this.iconGrid == null) {
            return null;
        }
        int iv = (int)(v / this.iconGridSizeV);
        int iu = (int)(u / this.iconGridSizeU);
        int index = iv * this.iconGridCountX + iu;
        if (index < 0 || index > this.iconGrid.length) {
            return null;
        }
        return this.iconGrid[index];
    }

    public int getCountAnimations() {
        return this.field_5276.size();
    }

    public int getCountAnimationsActive() {
        return this.countAnimationsActive;
    }

    public class_1058 registerSprite(class_2960 location) {
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null!");
        }
        class_1058 sprite = this.mapRegisteredSprites.get(location);
        if (sprite != null) {
            return sprite;
        }
        this.field_5277.add(location);
        sprite = new class_1058(location);
        this.mapRegisteredSprites.put(location, sprite);
        sprite.updateIndexInMap(this.counterIndexInMap);
        return sprite;
    }

    public Collection<class_1058> getRegisteredSprites() {
        return Collections.unmodifiableCollection(this.mapRegisteredSprites.values());
    }

    public boolean isTerrain() {
        return this.terrain;
    }

    public CounterInt getCounterIndexInMap() {
        return this.counterIndexInMap;
    }

    private void onSpriteMissing(class_2960 loc) {
        class_1058 sprite = this.mapRegisteredSprites.get(loc);
        if (sprite == null) {
            return;
        }
        this.mapMissingSprites.put(loc, sprite);
    }

    private static <T> Set<T> newHashSet(Set<T> set1, Set<T> set2) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(set1);
        set.addAll(set2);
        return set;
    }

    public int getMipmapLevel() {
        return this.mipmapLevel;
    }

    public boolean isMipmaps() {
        return this.mipmapLevel > 0;
    }

    public ITextureFormat getTextureFormat() {
        return this.textureFormat;
    }

    public IColorBlender getShadersColorBlender(ShadersTextureType typeIn) {
        if (typeIn == null) {
            return null;
        }
        if (this.textureFormat != null) {
            return this.textureFormat.getColorBlender(typeIn);
        }
        return new ColorBlenderLinear();
    }

    public boolean isTextureBlend(ShadersTextureType typeIn) {
        if (typeIn == null) {
            return true;
        }
        if (this.textureFormat != null) {
            return this.textureFormat.isTextureBlend(typeIn);
        }
        return true;
    }

    public boolean isNormalBlend() {
        return this.isTextureBlend(ShadersTextureType.NORMAL);
    }

    public boolean isSpecularBlend() {
        return this.isTextureBlend(ShadersTextureType.SPECULAR);
    }

    public String toString() {
        return "" + this.field_21749;
    }

    public static class class_4007 {
        final Set<class_2960> field_17900;
        final int field_17901;
        final int field_17902;
        final int field_21795;
        final List<class_1058> field_17903;

        public class_4007(Set<class_2960> spriteLocationsIn, int widthIn, int heightIn, int mipmapLevelIn, List<class_1058> spritesIn) {
            this.field_17900 = spriteLocationsIn;
            this.field_17901 = widthIn;
            this.field_17902 = heightIn;
            this.field_21795 = mipmapLevelIn;
            this.field_17903 = spritesIn;
        }
    }
}

