/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1049;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.optifine.Config;
import net.optifine.http.HttpPipeline;
import net.optifine.http.HttpRequest;
import net.optifine.http.HttpResponse;
import net.optifine.player.CapeImageBuffer;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_1046
extends class_1049 {
    private static final Logger field_5212 = LogManager.getLogger();
    private static final int field_34017 = 64;
    private static final int field_34018 = 64;
    private static final int field_34019 = 32;
    @Nullable
    private final File field_5210;
    private final String field_5214;
    private final boolean field_20842;
    @Nullable
    private final Runnable field_20843;
    @Nullable
    private CompletableFuture<?> field_20844;
    private boolean field_5215;
    public Boolean imageFound = null;
    public boolean pipeline = false;
    private boolean uploadPending = false;

    public class_1046(@Nullable File cacheFileIn, String imageUrlIn, class_2960 textureResourceLocation, boolean legacySkinIn, @Nullable Runnable processTaskIn) {
        super(textureResourceLocation);
        this.field_5210 = cacheFileIn;
        this.field_5214 = imageUrlIn;
        this.field_20842 = legacySkinIn;
        this.field_20843 = processTaskIn;
    }

    private void method_4534(class_1011 nativeImageIn) {
        if (this.field_20843 instanceof CapeImageBuffer) {
            CapeImageBuffer cib = (CapeImageBuffer)this.field_20843;
            nativeImageIn = cib.parseUserSkin(nativeImageIn);
            cib.skinAvailable();
        }
        this.setImageImpl(nativeImageIn);
    }

    private void setImageImpl(class_1011 nativeImageIn) {
        if (this.field_20843 != null) {
            this.field_20843.run();
        }
        class_310.method_1551().execute(() -> {
            this.field_5215 = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.method_4531(nativeImageIn));
            } else {
                this.method_4531(nativeImageIn);
            }
        });
    }

    private void method_4531(class_1011 imageIn) {
        TextureUtil.prepareImage(this.method_4624(), imageIn.method_4307(), imageIn.method_4323());
        imageIn.method_4301(0, 0, 0, true);
        this.imageFound = imageIn != null;
    }

    @Override
    public void method_4625(class_3300 manager) throws IOException {
        class_310.method_1551().execute(() -> {
            if (!this.field_5215) {
                try {
                    super.method_4625(manager);
                }
                catch (IOException ioexception) {
                    field_5212.warn("Failed to load texture: {}", (Object)this.field_5224, (Object)ioexception);
                }
                this.field_5215 = true;
            }
        });
        if (this.field_20844 == null) {
            class_1011 nativeimage;
            if (this.field_5210 != null && this.field_5210.isFile()) {
                field_5212.debug("Loading http texture from local cache ({})", (Object)this.field_5210);
                FileInputStream fileinputstream = new FileInputStream(this.field_5210);
                nativeimage = this.method_22795(fileinputstream);
            } else {
                nativeimage = null;
            }
            if (nativeimage != null) {
                this.method_4534(nativeimage);
                this.loadingFinished();
            } else {
                this.field_20844 = CompletableFuture.runAsync(() -> {
                    HttpURLConnection httpurlconnection = null;
                    field_5212.debug("Downloading http texture from {} to {}", (Object)this.field_5214, (Object)this.field_5210);
                    if (this.shouldPipeline()) {
                        this.loadPipelined();
                        return;
                    }
                    try {
                        httpurlconnection = (HttpURLConnection)new URL(this.field_5214).openConnection(class_310.method_1551().method_1487());
                        httpurlconnection.setDoInput(true);
                        httpurlconnection.setDoOutput(false);
                        httpurlconnection.connect();
                        if (httpurlconnection.getResponseCode() / 100 == 2) {
                            InputStream inputstream;
                            if (this.field_5210 != null) {
                                FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)this.field_5210);
                                inputstream = new FileInputStream(this.field_5210);
                            } else {
                                inputstream = httpurlconnection.getInputStream();
                            }
                            class_310.method_1551().execute(() -> {
                                class_1011 nativeimage1 = this.method_22795(inputstream);
                                if (nativeimage1 != null) {
                                    this.method_4534(nativeimage1);
                                    this.loadingFinished();
                                }
                            });
                            this.uploadPending = true;
                            return;
                        }
                        if (httpurlconnection.getErrorStream() != null) {
                            Config.readAll(httpurlconnection.getErrorStream());
                        }
                    }
                    catch (Exception exception) {
                        field_5212.error("Couldn't download http texture", (Throwable)exception);
                        return;
                    }
                    finally {
                        if (httpurlconnection != null) {
                            httpurlconnection.disconnect();
                        }
                        this.loadingFinished();
                    }
                }, this.getExecutor());
            }
        }
    }

    @Nullable
    private class_1011 method_22795(InputStream inputStreamIn) {
        class_1011 nativeimage = null;
        try {
            nativeimage = class_1011.method_4309(inputStreamIn);
            if (this.field_20842) {
                nativeimage = this.method_22798(nativeimage);
            }
        }
        catch (Exception exception) {
            field_5212.warn("Error while loading the skin texture", (Throwable)exception);
        }
        return nativeimage;
    }

    private boolean shouldPipeline() {
        if (!this.pipeline) {
            return false;
        }
        Proxy proxy = class_310.method_1551().method_1487();
        if (proxy.type() != Proxy.Type.DIRECT && proxy.type() != Proxy.Type.SOCKS) {
            return false;
        }
        return this.field_5214.startsWith("http://");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPipelined() {
        try {
            HttpRequest req = HttpPipeline.makeRequest(this.field_5214, class_310.method_1551().method_1487());
            HttpResponse resp = HttpPipeline.executeRequest(req);
            if (resp.getStatus() / 100 == 2) {
                class_1011 ni;
                byte[] body = resp.getBody();
                ByteArrayInputStream bais = new ByteArrayInputStream(body);
                if (this.field_5210 != null) {
                    FileUtils.copyInputStreamToFile((InputStream)bais, (File)this.field_5210);
                    ni = class_1011.method_4309(new FileInputStream(this.field_5210));
                } else {
                    ni = class_1011.method_4309(bais);
                }
                this.method_4534(ni);
                this.uploadPending = true;
                return;
            }
        }
        catch (Exception var6) {
            field_5212.error("Couldn't download http texture: " + var6.getClass().getName() + ": " + var6.getMessage());
            return;
        }
        finally {
            this.loadingFinished();
        }
    }

    private void loadingFinished() {
        if (this.uploadPending) {
            return;
        }
        if (this.field_20843 instanceof CapeImageBuffer) {
            CapeImageBuffer cib = (CapeImageBuffer)this.field_20843;
            cib.cleanup();
        }
    }

    public Runnable getProcessTask() {
        return this.field_20843;
    }

    private Executor getExecutor() {
        if (this.field_5214.startsWith("http://s.optifine.net")) {
            return class_156.getCapeExecutor();
        }
        return class_156.method_18349();
    }

    @Nullable
    private class_1011 method_22798(class_1011 p_118032_1_) {
        int i = p_118032_1_.method_4323();
        int j = p_118032_1_.method_4307();
        if (j == 64 && (i == 32 || i == 64)) {
            boolean flag;
            boolean bl = flag = i == 32;
            if (flag) {
                class_1011 nativeimage = new class_1011(64, 64, true);
                nativeimage.method_4317(p_118032_1_);
                p_118032_1_.close();
                p_118032_1_ = nativeimage;
                nativeimage.method_4326(0, 32, 64, 32, 0);
                nativeimage.method_4304(4, 16, 16, 32, 4, 4, true, false);
                nativeimage.method_4304(8, 16, 16, 32, 4, 4, true, false);
                nativeimage.method_4304(0, 20, 24, 32, 4, 12, true, false);
                nativeimage.method_4304(4, 20, 16, 32, 4, 12, true, false);
                nativeimage.method_4304(8, 20, 8, 32, 4, 12, true, false);
                nativeimage.method_4304(12, 20, 16, 32, 4, 12, true, false);
                nativeimage.method_4304(44, 16, -8, 32, 4, 4, true, false);
                nativeimage.method_4304(48, 16, -8, 32, 4, 4, true, false);
                nativeimage.method_4304(40, 20, 0, 32, 4, 12, true, false);
                nativeimage.method_4304(44, 20, -8, 32, 4, 12, true, false);
                nativeimage.method_4304(48, 20, -16, 32, 4, 12, true, false);
                nativeimage.method_4304(52, 20, -8, 32, 4, 12, true, false);
            }
            class_1046.method_22796(p_118032_1_, 0, 0, 32, 16);
            if (flag) {
                class_1046.method_22794(p_118032_1_, 32, 0, 64, 32);
            }
            class_1046.method_22796(p_118032_1_, 0, 16, 64, 32);
            class_1046.method_22796(p_118032_1_, 16, 48, 48, 64);
            return p_118032_1_;
        }
        p_118032_1_.close();
        field_5212.warn("Discarding incorrectly sized ({}x{}) skin texture from {}", (Object)j, (Object)i, (Object)this.field_5214);
        return null;
    }

    private static void method_22794(class_1011 image, int x, int y, int width, int height) {
        for (int i = x; i < width; ++i) {
            for (int j = y; j < height; ++j) {
                int k = image.method_4315(i, j);
                if ((k >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (int l = x; l < width; ++l) {
            for (int i1 = y; i1 < height; ++i1) {
                image.method_4305(l, i1, image.method_4315(l, i1) & 0xFFFFFF);
            }
        }
    }

    private static void method_22796(class_1011 image, int x, int y, int width, int height) {
        for (int i = x; i < width; ++i) {
            for (int j = y; j < height; ++j) {
                image.method_4305(i, j, image.method_4315(i, j) | 0xFF000000);
            }
        }
    }
}

