/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.base.Charsets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_301;
import net.optifine.Config;
import net.optifine.util.NativeMemory;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.stb.STBIWriteCallback;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageResize;
import org.lwjgl.stb.STBImageWrite;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public final class class_1011
implements AutoCloseable {
    private static final Logger field_21684 = LogManager.getLogger();
    private static final int field_32031 = 24;
    private static final int field_32032 = 16;
    private static final int field_32033 = 8;
    private static final int field_32034 = 0;
    private static final Set<StandardOpenOption> field_4992 = EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    private final class_1012 field_4986;
    private final int field_4991;
    private final int field_4989;
    private final boolean field_4990;
    private long field_4988;
    private final long field_4987;

    public class_1011(int widthIn, int heightIn, boolean clear) {
        this(class_1012.field_4997, widthIn, heightIn, clear);
    }

    public class_1011(class_1012 pixelFormatIn, int widthIn, int heightIn, boolean initialize) {
        if (widthIn > 0 && heightIn > 0) {
            this.field_4986 = pixelFormatIn;
            this.field_4991 = widthIn;
            this.field_4989 = heightIn;
            this.field_4987 = (long)widthIn * (long)heightIn * (long)pixelFormatIn.method_4335();
            this.field_4990 = false;
            this.field_4988 = initialize ? MemoryUtil.nmemCalloc((long)1L, (long)this.field_4987) : MemoryUtil.nmemAlloc((long)this.field_4987);
        } else {
            throw new IllegalArgumentException("Invalid texture size: " + widthIn + "x" + heightIn);
        }
        this.method_4320();
        NativeMemory.imageAllocated(this);
    }

    private class_1011(class_1012 pixelFormatIn, int widthIn, int heightIn, boolean stbiPointerIn, long pointer) {
        if (widthIn <= 0 || heightIn <= 0) {
            throw new IllegalArgumentException("Invalid texture size: " + widthIn + "x" + heightIn);
        }
        this.field_4986 = pixelFormatIn;
        this.field_4991 = widthIn;
        this.field_4989 = heightIn;
        this.field_4990 = stbiPointerIn;
        this.field_4988 = pointer;
        this.field_4987 = (long)widthIn * (long)heightIn * (long)pixelFormatIn.method_4335();
    }

    public String toString() {
        return "NativeImage[" + (Object)((Object)this.field_4986) + " " + this.field_4991 + "x" + this.field_4989 + "@" + this.field_4988 + (this.field_4990 ? "S" : "N") + "]";
    }

    private boolean method_36559(int xIn, int yIn) {
        return xIn < 0 || xIn >= this.field_4991 || yIn < 0 || yIn >= this.field_4989;
    }

    public static class_1011 method_4309(InputStream inputStreamIn) throws IOException {
        return class_1011.method_4310(class_1012.field_4997, inputStreamIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static class_1011 method_4310(@Nullable class_1012 pixelFormatIn, InputStream inputStreamIn) throws IOException {
        class_1011 nativeimage;
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = TextureUtil.readResource(inputStreamIn);
            bytebuffer.rewind();
            nativeimage = class_1011.method_4303(pixelFormatIn, bytebuffer);
        }
        finally {
            MemoryUtil.memFree((Buffer)bytebuffer);
            IOUtils.closeQuietly((InputStream)inputStreamIn);
        }
        return nativeimage;
    }

    public static class_1011 method_4324(ByteBuffer byteBufferIn) throws IOException {
        return class_1011.method_4303(class_1012.field_4997, byteBufferIn);
    }

    public static class_1011 method_4303(@Nullable class_1012 pixelFormatIn, ByteBuffer byteBufferIn) throws IOException {
        class_1011 nativeimage;
        if (pixelFormatIn != null && !pixelFormatIn.method_4338()) {
            throw new UnsupportedOperationException("Don't know how to read format " + (Object)((Object)pixelFormatIn));
        }
        if (MemoryUtil.memAddress((ByteBuffer)byteBufferIn) == 0L) {
            throw new IllegalArgumentException("Invalid buffer");
        }
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            ByteBuffer bytebuffer = STBImage.stbi_load_from_memory((ByteBuffer)byteBufferIn, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (IntBuffer)intbuffer2, (int)(pixelFormatIn == null ? 0 : pixelFormatIn.field_4994));
            if (bytebuffer == null) {
                throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
            }
            nativeimage = new class_1011(pixelFormatIn == null ? class_1012.method_4336(intbuffer2.get(0)) : pixelFormatIn, intbuffer.get(0), intbuffer1.get(0), true, MemoryUtil.memAddress((ByteBuffer)bytebuffer));
            NativeMemory.imageAllocated(nativeimage);
        }
        return nativeimage;
    }

    public static void method_4308(boolean linear, boolean mipmap) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (linear) {
            GlStateManager._texParameter(3553, 10241, mipmap ? 9987 : 9729);
            GlStateManager._texParameter(3553, 10240, 9729);
        } else {
            int mipmapType = Config.getMipmapType();
            GlStateManager._texParameter(3553, 10241, mipmap ? mipmapType : 9728);
            GlStateManager._texParameter(3553, 10240, 9728);
        }
    }

    private void method_4320() {
        if (this.field_4988 == 0L) {
            throw new IllegalStateException("Image is not allocated.");
        }
    }

    @Override
    public void close() {
        if (this.field_4988 != 0L) {
            if (this.field_4990) {
                STBImage.nstbi_image_free((long)this.field_4988);
            } else {
                MemoryUtil.nmemFree((long)this.field_4988);
            }
            NativeMemory.imageFreed(this);
        }
        this.field_4988 = 0L;
    }

    public int method_4307() {
        return this.field_4991;
    }

    public int method_4323() {
        return this.field_4989;
    }

    public class_1012 method_4318() {
        return this.field_4986;
    }

    public int method_4315(int x, int y) {
        if (this.field_4986 != class_1012.field_4997) {
            throw new IllegalArgumentException(String.format("getPixelRGBA only works on RGBA images; have %s", new Object[]{this.field_4986}));
        }
        if (this.method_36559(x, y)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.field_4991, this.field_4989));
        }
        this.method_4320();
        long i = ((long)x + (long)y * (long)this.field_4991) * 4L;
        return MemoryUtil.memGetInt((long)(this.field_4988 + i));
    }

    public void method_4305(int x, int y, int value) {
        if (this.field_4986 != class_1012.field_4997) {
            throw new IllegalArgumentException(String.format("getPixelRGBA only works on RGBA images; have %s", new Object[]{this.field_4986}));
        }
        if (this.method_36559(x, y)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.field_4991, this.field_4989));
        }
        this.method_4320();
        long i = ((long)x + (long)y * (long)this.field_4991) * 4L;
        MemoryUtil.memPutInt((long)(this.field_4988 + i), (int)value);
    }

    public void method_35621(int x, int y, byte lum) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (!this.field_4986.method_35631()) {
            throw new IllegalArgumentException(String.format("setPixelLuminance only works on image with luminance; have %s", new Object[]{this.field_4986}));
        }
        if (this.method_36559(x, y)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.field_4991, this.field_4989));
        }
        this.method_4320();
        long i = ((long)x + (long)y * (long)this.field_4991) * (long)this.field_4986.method_4335() + (long)(this.field_4986.method_35635() / 8);
        MemoryUtil.memPutByte((long)(this.field_4988 + i), (byte)lum);
    }

    public byte method_35623(int x, int y) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (!this.field_4986.method_35636()) {
            throw new IllegalArgumentException(String.format("no red or luminance in %s", new Object[]{this.field_4986}));
        }
        if (this.method_36559(x, y)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.field_4991, this.field_4989));
        }
        int i = (x + y * this.field_4991) * this.field_4986.method_4335() + this.field_4986.method_35639() / 8;
        return MemoryUtil.memGetByte((long)(this.field_4988 + (long)i));
    }

    public byte method_35625(int x, int y) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (!this.field_4986.method_35637()) {
            throw new IllegalArgumentException(String.format("no green or luminance in %s", new Object[]{this.field_4986}));
        }
        if (this.method_36559(x, y)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.field_4991, this.field_4989));
        }
        int i = (x + y * this.field_4991) * this.field_4986.method_4335() + this.field_4986.method_35640() / 8;
        return MemoryUtil.memGetByte((long)(this.field_4988 + (long)i));
    }

    public byte method_35626(int x, int y) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (!this.field_4986.method_35638()) {
            throw new IllegalArgumentException(String.format("no blue or luminance in %s", new Object[]{this.field_4986}));
        }
        if (this.method_36559(x, y)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.field_4991, this.field_4989));
        }
        int i = (x + y * this.field_4991) * this.field_4986.method_4335() + this.field_4986.method_35641() / 8;
        return MemoryUtil.memGetByte((long)(this.field_4988 + (long)i));
    }

    public byte method_4311(int x, int y) {
        if (!this.field_4986.method_4337()) {
            throw new IllegalArgumentException(String.format("no luminance or alpha in %s", new Object[]{this.field_4986}));
        }
        if (this.method_36559(x, y)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.field_4991, this.field_4989));
        }
        int i = (x + y * this.field_4991) * this.field_4986.method_4335() + this.field_4986.method_4330() / 8;
        return MemoryUtil.memGetByte((long)(this.field_4988 + (long)i));
    }

    public void method_35624(int x, int y, int col) {
        if (this.field_4986 != class_1012.field_4997) {
            throw new UnsupportedOperationException("Can only call blendPixel with RGBA format");
        }
        int i = this.method_4315(x, y);
        float f = (float)class_1011.method_24030(col) / 255.0f;
        float f1 = (float)class_1011.method_24035(col) / 255.0f;
        float f2 = (float)class_1011.method_24034(col) / 255.0f;
        float f3 = (float)class_1011.method_24033(col) / 255.0f;
        float f4 = (float)class_1011.method_24030(i) / 255.0f;
        float f5 = (float)class_1011.method_24035(i) / 255.0f;
        float f6 = (float)class_1011.method_24034(i) / 255.0f;
        float f7 = (float)class_1011.method_24033(i) / 255.0f;
        float f8 = 1.0f - f;
        float f9 = f * f + f4 * f8;
        float f10 = f1 * f + f5 * f8;
        float f11 = f2 * f + f6 * f8;
        float f12 = f3 * f + f7 * f8;
        if (f9 > 1.0f) {
            f9 = 1.0f;
        }
        if (f10 > 1.0f) {
            f10 = 1.0f;
        }
        if (f11 > 1.0f) {
            f11 = 1.0f;
        }
        if (f12 > 1.0f) {
            f12 = 1.0f;
        }
        int j = (int)(f9 * 255.0f);
        int k = (int)(f10 * 255.0f);
        int l = (int)(f11 * 255.0f);
        int i1 = (int)(f12 * 255.0f);
        this.method_4305(x, y, class_1011.method_24031(j, k, l, i1));
    }

    @Deprecated
    public int[] method_4322() {
        if (this.field_4986 != class_1012.field_4997) {
            throw new UnsupportedOperationException("can only call makePixelArray for RGBA images.");
        }
        this.method_4320();
        int[] aint = new int[this.method_4307() * this.method_4323()];
        for (int i = 0; i < this.method_4323(); ++i) {
            for (int j = 0; j < this.method_4307(); ++j) {
                int l1;
                int k = this.method_4315(j, i);
                int l = class_1011.method_24030(k);
                int i1 = class_1011.method_24035(k);
                int j1 = class_1011.method_24034(k);
                int k1 = class_1011.method_24033(k);
                aint[j + i * this.method_4307()] = l1 = l << 24 | k1 << 16 | j1 << 8 | i1;
            }
        }
        return aint;
    }

    public void method_4301(int level, int xOffset, int yOffset, boolean autoClose) {
        this.method_4312(level, xOffset, yOffset, 0, 0, this.field_4991, this.field_4989, false, autoClose);
    }

    public void method_4312(int level, int xOffset, int yOffset, int unpackSkipPixels, int unpackSkipRows, int widthIn, int heightIn, boolean mipmap, boolean autoClose) {
        this.method_22619(level, xOffset, yOffset, unpackSkipPixels, unpackSkipRows, widthIn, heightIn, false, false, mipmap, autoClose);
    }

    public void method_22619(int level, int xOffset, int yOffset, int unpackSkipPixels, int unpackSkipRows, int widthIn, int heightIn, boolean blur, boolean clamp, boolean mipmap, boolean autoClose) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this.method_4321(level, xOffset, yOffset, unpackSkipPixels, unpackSkipRows, widthIn, heightIn, blur, clamp, mipmap, autoClose));
        } else {
            this.method_4321(level, xOffset, yOffset, unpackSkipPixels, unpackSkipRows, widthIn, heightIn, blur, clamp, mipmap, autoClose);
        }
    }

    private void method_4321(int level, int xOffset, int yOffset, int unpackSkipPixels, int unpackSkipRows, int widthIn, int heightIn, boolean blur, boolean clamp, boolean mipmap, boolean autoClose) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.method_4320();
        class_1011.method_4308(blur, mipmap);
        if (widthIn == this.method_4307()) {
            GlStateManager._pixelStore(3314, 0);
        } else {
            GlStateManager._pixelStore(3314, this.method_4307());
        }
        GlStateManager._pixelStore(3316, unpackSkipPixels);
        GlStateManager._pixelStore(3315, unpackSkipRows);
        this.field_4986.method_4340();
        GlStateManager._texSubImage2D(3553, level, xOffset, yOffset, widthIn, heightIn, this.field_4986.method_4333(), 5121, this.field_4988);
        if (clamp) {
            GlStateManager._texParameter(3553, 10242, 33071);
            GlStateManager._texParameter(3553, 10243, 33071);
        }
        if (autoClose) {
            this.close();
        }
    }

    public void method_4327(int level, boolean opaque) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        this.method_4320();
        this.field_4986.method_4339();
        GlStateManager._getTexImage(3553, level, this.field_4986.method_4333(), 5121, this.field_4988);
        if (opaque && this.field_4986.method_4329()) {
            for (int i = 0; i < this.method_4323(); ++i) {
                for (int j = 0; j < this.method_4307(); ++j) {
                    this.method_4305(j, i, this.method_4315(j, i) | 255 << this.field_4986.method_4332());
                }
            }
        }
    }

    public void method_35620(float val) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (this.field_4986.method_4335() != 1) {
            throw new IllegalStateException("Depth buffer must be stored in NativeImage with 1 component.");
        }
        this.method_4320();
        this.field_4986.method_4339();
        GlStateManager._readPixels(0, 0, this.field_4991, this.field_4989, 6402, 5121, this.field_4988);
    }

    public void method_35627() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        this.field_4986.method_4340();
        GlStateManager._glDrawPixels(this.field_4991, this.field_4989, this.field_4986.method_4333(), 5121, this.field_4988);
    }

    public void method_35622(String pathIn) throws IOException {
        this.method_4314(FileSystems.getDefault().getPath(pathIn, new String[0]));
    }

    public void method_4325(File fileIn) throws IOException {
        this.method_4314(fileIn.toPath());
    }

    public void method_4316(STBTTFontinfo info, int glyphIndex, int widthIn, int heightIn, float scaleX, float scaleY, float shiftX, float shiftY, int x, int y) {
        if (x >= 0 && x + widthIn <= this.method_4307() && y >= 0 && y + heightIn <= this.method_4323()) {
            if (this.field_4986.method_4335() != 1) {
                throw new IllegalArgumentException("Can only write fonts into 1-component images.");
            }
        } else {
            throw new IllegalArgumentException(String.format("Out of bounds: start: (%s, %s) (size: %sx%s); size: %sx%s", x, y, widthIn, heightIn, this.method_4307(), this.method_4323()));
        }
        STBTruetype.nstbtt_MakeGlyphBitmapSubpixel((long)info.address(), (long)(this.field_4988 + (long)x + (long)(y * this.method_4307())), (int)widthIn, (int)heightIn, (int)this.method_4307(), (float)scaleX, (float)scaleY, (float)shiftX, (float)shiftY, (int)glyphIndex);
    }

    public void method_4314(Path pathIn) throws IOException {
        if (!this.field_4986.method_4338()) {
            throw new UnsupportedOperationException("Don't know how to write format " + (Object)((Object)this.field_4986));
        }
        this.method_4320();
        try (SeekableByteChannel writablebytechannel = Files.newByteChannel(pathIn, field_4992, new FileAttribute[0]);){
            if (!this.method_24032(writablebytechannel)) {
                throw new IOException("Could not write image to the PNG file \"" + pathIn.toAbsolutePath() + "\": " + STBImage.stbi_failure_reason());
            }
        }
    }

    public byte[] method_24036() throws IOException {
        byte[] abyte;
        try (ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
             WritableByteChannel writablebytechannel = Channels.newChannel(bytearrayoutputstream);){
            if (!this.method_24032(writablebytechannel)) {
                throw new IOException("Could not write image to byte array: " + STBImage.stbi_failure_reason());
            }
            abyte = bytearrayoutputstream.toByteArray();
        }
        return abyte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean method_24032(WritableByteChannel channelIn) throws IOException {
        boolean flag;
        class_1014 nativeimage$writecallback = new class_1014(channelIn);
        try {
            int i = Math.min(this.method_4323(), Integer.MAX_VALUE / this.method_4307() / this.field_4986.method_4335());
            if (i < this.method_4323()) {
                field_21684.warn("Dropping image height from {} to {} to fit the size into 32-bit signed int", (Object)this.method_4323(), (Object)i);
            }
            if (STBImageWrite.nstbi_write_png_to_func((long)nativeimage$writecallback.address(), (long)0L, (int)this.method_4307(), (int)i, (int)this.field_4986.method_4335(), (long)this.field_4988, (int)0) != 0) {
                nativeimage$writecallback.method_4342();
                boolean bl = true;
                return bl;
            }
            flag = false;
        }
        finally {
            nativeimage$writecallback.free();
        }
        return flag;
    }

    public void method_4317(class_1011 from) {
        if (from.method_4318() != this.field_4986) {
            throw new UnsupportedOperationException("Image formats don't match.");
        }
        int i = this.field_4986.method_4335();
        this.method_4320();
        from.method_4320();
        if (this.field_4991 == from.field_4991) {
            MemoryUtil.memCopy((long)from.field_4988, (long)this.field_4988, (long)Math.min(this.field_4987, from.field_4987));
        } else {
            int j = Math.min(this.method_4307(), from.method_4307());
            int k = Math.min(this.method_4323(), from.method_4323());
            for (int l = 0; l < k; ++l) {
                int i1 = l * from.method_4307() * i;
                int j1 = l * this.method_4307() * i;
                MemoryUtil.memCopy((long)(from.field_4988 + (long)i1), (long)(this.field_4988 + (long)j1), (long)((long)j * (long)i));
            }
        }
    }

    public void method_4326(int x, int y, int widthIn, int heightIn, int value) {
        for (int i = y; i < y + heightIn; ++i) {
            for (int j = x; j < x + widthIn; ++j) {
                this.method_4305(j, i, value);
            }
        }
    }

    public void method_4304(int xFrom, int yFrom, int xToDelta, int yToDelta, int widthIn, int heightIn, boolean mirrorX, boolean mirrorY) {
        for (int i = 0; i < heightIn; ++i) {
            for (int j = 0; j < widthIn; ++j) {
                int k = mirrorX ? widthIn - 1 - j : j;
                int l = mirrorY ? heightIn - 1 - i : i;
                int i1 = this.method_4315(xFrom + j, yFrom + i);
                this.method_4305(xFrom + xToDelta + k, yFrom + yToDelta + l, i1);
            }
        }
    }

    public void method_4319() {
        this.method_4320();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            int i = this.field_4986.method_4335();
            int j = this.method_4307() * i;
            long k = memorystack.nmalloc(j);
            for (int l = 0; l < this.method_4323() / 2; ++l) {
                int i1 = l * this.method_4307() * i;
                int j1 = (this.method_4323() - 1 - l) * this.method_4307() * i;
                MemoryUtil.memCopy((long)(this.field_4988 + (long)i1), (long)k, (long)j);
                MemoryUtil.memCopy((long)(this.field_4988 + (long)j1), (long)(this.field_4988 + (long)i1), (long)j);
                MemoryUtil.memCopy((long)k, (long)(this.field_4988 + (long)j1), (long)j);
            }
        }
    }

    public void method_4300(int xIn, int yIn, int widthIn, int heightIn, class_1011 imageIn) {
        this.method_4320();
        if (imageIn.method_4318() != this.field_4986) {
            throw new UnsupportedOperationException("resizeSubRectTo only works for images of the same format.");
        }
        int i = this.field_4986.method_4335();
        STBImageResize.nstbir_resize_uint8((long)(this.field_4988 + (long)((xIn + yIn * this.method_4307()) * i)), (int)widthIn, (int)heightIn, (int)(this.method_4307() * i), (long)imageIn.field_4988, (int)imageIn.method_4307(), (int)imageIn.method_4323(), (int)0, (int)i);
    }

    public void method_4302() {
        class_301.method_1407(this.field_4988);
    }

    public static class_1011 method_15990(String stringIn) throws IOException {
        class_1011 nativeimage;
        byte[] abyte = Base64.getDecoder().decode(stringIn.replaceAll("\n", "").getBytes(Charsets.UTF_8));
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(abyte.length);
            bytebuffer.put(abyte);
            bytebuffer.rewind();
            nativeimage = class_1011.method_4324(bytebuffer);
        }
        return nativeimage;
    }

    public static int method_24030(int col) {
        return col >> 24 & 0xFF;
    }

    public static int method_24033(int col) {
        return col >> 0 & 0xFF;
    }

    public static int method_24034(int col) {
        return col >> 8 & 0xFF;
    }

    public static int method_24035(int col) {
        return col >> 16 & 0xFF;
    }

    public static int method_24031(int alpha, int blue, int green, int red) {
        return (alpha & 0xFF) << 24 | (blue & 0xFF) << 16 | (green & 0xFF) << 8 | (red & 0xFF) << 0;
    }

    public IntBuffer getBufferRGBA() {
        if (this.field_4986 != class_1012.field_4997) {
            throw new IllegalArgumentException(String.format("getBuffer only works on RGBA images; have %s", new Object[]{this.field_4986}));
        }
        this.method_4320();
        return MemoryUtil.memIntBuffer((long)this.field_4988, (int)((int)this.field_4987));
    }

    public void fillRGBA(int rgba) {
        if (this.field_4986 != class_1012.field_4997) {
            throw new IllegalArgumentException(String.format("getBuffer only works on RGBA images; have %s", new Object[]{this.field_4986}));
        }
        this.method_4320();
        MemoryUtil.memSet((long)this.field_4988, (int)rgba, (long)this.field_4987);
    }

    public long getSize() {
        return this.field_4987;
    }

    public void downloadFromFramebuffer(boolean opaque) {
        this.method_4320();
        this.field_4986.method_4339();
    }

    static class class_1014
    extends STBIWriteCallback {
        private final WritableByteChannel field_5018;
        @Nullable
        private IOException field_5019;

        class_1014(WritableByteChannel byteChannelIn) {
            this.field_5018 = byteChannelIn;
        }

        public void invoke(long p_invoke_1_, long p_invoke_3_, int p_invoke_5_) {
            ByteBuffer bytebuffer = class_1014.getData((long)p_invoke_3_, (int)p_invoke_5_);
            try {
                this.field_5018.write(bytebuffer);
            }
            catch (IOException ioexception) {
                this.field_5019 = ioexception;
            }
        }

        public void method_4342() throws IOException {
            if (this.field_5019 != null) {
                throw this.field_5019;
            }
        }
    }

    public static enum class_1013 {
        field_5012(6408),
        field_5011(6407),
        field_33618(33319),
        field_33619(6403);

        private final int field_5015;

        private class_1013(int glFormatIn) {
            this.field_5015 = glFormatIn;
        }

        public int method_4341() {
            return this.field_5015;
        }
    }

    public static enum class_1012 {
        field_4997(4, 6408, true, true, true, false, true, 0, 8, 16, 255, 24, true),
        field_5001(3, 6407, true, true, true, false, false, 0, 8, 16, 255, 255, true),
        field_5002(2, 33319, false, false, false, true, true, 255, 255, 255, 0, 8, true),
        field_4998(1, 6403, false, false, false, true, false, 0, 0, 0, 0, 255, true);

        final int field_4994;
        private final int field_4993;
        private final boolean field_5005;
        private final boolean field_5004;
        private final boolean field_5003;
        private final boolean field_5000;
        private final boolean field_4999;
        private final int field_5010;
        private final int field_5009;
        private final int field_5008;
        private final int field_5007;
        private final int field_5006;
        private final boolean field_4996;

        private class_1012(int channelsIn, int glFormatIn, boolean redIn, boolean greenIn, boolean blueIn, boolean luminanceIn, boolean alphaIn, int offsetRedIn, int offsetGreenIn, int offsetBlueIn, int offsetLuminanceIn, int offsetAlphaIn, boolean standardIn) {
            this.field_4994 = channelsIn;
            this.field_4993 = glFormatIn;
            this.field_5005 = redIn;
            this.field_5004 = greenIn;
            this.field_5003 = blueIn;
            this.field_5000 = luminanceIn;
            this.field_4999 = alphaIn;
            this.field_5010 = offsetRedIn;
            this.field_5009 = offsetGreenIn;
            this.field_5008 = offsetBlueIn;
            this.field_5007 = offsetLuminanceIn;
            this.field_5006 = offsetAlphaIn;
            this.field_4996 = standardIn;
        }

        public int method_4335() {
            return this.field_4994;
        }

        public void method_4339() {
            RenderSystem.assertThread(RenderSystem::isOnRenderThread);
            GlStateManager._pixelStore(3333, this.method_4335());
        }

        public void method_4340() {
            RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
            GlStateManager._pixelStore(3317, this.method_4335());
        }

        public int method_4333() {
            return this.field_4993;
        }

        public boolean method_35628() {
            return this.field_5005;
        }

        public boolean method_35629() {
            return this.field_5004;
        }

        public boolean method_35630() {
            return this.field_5003;
        }

        public boolean method_35631() {
            return this.field_5000;
        }

        public boolean method_4329() {
            return this.field_4999;
        }

        public int method_35632() {
            return this.field_5010;
        }

        public int method_35633() {
            return this.field_5009;
        }

        public int method_35634() {
            return this.field_5008;
        }

        public int method_35635() {
            return this.field_5007;
        }

        public int method_4332() {
            return this.field_5006;
        }

        public boolean method_35636() {
            return this.field_5000 || this.field_5005;
        }

        public boolean method_35637() {
            return this.field_5000 || this.field_5004;
        }

        public boolean method_35638() {
            return this.field_5000 || this.field_5003;
        }

        public boolean method_4337() {
            return this.field_5000 || this.field_4999;
        }

        public int method_35639() {
            return this.field_5000 ? this.field_5007 : this.field_5010;
        }

        public int method_35640() {
            return this.field_5000 ? this.field_5007 : this.field_5009;
        }

        public int method_35641() {
            return this.field_5000 ? this.field_5007 : this.field_5008;
        }

        public int method_4330() {
            return this.field_5000 ? this.field_5007 : this.field_5006;
        }

        public boolean method_4338() {
            return this.field_4996;
        }

        static class_1012 method_4336(int channelsIn) {
            switch (channelsIn) {
                case 1: {
                    return field_4998;
                }
                case 2: {
                    return field_5002;
                }
                case 3: {
                    return field_5001;
                }
            }
            return field_4997;
        }
    }
}

