/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.vertex.BufferVertexConsumer;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.DefaultedVertexConsumer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.optifine.Config;
import net.optifine.SmartAnimations;
import net.optifine.render.MultiTextureBuilder;
import net.optifine.render.MultiTextureData;
import net.optifine.render.RenderEnv;
import net.optifine.render.VertexPosition;
import net.optifine.shaders.SVertexBuilder;
import net.optifine.util.BufferUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BufferBuilder
extends DefaultedVertexConsumer
implements BufferVertexConsumer {
    private static final int f_313166_ = 0x200000;
    private static final Logger f_85647_ = LogManager.getLogger();
    private ByteBuffer f_85648_;
    private final List<DrawState> f_190417_ = Lists.newArrayList();
    private int f_190418_;
    private int f_85651_;
    private int f_85652_;
    private int f_85653_;
    private int f_85654_;
    @Nullable
    private VertexFormatElement f_85655_;
    private int f_85656_;
    private VertexFormat f_85658_;
    private VertexFormat.Mode f_85657_;
    private boolean f_85659_;
    private boolean f_85660_;
    private boolean f_85661_;
    @Nullable
    private Vector3f[] f_190419_;
    private float f_190420_ = Float.NaN;
    private float f_190421_ = Float.NaN;
    private float f_190422_ = Float.NaN;
    private boolean f_190423_;
    private RenderType renderType;
    private boolean renderBlocks;
    private TextureAtlasSprite[] quadSprites = null;
    private TextureAtlasSprite[] quadSpritesPrev = null;
    private int[] quadOrdering = null;
    private TextureAtlasSprite quadSprite = null;
    private MultiTextureBuilder multiTextureBuilder = new MultiTextureBuilder();
    public SVertexBuilder sVertexBuilder;
    public RenderEnv renderEnv = null;
    public BitSet animatedSprites = null;
    public BitSet animatedSpritesCached = new BitSet();
    private ByteBuffer byteBufferTriangles;
    private Vector3f tempVec3f = new Vector3f();
    private float[] tempFloat4 = new float[4];
    private int[] tempInt4 = new int[4];
    private IntBuffer intBuffer;
    private FloatBuffer floatBuffer;
    private MultiBufferSource.BufferSource renderTypeBuffer;
    private FloatBuffer floatBufferSort;
    private VertexPosition[] quadVertexPositions;
    private Vector3f midBlock = new Vector3f();

    public BufferBuilder(int bufferSizeIn) {
        this.f_85648_ = MemoryTracker.m_321011_((int)(bufferSizeIn * 6));
        this.intBuffer = this.f_85648_.asIntBuffer();
        this.floatBuffer = this.f_85648_.asFloatBuffer();
        SVertexBuilder.initVertexBuilder((BufferBuilder)this);
    }

    private void m_85665_() {
        this.m_85722_(this.f_85658_.m_86020_());
    }

    private void m_85722_(int increaseAmount) {
        if (this.f_85652_ + increaseAmount > this.f_85648_.capacity()) {
            int i = this.f_85648_.capacity();
            int j = i + BufferBuilder.m_85725_(increaseAmount);
            f_85647_.debug("Needed to grow BufferBuilder buffer: Old size {} bytes, new size {} bytes.", (Object)i, (Object)j);
            ByteBuffer bytebuffer = MemoryTracker.m_321013_((ByteBuffer)this.f_85648_, (int)j);
            bytebuffer.rewind();
            this.f_85648_ = bytebuffer;
            this.intBuffer = this.f_85648_.asIntBuffer();
            this.floatBuffer = this.f_85648_.asFloatBuffer();
            if (this.quadSprites != null) {
                TextureAtlasSprite[] sprites = this.quadSprites;
                int quadSize = this.getBufferQuadSize();
                this.quadSprites = new TextureAtlasSprite[quadSize];
                System.arraycopy(sprites, 0, this.quadSprites, 0, Math.min(sprites.length, this.quadSprites.length));
                this.quadSpritesPrev = null;
            }
        }
    }

    private static int m_85725_(int xIn) {
        int j;
        int i = 0x200000;
        if (xIn == 0) {
            return i;
        }
        if (xIn < 0) {
            i *= -1;
        }
        return (j = xIn % i) == 0 ? xIn : xIn + i - j;
    }

    public void m_190426_(float cameraX, float cameraY, float cameraZ) {
        if (this.f_85657_ == VertexFormat.Mode.QUADS && (this.f_190420_ != cameraX || this.f_190421_ != cameraY || this.f_190422_ != cameraZ)) {
            this.f_190420_ = cameraX;
            this.f_190421_ = cameraY;
            this.f_190422_ = cameraZ;
            if (this.f_190419_ == null) {
                this.f_190419_ = this.m_190476_();
            }
        }
    }

    public SortState m_190425_() {
        TextureAtlasSprite[] quadSpritesNew = null;
        if (this.quadSprites != null) {
            int countQuads = this.f_85654_ / 4;
            quadSpritesNew = Arrays.copyOfRange(this.quadSprites, 0, countQuads);
        }
        return new SortState(this.f_85657_, this.f_85654_, this.f_190419_, this.f_190420_, this.f_190421_, this.f_190422_, quadSpritesNew);
    }

    public void m_190454_(SortState sortStateIn) {
        this.f_85648_.clear();
        this.f_85657_ = sortStateIn.f_190508_;
        this.f_85654_ = sortStateIn.f_190509_;
        this.f_85652_ = this.f_85651_;
        this.f_190419_ = sortStateIn.f_190510_;
        this.f_190420_ = sortStateIn.f_190511_;
        this.f_190421_ = sortStateIn.f_190512_;
        this.f_190422_ = sortStateIn.f_190513_;
        this.f_190423_ = true;
        if (this.quadSprites != null && sortStateIn.quadSprites != null) {
            System.arraycopy(sortStateIn.quadSprites, 0, this.quadSprites, 0, Math.min(sortStateIn.quadSprites.length, this.quadSprites.length));
        }
    }

    public void m_190458_(VertexFormat.Mode modeIn, VertexFormat formatIn) {
        if (this.f_85661_) {
            throw new IllegalStateException("Already building!");
        }
        this.f_85661_ = true;
        this.f_85657_ = modeIn;
        this.m_85704_(formatIn);
        this.f_85655_ = (VertexFormatElement)formatIn.m_86023_().get(0);
        this.f_85656_ = 0;
        this.f_85648_.clear();
        if (Config.isShaders()) {
            SVertexBuilder.endSetVertexFormat((BufferBuilder)this);
        }
        if (Config.isMultiTexture()) {
            this.initQuadSprites();
        }
        if (SmartAnimations.isActive()) {
            if (this.animatedSprites == null) {
                this.animatedSprites = this.animatedSpritesCached;
            }
            this.animatedSprites.clear();
        } else if (this.animatedSprites != null) {
            this.animatedSprites = null;
        }
    }

    public VertexConsumer m_7421_(float u, float v) {
        if (this.quadSprite != null && this.quadSprites != null) {
            u = this.quadSprite.toSingleU(u);
            v = this.quadSprite.toSingleV(v);
            this.quadSprites[this.f_85654_ / 4] = this.quadSprite;
        }
        return super.m_7421_(u, v);
    }

    private void m_85704_(VertexFormat vertexFormatIn) {
        if (this.f_85658_ != vertexFormatIn) {
            this.f_85658_ = vertexFormatIn;
            boolean flag = vertexFormatIn == DefaultVertexFormat.f_85812_;
            boolean flag1 = vertexFormatIn == DefaultVertexFormat.f_85811_;
            this.f_85659_ = flag || flag1;
            this.f_85660_ = flag;
        }
    }

    private IntConsumer m_190456_(VertexFormat.IndexType indexTypeIn) {
        switch (indexTypeIn) {
            case BYTE: {
                return valueIn -> this.f_85648_.put((byte)valueIn);
            }
            case SHORT: {
                return valueIn -> this.f_85648_.putShort((short)valueIn);
            }
        }
        return valueIn -> this.f_85648_.putInt(valueIn);
    }

    private Vector3f[] m_190476_() {
        FloatBuffer floatbuffer = this.f_85648_.asFloatBuffer();
        int i = this.f_85651_ / 4;
        int j = this.f_85658_.m_86017_();
        int k = j * this.f_85657_.f_190734_;
        int l = this.f_85654_ / this.f_85657_.f_190734_;
        Vector3f[] avector3f = new Vector3f[l];
        for (int i1 = 0; i1 < l; ++i1) {
            float f = floatbuffer.get(i + i1 * k + 0);
            float f1 = floatbuffer.get(i + i1 * k + 1);
            float f2 = floatbuffer.get(i + i1 * k + 2);
            float f3 = floatbuffer.get(i + i1 * k + j * 2 + 0);
            float f4 = floatbuffer.get(i + i1 * k + j * 2 + 1);
            float f5 = floatbuffer.get(i + i1 * k + j * 2 + 2);
            float f6 = (f + f3) / 2.0f;
            float f7 = (f1 + f4) / 2.0f;
            float f8 = (f2 + f5) / 2.0f;
            avector3f[i1] = new Vector3f(f6, f7, f8);
        }
        return avector3f;
    }

    private void m_190466_(VertexFormat.IndexType indexTypeIn) {
        float[] afloat = new float[this.f_190419_.length];
        int[] aint = new int[this.f_190419_.length];
        int i = 0;
        while (i < this.f_190419_.length) {
            float f = this.f_190419_[i].m_122239_() - this.f_190420_;
            float f1 = this.f_190419_[i].m_122260_() - this.f_190421_;
            float f2 = this.f_190419_[i].m_122269_() - this.f_190422_;
            afloat[i] = f * f + f1 * f1 + f2 * f2;
            aint[i] = i++;
        }
        IntArrays.mergeSort((int[])aint, (index1, index2) -> Floats.compare((float)afloat[index2], (float)afloat[index1]));
        IntConsumer intconsumer = this.m_190456_(indexTypeIn);
        this.f_85648_.position(this.f_85652_);
        for (int j : aint) {
            intconsumer.accept(j * this.f_85657_.f_190734_ + 0);
            intconsumer.accept(j * this.f_85657_.f_190734_ + 1);
            intconsumer.accept(j * this.f_85657_.f_190734_ + 2);
            intconsumer.accept(j * this.f_85657_.f_190734_ + 2);
            intconsumer.accept(j * this.f_85657_.f_190734_ + 3);
            intconsumer.accept(j * this.f_85657_.f_190734_ + 0);
        }
        if (this.quadSprites != null) {
            this.quadOrdering = aint;
        }
    }

    public void m_85721_() {
        boolean flag;
        if (!this.f_85661_) {
            throw new IllegalStateException("Not building!");
        }
        int i = this.f_85657_.m_190743_(this.f_85654_);
        VertexFormat.IndexType vertexformat$indextype = VertexFormat.IndexType.m_190721_(i);
        if (this.f_190419_ != null) {
            int j = Mth.m_146242_(i * vertexformat$indextype.f_190713_, 4);
            this.m_85722_(j);
            this.m_190466_(vertexformat$indextype);
            flag = false;
            this.f_85652_ += j;
            this.f_85651_ += this.f_85654_ * this.f_85658_.m_86020_() + j;
        } else {
            flag = true;
            this.f_85651_ += this.f_85654_ * this.f_85658_.m_86020_();
        }
        this.f_85661_ = false;
        MultiTextureData mtd = this.multiTextureBuilder.build(this.f_85654_, this.renderType, this.quadSprites, this.quadOrdering);
        this.f_190417_.add(new DrawState(this.f_85658_, this.f_85654_, i, this.f_85657_, vertexformat$indextype, this.f_190423_, flag, mtd));
        this.renderType = null;
        this.renderBlocks = false;
        if (this.quadSprites != null) {
            this.quadSpritesPrev = this.quadSprites;
        }
        this.quadSprites = null;
        this.quadSprite = null;
        this.quadOrdering = null;
        this.f_85654_ = 0;
        this.f_85655_ = null;
        this.f_85656_ = 0;
        this.f_190419_ = null;
        this.f_190420_ = Float.NaN;
        this.f_190421_ = Float.NaN;
        this.f_190422_ = Float.NaN;
        this.f_190423_ = false;
    }

    public void m_5672_(int indexIn, byte byteIn) {
        this.f_85648_.put(this.f_85652_ + indexIn, byteIn);
    }

    public void m_5586_(int indexIn, short shortIn) {
        this.f_85648_.putShort(this.f_85652_ + indexIn, shortIn);
    }

    public void m_5832_(int indexIn, float floatIn) {
        this.f_85648_.putFloat(this.f_85652_ + indexIn, floatIn);
    }

    public void m_5752_() {
        if (this.f_85656_ != 0) {
            throw new IllegalStateException("Not filled all elements of the vertex");
        }
        ++this.f_85654_;
        this.m_85665_();
        if (this.f_85657_ == VertexFormat.Mode.LINES || this.f_85657_ == VertexFormat.Mode.LINE_STRIP) {
            int i = this.f_85658_.m_86020_();
            this.f_85648_.position(this.f_85652_);
            ByteBuffer bytebuffer = this.f_85648_.duplicate();
            bytebuffer.position(this.f_85652_ - i).limit(this.f_85652_);
            this.f_85648_.put(bytebuffer);
            this.f_85652_ += i;
            ++this.f_85654_;
            this.m_85665_();
        }
        if (Config.isShaders()) {
            SVertexBuilder.endAddVertex((BufferBuilder)this);
        }
    }

    public void m_5751_() {
        VertexFormatElement vertexformatelement;
        ImmutableList<VertexFormatElement> immutablelist = this.f_85658_.m_86023_();
        this.f_85656_ = (this.f_85656_ + 1) % immutablelist.size();
        this.f_85652_ += this.f_85655_.m_86050_();
        this.f_85655_ = vertexformatelement = (VertexFormatElement)immutablelist.get(this.f_85656_);
        if (vertexformatelement.m_86048_() == VertexFormatElement.Usage.PADDING) {
            this.m_5751_();
        }
        if (this.f_85824_ && this.f_85655_.m_86048_() == VertexFormatElement.Usage.COLOR) {
            super.m_6122_(this.f_85825_, this.f_85826_, this.f_85827_, this.f_85828_);
        }
    }

    public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
        if (this.f_85824_) {
            throw new IllegalStateException();
        }
        return super.m_6122_(red, green, blue, alpha);
    }

    public void m_5954_(float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        if (this.f_85824_) {
            throw new IllegalStateException();
        }
        if (this.f_85659_) {
            int i;
            this.m_5832_(0, x);
            this.m_5832_(4, y);
            this.m_5832_(8, z);
            this.m_5672_(12, (byte)(red * 255.0f));
            this.m_5672_(13, (byte)(green * 255.0f));
            this.m_5672_(14, (byte)(blue * 255.0f));
            this.m_5672_(15, (byte)(alpha * 255.0f));
            this.m_5832_(16, texU);
            this.m_5832_(20, texV);
            if (this.f_85660_) {
                this.m_5586_(24, (short)(overlayUV & 0xFFFF));
                this.m_5586_(26, (short)(overlayUV >> 16 & 0xFFFF));
                i = 28;
            } else {
                i = 24;
            }
            this.m_5586_(i + 0, (short)(lightmapUV & 0xFFFF));
            this.m_5586_(i + 2, (short)(lightmapUV >> 16 & 0xFFFF));
            this.m_5672_(i + 4, BufferVertexConsumer.m_85774_((float)normalX));
            this.m_5672_(i + 5, BufferVertexConsumer.m_85774_((float)normalY));
            this.m_5672_(i + 6, BufferVertexConsumer.m_85774_((float)normalZ));
            this.f_85652_ += this.f_85658_.m_86020_();
            this.m_5752_();
        } else {
            super.m_5954_(x, y, z, red, green, blue, alpha, texU, texV, overlayUV, lightmapUV, normalX, normalY, normalZ);
        }
    }

    public Pair<DrawState, ByteBuffer> m_85728_() {
        DrawState bufferbuilder$drawstate = this.f_190417_.get(this.f_190418_++);
        this.f_85648_.position(this.f_85653_);
        this.f_85653_ += Mth.m_146242_(bufferbuilder$drawstate.m_190504_(), 4);
        this.f_85648_.limit(this.f_85653_);
        if (this.f_190418_ == this.f_190417_.size() && this.f_85654_ == 0) {
            this.m_85729_();
        }
        ByteBuffer bytebuffer = this.f_85648_.slice();
        bytebuffer.order(this.f_85648_.order());
        this.f_85648_.clear();
        return Pair.of((Object)bufferbuilder$drawstate, (Object)bytebuffer);
    }

    public void m_85729_() {
        if (this.f_85651_ != this.f_85653_) {
            f_85647_.warn("Bytes mismatch {} {}", (Object)this.f_85651_, (Object)this.f_85653_);
        }
        this.m_85730_();
    }

    public void m_85730_() {
        this.f_85651_ = 0;
        this.f_85653_ = 0;
        this.f_85652_ = 0;
        this.f_190417_.clear();
        this.f_190418_ = 0;
        this.quadSprite = null;
    }

    public VertexFormatElement m_6297_() {
        if (this.f_85655_ == null) {
            throw new IllegalStateException("BufferBuilder not started");
        }
        return this.f_85655_;
    }

    public boolean m_85732_() {
        return this.f_85661_;
    }

    public void putSprite(TextureAtlasSprite sprite) {
        if (this.animatedSprites != null && sprite != null && sprite.isTerrain() && sprite.getAnimationIndex() >= 0) {
            this.animatedSprites.set(sprite.getAnimationIndex());
        }
        if (this.quadSprites != null) {
            int countQuads = this.f_85654_ / 4;
            this.quadSprites[countQuads] = sprite;
        }
    }

    public void setSprite(TextureAtlasSprite sprite) {
        if (this.animatedSprites != null && sprite != null && sprite.isTerrain() && sprite.getAnimationIndex() >= 0) {
            this.animatedSprites.set(sprite.getAnimationIndex());
        }
        if (this.quadSprites != null) {
            this.quadSprite = sprite;
        }
    }

    public boolean isMultiTexture() {
        return this.quadSprites != null;
    }

    public void setRenderType(RenderType renderType) {
        this.renderType = renderType;
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public void setRenderBlocks(boolean renderBlocks) {
        this.renderBlocks = renderBlocks;
        if (Config.isMultiTexture()) {
            this.initQuadSprites();
        }
    }

    public void setBlockLayer(RenderType layer) {
        this.renderType = layer;
        this.renderBlocks = true;
    }

    private void initQuadSprites() {
        if (!this.renderBlocks) {
            return;
        }
        if (this.renderType == null) {
            return;
        }
        if (this.quadSprites != null) {
            return;
        }
        if (!this.f_85661_) {
            return;
        }
        if (this.f_85654_ > 0) {
            VertexFormat.Mode drawModePrev = this.f_85657_;
            VertexFormat vertexFormatPrev = this.f_85658_;
            RenderType renderTypePrev = this.renderType;
            boolean renderBlocksPrev = this.renderBlocks;
            this.renderType.m_110412_(this, 0, 0, 0);
            this.m_190458_(drawModePrev, vertexFormatPrev);
            this.renderType = renderTypePrev;
            this.renderBlocks = renderBlocksPrev;
        }
        this.quadSprites = this.quadSpritesPrev;
        if (this.quadSprites == null || this.quadSprites.length < this.getBufferQuadSize()) {
            this.quadSprites = new TextureAtlasSprite[this.getBufferQuadSize()];
        }
    }

    private int getBufferQuadSize() {
        int quadSize = this.f_85648_.capacity() / this.f_85658_.m_86020_();
        return quadSize;
    }

    public RenderEnv getRenderEnv(BlockState blockStateIn, BlockPos blockPosIn) {
        if (this.renderEnv == null) {
            this.renderEnv = new RenderEnv(blockStateIn, blockPosIn);
            return this.renderEnv;
        }
        this.renderEnv.reset(blockStateIn, blockPosIn);
        return this.renderEnv;
    }

    private static void quadsToTriangles(ByteBuffer byteBuffer, VertexFormat vertexFormat, int vertexCount, ByteBuffer byteBufferTriangles) {
        int vertexSize = vertexFormat.m_86020_();
        int limit = byteBuffer.limit();
        byteBuffer.rewind();
        byteBufferTriangles.clear();
        for (int v = 0; v < vertexCount; v += 4) {
            byteBuffer.limit((v + 3) * vertexSize);
            byteBuffer.position(v * vertexSize);
            byteBufferTriangles.put(byteBuffer);
            byteBuffer.limit((v + 1) * vertexSize);
            byteBuffer.position(v * vertexSize);
            byteBufferTriangles.put(byteBuffer);
            byteBuffer.limit((v + 2 + 2) * vertexSize);
            byteBuffer.position((v + 2) * vertexSize);
            byteBufferTriangles.put(byteBuffer);
        }
        byteBuffer.limit(limit);
        byteBuffer.rewind();
        byteBufferTriangles.flip();
    }

    public VertexFormat.Mode getDrawMode() {
        return this.f_85657_;
    }

    public int getVertexCount() {
        return this.f_85654_;
    }

    public Vector3f getTempVec3f(Vector3f vec) {
        this.tempVec3f.m_122245_(vec.m_122239_(), vec.m_122260_(), vec.m_122269_());
        return this.tempVec3f;
    }

    public Vector3f getTempVec3f(float x, float y, float z) {
        this.tempVec3f.m_122245_(x, y, z);
        return this.tempVec3f;
    }

    public float[] getTempFloat4(float f1, float f2, float f3, float f4) {
        this.tempFloat4[0] = f1;
        this.tempFloat4[1] = f2;
        this.tempFloat4[2] = f3;
        this.tempFloat4[3] = f4;
        return this.tempFloat4;
    }

    public int[] getTempInt4(int i1, int i2, int i3, int i4) {
        this.tempInt4[0] = i1;
        this.tempInt4[1] = i2;
        this.tempInt4[2] = i3;
        this.tempInt4[3] = i4;
        return this.tempInt4;
    }

    public ByteBuffer getByteBuffer() {
        return this.f_85648_;
    }

    public FloatBuffer getFloatBuffer() {
        return this.floatBuffer;
    }

    public IntBuffer getIntBuffer() {
        return this.intBuffer;
    }

    public int getBufferIntSize() {
        return this.f_85654_ * this.f_85658_.m_86017_();
    }

    private FloatBuffer getFloatBufferSort(int size) {
        if (this.floatBufferSort == null || this.floatBufferSort.capacity() < size) {
            this.floatBufferSort = BufferUtil.createDirectFloatBuffer(size);
        }
        return this.floatBufferSort;
    }

    public MultiBufferSource.BufferSource getRenderTypeBuffer() {
        return this.renderTypeBuffer;
    }

    public void setRenderTypeBuffer(MultiBufferSource.BufferSource renderTypeBuffer) {
        this.renderTypeBuffer = renderTypeBuffer;
    }

    public void addVertexText(float x, float y, float z, int red, int green, int blue, int alpha, float texU, float texV, int lightmapU, int lightmapV) {
        if (this.f_85658_.m_86020_() != DefaultVertexFormat.f_85820_.m_86020_()) {
            throw new IllegalStateException("Invalid text vertex format: " + this.f_85658_);
        }
        this.m_5832_(0, x);
        this.m_5832_(4, y);
        this.m_5832_(8, z);
        this.m_5672_(12, (byte)red);
        this.m_5672_(13, (byte)green);
        this.m_5672_(14, (byte)blue);
        this.m_5672_(15, (byte)alpha);
        this.m_5832_(16, texU);
        this.m_5832_(20, texV);
        this.m_5586_(24, (short)lightmapU);
        this.m_5586_(26, (short)lightmapV);
        this.f_85652_ += this.f_85658_.m_86020_();
        this.m_5752_();
    }

    public void setQuadVertexPositions(VertexPosition[] vps) {
        this.quadVertexPositions = vps;
    }

    public VertexPosition[] getQuadVertexPositions() {
        return this.quadVertexPositions;
    }

    public void setMidBlock(float mx, float my, float mz) {
        this.midBlock.m_122245_(mx, my, mz);
    }

    public Vector3f getMidBlock() {
        return this.midBlock;
    }

    public void putBulkData(ByteBuffer buffer) {
        if (Config.isShaders()) {
            SVertexBuilder.beginAddVertexData((BufferBuilder)this, (ByteBuffer)buffer);
        }
        this.m_85722_(buffer.limit() + this.f_85658_.m_86020_());
        this.f_85648_.position(this.f_85654_ * this.f_85658_.m_86020_());
        this.f_85648_.put(buffer);
        this.f_85654_ += buffer.limit() / this.f_85658_.m_86020_();
        this.f_85652_ += buffer.limit();
        if (Config.isShaders()) {
            SVertexBuilder.endAddVertexData((BufferBuilder)this);
        }
    }

    public VertexFormat getVertexFormat() {
        return this.f_85658_;
    }

    public int getStartPosition() {
        return this.f_85651_;
    }

    public int getIntStartPosition() {
        return this.f_85651_ / 4;
    }

    public static class SortState {
        final VertexFormat.Mode f_190508_;
        final int f_190509_;
        @Nullable
        final Vector3f[] f_190510_;
        final float f_190511_;
        final float f_190512_;
        final float f_190513_;
        private TextureAtlasSprite[] quadSprites;

        private SortState(VertexFormat.Mode modeIn, int verticesIn, @Nullable Vector3f[] sortingPointsIn, float sortXIn, float sortYIn, float sortZIn, TextureAtlasSprite[] quadSpritesIn) {
            this(modeIn, verticesIn, sortingPointsIn, sortXIn, sortYIn, sortZIn);
            this.quadSprites = quadSpritesIn;
        }

        SortState(VertexFormat.Mode modeIn, int verticesIn, @Nullable Vector3f[] sortingPointsIn, float sortXIn, float sortYIn, float sortZIn) {
            this.f_190508_ = modeIn;
            this.f_190509_ = verticesIn;
            this.f_190510_ = sortingPointsIn;
            this.f_190511_ = sortXIn;
            this.f_190512_ = sortYIn;
            this.f_190513_ = sortZIn;
        }
    }

    public static final class DrawState {
        private final VertexFormat f_85733_;
        private final int f_85734_;
        private final int f_190479_;
        private final VertexFormat.Mode f_85735_;
        private final VertexFormat.IndexType f_190480_;
        private final boolean f_190481_;
        private final boolean f_190482_;
        private MultiTextureData multiTextureData;

        private DrawState(VertexFormat formatIn, int vertexCountIn, int indexCountIn, VertexFormat.Mode drawModeIn, VertexFormat.IndexType indexTypeIn, boolean indexOnlyIn, boolean sequentialIndexIn, MultiTextureData multiTextureData) {
            this(formatIn, vertexCountIn, indexCountIn, drawModeIn, indexTypeIn, indexOnlyIn, sequentialIndexIn);
            this.multiTextureData = multiTextureData;
        }

        public MultiTextureData getMultiTextureData() {
            return this.multiTextureData;
        }

        DrawState(VertexFormat formatIn, int vertexCountIn, int indexCountIn, VertexFormat.Mode drawModeIn, VertexFormat.IndexType indexTypeIn, boolean indexOnlyIn, boolean sequentialIndexIn) {
            this.f_85733_ = formatIn;
            this.f_85734_ = vertexCountIn;
            this.f_190479_ = indexCountIn;
            this.f_85735_ = drawModeIn;
            this.f_190480_ = indexTypeIn;
            this.f_190481_ = indexOnlyIn;
            this.f_190482_ = sequentialIndexIn;
        }

        public VertexFormat m_85745_() {
            return this.f_85733_;
        }

        public int m_85746_() {
            return this.f_85734_;
        }

        public int m_190500_() {
            return this.f_190479_;
        }

        public VertexFormat.Mode m_190501_() {
            return this.f_85735_;
        }

        public VertexFormat.IndexType m_190502_() {
            return this.f_190480_;
        }

        public int m_190503_() {
            return this.f_85734_ * this.f_85733_.m_86020_();
        }

        private int m_190507_() {
            return this.f_190482_ ? 0 : this.f_190479_ * this.f_190480_.f_190713_;
        }

        public int m_190504_() {
            return this.m_190503_() + this.m_190507_();
        }

        public boolean m_190505_() {
            return this.f_190481_;
        }

        public boolean m_190506_() {
            return this.f_190482_;
        }
    }
}

