/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.inventory.sort;

import de.siphalor.mousewheelie.client.inventory.ContainerScreenHelper;
import de.siphalor.mousewheelie.client.inventory.sort.SortMode;
import de.siphalor.mousewheelie.client.network.InteractionManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_465;
import org.apache.commons.lang3.ArrayUtils;

@Environment(value=EnvType.CLIENT)
public class InventorySorter {
    private final class_465<?> containerScreen;
    private List<class_1735> inventorySlots;
    private final class_1799[] stacks;

    public InventorySorter(class_465<?> containerScreen, class_1735 originSlot) {
        this.containerScreen = containerScreen;
        this.collectSlots(originSlot);
        this.stacks = (class_1799[])this.inventorySlots.stream().map(slot -> slot.method_7677().method_7972()).toArray(class_1799[]::new);
    }

    private void collectSlots(class_1735 originSlot) {
        this.inventorySlots = new ArrayList<class_1735>();
        ContainerScreenHelper<class_465<?>> screenHelper = ContainerScreenHelper.of(this.containerScreen, (slot, data, slotActionType) -> {});
        int originScope = screenHelper.getScope(originSlot);
        if (originScope == ContainerScreenHelper.INVALID_SCOPE) {
            return;
        }
        for (class_1735 slot2 : this.containerScreen.method_17577().field_7761) {
            if (originScope != screenHelper.getScope(slot2)) continue;
            this.inventorySlots.add(slot2);
        }
    }

    private void combineStacks() {
        ArrayDeque<InteractionManager.ClickEvent> clickEvents = new ArrayDeque<InteractionManager.ClickEvent>();
        for (int i = this.stacks.length - 1; i >= 0; --i) {
            int stackSize;
            class_1799 stack = this.stacks[i];
            if (stack.method_7960() || (stackSize = stack.method_7947()) >= stack.method_7909().method_7882()) continue;
            clickEvents.add(new InteractionManager.ClickEvent(this.containerScreen.method_17577().field_7763, this.inventorySlots.get((int)i).field_7874, 0, class_1713.field_7790));
            for (int j = 0; j < i; ++j) {
                class_1799 targetStack = this.stacks[j];
                if (targetStack.method_7960() || targetStack.method_7947() >= targetStack.method_7909().method_7882() || stack.method_7909() != targetStack.method_7909() || !class_1799.method_7975((class_1799)stack, (class_1799)targetStack)) continue;
                int delta = targetStack.method_7909().method_7882() - targetStack.method_7947();
                delta = Math.min(delta, stackSize);
                targetStack.method_7939(targetStack.method_7947() + delta);
                clickEvents.add(new InteractionManager.ClickEvent(this.containerScreen.method_17577().field_7763, this.inventorySlots.get((int)j).field_7874, 0, class_1713.field_7790));
                if ((stackSize -= delta) <= 0) break;
            }
            if (clickEvents.size() <= 1) {
                clickEvents.clear();
                continue;
            }
            InteractionManager.interactionEventQueue.addAll(clickEvents);
            InteractionManager.triggerSend(InteractionManager.TriggerType.GUI_CONFIRM);
            clickEvents.clear();
            if (stackSize > 0) {
                InteractionManager.pushClickEvent(this.containerScreen.method_17577().field_7763, this.inventorySlots.get((int)i).field_7874, 0, class_1713.field_7790);
                stack.method_7939(stackSize);
                continue;
            }
            this.stacks[i] = class_1799.field_8037;
        }
    }

    public void sort(SortMode sortMode) {
        int i;
        this.combineStacks();
        int slotCount = this.stacks.length;
        Object[] sortIds = (Integer[])IntStream.range(0, slotCount).boxed().toArray(Integer[]::new);
        sortIds = sortMode.sort((Integer[])sortIds, this.stacks);
        BitSet doneSlashEmpty = new BitSet(slotCount * 2);
        for (i = 0; i < slotCount; ++i) {
            if (i == sortIds[i]) {
                doneSlashEmpty.set(i);
                continue;
            }
            if (!this.stacks[i].method_7960()) continue;
            doneSlashEmpty.set(slotCount + i);
        }
        block1: for (i = 0; i < slotCount; ++i) {
            if (doneSlashEmpty.get(i)) continue;
            if (doneSlashEmpty.get(slotCount + sortIds[i])) {
                doneSlashEmpty.set(sortIds[i]);
                continue;
            }
            InteractionManager.pushClickEvent(this.containerScreen.method_17577().field_7763, this.inventorySlots.get((int)sortIds[i].intValue()).field_7874, 0, class_1713.field_7790);
            doneSlashEmpty.set(slotCount + sortIds[i]);
            class_1799 currentStack = this.stacks[sortIds[i]];
            int id = i;
            do {
                if (this.stacks[id].method_7909() == currentStack.method_7909() && this.stacks[id].method_7947() == currentStack.method_7947() && !doneSlashEmpty.get(slotCount + id) && class_1799.method_7975((class_1799)this.stacks[id], (class_1799)currentStack)) {
                    doneSlashEmpty.set(id);
                    id = ArrayUtils.indexOf((Object[])sortIds, (Object)id);
                    continue;
                }
                InteractionManager.pushClickEvent(this.containerScreen.method_17577().field_7763, this.inventorySlots.get((int)id).field_7874, 0, class_1713.field_7790);
                currentStack = this.stacks[id];
                doneSlashEmpty.set(id);
                if (doneSlashEmpty.get(slotCount + id)) continue block1;
                id = ArrayUtils.indexOf((Object[])sortIds, (Object)id);
            } while (!doneSlashEmpty.get(id));
        }
    }
}

