/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_1060;
import net.minecraft.class_1074;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import org.lwjgl.opengl.GL11;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiWaypoints;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Misc;
import xaero.common.mods.SupportXaeroWorldmap;
import xaero.common.settings.ModSettings;
import xaero.map.WorldMap;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.gui.GuiDropDown;
import xaero.map.gui.GuiMap;
import xaero.map.misc.KeySortableByOther;
import xaero.map.mods.SupportBetterPVP;
import xaero.map.mods.SupportMinimap;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointMenuElement;
import xaero.map.mods.gui.WaypointMenuRenderer;
import xaero.map.mods.gui.WaypointSymbolCreator;

public class SupportXaeroMinimap {
    AXaeroMinimap modMain;
    public int compatibilityVersion;
    private boolean deathpoints = true;
    private boolean refreshWaypoints = true;
    private WaypointWorld waypointWorld;
    private WaypointSet waypointSet;
    private boolean allSets;
    private ArrayList<Waypoint> waypoints;
    private ArrayList<Waypoint> waypointsSorted;
    private ArrayList<Waypoint> waypointsFiltered;
    private WaypointMenuRenderer waypointMenuRenderer;

    public SupportXaeroMinimap() {
        try {
            Class<?> mmClassTest = Class.forName("xaero.pvp.BetterPVP");
            this.modMain = SupportBetterPVP.getMain();
            WorldMap.LOGGER.info("Xaero's WorldMap Mod: Better PVP found!");
        }
        catch (ClassNotFoundException e) {
            try {
                Class<?> mmClassTest = Class.forName("xaero.minimap.XaeroMinimap");
                this.modMain = SupportMinimap.getMain();
                WorldMap.LOGGER.info("Xaero's WorldMap Mod: Xaero's minimap found!");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.modMain != null) {
            try {
                this.compatibilityVersion = SupportXaeroWorldmap.WORLDMAP_COMPATIBILITY_VERSION;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            if (this.compatibilityVersion < 3) {
                throw new RuntimeException("Xaero's Minimap 20.23.0 or newer required!");
            }
        }
    }

    public boolean waypointIsGood(Waypoint w) {
        return w.getType() != 1 || this.deathpoints;
    }

    public ArrayList<Waypoint> convertWaypoints() {
        if (this.waypointSet == null) {
            return null;
        }
        ArrayList<Waypoint> result = new ArrayList<Waypoint>();
        if (!this.allSets) {
            this.convertSet(this.waypointSet, result);
        } else {
            HashMap sets = this.waypointWorld.getSets();
            for (WaypointSet set : sets.values()) {
                this.convertSet(set, result);
            }
        }
        this.deathpoints = this.modMain.getSettings().getDeathpoints();
        return result;
    }

    private void convertSet(WaypointSet set, ArrayList<Waypoint> result) {
        ArrayList list = set.getList();
        String setName = set.getName();
        for (int i = 0; i < list.size(); ++i) {
            xaero.common.minimap.waypoints.Waypoint w = (xaero.common.minimap.waypoints.Waypoint)list.get(i);
            result.add(this.convertWaypoint(w, true, setName));
        }
    }

    public Waypoint convertWaypoint(xaero.common.minimap.waypoints.Waypoint w, boolean editable, String setName) {
        Waypoint converted = new Waypoint(w, w.getX(), w.getY(), w.getZ(), w.getName(), w.getSymbol(), ModSettings.COLORS[w.getColor()], w.getType(), editable, setName, this.compatibilityVersion < 7 ? true : w.isYIncluded());
        converted.setDisabled(w.isDisabled());
        converted.setYaw(w.getYaw());
        converted.setRotation(w.isRotation());
        converted.setTemporary(w.isTemporary());
        converted.setGlobal(w.isGlobal());
        return converted;
    }

    public void openWaypoint(GuiMap parent, Waypoint waypoint) {
        if (!waypoint.isEditable()) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        GuiAddWaypoint addScreen = this.compatibilityVersion >= 6 ? new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (class_437)parent, (class_437)parent, (xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal(), this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld, waypoint.getSetName()) : new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (class_437)parent, (xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal(), this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld);
        class_310.method_1551().method_1507((class_437)addScreen);
    }

    public void createWaypoint(GuiMap parent, int x, int y, int z) {
        if (this.waypointWorld == null) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        double dimDiv = this.compatibilityVersion < 2 ? (waypointsManager.divideBy8(this.waypointWorld.getContainer().getKey()) ? 8.0 : 1.0) : waypointsManager.getDimensionDivision(this.waypointWorld.getContainer().getKey());
        xaero.common.minimap.waypoints.Waypoint w = this.compatibilityVersion >= 7 && y == Short.MAX_VALUE ? new xaero.common.minimap.waypoints.Waypoint(xaero.map.misc.Misc.myFloor((double)x * dimDiv), y, xaero.map.misc.Misc.myFloor((double)z * dimDiv), "", "", -1, 0, false, false) : new xaero.common.minimap.waypoints.Waypoint(xaero.map.misc.Misc.myFloor((double)x * dimDiv), y, xaero.map.misc.Misc.myFloor((double)z * dimDiv), "", "", -1);
        GuiAddWaypoint addScreen = this.compatibilityVersion >= 6 ? new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (class_437)parent, (class_437)parent, w, this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld, this.waypointWorld.getCurrent()) : new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (class_437)parent, w, this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld);
        class_310.method_1551().method_1507((class_437)addScreen);
    }

    public boolean canCreateWaypoint(int y) {
        return y != Short.MAX_VALUE || this.compatibilityVersion > 6;
    }

    public void createTempWaypoint(int x, int y, int z) {
        if (this.waypointWorld == null) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        if (this.compatibilityVersion >= 7 && y == Short.MAX_VALUE) {
            waypointsManager.createTemporaryWaypoints(this.waypointWorld, x, y, z, false);
        } else {
            waypointsManager.createTemporaryWaypoints(this.waypointWorld, x, y, z);
        }
        this.requestWaypointsRefresh();
    }

    public boolean canTeleport() {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        return this.waypointWorld != null && waypointsManager.canTeleport(waypointsManager.isWorldTeleportable(this.waypointWorld), this.waypointWorld);
    }

    public void teleportToWaypoint(class_437 screen, Waypoint w) {
        if (this.waypointWorld == null) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        waypointsManager.teleportToWaypoint((xaero.common.minimap.waypoints.Waypoint)w.getOriginal(), this.waypointWorld, screen);
    }

    public void disableWaypoint(Waypoint waypoint) {
        ((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).setDisabled(!((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        waypoint.setDisabled(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        waypoint.setTemporary(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isTemporary());
    }

    public void deleteWaypoint(Waypoint waypoint) {
        if (!this.allSets) {
            this.waypointSet.getList().remove((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal());
        } else {
            WaypointSet set;
            HashMap sets = this.waypointWorld.getSets();
            Iterator iterator = sets.values().iterator();
            while (iterator.hasNext() && !(set = (WaypointSet)iterator.next()).getList().remove((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal())) {
            }
        }
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.waypoints.remove(waypoint);
        this.waypointsSorted.remove(waypoint);
        this.waypointsFiltered.remove(waypoint);
    }

    public boolean isOnScreen(Waypoint w, double cameraX, double cameraZ, int width, int height, double scale) {
        double xOnScreen = ((double)w.getX() - cameraX) * scale + (double)(width / 2);
        double zOnScreen = ((double)w.getZ() - cameraZ) * scale + (double)(height / 2);
        return xOnScreen < (double)width && xOnScreen > 0.0 && zOnScreen < (double)height && zOnScreen > 0.0;
    }

    public void checkWaypoints(boolean multiplayer, class_5321<class_1937> dimId, String multiworldId, int width, int height, GuiMap screen, Pattern regex, Pattern regexStartsWith) {
        WaypointSet checkingSet;
        String containerId;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        WaypointWorldContainer container = waypointsManager.getWorldContainerNullable(containerId = waypointsManager.getAutoRootContainerID() + "/" + waypointsManager.getDimensionDirectoryName(dimId));
        WaypointWorld checkingWaypointWorld = container == null ? null : (WaypointWorld)container.worlds.get(!multiplayer ? "waypoints" : multiworldId);
        class_310 mc = class_310.method_1551();
        if (this.compatibilityVersion >= 4 && mc.field_1724.method_6059(Effects.NO_WAYPOINTS)) {
            checkingWaypointWorld = null;
        } else if (this.compatibilityVersion >= 5 && (mc.field_1724.method_6059(Effects.NO_WAYPOINTS_BENEFICIAL) || mc.field_1724.method_6059(Effects.NO_WAYPOINTS_HARMFUL))) {
            checkingWaypointWorld = null;
        }
        boolean shouldRefresh = this.refreshWaypoints;
        if (checkingWaypointWorld != this.waypointWorld) {
            this.waypointWorld = checkingWaypointWorld;
            screen.closeRightClick();
            if (screen.waypointMenu) {
                screen.method_25423(class_310.method_1551(), width, height);
            }
            shouldRefresh = true;
        }
        WaypointSet waypointSet = checkingSet = checkingWaypointWorld == null ? null : checkingWaypointWorld.getCurrentSet();
        if (checkingSet != this.waypointSet) {
            this.waypointSet = checkingSet;
            shouldRefresh = true;
        }
        if (this.allSets != this.modMain.getSettings().renderAllSets) {
            this.allSets = this.modMain.getSettings().renderAllSets;
            shouldRefresh = true;
        }
        if (shouldRefresh) {
            this.waypoints = this.convertWaypoints();
            if (this.waypoints != null) {
                Collections.sort(this.waypoints);
                this.waypointsSorted = new ArrayList();
                ArrayList<KeySortableByOther<Waypoint>> sortingList = new ArrayList<KeySortableByOther<Waypoint>>();
                for (Waypoint waypoint : this.waypoints) {
                    sortingList.add(new KeySortableByOther<Waypoint>(waypoint, new Comparable[]{waypoint.getComparisonName(), waypoint.getName()}));
                }
                Collections.sort(sortingList);
                for (KeySortableByOther keySortableByOther : sortingList) {
                    this.waypointsSorted.add((Waypoint)keySortableByOther.getKey());
                }
            } else {
                this.waypointsSorted = null;
            }
            this.updateFilteredList(regex, regexStartsWith);
        }
        this.refreshWaypoints = false;
    }

    public void updateFilteredList(Pattern regex, Pattern regexStartsWith) {
        if (this.waypointsSorted == null) {
            this.waypointsFiltered = null;
            return;
        }
        if (this.waypointsFiltered == null) {
            this.waypointsFiltered = new ArrayList();
        } else {
            this.waypointsFiltered.clear();
        }
        boolean showingDisabled = WorldMap.settings.showDisabledWaypoints;
        for (Waypoint w : this.waypointsSorted) {
            if (!showingDisabled && w.isDisabled()) continue;
            if (regex == null) {
                this.waypointsFiltered.add(w);
                continue;
            }
            if (regexStartsWith.matcher(w.getName().toLowerCase()).find()) {
                this.waypointsFiltered.add(0, w);
                continue;
            }
            if (regex.matcher(w.getName().toLowerCase()).find()) {
                this.waypointsFiltered.add(w);
                continue;
            }
            if (!regex.matcher(w.getSymbol().toLowerCase()).find()) continue;
            this.waypointsFiltered.add(w);
        }
    }

    public Waypoint renderWaypoints(class_4587 matrixStack, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, double cameraX, double cameraZ, int width, int height, double guiBasedScale, double scale, double mouseX, double mouseZ, float brightness, Waypoint oldViewed, class_310 mc) {
        if (this.waypoints == null) {
            return null;
        }
        MultiTextureRenderTypeRenderer uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR_PREMULTIPLIED);
        class_4588 regularUIObjectConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.GUI_BILINEAR);
        boolean renderBackgrounds = WorldMap.settings.waypointBackgrounds;
        Object viewed = null;
        class_1060 textureManager = mc.method_1531();
        class_327 fontRenderer = mc.field_1772;
        WaypointSymbolCreator symbolCreator = WorldMap.waypointSymbolCreator;
        textureManager.method_22813(WorldMap.guiTextures);
        RenderSystem.setShaderTexture((int)0, (class_2960)WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        double wpScale = guiBasedScale * (double)WorldMap.settings.worldmapWaypointsScale / scale;
        boolean showingHiddenWaypoints = WorldMap.settings.showDisabledWaypoints;
        double cursorHitMinY = (double)(renderBackgrounds ? -41 : -12) * wpScale;
        double cursorHitMaxY = (double)(renderBackgrounds ? 0 : 12) * wpScale;
        for (int i = this.waypoints.size() - 1; i >= 0; --i) {
            Waypoint w = this.waypoints.get(i);
            if (!this.waypointIsGood(w) || !showingHiddenWaypoints && w.isDisabled() || !((double)w.getZ() + cursorHitMaxY > mouseZ) || !((double)w.getZ() + cursorHitMinY < mouseZ)) continue;
            double d = Math.abs((double)w.getX() - mouseX);
            float f = w.getSymbol().length() > 1 ? 20.5f : 14.0f;
            if (!(d <= (double)f * wpScale)) continue;
            viewed = w;
            break;
        }
        Waypoint viewedToReturn = viewed;
        if (viewed == null) {
            viewed = oldViewed;
        }
        if (renderBackgrounds) {
            for (Waypoint w : this.waypoints) {
                if (!this.waypointIsGood(w) || !showingHiddenWaypoints && w.isDisabled() || !this.isOnScreen(w, cameraX, cameraZ, width, height, scale)) continue;
                w.renderShadow(brightness, regularUIObjectConsumer, matrixStack, wpScale, (float)((double)w.getX() - cameraX), (float)((double)w.getZ() - cameraZ), textureManager);
            }
        }
        renderTypeBuffers.method_22993();
        class_4588 waypointNameBGConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_WAYPOINT_NAME_BG);
        for (Waypoint w : this.waypoints) {
            if (!this.waypointIsGood(w) || !showingHiddenWaypoints && w.isDisabled() || w == viewed || !this.isOnScreen(w, cameraX, cameraZ, width, height, scale)) continue;
            w.renderWaypoint(waypointNameBGConsumer, uniqueTextureUIObjectRenderer, matrixStack, wpScale, (float)((double)w.getX() - cameraX), (float)((double)w.getZ() - cameraZ), false, textureManager, fontRenderer, symbolCreator, renderBackgrounds, renderTypeBuffers);
        }
        rendererProvider.draw(uniqueTextureUIObjectRenderer);
        renderTypeBuffers.method_22993();
        if (viewed != null) {
            matrixStack.method_22903();
            matrixStack.method_22904(0.0, 0.0, 10.0);
            waypointNameBGConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_WAYPOINT_NAME_BG);
            uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR_PREMULTIPLIED);
            ((Waypoint)viewed).renderWaypoint(waypointNameBGConsumer, uniqueTextureUIObjectRenderer, matrixStack, wpScale, (float)((double)((Waypoint)viewed).getX() - cameraX), (float)((double)((Waypoint)viewed).getZ() - cameraZ), true, textureManager, fontRenderer, symbolCreator, true, renderTypeBuffers);
            rendererProvider.draw(uniqueTextureUIObjectRenderer);
            renderTypeBuffers.method_22993();
            matrixStack.method_22909();
        }
        textureManager.method_22813(WorldMap.guiTextures);
        RenderSystem.setShaderTexture((int)0, (class_2960)WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        return viewedToReturn;
    }

    public WaypointMenuElement renderWaypointsMenu(class_4587 matrixStack, GuiMap gui, ArrayList<Waypoint> sideWaypoints, double scale, int width, int height, int offset, int mouseX, int mouseY, boolean leftMousePressed, boolean leftMouseClicked, class_310 mc) {
        return this.waypointMenuRenderer.renderWaypointsMenu(matrixStack, gui, sideWaypoints, scale, width, height, offset, mouseX, mouseY, leftMousePressed, leftMouseClicked, mc);
    }

    public void requestWaypointsRefresh() {
        this.refreshWaypoints = true;
    }

    public class_304 getWaypointKeyBinding() {
        return ModSettings.newWaypoint;
    }

    public class_304 getTempWaypointKeyBinding() {
        return ModSettings.keyInstantWaypoint;
    }

    public class_304 getTempWaypointsMenuKeyBinding() {
        return ModSettings.keyWaypoints;
    }

    public void onMapKeyPressed(class_3675.class_307 type, int code, GuiMap screen) {
        class_304 minimapSettingsKB;
        class_304 kb = null;
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keySwitchSet)) {
            kb = ModSettings.keySwitchSet;
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keyAllSets)) {
            kb = ModSettings.keyAllSets;
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keyWaypoints)) {
            kb = ModSettings.keyWaypoints;
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, minimapSettingsKB = (class_304)this.modMain.getSettingsKey())) {
            kb = minimapSettingsKB;
        }
        class_310 mc = class_310.method_1551();
        if (kb != null) {
            if (kb == ModSettings.keyWaypoints) {
                this.openWaypointsMenu(mc, screen);
                return;
            }
            if (minimapSettingsKB != null && kb == minimapSettingsKB) {
                this.openSettings(mc, screen, screen);
                return;
            }
            this.handleMinimapKeyBinding(kb, screen);
        }
    }

    public void handleMinimapKeyBinding(class_304 kb, GuiMap screen) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        minimapSession.getControls().keyDown(kb, false, false);
        if ((kb == ModSettings.keySwitchSet || kb == ModSettings.keyAllSets) && screen.waypointMenu) {
            screen.method_25423(class_310.method_1551(), screen.field_22789, screen.field_22790);
        }
    }

    public void drawSetChange(class_4587 matrixStack) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        this.modMain.getInterfaces().getMinimapInterface().getWaypointsGuiRenderer().drawSetChange(minimapSession.getWaypointsManager(), matrixStack, class_310.method_1551().method_22683());
    }

    public float getMinimapBrightnessOldCompatibility() {
        return this.modMain.getSupportMods().worldmapSupport.getMinimapBrightness();
    }

    public void openSettings(class_310 mc, class_437 current, class_437 escape) {
        if (this.compatibilityVersion >= 6) {
            this.modMain.getGuiHelper().openMinimapSettingsFromScreen(current, escape);
        } else {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getControls().keyDown((class_304)this.modMain.getSettingsKey(), false, false);
        }
    }

    public String getControlsTooltip() {
        return class_1074.method_4662((String)"gui.xaero_box_controls_minimap", (Object[])new Object[]{xaero.map.misc.Misc.getKeyName(ModSettings.newWaypoint), xaero.map.misc.Misc.getKeyName(ModSettings.keyInstantWaypoint), xaero.map.misc.Misc.getKeyName(ModSettings.keySwitchSet), xaero.map.misc.Misc.getKeyName(ModSettings.keyAllSets), xaero.map.misc.Misc.getKeyName(ModSettings.keyWaypoints)});
    }

    public void onMapMouseRelease(double par1, double par2, int par3) {
        this.waypointMenuRenderer.onMapMouseRelease(par1, par2, par3);
    }

    public void onMapConstruct() {
        this.waypointMenuRenderer = new WaypointMenuRenderer();
    }

    public void onMapInit(GuiMap mapScreen, List<GuiDropDown> dropdowns, class_310 mc, int width, int height) {
        this.waypointMenuRenderer.onMapInit(mapScreen, dropdowns, mc, width, height, this.waypointWorld, this.modMain, XaeroMinimapSession.getCurrentSession());
    }

    public ArrayList<Waypoint> getWaypointsFiltered() {
        return this.waypointsFiltered;
    }

    public boolean waypointExists(Waypoint w) {
        return this.waypoints != null && this.waypoints.contains(w);
    }

    public void toggleTemporaryWaypoint(Waypoint waypoint) {
        ((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).setTemporary(!((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isTemporary());
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        waypoint.setDisabled(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        waypoint.setTemporary(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isTemporary());
    }

    public void teleportToCoordinates(GuiMap screen, int rightClickX, int rightClickY, int rightClickZ) {
        this.teleportToWaypoint(screen, this.convertWaypoint(new xaero.common.minimap.waypoints.Waypoint(rightClickX, rightClickY, rightClickZ, "", "", -1), false, ""));
    }

    public void openWaypointsMenu(class_310 mc, GuiMap screen) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (this.compatibilityVersion >= 6) {
            mc.method_1507((class_437)new GuiWaypoints(this.modMain, minimapSession, (class_437)screen, (class_437)screen));
        } else {
            mc.method_1507((class_437)new GuiWaypoints(this.modMain, minimapSession, (class_437)screen));
        }
    }

    public boolean screenShouldSkipWorldRender(class_437 currentScreen) {
        if (this.compatibilityVersion < 6) {
            return false;
        }
        return Misc.screenShouldSkipWorldRender((AXaeroMinimap)this.modMain, (class_437)currentScreen, (boolean)false);
    }

    public boolean hidingWaypointCoordinates() {
        return this.modMain.getSettings().hideWaypointCoordinates;
    }

    public void shareWaypoint(Waypoint waypoint, GuiMap screen) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        minimapSession.getWaypointSharing().shareWaypoint((class_437)screen, (xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal(), this.waypointWorld);
    }

    public void shareLocation(GuiMap guiMap, int rightClickX, int rightClickY, int rightClickZ) {
        int wpColor = (int)((double)ModSettings.COLORS.length * Math.random());
        xaero.common.minimap.waypoints.Waypoint minimapLocationWaypoint = this.compatibilityVersion < 7 ? new xaero.common.minimap.waypoints.Waypoint(rightClickX, rightClickY, rightClickZ, "SL", "L", wpColor) : new xaero.common.minimap.waypoints.Waypoint(rightClickX, rightClickY == -1 ? 0 : rightClickY, rightClickZ, "SL", "L", wpColor, 0, false, rightClickY != -1);
        Waypoint locationWaypoint = this.convertWaypoint(minimapLocationWaypoint, false, "");
        this.shareWaypoint(locationWaypoint, guiMap);
    }
}

