/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1008;
import net.minecraft.class_1041;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_6177;
import net.minecraft.class_757;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.Version;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

@class_6177
public class GLX {
    private static final Logger LOGGER = LogManager.getLogger();
    private static String cpuInfo;

    public static String getOpenGLVersionString() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (GLFW.glfwGetCurrentContext() == 0L) {
            return "NO CONTEXT";
        }
        return GlStateManager._getString(7937) + " GL version " + GlStateManager._getString(7938) + ", " + GlStateManager._getString(7936);
    }

    public static int _getRefreshRate(class_1041 class_10412) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        long l = GLFW.glfwGetWindowMonitor((long)class_10412.method_4490());
        if (l == 0L) {
            l = GLFW.glfwGetPrimaryMonitor();
        }
        GLFWVidMode \u00e2\u02dc\u01922 = l == 0L ? null : GLFW.glfwGetVideoMode((long)l);
        return \u00e2\u02dc\u01922 == null ? 0 : \u00e2\u02dc\u01922.refreshRate();
    }

    public static String _getLWJGLVersion() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return Version.getVersion();
    }

    public static LongSupplier _initGlfw() {
        LongSupplier longSupplier;
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        class_1041.method_4492((n, string) -> {
            throw new IllegalStateException(String.format("GLFW error before init: [0x%X]%s", n, string));
        });
        ArrayList arrayList = Lists.newArrayList();
        GLFWErrorCallback \u00e2\u02dc\u01922 = GLFW.glfwSetErrorCallback((n, l) -> arrayList.add(String.format("GLFW error during init: [0x%X]%s", n, l)));
        if (GLFW.glfwInit()) {
            longSupplier = () -> (long)(GLFW.glfwGetTime() * 1.0E9);
            for (String string2 : arrayList) {
                LOGGER.error("GLFW error collected during initialization: {}", (Object)string2);
            }
        } else {
            throw new IllegalStateException("Failed to initialize GLFW, errors: " + Joiner.on((String)",").join((Iterable)arrayList));
        }
        RenderSystem.setErrorCallback((GLFWErrorCallbackI)\u00e2\u02dc\u01922);
        return longSupplier;
    }

    public static void _setGlfwErrorCallback(GLFWErrorCallbackI gLFWErrorCallbackI) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLFWErrorCallback gLFWErrorCallback = GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)gLFWErrorCallbackI);
        if (gLFWErrorCallback != null) {
            gLFWErrorCallback.free();
        }
    }

    public static boolean _shouldClose(class_1041 class_10412) {
        return GLFW.glfwWindowShouldClose((long)class_10412.method_4490());
    }

    public static void _init(int n2, boolean bl) {
        int n2;
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        try {
            CentralProcessor centralProcessor = new SystemInfo().getHardware().getProcessor();
            cpuInfo = String.format("%dx %s", centralProcessor.getLogicalProcessorCount(), centralProcessor.getProcessorIdentifier().getName()).replaceAll("\\s+", " ");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        class_1008.method_4227(n2, bl);
    }

    public static String _getCpuInfo() {
        return cpuInfo == null ? "<unknown>" : cpuInfo;
    }

    public static void _renderCrosshair(int n, boolean bl, boolean bl2, boolean bl3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager._disableTexture();
        GlStateManager._depthMask(false);
        GlStateManager._disableCull();
        RenderSystem.setShader(class_757::method_34535);
        class_289 class_2892 = RenderSystem.renderThreadTesselator();
        class_287 \u00e2\u02dc\u01922 = class_2892.method_1349();
        RenderSystem.lineWidth(4.0f);
        \u00e2\u02dc\u01922.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
        if (bl) {
            \u00e2\u02dc\u01922.method_22912(0.0, 0.0, 0.0).method_1336(0, 0, 0, 255).method_22914(1.0f, 0.0f, 0.0f).method_1344();
            \u00e2\u02dc\u01922.method_22912(n, 0.0, 0.0).method_1336(0, 0, 0, 255).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        }
        if (bl2) {
            \u00e2\u02dc\u01922.method_22912(0.0, 0.0, 0.0).method_1336(0, 0, 0, 255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            \u00e2\u02dc\u01922.method_22912(0.0, n, 0.0).method_1336(0, 0, 0, 255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        }
        if (bl3) {
            \u00e2\u02dc\u01922.method_22912(0.0, 0.0, 0.0).method_1336(0, 0, 0, 255).method_22914(0.0f, 0.0f, 1.0f).method_1344();
            \u00e2\u02dc\u01922.method_22912(0.0, 0.0, n).method_1336(0, 0, 0, 255).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        }
        class_2892.method_1350();
        RenderSystem.lineWidth(2.0f);
        \u00e2\u02dc\u01922.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
        if (bl) {
            \u00e2\u02dc\u01922.method_22912(0.0, 0.0, 0.0).method_1336(255, 0, 0, 255).method_22914(1.0f, 0.0f, 0.0f).method_1344();
            \u00e2\u02dc\u01922.method_22912(n, 0.0, 0.0).method_1336(255, 0, 0, 255).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        }
        if (bl2) {
            \u00e2\u02dc\u01922.method_22912(0.0, 0.0, 0.0).method_1336(0, 255, 0, 255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            \u00e2\u02dc\u01922.method_22912(0.0, n, 0.0).method_1336(0, 255, 0, 255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        }
        if (bl3) {
            \u00e2\u02dc\u01922.method_22912(0.0, 0.0, 0.0).method_1336(127, 127, 255, 255).method_22914(0.0f, 0.0f, 1.0f).method_1344();
            \u00e2\u02dc\u01922.method_22912(0.0, 0.0, n).method_1336(127, 127, 255, 255).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        }
        class_2892.method_1350();
        RenderSystem.lineWidth(1.0f);
        GlStateManager._enableCull();
        GlStateManager._depthMask(true);
        GlStateManager._enableTexture();
    }

    public static <T> T make(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T make(T t, Consumer<T> consumer) {
        consumer.accept(t);
        return t;
    }
}

