/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.config.value.serializer;

import de.siphalor.tweed.config.ConfigReadException;
import de.siphalor.tweed.config.value.serializer.ConfigValueSerializer;
import de.siphalor.tweed.data.DataContainer;
import de.siphalor.tweed.data.DataValue;
import de.siphalor.tweed.util.StaticStringConvertible;
import net.minecraft.class_2540;

public class StringConvertibleSerializer<T extends StaticStringConvertible<T>>
extends ConfigValueSerializer<StaticStringConvertible<T>> {
    final T fallback;

    public StringConvertibleSerializer(T fallback) {
        this.fallback = fallback;
    }

    @Override
    public StaticStringConvertible<T> read(DataValue<?> data) throws ConfigReadException {
        if (data.isString()) {
            Object val = this.fallback.valueOf(data.asString());
            return val == null ? this.fallback : val;
        }
        return this.fallback;
    }

    @Override
    public <Key> void write(DataContainer<?, Key> dataContainer, Key key, StaticStringConvertible<T> value) {
        dataContainer.set(key, value.asString());
    }

    @Override
    public StaticStringConvertible<T> read(class_2540 packetByteBuf) {
        return this.fallback.valueOf(packetByteBuf.method_10800(Short.MAX_VALUE));
    }

    @Override
    public void write(class_2540 packetByteBuf, StaticStringConvertible<T> value) {
        packetByteBuf.method_10814(value.asString());
    }

    @Override
    public String asString(StaticStringConvertible<T> value) {
        return value.asString();
    }

    @Override
    public Class<StaticStringConvertible<T>> getType() {
        return this.fallback.getClass();
    }
}

