/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.tool.attribute;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.tool.attribute.v1.DynamicAttributeTool;
import net.fabricmc.fabric.api.tool.attribute.v1.ToolManager;
import net.fabricmc.fabric.impl.tool.attribute.ItemStackContext;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1799.class})
public abstract class MixinItemStack
implements ItemStackContext {
    @Unique
    @Nullable
    private class_1309 contextEntity = null;

    @Inject(at={@At(value="RETURN")}, method={"isSuitableFor"}, cancellable=true)
    public void isEffectiveOn(class_2680 state, CallbackInfoReturnable<Boolean> info) {
        info.setReturnValue((Object)ToolManager.handleIsEffectiveOnIgnoresVanilla(state, (class_1799)this, null, info.getReturnValueZ()));
    }

    @Inject(at={@At(value="RETURN")}, method={"getMiningSpeedMultiplier"}, cancellable=true)
    public void getMiningSpeedMultiplier(class_2680 state, CallbackInfoReturnable<Float> info) {
        float customSpeed = ToolManager.handleBreakingSpeedIgnoresVanilla(state, (class_1799)this, null);
        if (info.getReturnValueF() < customSpeed) {
            info.setReturnValue((Object)Float.valueOf(customSpeed));
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getAttributeModifiers(Lnet/minecraft/entity/EquipmentSlot;)Lcom/google/common/collect/Multimap;")}, method={"getTooltip"})
    @Environment(value=EnvType.CLIENT)
    private void storeTooltipAttributeEntityContext(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir) {
        this.contextEntity = player;
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getAttributeModifiers(Lnet/minecraft/entity/EquipmentSlot;)Lcom/google/common/collect/Multimap;", shift=At.Shift.AFTER)}, method={"getTooltip"})
    @Environment(value=EnvType.CLIENT)
    private void revokeTooltipAttributeEntityContext(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> cir) {
        this.contextEntity = null;
    }

    @Inject(at={@At(value="RETURN")}, method={"getAttributeModifiers"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    public void getAttributeModifiers(class_1304 slot, CallbackInfoReturnable<Multimap<class_1320, class_1322>> info, Multimap<class_1320, class_1322> multimap) {
        class_1799 stack = (class_1799)this;
        if (stack.method_7909() instanceof DynamicAttributeTool) {
            LinkedListMultimap orderedAttributes = LinkedListMultimap.create();
            orderedAttributes.putAll(multimap);
            DynamicAttributeTool holder = (DynamicAttributeTool)stack.method_7909();
            orderedAttributes.putAll(holder.getDynamicModifiers(slot, stack, this.contextEntity));
            info.setReturnValue((Object)orderedAttributes);
        }
    }

    @Override
    public void fabricToolAttributes_setContext(@Nullable class_1309 contextEntity) {
        this.contextEntity = contextEntity;
    }
}

