/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util.mod.fabric;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.terraformersmc.modmenu.util.OptionalUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModIconHandler;
import com.terraformersmc.modmenu.util.mod.fabric.CustomValueUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_1043;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FabricMod
implements Mod {
    private static final Logger LOGGER = LogManager.getLogger((String)"Mod Menu");
    private final ModContainer container;
    private final ModMetadata metadata;
    private final ModMenuData modMenuData;
    private final Set<Mod.Badge> badges;
    private final Map<String, String> links = new HashMap<String, String>();

    public FabricMod(ModContainer modContainer) {
        this.container = modContainer;
        this.metadata = modContainer.getMetadata();
        boolean usesModernParent = false;
        Optional<String> parentId = Optional.empty();
        ModMenuData.DummyParentData parentData = null;
        HashSet<String> badgeNames = new HashSet<String>();
        CustomValue modMenuValue = this.metadata.getCustomValue("modmenu");
        if (modMenuValue != null && modMenuValue.getType() == CustomValue.CvType.OBJECT) {
            CustomValue.CvObject modMenuObject = modMenuValue.getAsObject();
            CustomValue parentCv = modMenuObject.get("parent");
            if (parentCv != null) {
                if (parentCv.getType() == CustomValue.CvType.STRING) {
                    parentId = Optional.of(parentCv.getAsString());
                } else if (parentCv.getType() == CustomValue.CvType.OBJECT) {
                    try {
                        CustomValue.CvObject parentObj = parentCv.getAsObject();
                        parentId = CustomValueUtil.getString("id", parentObj);
                        parentData = new ModMenuData.DummyParentData(parentId.orElseThrow(() -> new RuntimeException("Parent object lacks an id")), CustomValueUtil.getString("name", parentObj), CustomValueUtil.getString("description", parentObj), CustomValueUtil.getString("icon", parentObj), CustomValueUtil.getStringSet("badges", parentObj).orElse(new HashSet()));
                    }
                    catch (Throwable t) {
                        LOGGER.error("Error loading parent data from mod: " + this.metadata.getId(), t);
                    }
                }
            }
            badgeNames.addAll(CustomValueUtil.getStringSet("badges", modMenuObject).orElse(new HashSet()));
            this.links.putAll(CustomValueUtil.getStringMap("links", modMenuObject).orElse(new HashMap()));
            usesModernParent = modMenuObject.containsKey("parent");
        }
        if (parentId.orElse("").equals(this.metadata.getId())) {
            LOGGER.warn("WARNING! Mod " + this.metadata.getId() + " declared itself as its own parent! This parent declaration is ignored.");
            parentId = Optional.empty();
            parentData = null;
        }
        this.modMenuData = new ModMenuData(badgeNames, parentId, parentData);
        boolean finalUsesModernParent = usesModernParent;
        CustomValueUtil.getString("modmenu:parent", this.metadata).ifPresent(parent -> {
            this.modMenuData.parent = Optional.of(parent);
            if (!finalUsesModernParent) {
                LOGGER.warn("WARNING! Mod " + this.metadata.getId() + " is only using deprecated 'modmenu:parent' custom value! This will be removed in 1.18 snapshots, so ask the author of this mod to support the new API.");
            }
        });
        CustomValueUtil.getBoolean("modmenu:clientsideOnly", this.metadata).ifPresent(client -> {
            if (client.booleanValue()) {
                this.modMenuData.badges.add(Mod.Badge.CLIENT);
            }
            LOGGER.warn("WARNING! Mod " + this.metadata.getId() + " is only using deprecated 'modmenu:clientsideOnly' custom value! This is no longer needed and will be removed in 1.18 snapshots.");
        });
        CustomValueUtil.getBoolean("modmenu:api", this.metadata).ifPresent(library -> {
            if (library.booleanValue()) {
                this.modMenuData.badges.add(Mod.Badge.LIBRARY);
            }
            if (!badgeNames.contains("library")) {
                LOGGER.warn("WARNING! Mod " + this.metadata.getId() + " is only using deprecated 'modmenu:api' custom value! This will be removed in 1.18 snapshots, so ask the author of this mod to support the new API.");
            }
        });
        CustomValueUtil.getBoolean("modmenu:deprecated", this.metadata).ifPresent(deprecated -> {
            if (deprecated.booleanValue()) {
                this.modMenuData.badges.add(Mod.Badge.DEPRECATED);
            }
            if (!badgeNames.contains("deprecated")) {
                LOGGER.warn("WARNING! Mod " + this.metadata.getId() + " is only using deprecated 'modmenu:deprecated' custom value! This will be removed in 1.18 snapshots, so ask the author of this mod to support the new API.");
            }
        });
        String id = this.metadata.getId();
        if (id.startsWith("fabric") && this.metadata.containsCustomValue("fabric-api:module-lifecycle")) {
            if (FabricLoader.getInstance().isModLoaded("fabric-api")) {
                this.modMenuData.fillParentIfEmpty("fabric-api");
            } else {
                this.modMenuData.fillParentIfEmpty("fabric");
            }
            this.modMenuData.badges.add(Mod.Badge.LIBRARY);
        }
        if (id.startsWith("fabric") && (id.equals("fabricloader") || this.metadata.getProvides().contains("fabricloader") || id.equals("fabric") || id.equals("fabric-api") || this.metadata.getProvides().contains("fabric") || this.metadata.getProvides().contains("fabric-api"))) {
            this.modMenuData.badges.add(Mod.Badge.LIBRARY);
        }
        this.badges = this.modMenuData.badges;
        if (this.metadata.getEnvironment() == ModEnvironment.CLIENT) {
            this.badges.add(Mod.Badge.CLIENT);
        }
        if (OptionalUtil.isPresentAndTrue(CustomValueUtil.getBoolean("fabric-loom:generated", this.metadata)) || "java".equals(id)) {
            this.badges.add(Mod.Badge.LIBRARY);
        }
        if ("deprecated".equals(CustomValueUtil.getString("fabric-api:module-lifecycle", this.metadata).orElse(null))) {
            this.badges.add(Mod.Badge.DEPRECATED);
        }
        if (this.metadata.containsCustomValue("patchwork:patcherMeta")) {
            this.badges.add(Mod.Badge.PATCHWORK_FORGE);
        }
        if ("minecraft".equals(this.getId())) {
            this.badges.add(Mod.Badge.MINECRAFT);
        }
    }

    @NotNull
    public ModContainer getContainer() {
        return this.container;
    }

    @Override
    @NotNull
    public String getId() {
        return this.metadata.getId();
    }

    @Override
    @NotNull
    public String getName() {
        return this.metadata.getName();
    }

    @Override
    @NotNull
    public class_1043 getIcon(ModIconHandler iconHandler, int i) {
        String iconSourceId = this.getId();
        String iconPath = (String)((Object)this.metadata.getIconPath(i).orElse("assets/" + this.getId() + "/icon.png"));
        if ("minecraft".equals(this.getId())) {
            iconSourceId = "modmenu";
            iconPath = "assets/modmenu/minecraft_icon.png";
        } else if ("java".equals(this.getId())) {
            iconSourceId = "modmenu";
            iconPath = "assets/modmenu/java_icon.png";
        }
        String finalIconSourceId = iconSourceId;
        ModContainer iconSource = (ModContainer)FabricLoader.getInstance().getModContainer(iconSourceId).orElseThrow(() -> new RuntimeException("Cannot get ModContainer for Fabric mod with id " + finalIconSourceId));
        class_1043 icon = iconHandler.createIcon(iconSource, iconPath);
        if (icon == null) {
            LOGGER.warn("Warning! Mod {} has a broken icon, loading default icon", (Object)this.metadata.getId());
            return iconHandler.createIcon((ModContainer)FabricLoader.getInstance().getModContainer("modmenu").orElseThrow(() -> new RuntimeException("Cannot get ModContainer for Fabric mod with id modmenu")), "assets/modmenu/unknown_icon.png");
        }
        return icon;
    }

    @Override
    @NotNull
    public String getSummary() {
        return this.getDescription();
    }

    @Override
    @NotNull
    public String getDescription() {
        String description = this.metadata.getDescription();
        if ("minecraft".equals(this.getId()) && description.isEmpty()) {
            return "The base game.";
        }
        return description;
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.metadata.getVersion().getFriendlyString();
    }

    @Override
    @NotNull
    public String getPrefixedVersion() {
        Object version = this.getVersion().trim();
        if (((String)version).startsWith("version")) {
            version = "v" + ((String)version).substring("version".length());
        } else if (((String)version).startsWith("ver")) {
            version = "v" + ((String)version).substring("ver".length());
        } else if (!((String)version).startsWith("v")) {
            version = "v" + (String)version;
        }
        return ((String)version).trim();
    }

    @Override
    @NotNull
    public List<String> getAuthors() {
        List<String> authors = this.metadata.getAuthors().stream().map(Person::getName).collect(Collectors.toList());
        if ("minecraft".equals(this.getId()) && authors.isEmpty()) {
            return Lists.newArrayList((Object[])new String[]{"Mojang Studios"});
        }
        return authors;
    }

    @Override
    @NotNull
    public List<String> getContributors() {
        List<String> authors = this.metadata.getContributors().stream().map(Person::getName).collect(Collectors.toList());
        if ("minecraft".equals(this.getId()) && authors.isEmpty()) {
            return Lists.newArrayList();
        }
        return authors;
    }

    @Override
    @NotNull
    public Set<Mod.Badge> getBadges() {
        return this.badges;
    }

    @Override
    @Nullable
    public String getWebsite() {
        if ("minecraft".equals(this.getId())) {
            return "https://www.minecraft.net/";
        }
        return this.metadata.getContact().get("homepage").orElse(null);
    }

    @Override
    @Nullable
    public String getIssueTracker() {
        if ("minecraft".equals(this.getId())) {
            return "https://aka.ms/snapshotbugs?ref=game";
        }
        return this.metadata.getContact().get("issues").orElse(null);
    }

    @Override
    @Nullable
    public String getSource() {
        return this.metadata.getContact().get("sources").orElse(null);
    }

    @Override
    @Nullable
    public String getParent() {
        return this.modMenuData.parent.orElse(null);
    }

    @Override
    @NotNull
    public Set<String> getLicense() {
        if ("minecraft".equals(this.getId())) {
            return Sets.newHashSet((Object[])new String[]{"All Rights Reserved"});
        }
        return Sets.newHashSet((Iterable)this.metadata.getLicense());
    }

    @Override
    @NotNull
    public Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean isReal() {
        return true;
    }

    public ModMenuData getModMenuData() {
        return this.modMenuData;
    }

    static class ModMenuData {
        private final Set<Mod.Badge> badges;
        private Optional<String> parent;
        @Nullable
        private final DummyParentData dummyParentData;

        public ModMenuData(Set<String> badges, Optional<String> parent, DummyParentData dummyParentData) {
            this.badges = Mod.Badge.convert(badges);
            this.parent = parent;
            this.dummyParentData = dummyParentData;
        }

        public Set<Mod.Badge> getBadges() {
            return this.badges;
        }

        public Optional<String> getParent() {
            return this.parent;
        }

        @Nullable
        public DummyParentData getDummyParentData() {
            return this.dummyParentData;
        }

        public void addClientBadge(boolean add) {
            if (add) {
                this.badges.add(Mod.Badge.CLIENT);
            }
        }

        public void addLibraryBadge(boolean add) {
            if (add) {
                this.badges.add(Mod.Badge.LIBRARY);
            }
        }

        public void fillParentIfEmpty(String parent) {
            if (!this.parent.isPresent()) {
                this.parent = Optional.of(parent);
            }
        }

        public static class DummyParentData {
            private final String id;
            private final Optional<String> name;
            private final Optional<String> description;
            private final Optional<String> icon;
            private final Set<Mod.Badge> badges;

            public DummyParentData(String id, Optional<String> name, Optional<String> description, Optional<String> icon, Set<String> badges) {
                this.id = id;
                this.name = name;
                this.description = description;
                this.icon = icon;
                this.badges = Mod.Badge.convert(badges);
            }

            public String getId() {
                return this.id;
            }

            public Optional<String> getName() {
                return this.name;
            }

            public Optional<String> getDescription() {
                return this.description;
            }

            public Optional<String> getIcon() {
                return this.icon;
            }

            public Set<Mod.Badge> getBadges() {
                return this.badges;
            }
        }
    }
}

