/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.registry.sync.RemapException;
import net.fabricmc.fabric.impl.registry.sync.RemappableRegistry;
import net.minecraft.class_1255;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class RegistrySyncManager {
    static final boolean DEBUG = System.getProperty("fabric.registry.debug", "false").equalsIgnoreCase("true");
    static final class_2960 ID = new class_2960("fabric", "registry/sync");
    private static final Logger LOGGER = LogManager.getLogger((String)"FabricRegistrySync");
    private static final boolean DEBUG_WRITE_REGISTRY_DATA = System.getProperty("fabric.registry.debug.writeContentsAsCsv", "false").equalsIgnoreCase("true");
    public static boolean postBootstrap = false;

    private RegistrySyncManager() {
    }

    public static class_2596<?> createPacket() {
        LOGGER.debug("Creating registry sync packet");
        class_2487 tag = RegistrySyncManager.toTag(true, null);
        if (tag == null) {
            return null;
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10794(tag);
        return ServerPlayNetworking.createS2CPacket((class_2960)ID, (class_2540)buf);
    }

    public static void receivePacket(class_1255<?> executor, class_2540 buf, boolean accept, Consumer<Exception> errorHandler) {
        class_2487 compound = buf.method_10798();
        if (accept) {
            try {
                executor.method_5385(() -> {
                    if (compound == null) {
                        errorHandler.accept(new RemapException("Received null compound tag in sync packet!"));
                        return null;
                    }
                    try {
                        RegistrySyncManager.apply(compound, RemappableRegistry.RemapMode.REMOTE);
                    }
                    catch (RemapException e) {
                        errorHandler.accept(e);
                    }
                    return null;
                }).get(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                errorHandler.accept(e);
            }
        }
    }

    @Nullable
    public static class_2487 toTag(boolean isClientSync, @Nullable class_2487 activeTag) {
        class_2487 mainTag = new class_2487();
        for (class_2960 registryId : class_2378.field_11144.method_10235()) {
            RegistryAttributeHolder attributeHolder;
            class_2378 registry = (class_2378)class_2378.field_11144.method_10223(registryId);
            if (DEBUG_WRITE_REGISTRY_DATA) {
                File location = new File(".fabric" + File.separatorChar + "debug" + File.separatorChar + "registry");
                boolean c = true;
                if (!location.exists() && !location.mkdirs()) {
                    LOGGER.warn("[fabric-registry-sync debug] Could not create " + location.getAbsolutePath() + " directory!");
                    c = false;
                }
                if (c && registry != null) {
                    File file = new File(location, registryId.toString().replace(':', '.').replace('/', '.') + ".csv");
                    try (FileOutputStream stream = new FileOutputStream(file);){
                        StringBuilder builder = new StringBuilder("Raw ID,String ID,Class Type\n");
                        for (Object o : registry) {
                            String classType = o == null ? "null" : o.getClass().getName();
                            class_2960 id = registry.method_10221(o);
                            if (id == null) continue;
                            int rawId = registry.method_10206(o);
                            String stringId = id.toString();
                            builder.append("\"").append(rawId).append("\",\"").append(stringId).append("\",\"").append(classType).append("\"\n");
                        }
                        stream.write(builder.toString().getBytes(StandardCharsets.UTF_8));
                    }
                    catch (IOException e) {
                        LOGGER.warn("[fabric-registry-sync debug] Could not write to " + file.getAbsolutePath() + "!", (Throwable)e);
                    }
                }
            }
            class_2487 previousRegistryData = null;
            if (activeTag != null && activeTag.method_10545(registryId.toString())) {
                previousRegistryData = activeTag.method_10562(registryId.toString());
            }
            if (!(attributeHolder = RegistryAttributeHolder.get(registry)).hasAttribute(isClientSync ? RegistryAttribute.SYNCED : RegistryAttribute.PERSISTED)) {
                LOGGER.debug("Not {} registry: {}", (Object)(isClientSync ? "syncing" : "saving"), (Object)registryId);
                continue;
            }
            if ((previousRegistryData == null || isClientSync) && !attributeHolder.hasAttribute(RegistryAttribute.MODDED)) {
                LOGGER.debug("Skipping un-modded registry: " + registryId);
                continue;
            }
            if (previousRegistryData != null) {
                LOGGER.debug("Preserving previously modded registry: " + registryId);
            }
            if (isClientSync) {
                LOGGER.debug("Syncing registry: " + registryId);
            } else {
                LOGGER.debug("Saving registry: " + registryId);
            }
            if (!(registry instanceof RemappableRegistry)) continue;
            class_2487 registryTag = new class_2487();
            IntOpenHashSet rawIdsFound = DEBUG ? new IntOpenHashSet() : null;
            for (Object o : registry) {
                class_2960 id = registry.method_10221(o);
                if (id == null) continue;
                int rawId = registry.method_10206(o);
                if (DEBUG) {
                    if (registry.method_10223(id) != o) {
                        LOGGER.error("[fabric-registry-sync] Inconsistency detected in " + registryId + ": object " + o + " -> string ID " + id + " -> object " + registry.method_10223(id) + "!");
                    }
                    if (registry.method_10200(rawId) != o) {
                        LOGGER.error("[fabric-registry-sync] Inconsistency detected in " + registryId + ": object " + o + " -> integer ID " + rawId + " -> object " + registry.method_10200(rawId) + "!");
                    }
                    if (!rawIdsFound.add(rawId)) {
                        LOGGER.error("[fabric-registry-sync] Inconsistency detected in " + registryId + ": multiple objects hold the raw ID " + rawId + " (this one is " + id + ")");
                    }
                }
                registryTag.method_10569(id.toString(), rawId);
            }
            if (!isClientSync && previousRegistryData != null) {
                for (String key : previousRegistryData.method_10541()) {
                    if (registryTag.method_10545(key)) continue;
                    LOGGER.debug("Saving orphaned registry entry: " + key);
                    registryTag.method_10569(key, previousRegistryData.method_10550(key));
                }
            }
            mainTag.method_10566(registryId.toString(), (class_2520)registryTag);
        }
        if (!isClientSync && activeTag != null) {
            for (String registryKey : activeTag.method_10541()) {
                if (mainTag.method_10545(registryKey)) continue;
                LOGGER.debug("Saving orphaned registry: " + registryKey);
                mainTag.method_10566(registryKey, (class_2520)activeTag.method_10562(registryKey));
            }
        }
        if (mainTag.method_10541().isEmpty()) {
            return null;
        }
        class_2487 tag = new class_2487();
        tag.method_10569("version", 1);
        tag.method_10566("registries", (class_2520)mainTag);
        return tag;
    }

    public static class_2487 apply(class_2487 tag, RemappableRegistry.RemapMode mode) throws RemapException {
        class_2487 mainTag = tag.method_10562("registries");
        HashSet containedRegistries = Sets.newHashSet((Iterable)mainTag.method_10541());
        for (class_2960 registryId : class_2378.field_11144.method_10235()) {
            if (!containedRegistries.remove(registryId.toString())) continue;
            class_2487 registryTag = mainTag.method_10562(registryId.toString());
            class_2378 registry = (class_2378)class_2378.field_11144.method_10223(registryId);
            RegistryAttributeHolder attributeHolder = RegistryAttributeHolder.get(registry);
            if (!attributeHolder.hasAttribute(RegistryAttribute.MODDED)) {
                LOGGER.debug("Not applying registry data to vanilla registry {}", (Object)registryId.toString());
                continue;
            }
            if (!(registry instanceof RemappableRegistry)) continue;
            Object2IntOpenHashMap idMap = new Object2IntOpenHashMap();
            for (String key : registryTag.method_10541()) {
                idMap.put((Object)new class_2960(key), registryTag.method_10550(key));
            }
            ((RemappableRegistry)registry).remap(registryId.toString(), (Object2IntMap<class_2960>)idMap, mode);
        }
        if (!containedRegistries.isEmpty()) {
            LOGGER.warn("[fabric-registry-sync] Could not find the following registries: " + Joiner.on((String)", ").join((Iterable)containedRegistries));
        }
        return mainTag;
    }

    public static void unmap() throws RemapException {
        for (class_2960 registryId : class_2378.field_11144.method_10235()) {
            class_2378 registry = (class_2378)class_2378.field_11144.method_10223(registryId);
            if (!(registry instanceof RemappableRegistry)) continue;
            ((RemappableRegistry)registry).unmap(registryId.toString());
        }
    }

    public static void bootstrapRegistries() {
        postBootstrap = true;
    }
}

