/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_3518;
import net.minecraft.class_3846;
import net.minecraft.class_5513;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_5514
implements AutoCloseable {
    private static final Logger field_26823 = LogManager.getLogger();
    private static final AtomicInteger field_26824 = new AtomicInteger(1);
    private static final ThreadFactory field_26825 = runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName("Chat-Filter-Worker-" + field_26824.getAndIncrement());
        return thread;
    };
    private final URL field_26826;
    private final URL field_26827;
    private final URL field_26828;
    private final String field_26829;
    private final int field_26830;
    private final String field_26831;
    private final class_5515 field_26832;
    private final ExecutorService field_26833;

    private void method_31299(GameProfile gameProfile, URL uRL, Executor executor) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("server", this.field_26831);
        jsonObject.addProperty("room", "Chat");
        jsonObject.addProperty("user_id", gameProfile.getId().toString());
        jsonObject.addProperty("user_display_name", gameProfile.getName());
        executor.execute(() -> {
            try {
                this.method_31304(jsonObject, uRL);
            }
            catch (Exception exception) {
                field_26823.warn("Failed to send join/leave packet to {} for player {}", (Object)uRL, (Object)gameProfile, (Object)exception);
            }
        });
    }

    private CompletableFuture<Optional<String>> method_31298(GameProfile gameProfile, String string, class_5515 class_55152, Executor executor) {
        if (string.isEmpty()) {
            return CompletableFuture.completedFuture(Optional.of(""));
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("rule", (Number)this.field_26830);
        jsonObject.addProperty("server", this.field_26831);
        jsonObject.addProperty("room", "Chat");
        jsonObject.addProperty("player", gameProfile.getId().toString());
        jsonObject.addProperty("player_display_name", gameProfile.getName());
        jsonObject.addProperty("text", string);
        return CompletableFuture.supplyAsync(() -> {
            try {
                JsonObject jsonObject2 = this.method_31295(jsonObject, this.field_26826);
                boolean \u26032 = class_3518.method_15258(jsonObject2, "response", false);
                if (\u26032) {
                    return Optional.of(string);
                }
                String \u26033 = class_3518.method_15253(jsonObject2, "hashed", null);
                if (\u26033 == null) {
                    return Optional.empty();
                }
                int \u26034 = class_3518.method_15261(jsonObject2, "hashes").size();
                return class_55152.shouldIgnore(\u26033, \u26034) ? Optional.empty() : Optional.of(\u26033);
            }
            catch (Exception exception) {
                field_26823.warn("Failed to validate message '{}'", (Object)string, (Object)exception);
                return Optional.empty();
            }
        }, executor);
    }

    @Override
    public void close() {
        this.field_26833.shutdownNow();
    }

    private void method_31300(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[1024];
        while (inputStream.read(byArray) != -1) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject method_31295(JsonObject jsonObject, URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = this.method_31306(jsonObject, uRL);
        Throwable throwable = null;
        try (InputStream \u26032 = httpURLConnection.getInputStream();){
            JsonObject jsonObject2;
            if (httpURLConnection.getResponseCode() == 204) {
                JsonObject jsonObject3 = new JsonObject();
                return jsonObject3;
            }
            try {
                jsonObject2 = Streams.parse((JsonReader)new JsonReader((Reader)new InputStreamReader(\u26032))).getAsJsonObject();
            }
            catch (Throwable throwable2) {
                try {
                    this.method_31300(\u26032);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            this.method_31300(\u26032);
            return jsonObject2;
        }
    }

    private void method_31304(JsonObject jsonObject, URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = this.method_31306(jsonObject, uRL);
        try (InputStream \u26032 = httpURLConnection.getInputStream();){
            this.method_31300(\u26032);
        }
    }

    private HttpURLConnection method_31306(JsonObject jsonObject, URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.setReadTimeout(2000);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        httpURLConnection.setRequestProperty("Accept", "application/json");
        httpURLConnection.setRequestProperty("Authorization", "Basic " + this.field_26829);
        httpURLConnection.setRequestProperty("User-Agent", "Minecraft server" + class_155.method_16673().getName());
        try (OutputStreamWriter \u26032 = new OutputStreamWriter(httpURLConnection.getOutputStream(), StandardCharsets.UTF_8);
             JsonWriter jsonWriter = new JsonWriter((Writer)\u26032);){
            Streams.write((JsonElement)jsonObject, (JsonWriter)jsonWriter);
        }
        int \u26033 = httpURLConnection.getResponseCode();
        if (\u26033 < 200 || \u26033 >= 300) {
            throw new class_5517(\u26033 + " " + httpURLConnection.getResponseMessage());
        }
        return httpURLConnection;
    }

    public class_5513 method_31297(GameProfile gameProfile) {
        return new class_5516(gameProfile);
    }

    @FunctionalInterface
    public static interface class_5515 {
        public static final class_5515 field_26834 = (string, n) -> false;
        public static final class_5515 field_26835 = (string, n) -> string.length() == n;

        public boolean shouldIgnore(String var1, int var2);
    }

    class class_5516
    implements class_5513 {
        private final GameProfile field_26837;
        private final Executor field_26838;

        private class_5516(GameProfile gameProfile) {
            this.field_26837 = gameProfile;
            class_3846<Runnable> class_38462 = class_3846.method_16902(class_5514.this.field_26833, "chat stream for " + gameProfile.getName());
            this.field_26838 = class_38462::method_16901;
        }

        @Override
        public void method_31287() {
            class_5514.this.method_31299(this.field_26837, class_5514.this.field_26827, this.field_26838);
        }

        @Override
        public void method_31290() {
            class_5514.this.method_31299(this.field_26837, class_5514.this.field_26828, this.field_26838);
        }

        @Override
        public CompletableFuture<Optional<List<String>>> method_31289(List<String> list2) {
            List list3 = (List)list2.stream().map(string -> class_5514.this.method_31298(this.field_26837, string, class_5514.this.field_26832, this.field_26838)).collect(ImmutableList.toImmutableList());
            return ((CompletableFuture)class_156.method_652(list3).thenApply(list -> Optional.of(list.stream().map(optional -> optional.orElse("")).collect(ImmutableList.toImmutableList())))).exceptionally(throwable -> Optional.empty());
        }

        @Override
        public CompletableFuture<Optional<String>> method_31288(String string) {
            return class_5514.this.method_31298(this.field_26837, string, class_5514.this.field_26832, this.field_26838);
        }
    }

    public static class class_5517
    extends RuntimeException {
        private class_5517(String string) {
            super(string);
        }
    }
}

