/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_5478;
import net.optifine.config.BiomeId;
import net.optifine.override.ChunkCacheOF;

public class BiomeUtils {
    private static class_2378<class_1959> biomeRegistry = BiomeUtils.getBiomeRegistry((class_1937)class_310.method_1551().field_1687);
    public static class_1959 PLAINS = BiomeUtils.getBiomeSafe(biomeRegistry, (class_5321<class_1959>)class_1972.field_9451, () -> class_5478.method_30701((boolean)false));
    public static class_1959 SWAMP = BiomeUtils.getBiomeSafe(biomeRegistry, (class_5321<class_1959>)class_1972.field_9471, () -> class_5478.method_30708((float)-0.2f, (float)0.1f, (boolean)false));
    public static class_1959 SWAMP_HILLS = BiomeUtils.getBiomeSafe(biomeRegistry, (class_5321<class_1959>)class_1972.field_9479, () -> class_5478.method_30708((float)-0.1f, (float)0.3f, (boolean)true));

    public static void onWorldChanged(class_1937 worldIn) {
        biomeRegistry = BiomeUtils.getBiomeRegistry(worldIn);
        PLAINS = BiomeUtils.getBiomeSafe(biomeRegistry, (class_5321<class_1959>)class_1972.field_9451, () -> class_5478.method_30701((boolean)false));
        SWAMP = BiomeUtils.getBiomeSafe(biomeRegistry, (class_5321<class_1959>)class_1972.field_9471, () -> class_5478.method_30708((float)-0.2f, (float)0.1f, (boolean)false));
        SWAMP_HILLS = BiomeUtils.getBiomeSafe(biomeRegistry, (class_5321<class_1959>)class_1972.field_9479, () -> class_5478.method_30708((float)-0.1f, (float)0.3f, (boolean)true));
    }

    private static class_1959 getBiomeSafe(class_2378<class_1959> registry, class_5321<class_1959> biomeKey, Supplier<class_1959> biomeDefault) {
        class_1959 biome = (class_1959)registry.method_29107(biomeKey);
        if (biome == null) {
            biome = biomeDefault.get();
        }
        return biome;
    }

    public static class_2378<class_1959> getBiomeRegistry(class_1937 worldIn) {
        if (worldIn != null) {
            return worldIn.method_30349().method_33309(class_2378.field_25114);
        }
        return class_5458.field_25933;
    }

    public static class_2378<class_1959> getBiomeRegistry() {
        return biomeRegistry;
    }

    public static class_2960 getLocation(class_1959 biome) {
        return BiomeUtils.getBiomeRegistry().method_10221((Object)biome);
    }

    public static int getId(class_1959 biome) {
        return BiomeUtils.getBiomeRegistry().method_10206((Object)biome);
    }

    public static int getId(class_2960 loc) {
        class_1959 biome = BiomeUtils.getBiome(loc);
        return BiomeUtils.getBiomeRegistry().method_10206((Object)biome);
    }

    public static BiomeId getBiomeId(class_2960 loc) {
        return BiomeId.make(loc);
    }

    public static class_1959 getBiome(class_2960 loc) {
        return (class_1959)BiomeUtils.getBiomeRegistry().method_10223(loc);
    }

    public static Set<class_2960> getLocations() {
        return BiomeUtils.getBiomeRegistry().method_10235();
    }

    public static List<class_1959> getBiomes() {
        return Lists.newArrayList(biomeRegistry);
    }

    public static List<BiomeId> getBiomeIds() {
        return BiomeUtils.getBiomeIds(BiomeUtils.getLocations());
    }

    public static List<BiomeId> getBiomeIds(Collection<class_2960> locations) {
        ArrayList<BiomeId> biomeIds = new ArrayList<BiomeId>();
        for (class_2960 loc : locations) {
            BiomeId bi = BiomeId.make(loc);
            if (bi == null) continue;
            biomeIds.add(bi);
        }
        return biomeIds;
    }

    public static class_1959 getBiome(class_1920 lightReader, class_2338 blockPos) {
        class_1959 biome = PLAINS;
        if (lightReader instanceof ChunkCacheOF) {
            biome = ((ChunkCacheOF)lightReader).getBiome(blockPos);
        } else if (lightReader instanceof class_4538) {
            biome = ((class_4538)lightReader).method_23753(blockPos);
        }
        return biome;
    }
}

