/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.player;

import java.awt.Dimension;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.optifine.player.PlayerItemRenderer;

public class PlayerItemModel {
    private Dimension textureSize = null;
    private boolean usePlayerTexture = false;
    private PlayerItemRenderer[] modelRenderers = new PlayerItemRenderer[0];
    private class_2960 textureLocation = null;
    private class_1011 textureImage = null;
    private class_1043 texture = null;
    private class_2960 locationMissing = new class_2960("textures/block/red_wool.png");
    public static final int ATTACH_BODY = 0;
    public static final int ATTACH_HEAD = 1;
    public static final int ATTACH_LEFT_ARM = 2;
    public static final int ATTACH_RIGHT_ARM = 3;
    public static final int ATTACH_LEFT_LEG = 4;
    public static final int ATTACH_RIGHT_LEG = 5;
    public static final int ATTACH_CAPE = 6;

    public PlayerItemModel(Dimension textureSize, boolean usePlayerTexture, PlayerItemRenderer[] modelRenderers) {
        this.textureSize = textureSize;
        this.usePlayerTexture = usePlayerTexture;
        this.modelRenderers = modelRenderers;
    }

    public void render(class_572 modelBiped, class_742 player, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, int packedOverlayIn) {
        class_2960 locTex = this.locationMissing;
        if (this.usePlayerTexture) {
            locTex = player.method_3117();
        } else if (this.textureLocation != null) {
            if (this.texture == null && this.textureImage != null) {
                this.texture = new class_1043(this.textureImage);
                class_310.method_1551().method_1531().method_4616(this.textureLocation, (class_1044)this.texture);
            }
            locTex = this.textureLocation;
        } else {
            locTex = this.locationMissing;
        }
        for (int i = 0; i < this.modelRenderers.length; ++i) {
            PlayerItemRenderer pir = this.modelRenderers[i];
            matrixStackIn.method_22903();
            class_1921 renderType = class_1921.method_23578((class_2960)locTex);
            class_4588 buffer = bufferIn.getBuffer(renderType);
            pir.render(modelBiped, matrixStackIn, buffer, packedLightIn, packedOverlayIn);
            matrixStackIn.method_22909();
        }
    }

    public static class_630 getAttachModel(class_572 modelBiped, int attachTo) {
        switch (attachTo) {
            case 0: {
                return modelBiped.field_3391;
            }
            case 1: {
                return modelBiped.field_3398;
            }
            case 2: {
                return modelBiped.field_27433;
            }
            case 3: {
                return modelBiped.field_3401;
            }
            case 4: {
                return modelBiped.field_3397;
            }
            case 5: {
                return modelBiped.field_3392;
            }
        }
        return null;
    }

    public class_1011 getTextureImage() {
        return this.textureImage;
    }

    public void setTextureImage(class_1011 textureImage) {
        this.textureImage = textureImage;
    }

    public class_1043 getTexture() {
        return this.texture;
    }

    public class_2960 getTextureLocation() {
        return this.textureLocation;
    }

    public void setTextureLocation(class_2960 textureLocation) {
        this.textureLocation = textureLocation;
    }

    public boolean isUsePlayerTexture() {
        return this.usePlayerTexture;
    }
}

