/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import net.minecraft.class_3852;
import net.optifine.Config;

public class MatchProfession {
    private class_3852 profession;
    private int[] levels;

    public MatchProfession(class_3852 profession) {
        this(profession, null);
    }

    public MatchProfession(class_3852 profession, int level) {
        this(profession, new int[]{level});
    }

    public MatchProfession(class_3852 profession, int[] levels) {
        this.profession = profession;
        this.levels = levels;
    }

    public boolean matches(class_3852 prof, int lev) {
        if (this.profession != prof) {
            return false;
        }
        return this.levels == null || Config.equalsOne(lev, this.levels);
    }

    private boolean hasLevel(int lev) {
        if (this.levels == null) {
            return false;
        }
        return Config.equalsOne(lev, this.levels);
    }

    public boolean addLevel(int lev) {
        if (this.levels == null) {
            this.levels = new int[]{lev};
            return true;
        }
        if (this.hasLevel(lev)) {
            return false;
        }
        this.levels = Config.addIntToArray(this.levels, lev);
        return true;
    }

    public class_3852 getProfession() {
        return this.profession;
    }

    public int[] getLevels() {
        return this.levels;
    }

    public static boolean matchesOne(class_3852 prof, int level, MatchProfession[] mps) {
        if (mps == null) {
            return false;
        }
        for (int i = 0; i < mps.length; ++i) {
            MatchProfession mp = mps[i];
            if (!mp.matches(prof, level)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.levels == null) {
            return "" + this.profession;
        }
        return "" + this.profession + ":" + Config.arrayToString(this.levels);
    }
}

