/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class ArrayUtils {
    public static boolean contains(Object[] arr, Object val) {
        if (arr == null) {
            return false;
        }
        for (int i2 = 0; i2 < arr.length; ++i2) {
            Object obj = arr[i2];
            if (obj != val) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] arr, int val) {
        if (arr == null) {
            return false;
        }
        for (int i2 = 0; i2 < arr.length; ++i2) {
            if (arr[i2] != val) continue;
            return true;
        }
        return false;
    }

    public static int[] addIntsToArray(int[] intArray, int[] copyFrom) {
        if (intArray == null || copyFrom == null) {
            throw new NullPointerException("The given array is NULL");
        }
        int arrLen = intArray.length;
        int newLen = arrLen + copyFrom.length;
        int[] newArray = new int[newLen];
        System.arraycopy(intArray, 0, newArray, 0, arrLen);
        for (int index = 0; index < copyFrom.length; ++index) {
            newArray[index + arrLen] = copyFrom[index];
        }
        return newArray;
    }

    public static int[] addIntToArray(int[] intArray, int intValue) {
        return ArrayUtils.addIntsToArray(intArray, new int[]{intValue});
    }

    public static Object[] addObjectsToArray(Object[] arr, Object[] objs) {
        if (arr == null) {
            throw new NullPointerException("The given array is NULL");
        }
        if (objs.length == 0) {
            return arr;
        }
        int arrLen = arr.length;
        int newLen = arrLen + objs.length;
        Object[] newArr = (Object[])Array.newInstance(arr.getClass().getComponentType(), newLen);
        System.arraycopy(arr, 0, newArr, 0, arrLen);
        System.arraycopy(objs, 0, newArr, arrLen, objs.length);
        return newArr;
    }

    public static Object[] addObjectToArray(Object[] arr, Object obj) {
        if (arr == null) {
            throw new NullPointerException("The given array is NULL");
        }
        int arrLen = arr.length;
        int newLen = arrLen + 1;
        Object[] newArr = (Object[])Array.newInstance(arr.getClass().getComponentType(), newLen);
        System.arraycopy(arr, 0, newArr, 0, arrLen);
        newArr[arrLen] = obj;
        return newArr;
    }

    public static Object[] addObjectToArray(Object[] arr, Object obj, int index) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(arr));
        list.add(index, obj);
        Object[] newArr = (Object[])Array.newInstance(arr.getClass().getComponentType(), list.size());
        return list.toArray(newArr);
    }

    public static String arrayToString(boolean[] arr) {
        return ArrayUtils.arrayToString(arr, ", ");
    }

    public static String arrayToString(boolean[] arr, int maxLen) {
        return ArrayUtils.arrayToString(arr, ", ", maxLen);
    }

    public static String arrayToString(boolean[] arr, String separator) {
        return ArrayUtils.arrayToString(arr, separator, arr.length);
    }

    public static String arrayToString(boolean[] arr, String separator, int maxLen) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        int len = Math.min(arr.length, maxLen);
        for (int i2 = 0; i2 < len; ++i2) {
            boolean x = arr[i2];
            if (i2 > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(x));
        }
        return buf.toString();
    }

    public static String arrayToString(float[] arr) {
        return ArrayUtils.arrayToString(arr, ", ");
    }

    public static String arrayToString(float[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            float x = arr[i2];
            if (i2 > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(x));
        }
        return buf.toString();
    }

    public static String arrayToString(float[] arr, String separator, String format) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            float x = arr[i2];
            if (i2 > 0) {
                buf.append(separator);
            }
            buf.append(String.format(format, Float.valueOf(x)));
        }
        return buf.toString();
    }

    public static String arrayToString(int[] arr) {
        return ArrayUtils.arrayToString(arr, ", ");
    }

    public static String arrayToString(int[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            int x = arr[i2];
            if (i2 > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(x));
        }
        return buf.toString();
    }

    public static String arrayToHexString(int[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            int x = arr[i2];
            if (i2 > 0) {
                buf.append(separator);
            }
            buf.append("0x");
            buf.append(Integer.toHexString(x));
        }
        return buf.toString();
    }

    public static String arrayToString(Object[] arr) {
        return ArrayUtils.arrayToString(arr, ", ");
    }

    public static String arrayToString(Object[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            Object obj = arr[i2];
            if (i2 > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(obj));
        }
        return buf.toString();
    }

    public static Object[] collectionToArray(Collection coll, Class elementClass) {
        if (coll == null) {
            return null;
        }
        if (elementClass == null) {
            return null;
        }
        if (elementClass.isPrimitive()) {
            throw new IllegalArgumentException("Can not make arrays with primitive elements (int, double), element class: " + elementClass);
        }
        Object[] array = (Object[])Array.newInstance(elementClass, coll.size());
        return coll.toArray(array);
    }

    public static boolean equalsOne(int val, int[] vals) {
        for (int i2 = 0; i2 < vals.length; ++i2) {
            if (vals[i2] != val) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsOne(Object a2, Object[] bs) {
        if (bs == null) {
            return false;
        }
        for (int i2 = 0; i2 < bs.length; ++i2) {
            Object b2 = bs[i2];
            if (!ArrayUtils.equals(a2, b2)) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean isSameOne(Object a2, Object[] bs) {
        if (bs == null) {
            return false;
        }
        for (int i2 = 0; i2 < bs.length; ++i2) {
            Object b2 = bs[i2];
            if (a2 != b2) continue;
            return true;
        }
        return false;
    }

    public static Object[] removeObjectFromArray(Object[] arr, Object obj) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(arr));
        list.remove(obj);
        Object[] newArr = ArrayUtils.collectionToArray(list, arr.getClass().getComponentType());
        return newArr;
    }

    public static int[] toPrimitive(Integer[] arr) {
        if (arr == null) {
            return null;
        }
        if (arr.length == 0) {
            return new int[0];
        }
        int[] intArr = new int[arr.length];
        for (int i2 = 0; i2 < intArr.length; ++i2) {
            intArr[i2] = arr[i2];
        }
        return intArr;
    }

    public static boolean[] newBoolean(int len, boolean val) {
        boolean[] arr = new boolean[len];
        Arrays.fill(arr, val);
        return arr;
    }

    public static int[] newInt(int len, int val) {
        int[] arr = new int[len];
        Arrays.fill(arr, val);
        return arr;
    }

    public static Object[] newObject(int len, Object val) {
        Object[] arr = (Object[])Array.newInstance(val.getClass(), len);
        Arrays.fill(arr, val);
        return arr;
    }
}

