/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.rule;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import xaero.common.category.rule.ObjectCategoryRule;
import xaero.common.misc.ListFactory;

abstract class ObjectCategoryListRule<E, S>
extends ObjectCategoryRule<E, Object>
implements Iterable<S> {
    private final List<S> list;
    private final Function<E, S> getter;
    private final Comparator<S> comparator;

    ObjectCategoryListRule(@Nonnull String name, @Nonnull List<S> list, @Nonnull Function<E, S> getter, @Nonnull Comparator<S> comparator) {
        super(name);
        this.list = list;
        this.getter = getter;
        this.comparator = comparator;
    }

    public boolean inList(E object) {
        if (this.list.isEmpty()) {
            return false;
        }
        S s = this.getter.apply(object);
        return s != null && Collections.binarySearch(this.list, s, this.comparator) >= 0;
    }

    @Override
    public Iterator<S> iterator() {
        return this.list.iterator();
    }

    public static abstract class Builder<E, S, B extends Builder<E, S, B>> {
        protected final B self = this;
        protected final List<S> list;
        protected Function<E, S> getter;
        protected Comparator<S> comparator;

        public Builder(ListFactory listFactory) {
            this.list = listFactory.get();
        }

        public B setDefault() {
            this.list.clear();
            this.setGetter(null);
            this.setComparator((o1, o2) -> Integer.compare(o1.hashCode(), o2.hashCode()));
            return this.self;
        }

        public List<S> getList() {
            return this.list;
        }

        public B setGetter(Function<E, S> getter) {
            this.getter = getter;
            return this.self;
        }

        public B setComparator(Comparator<S> comparator) {
            this.comparator = comparator;
            return this.self;
        }

        public ObjectCategoryListRule<E, S> build() {
            if (this.list == null || this.getter == null || this.comparator == null) {
                throw new IllegalStateException("required fields not set!");
            }
            Collections.sort(this.list, this.comparator);
            return this.buildInternally();
        }

        protected abstract ObjectCategoryListRule<E, S> buildInternally();
    }
}

