/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2404;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.optifine.Config;
import net.optifine.ConnectedProperties;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchBlock;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.shaders.BlockAlias;
import net.optifine.shaders.IShaderPack;
import net.optifine.shaders.ShaderPackNone;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.config.MacroProcessor;
import net.optifine.util.BlockUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.StrUtils;

public class BlockAliases {
    private static BlockAlias[][] blockAliases = null;
    private static boolean hasAliasMetadata = false;
    private static PropertiesOrdered blockLayerPropertes = null;
    private static boolean updateOnResourcesReloaded;
    private static List<List<BlockAlias>> legacyAliases;

    public static int getAliasBlockId(class_2680 blockState) {
        int metadata;
        int blockId = blockState.getBlockId();
        BlockAlias alias = BlockAliases.getBlockAlias(blockId, metadata = blockState.getMetadata());
        if (alias != null) {
            return alias.getAliasBlockId();
        }
        return -1;
    }

    public static boolean hasAliasMetadata() {
        return hasAliasMetadata;
    }

    public static int getAliasMetadata(class_2680 blockState) {
        int metadata;
        if (!hasAliasMetadata) {
            return 0;
        }
        int blockId = blockState.getBlockId();
        BlockAlias alias = BlockAliases.getBlockAlias(blockId, metadata = blockState.getMetadata());
        if (alias != null) {
            return alias.getAliasMetadata();
        }
        return 0;
    }

    public static BlockAlias getBlockAlias(int blockId, int metadata) {
        if (blockAliases == null) {
            return null;
        }
        if (blockId < 0 || blockId >= blockAliases.length) {
            return null;
        }
        BlockAlias[] aliases = blockAliases[blockId];
        if (aliases == null) {
            return null;
        }
        for (int i = 0; i < aliases.length; ++i) {
            BlockAlias ba = aliases[i];
            if (!ba.matches(blockId, metadata)) continue;
            return ba;
        }
        return null;
    }

    public static BlockAlias[] getBlockAliases(int blockId) {
        if (blockAliases == null) {
            return null;
        }
        if (blockId < 0 || blockId >= blockAliases.length) {
            return null;
        }
        BlockAlias[] aliases = blockAliases[blockId];
        return aliases;
    }

    public static void resourcesReloaded() {
        if (!updateOnResourcesReloaded) {
            return;
        }
        updateOnResourcesReloaded = false;
        BlockAliases.update(Shaders.getShaderPack());
    }

    public static void update(IShaderPack shaderPack) {
        BlockAliases.reset();
        if (shaderPack == null) {
            return;
        }
        if (shaderPack instanceof ShaderPackNone) {
            return;
        }
        if (Reflector.Loader_getActiveModList.exists() && class_310.method_1551().method_1478() == null) {
            Config.dbg("[Shaders] Delayed loading of block mappings after resources are loaded");
            updateOnResourcesReloaded = true;
            return;
        }
        List<List<BlockAlias>> listBlockAliases = new ArrayList<List<BlockAlias>>();
        String path = "/shaders/block.properties";
        InputStream in = shaderPack.getResourceAsStream(path);
        if (in != null) {
            BlockAliases.loadBlockAliases(in, path, listBlockAliases);
        }
        BlockAliases.loadModBlockAliases(listBlockAliases);
        if (listBlockAliases.size() <= 0) {
            listBlockAliases = BlockAliases.getLegacyAliases();
            hasAliasMetadata = true;
        }
        blockAliases = BlockAliases.toBlockAliasArrays(listBlockAliases);
    }

    private static void loadModBlockAliases(List<List<BlockAlias>> listBlockAliases) {
        String[] modIds = ReflectorForge.getForgeModIds();
        for (int i = 0; i < modIds.length; ++i) {
            String modId = modIds[i];
            try {
                class_2960 loc = new class_2960(modId, "shaders/block.properties");
                InputStream in = Config.getResourceStream(loc);
                BlockAliases.loadBlockAliases(in, loc.toString(), listBlockAliases);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void loadBlockAliases(InputStream in, String path, List<List<BlockAlias>> listBlockAliases) {
        if (in == null) {
            return;
        }
        try {
            in = MacroProcessor.process(in, path, true);
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            Config.dbg("[Shaders] Parsing block mappings: " + path);
            ConnectedParser cp = new ConnectedParser("Shaders");
            Set<Object> keys = ((Properties)props).keySet();
            for (String string : keys) {
                String val = props.getProperty(string);
                if (string.startsWith("layer.")) {
                    if (blockLayerPropertes == null) {
                        blockLayerPropertes = new PropertiesOrdered();
                    }
                    blockLayerPropertes.put(string, val);
                    continue;
                }
                String prefix = "block.";
                if (!string.startsWith(prefix)) {
                    Config.warn("[Shaders] Invalid block ID: " + string);
                    continue;
                }
                String blockIdStr = StrUtils.removePrefix(string, prefix);
                int blockId = Config.parseInt(blockIdStr, -1);
                if (blockId < 0) {
                    Config.warn("[Shaders] Invalid block ID: " + string);
                    continue;
                }
                MatchBlock[] matchBlocks = cp.parseMatchBlocks(val);
                if (matchBlocks == null || matchBlocks.length < 1) {
                    Config.warn("[Shaders] Invalid block ID mapping: " + string + "=" + val);
                    continue;
                }
                BlockAlias ba = new BlockAlias(blockId, matchBlocks);
                BlockAliases.addToList(listBlockAliases, ba);
            }
        }
        catch (IOException e) {
            Config.warn("[Shaders] Error reading: " + path);
        }
    }

    private static void addToList(List<List<BlockAlias>> blocksAliases, BlockAlias ba) {
        int[] blockIds = ba.getMatchBlockIds();
        for (int i = 0; i < blockIds.length; ++i) {
            int blockId = blockIds[i];
            while (blockId >= blocksAliases.size()) {
                blocksAliases.add(null);
            }
            List<BlockAlias> blockAliases = blocksAliases.get(blockId);
            if (blockAliases == null) {
                blockAliases = new ArrayList<BlockAlias>();
                blocksAliases.set(blockId, blockAliases);
            }
            BlockAlias baBlock = new BlockAlias(ba.getAliasBlockId(), ba.getMatchBlocks(blockId));
            blockAliases.add(baBlock);
        }
    }

    private static BlockAlias[][] toBlockAliasArrays(List<List<BlockAlias>> listBlocksAliases) {
        BlockAlias[][] bas = new BlockAlias[listBlocksAliases.size()][];
        for (int i = 0; i < bas.length; ++i) {
            List<BlockAlias> listBlockAliases = listBlocksAliases.get(i);
            if (listBlockAliases == null) continue;
            bas[i] = listBlockAliases.toArray(new BlockAlias[listBlockAliases.size()]);
        }
        return bas;
    }

    private static List<List<BlockAlias>> getLegacyAliases() {
        if (legacyAliases == null) {
            legacyAliases = BlockAliases.makeLegacyAliases();
        }
        return legacyAliases;
    }

    private static List<List<BlockAlias>> makeLegacyAliases() {
        try {
            String path = "flattening_ids.txt";
            Config.dbg("Using legacy block aliases: " + path);
            ArrayList<List<BlockAlias>> listAliases = new ArrayList<List<BlockAlias>>();
            ArrayList<String> listLines = new ArrayList<String>();
            int countAliases = 0;
            InputStream in = Config.getOptiFineResourceStream("/" + path);
            if (in == null) {
                return listAliases;
            }
            String[] lines = Config.readLines(in);
            for (int i = 0; i < lines.length; ++i) {
                int lineNum = i + 1;
                String line = lines[i];
                if (line.trim().length() <= 0) continue;
                listLines.add(line);
                if (line.startsWith("#")) continue;
                if (line.startsWith("alias")) {
                    String[] parts = Config.tokenize(line, " ");
                    String blockAliasStr = parts[1];
                    String blockStr = parts[2];
                    String prefix = "{Name:'" + blockStr + "'";
                    List blockLines = listLines.stream().filter(s -> s.startsWith(prefix)).collect(Collectors.toList());
                    if (blockLines.size() <= 0) {
                        Config.warn("Block not processed: " + line);
                        continue;
                    }
                    for (String lineBlock : blockLines) {
                        String prefixNew = "{Name:'" + blockAliasStr + "'";
                        String lineNew = lineBlock.replace(prefix, prefixNew);
                        listLines.add(lineNew);
                        BlockAliases.addLegacyAlias(lineNew, lineNum, listAliases);
                        ++countAliases;
                    }
                    continue;
                }
                BlockAliases.addLegacyAlias(line, lineNum, listAliases);
                ++countAliases;
            }
            Config.dbg("Legacy block aliases: " + countAliases);
            return listAliases;
        }
        catch (IOException e) {
            Config.warn("Error loading legacy block aliases: " + e.getClass().getName() + ": " + e.getMessage());
            return new ArrayList<List<BlockAlias>>();
        }
    }

    private static void addLegacyAlias(String line, int lineNum, List<List<BlockAlias>> listAliases) {
        String[] parts = Config.tokenize(line, " ");
        if (parts.length != 4) {
            Config.warn("Invalid flattening line: " + line);
            return;
        }
        String partNew = parts[0];
        String partOld = parts[1];
        int blockIdOld = Config.parseInt(parts[2], Integer.MIN_VALUE);
        int metadataOld = Config.parseInt(parts[3], Integer.MIN_VALUE);
        if (blockIdOld < 0 || metadataOld < 0) {
            Config.warn("Invalid blockID or metadata (" + lineNum + "): " + blockIdOld + ":" + metadataOld);
            return;
        }
        try {
            JsonParser jp = new JsonParser();
            JsonObject jo = jp.parse(partNew).getAsJsonObject();
            String name = jo.get("Name").getAsString();
            class_2960 loc = new class_2960(name);
            class_2248 block = BlockUtils.getBlock(loc);
            if (block == null) {
                Config.warn("Invalid block name (" + lineNum + "): " + name);
                return;
            }
            class_2680 blockState = block.method_9564();
            Collection<class_2769<?>> stateProperties = blockState.method_28501();
            LinkedHashMap<class_2769, Comparable> mapProperties = new LinkedHashMap<class_2769, Comparable>();
            JsonObject properties = (JsonObject)jo.get("Properties");
            if (properties != null) {
                Set entries = properties.entrySet();
                for (Map.Entry entry : entries) {
                    String key = (String)entry.getKey();
                    String value = ((JsonElement)entry.getValue()).getAsString();
                    class_2769 prop = ConnectedProperties.getProperty(key, stateProperties);
                    if (prop == null) {
                        Config.warn("Invalid property (" + lineNum + "): " + key);
                        continue;
                    }
                    Comparable propVal = ConnectedParser.parsePropertyValue(prop, value);
                    if (propVal == null) {
                        Config.warn("Invalid property value (" + lineNum + "): " + value);
                        continue;
                    }
                    mapProperties.put(prop, propVal);
                }
            }
            int blockId = blockState.getBlockId();
            while (listAliases.size() <= blockId) {
                listAliases.add(null);
            }
            List<BlockAlias> las = listAliases.get(blockId);
            if (las == null) {
                las = new ArrayList<BlockAlias>(BlockUtils.getMetadataCount(block));
                listAliases.set(blockId, las);
            }
            MatchBlock mb = BlockAliases.getMatchBlock(blockState.method_26204(), blockState.getBlockId(), mapProperties);
            BlockAliases.addBlockAlias(las, blockIdOld, metadataOld, mb);
        }
        catch (Exception e) {
            Config.warn("Error parsing: " + line);
        }
    }

    private static void addBlockAlias(List<BlockAlias> listBlockAliases, int aliasBlockId, int aliasMetadata, MatchBlock matchBlock) {
        for (BlockAlias ba : listBlockAliases) {
            if (ba.getAliasBlockId() != aliasBlockId || ba.getAliasMetadata() != aliasMetadata) continue;
            MatchBlock[] mbs = ba.getMatchBlocks();
            for (int i = 0; i < mbs.length; ++i) {
                MatchBlock mb = mbs[i];
                if (mb.getBlockId() != matchBlock.getBlockId()) continue;
                mb.addMetadatas(matchBlock.getMetadatas());
                return;
            }
        }
        BlockAlias ba = new BlockAlias(aliasBlockId, aliasMetadata, new MatchBlock[]{matchBlock});
        listBlockAliases.add(ba);
    }

    private static MatchBlock getMatchBlock(class_2248 block, int blockId, Map<class_2769, Comparable> mapProperties) {
        ArrayList<class_2680> matchingStates = new ArrayList<class_2680>();
        Set<class_2769> props = mapProperties.keySet();
        List<class_2680> states = BlockUtils.getBlockStates(block);
        for (class_2680 class_26802 : states) {
            boolean bl = true;
            for (class_2769 prop : props) {
                Object val2;
                if (!class_26802.method_28498(prop)) {
                    bl = false;
                    break;
                }
                Comparable val1 = mapProperties.get(prop);
                if (val1.equals(val2 = class_26802.method_11654(prop))) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            matchingStates.add(class_26802);
        }
        LinkedHashSet<Integer> setMetadatas = new LinkedHashSet<Integer>();
        for (class_2680 class_26803 : matchingStates) {
            setMetadatas.add(class_26803.getMetadata());
        }
        Integer[] integerArray = setMetadatas.toArray(new Integer[setMetadatas.size()]);
        int[] nArray = Config.toPrimitive(integerArray);
        MatchBlock mb = new MatchBlock(blockId, nArray);
        return mb;
    }

    private static void checkLegacyAliases() {
        Set<class_2960> locs = class_2378.field_11146.method_10235();
        for (class_2960 loc : locs) {
            class_2248 block = class_2378.field_11146.method_10223(loc);
            int blockId = block.method_9564().getBlockId();
            BlockAlias[] bas = BlockAliases.getBlockAliases(blockId);
            if (bas == null) {
                Config.warn("Block has no alias: " + block);
                continue;
            }
            List<class_2680> states = BlockUtils.getBlockStates(block);
            for (class_2680 state : states) {
                int metadata = state.getMetadata();
                BlockAlias ba = BlockAliases.getBlockAlias(blockId, metadata);
                if (ba != null) continue;
                Config.warn("State has no alias: " + state);
            }
        }
    }

    public static PropertiesOrdered getBlockLayerPropertes() {
        return blockLayerPropertes;
    }

    public static void reset() {
        blockAliases = null;
        hasAliasMetadata = false;
        blockLayerPropertes = null;
    }

    public static int getRenderType(class_2680 blockState) {
        if (hasAliasMetadata) {
            class_2248 block = blockState.method_26204();
            if (block instanceof class_2404) {
                return 1;
            }
            class_2464 brt = blockState.method_26217();
            if (brt == class_2464.field_11456 || brt == class_2464.field_11458) {
                return brt.ordinal() + 1;
            }
            return brt.ordinal();
        }
        return blockState.method_26217().ordinal();
    }
}

