/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.IntBuffer;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.optifine.Config;
import net.optifine.render.MultiTextureData;
import net.optifine.render.SpriteRenderData;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersTex;
import org.lwjgl.PointerBuffer;

public class MultiTextureRenderer {
    private static PointerBuffer bufferPositions = Config.createDirectPointerBuffer(1024);
    private static IntBuffer bufferCounts = Config.createDirectIntBuffer(1024);
    private static boolean shaders;

    public static void draw(class_293.class_5596 drawMode, int indexTypeIn, MultiTextureData multiTextureData) {
        shaders = Config.isShaders();
        SpriteRenderData[] srds = multiTextureData.getSpriteRenderDatas();
        for (int i = 0; i < srds.length; ++i) {
            SpriteRenderData srd = srds[i];
            MultiTextureRenderer.draw(drawMode, indexTypeIn, srd);
        }
    }

    private static void draw(class_293.class_5596 drawMode, int indexTypeIn, SpriteRenderData srd) {
        int i;
        class_1058 sprite = srd.getSprite();
        int[] positions = srd.getPositions();
        int[] counts = srd.getCounts();
        sprite.bindSpriteTexture();
        if (shaders) {
            int normalTex = sprite.spriteNormal != null ? sprite.spriteNormal.glSpriteTextureId : 0;
            int specularTex = sprite.spriteSpecular != null ? sprite.spriteSpecular.glSpriteTextureId : 0;
            class_1059 at = sprite.method_24119();
            ShadersTex.bindNSTextures(normalTex, specularTex, at.isNormalBlend(), at.isSpecularBlend(), at.isMipmaps());
            if (Shaders.uniform_spriteBounds.isDefined()) {
                Shaders.uniform_spriteBounds.setValue(sprite.method_4594(), sprite.method_4593(), sprite.method_4577(), sprite.method_4575());
            }
        }
        if (bufferPositions.capacity() < positions.length) {
            int size = class_3532.method_15339(positions.length);
            bufferPositions = Config.createDirectPointerBuffer(size);
            bufferCounts = Config.createDirectIntBuffer(size);
        }
        bufferPositions.clear();
        bufferCounts.clear();
        int indexSize = MultiTextureRenderer.getIndexSize(indexTypeIn);
        for (i = 0; i < positions.length; ++i) {
            bufferPositions.put((long)(drawMode.method_31973(positions[i]) * indexSize));
        }
        for (i = 0; i < counts.length; ++i) {
            bufferCounts.put(drawMode.method_31973(counts[i]));
        }
        bufferPositions.flip();
        bufferCounts.flip();
        GlStateManager.glMultiDrawElements(drawMode.field_27383, bufferCounts, indexTypeIn, bufferPositions);
    }

    private static int getIndexSize(int indexTypeIn) {
        if (indexTypeIn == 5125) {
            return 4;
        }
        if (indexTypeIn == 5123) {
            return 2;
        }
        return 1;
    }
}

