/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_1074;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.optifine.Config;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class Lang {
    private static final Splitter splitter = Splitter.on((char)'=').limit(2);
    private static final Pattern pattern = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");

    public static void resourcesReloaded() {
        HashMap localeProperties = new HashMap();
        ArrayList<String> listFiles = new ArrayList<String>();
        String PREFIX = "optifine/lang/";
        String EN_US = "en_us";
        String SUFFIX = ".lang";
        listFiles.add(PREFIX + EN_US + SUFFIX);
        if (!Config.getGameSettings().field_1883.equals(EN_US)) {
            listFiles.add(PREFIX + Config.getGameSettings().field_1883 + SUFFIX);
        }
        String[] files = listFiles.toArray(new String[listFiles.size()]);
        Lang.loadResources(Config.getDefaultResourcePack(), files, localeProperties);
        class_3262[] resourcePacks = Config.getResourcePacks();
        for (int i = 0; i < resourcePacks.length; ++i) {
            class_3262 rp = resourcePacks[i];
            Lang.loadResources(rp, files, localeProperties);
        }
    }

    private static void loadResources(class_3262 rp, String[] files, Map localeProperties) {
        try {
            for (int i = 0; i < files.length; ++i) {
                InputStream in;
                String file = files[i];
                class_2960 loc = new class_2960(file);
                if (!rp.method_14411(class_3264.field_14188, loc) || (in = rp.method_14405(class_3264.field_14188, loc)) == null) continue;
                Lang.loadLocaleData(in, localeProperties);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadLocaleData(InputStream is, Map localeProperties) throws IOException {
        Iterator it = IOUtils.readLines((InputStream)is, (Charset)Charsets.UTF_8).iterator();
        is.close();
        while (it.hasNext()) {
            String[] parts;
            String line = (String)it.next();
            if (line.isEmpty() || line.charAt(0) == '#' || (parts = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)line), String.class)) == null || parts.length != 2) continue;
            String key = parts[0];
            String value = pattern.matcher(parts[1]).replaceAll("%$1s");
            localeProperties.put(key, value);
        }
    }

    public static void loadResources(class_3300 resourceManager, String langCode, Map<String, String> map) {
        try {
            String pathLang = "optifine/lang/" + langCode + ".lang";
            class_2960 locLang = new class_2960(pathLang);
            class_3298 res = resourceManager.method_14486(locLang);
            InputStream is = res.method_14482();
            Lang.loadLocaleData(is, map);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String get(String key) {
        return class_1074.method_4662(key, new Object[0]);
    }

    public static class_2588 getComponent(String key) {
        return new class_2588(key);
    }

    public static String get(String key, String def) {
        String str = class_1074.method_4662(key, new Object[0]);
        if (str == null || str.equals(key)) {
            return def;
        }
        return str;
    }

    public static String getOn() {
        return class_1074.method_4662("options.on", new Object[0]);
    }

    public static String getOff() {
        return class_1074.method_4662("options.off", new Object[0]);
    }

    public static String getFast() {
        return class_1074.method_4662("options.graphics.fast", new Object[0]);
    }

    public static String getFancy() {
        return class_1074.method_4662("options.graphics.fancy", new Object[0]);
    }

    public static String getDefault() {
        return class_1074.method_4662("generator.default", new Object[0]);
    }
}

