/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1545;
import net.minecraft.class_1548;
import net.minecraft.class_1589;
import net.minecraft.class_1657;
import net.minecraft.class_1668;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2940;
import net.minecraft.class_2960;
import net.minecraft.class_5776;
import net.minecraft.class_5915;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.optifine.Config;
import net.optifine.DynamicLight;
import net.optifine.DynamicLightsMap;
import net.optifine.config.ConnectedParser;
import net.optifine.config.EntityTypeNameLocator;
import net.optifine.config.IObjectLocator;
import net.optifine.config.ItemLocator;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.util.PropertiesOrdered;

public class DynamicLights {
    private static DynamicLightsMap mapDynamicLights = new DynamicLightsMap();
    private static Map<String, Integer> mapEntityLightLevels = new HashMap<String, Integer>();
    private static Map<class_1792, Integer> mapItemLightLevels = new HashMap<class_1792, Integer>();
    private static long timeUpdateMs = 0L;
    private static final double MAX_DIST = 7.5;
    private static final double MAX_DIST_SQ = 56.25;
    private static final int LIGHT_LEVEL_MAX = 15;
    private static final int LIGHT_LEVEL_FIRE = 15;
    private static final int LIGHT_LEVEL_BLAZE = 10;
    private static final int LIGHT_LEVEL_MAGMA_CUBE = 8;
    private static final int LIGHT_LEVEL_MAGMA_CUBE_CORE = 13;
    private static final int LIGHT_LEVEL_GLOWSTONE_DUST = 8;
    private static final int LIGHT_LEVEL_PRISMARINE_CRYSTALS = 8;
    private static final int LIGHT_LEVEL_GLOW_SQUID = 11;
    private static final int LIGHT_LEVEL_GLOW_INK_SAC = 8;
    private static final int LIGHT_LEVEL_GLOW_LICHEN = 6;
    private static final int LIGHT_LEVEL_GLOW_BERRIES = 12;
    private static final int LIGHT_LEVEL_GLOW_ITEM_FRAME = 8;
    private static final class_2940<class_1799> PARAMETER_ITEM_STACK = (class_2940)Reflector.EntityItem_ITEM.getValue();
    private static boolean initialized;

    public static void entityAdded(class_1297 entityIn, class_761 renderGlobal) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entityRemoved(class_1297 entityIn, class_761 renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLight dynamicLight = mapDynamicLights.remove(entityIn.method_5628());
            if (dynamicLight != null) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(class_761 renderGlobal) {
        long timeNowMs = System.currentTimeMillis();
        if (timeNowMs < timeUpdateMs + 50L) {
            return;
        }
        timeUpdateMs = timeNowMs;
        if (!initialized) {
            DynamicLights.initialize();
        }
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLights.updateMapDynamicLights(renderGlobal);
            if (mapDynamicLights.size() <= 0) {
                return;
            }
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            for (int i = 0; i < dynamicLights.size(); ++i) {
                DynamicLight dynamicLight = dynamicLights.get(i);
                dynamicLight.update(renderGlobal);
            }
        }
    }

    private static void initialize() {
        initialized = true;
        mapEntityLightLevels.clear();
        mapItemLightLevels.clear();
        String[] modIds = ReflectorForge.getForgeModIds();
        for (int i = 0; i < modIds.length; ++i) {
            String modId = modIds[i];
            try {
                class_2960 loc = new class_2960(modId, "optifine/dynamic_lights.properties");
                InputStream in = Config.getResourceStream(loc);
                DynamicLights.loadModConfiguration(in, loc.toString(), modId);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (mapEntityLightLevels.size() > 0) {
            Config.dbg("DynamicLights entities: " + mapEntityLightLevels.size());
        }
        if (mapItemLightLevels.size() > 0) {
            Config.dbg("DynamicLights items: " + mapItemLightLevels.size());
        }
    }

    private static void loadModConfiguration(InputStream in, String path, String modId) {
        if (in == null) {
            return;
        }
        try {
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            Config.dbg("DynamicLights: Parsing " + path);
            ConnectedParser cp = new ConnectedParser("DynamicLights");
            DynamicLights.loadModLightLevels(props.getProperty("entities"), mapEntityLightLevels, new EntityTypeNameLocator(), cp, path, modId);
            DynamicLights.loadModLightLevels(props.getProperty("items"), mapItemLightLevels, new ItemLocator(), cp, path, modId);
        }
        catch (IOException e) {
            Config.warn("DynamicLights: Error reading " + path);
        }
    }

    private static <T> void loadModLightLevels(String prop, Map<T, Integer> mapLightLevels, IObjectLocator<T> ol, ConnectedParser cp, String path, String modId) {
        if (prop == null) {
            return;
        }
        String[] parts = Config.tokenize(prop, " ");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            String[] tokens = Config.tokenize(part, ":");
            if (tokens.length != 2) {
                cp.warn("Invalid entry: " + part + ", in:" + path);
                continue;
            }
            String name = tokens[0];
            String light = tokens[1];
            String nameFull = modId + ":" + name;
            class_2960 loc = new class_2960(nameFull);
            T obj = ol.getObject(loc);
            if (obj == null) {
                cp.warn("Object not found: " + nameFull);
                continue;
            }
            int lightLevel = cp.parseInt(light, -1);
            if (lightLevel < 0 || lightLevel > 15) {
                cp.warn("Invalid light level: " + part);
                continue;
            }
            mapLightLevels.put(obj, new Integer(lightLevel));
        }
    }

    private static void updateMapDynamicLights(class_761 renderGlobal) {
        class_638 world = renderGlobal.getWorld();
        if (world == null) {
            return;
        }
        Iterable<class_1297> entities = world.method_18112();
        for (class_1297 entity : entities) {
            DynamicLight dynamicLight;
            int key;
            int lightLevel = DynamicLights.getLightLevel(entity);
            if (lightLevel > 0) {
                key = entity.method_5628();
                dynamicLight = mapDynamicLights.get(key);
                if (dynamicLight != null) continue;
                dynamicLight = new DynamicLight(entity);
                mapDynamicLights.put(key, dynamicLight);
                continue;
            }
            key = entity.method_5628();
            dynamicLight = mapDynamicLights.remove(key);
            if (dynamicLight == null) continue;
            dynamicLight.updateLitChunks(renderGlobal);
        }
    }

    public static int getCombinedLight(class_2338 pos, int combinedLight) {
        double lightPos = DynamicLights.getLightLevel(pos);
        combinedLight = DynamicLights.getCombinedLight(lightPos, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(class_1297 entity, int combinedLight) {
        double lightPos = DynamicLights.getLightLevel(entity.method_24515());
        if (entity == Config.getMinecraft().field_1724) {
            double lightOwn = DynamicLights.getLightLevel(entity);
            lightPos = Math.max(lightPos, lightOwn);
        }
        combinedLight = DynamicLights.getCombinedLight(lightPos, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(double lightPlayer, int combinedLight) {
        int lightBlockFF;
        int lightPlayerFF;
        if (lightPlayer > 0.0 && (lightPlayerFF = (int)(lightPlayer * 16.0)) > (lightBlockFF = combinedLight & 0xFF)) {
            combinedLight &= 0xFFFFFF00;
            combinedLight |= lightPlayerFF;
        }
        return combinedLight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getLightLevel(class_2338 pos) {
        double lightLevelMax = 0.0;
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            int dynamicLightsSize = dynamicLights.size();
            for (int i = 0; i < dynamicLightsSize; ++i) {
                double dist;
                double light;
                double lightLevel;
                double dz;
                double dy;
                DynamicLight dynamicLight = dynamicLights.get(i);
                int dynamicLightLevel = dynamicLight.getLastLightLevel();
                if (dynamicLightLevel <= 0) continue;
                double px = dynamicLight.getLastPosX();
                double py = dynamicLight.getLastPosY();
                double pz = dynamicLight.getLastPosZ();
                double dx = (double)pos.method_10263() - px;
                double distSq = dx * dx + (dy = (double)pos.method_10264() - py) * dy + (dz = (double)pos.method_10260() - pz) * dz;
                if (distSq > 56.25 || !((lightLevel = (light = 1.0 - (dist = Math.sqrt(distSq)) / 7.5) * (double)dynamicLightLevel) > lightLevelMax)) continue;
                lightLevelMax = lightLevel;
            }
        }
        double lightPlayer = Config.limit(lightLevelMax, 0.0, 15.0);
        return lightPlayer;
    }

    public static int getLightLevel(class_1799 itemStack) {
        Integer level;
        class_1747 itemBlock;
        class_2248 block;
        if (itemStack == null) {
            return 0;
        }
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1747 && (block = (itemBlock = (class_1747)item).method_7711()) != null) {
            if (block == class_2246.field_31037) {
                return 0;
            }
            if (block == class_2246.field_28411) {
                return 6;
            }
            if (block == class_2246.field_28675) {
                return 12;
            }
            return block.method_9564().method_26213();
        }
        if (item == class_1802.field_8187) {
            return class_2246.field_10164.method_9564().method_26213();
        }
        if (item == class_1802.field_8894 || item == class_1802.field_8183) {
            return 10;
        }
        if (item == class_1802.field_8601) {
            return 8;
        }
        if (item == class_1802.field_8434) {
            return 8;
        }
        if (item == class_1802.field_8135) {
            return 8;
        }
        if (item == class_1802.field_8137) {
            return class_2246.field_10327.method_9564().method_26213() / 2;
        }
        if (item == class_1802.field_28410) {
            return 8;
        }
        if (item == class_1802.field_28408) {
            return 8;
        }
        if (!mapItemLightLevels.isEmpty() && (level = mapItemLightLevels.get(item)) != null) {
            return level;
        }
        return 0;
    }

    public static int getLightLevel(class_1297 entity) {
        class_1548 entityCreeper;
        String typeName;
        Integer level;
        class_1309 player;
        if (entity == Config.getMinecraft().method_1560() && !Config.isDynamicHandLight()) {
            return 0;
        }
        if (entity instanceof class_1657 && ((class_1657)(player = (class_1657)entity)).method_7325()) {
            return 0;
        }
        if (entity.method_5809()) {
            return 15;
        }
        if (!mapEntityLightLevels.isEmpty() && (level = mapEntityLightLevels.get(typeName = EntityTypeNameLocator.getEntityTypeName(entity))) != null) {
            return level;
        }
        if (entity instanceof class_1668) {
            return 15;
        }
        if (entity instanceof class_1541) {
            return 15;
        }
        if (entity instanceof class_1545) {
            class_1545 entityBlaze = (class_1545)entity;
            if (entityBlaze.method_5809()) {
                return 15;
            }
            return 10;
        }
        if (entity instanceof class_1589) {
            class_1589 emc = (class_1589)entity;
            if ((double)emc.field_7388 > 0.6) {
                return 13;
            }
            return 8;
        }
        if (entity instanceof class_1548 && (double)(entityCreeper = (class_1548)entity).method_7003(0.0f) > 0.001) {
            return 15;
        }
        if (entity instanceof class_5776) {
            return 11;
        }
        if (entity instanceof class_5915) {
            return 8;
        }
        if (entity instanceof class_1309) {
            player = (class_1309)entity;
            class_1799 stackMain = player.method_6047();
            int levelMain = DynamicLights.getLightLevel(stackMain);
            class_1799 stackOff = player.method_6079();
            int levelOff = DynamicLights.getLightLevel(stackOff);
            class_1799 stackHead = player.method_6118(class_1304.field_6169);
            int levelHead = DynamicLights.getLightLevel(stackHead);
            int levelHandMax = Math.max(levelMain, levelOff);
            return Math.max(levelHandMax, levelHead);
        }
        if (entity instanceof class_1542) {
            class_1542 entityItem = (class_1542)entity;
            class_1799 itemStack = DynamicLights.getItemStack(entityItem);
            return DynamicLights.getLightLevel(itemStack);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLights(class_761 renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            for (int i = 0; i < dynamicLights.size(); ++i) {
                DynamicLight dynamicLight = dynamicLights.get(i);
                dynamicLight.updateLitChunks(renderGlobal);
            }
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            return mapDynamicLights.size();
        }
    }

    public static class_1799 getItemStack(class_1542 entityItem) {
        class_1799 itemstack = entityItem.method_5841().method_12789(PARAMETER_ITEM_STACK);
        return itemstack;
    }
}

