/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ClassInstanceMultiMap<T>
extends AbstractCollection<T> {
    private final Map<Class<?>, List<T>> f_13527_ = Maps.newHashMap();
    private final Class<T> f_13528_;
    private final List<T> f_13529_ = Lists.newArrayList();

    public ClassInstanceMultiMap(Class<T> baseClassIn) {
        this.f_13528_ = baseClassIn;
        this.f_13527_.put(baseClassIn, this.f_13529_);
    }

    @Override
    public boolean add(T p_add_1_) {
        boolean flag = false;
        for (Map.Entry<Class<?>, List<T>> entry : this.f_13527_.entrySet()) {
            if (!entry.getKey().isInstance(p_add_1_)) continue;
            flag |= entry.getValue().add(p_add_1_);
        }
        return flag;
    }

    @Override
    public boolean remove(Object p_remove_1_) {
        boolean flag = false;
        for (Map.Entry<Class<?>, List<T>> entry : this.f_13527_.entrySet()) {
            if (!entry.getKey().isInstance(p_remove_1_)) continue;
            List<T> list = entry.getValue();
            flag |= list.remove(p_remove_1_);
        }
        return flag;
    }

    @Override
    public boolean contains(Object p_contains_1_) {
        return this.m_13533_(p_contains_1_.getClass()).contains(p_contains_1_);
    }

    public <S> Collection<S> m_13533_(Class<S> p_13533_1_) {
        if (!this.f_13528_.isAssignableFrom(p_13533_1_)) {
            throw new IllegalArgumentException("Don't know how to search for " + p_13533_1_);
        }
        List list = this.f_13527_.computeIfAbsent(p_13533_1_, p_13537_1_ -> this.f_13529_.stream().filter(p_13537_1_::isInstance).collect(Collectors.toList()));
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public Iterator<T> iterator() {
        return this.f_13529_.isEmpty() ? Collections.emptyIterator() : Iterators.unmodifiableIterator(this.f_13529_.iterator());
    }

    public List<T> m_300848_() {
        return ImmutableList.copyOf(this.f_13529_);
    }

    @Override
    public int size() {
        return this.f_13529_.size();
    }

    public List<T> getValues() {
        return this.f_13529_;
    }
}

