/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.ChunkTracker;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.optifine.reflect.Reflector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DistanceManager {
    static final Logger f_140758_ = LogManager.getLogger();
    private static final int f_300333_ = 2;
    static final int f_140759_ = 33 + ChunkStatus.m_62370_((ChunkStatus)ChunkStatus.f_62326_) - 2;
    private static final int f_300334_ = 4;
    final Long2ObjectMap<ObjectSet<ServerPlayer>> f_140760_ = new Long2ObjectOpenHashMap();
    final Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> f_140761_ = new Long2ObjectOpenHashMap();
    private final ChunkTicketTracker f_140762_ = new ChunkTicketTracker();
    private final FixedPlayerDistanceChunkTracker f_140763_ = new FixedPlayerDistanceChunkTracker(8);
    private final PlayerTicketTracker f_140764_ = new PlayerTicketTracker(65);
    final Set<ChunkHolder> f_140765_ = Sets.newHashSet();
    final ChunkTaskPriorityQueueSorter f_140766_;
    final ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> f_140767_;
    final ProcessorHandle<ChunkTaskPriorityQueueSorter.Release> f_140768_;
    final LongSet f_140769_ = new LongOpenHashSet();
    final Executor f_140770_;
    private long f_140771_;
    private final Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> forcedTickets = new Long2ObjectOpenHashMap();

    protected DistanceManager(Executor p_i140773_1_, Executor p_i140773_2_) {
        ChunkTaskPriorityQueueSorter chunktaskpriorityqueuesorter;
        ProcessorHandle processorhandle = ProcessorHandle.m_18714_((String)"player ticket throttler", p_i140773_2_::execute);
        this.f_140766_ = chunktaskpriorityqueuesorter = new ChunkTaskPriorityQueueSorter((List)ImmutableList.of((Object)processorhandle), p_i140773_1_, 4);
        this.f_140767_ = chunktaskpriorityqueuesorter.m_140604_(processorhandle, true);
        this.f_140768_ = chunktaskpriorityqueuesorter.m_140567_(processorhandle);
        this.f_140770_ = p_i140773_2_;
    }

    protected void m_140776_() {
        ++this.f_140771_;
        ObjectIterator objectiterator = this.f_140761_.long2ObjectEntrySet().fastIterator();
        while (objectiterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectiterator.next();
            if (((SortedArraySet)entry.getValue()).removeIf(p_140821_1_ -> p_140821_1_.m_9434_(this.f_140771_))) {
                this.f_140762_.m_140715_(entry.getLongKey(), DistanceManager.m_140797_((SortedArraySet)entry.getValue()), false);
            }
            if (!((SortedArraySet)entry.getValue()).isEmpty()) continue;
            objectiterator.remove();
        }
    }

    private static int m_140797_(SortedArraySet<Ticket<?>> p_140797_0_) {
        return !p_140797_0_.isEmpty() ? ((Ticket)p_140797_0_.m_14262_()).m_9433_() : ChunkMap.f_140127_ + 1;
    }

    protected abstract boolean m_7009_(long var1);

    @Nullable
    protected abstract ChunkHolder m_7316_(long var1);

    @Nullable
    protected abstract ChunkHolder m_7288_(long var1, int var3, @Nullable ChunkHolder var4, int var5);

    public boolean m_140805_(ChunkMap chunkManagerIn) {
        boolean flag;
        this.f_140763_.m_6410_();
        this.f_140764_.m_6410_();
        int i = Integer.MAX_VALUE - this.f_140762_.m_140877_(Integer.MAX_VALUE);
        boolean bl = flag = i != 0;
        if (flag) {
            // empty if block
        }
        if (!this.f_140765_.isEmpty()) {
            this.f_140765_.forEach(p_140807_2_ -> p_140807_2_.m_142443_(chunkManagerIn, this.f_140770_));
            this.f_140765_.clear();
            return true;
        }
        if (!this.f_140769_.isEmpty()) {
            LongIterator longiterator = this.f_140769_.iterator();
            while (longiterator.hasNext()) {
                long j = longiterator.nextLong();
                if (!this.m_140857_(j).stream().anyMatch(p_140790_0_ -> p_140790_0_.m_9428_() == TicketType.f_9444_)) continue;
                ChunkHolder chunkholder = chunkManagerIn.m_140174_(j);
                if (chunkholder == null) {
                    throw new IllegalStateException();
                }
                CompletableFuture completablefuture = chunkholder.m_140073_();
                completablefuture.thenAccept(p_140787_3_ -> this.f_140770_.execute(() -> this.f_140768_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140628_(() -> {}, (long)j, (boolean)false))));
            }
            this.f_140769_.clear();
        }
        return flag;
    }

    void m_140784_(long chunkPosIn, Ticket<?> ticketIn) {
        SortedArraySet<Ticket<?>> sortedarrayset = this.m_140857_(chunkPosIn);
        int i = DistanceManager.m_140797_(sortedarrayset);
        Ticket ticket = (Ticket)sortedarrayset.m_14253_(ticketIn);
        ticket.m_9429_(this.f_140771_);
        if (ticketIn.m_9433_() < i) {
            this.f_140762_.m_140715_(chunkPosIn, ticketIn.m_9433_(), true);
        }
        if (Reflector.callBoolean(ticketIn, Reflector.ForgeTicket_isForceTicks, new Object[0])) {
            SortedArraySet tickets = (SortedArraySet)this.forcedTickets.computeIfAbsent(chunkPosIn, e -> SortedArraySet.m_14246_((int)4));
            tickets.m_14253_((Object)ticket);
        }
    }

    void m_140818_(long chunkPosIn, Ticket<?> ticketIn) {
        SortedArraySet tickets;
        SortedArraySet<Ticket<?>> sortedarrayset = this.m_140857_(chunkPosIn);
        if (sortedarrayset.remove(ticketIn)) {
            // empty if block
        }
        if (sortedarrayset.isEmpty()) {
            this.f_140761_.remove(chunkPosIn);
        }
        this.f_140762_.m_140715_(chunkPosIn, DistanceManager.m_140797_(sortedarrayset), false);
        if (Reflector.callBoolean(ticketIn, Reflector.ForgeTicket_isForceTicks, new Object[0]) && (tickets = (SortedArraySet)this.forcedTickets.get(chunkPosIn)) != null) {
            tickets.remove(ticketIn);
        }
    }

    public <T> void m_140792_(TicketType<T> type, ChunkPos pos, int level, T value) {
        this.m_140784_(pos.m_45588_(), new Ticket(type, level, value));
    }

    public <T> void m_140823_(TicketType<T> type, ChunkPos pos, int level, T value) {
        Ticket ticket = new Ticket(type, level, value);
        this.m_140818_(pos.m_45588_(), ticket);
    }

    public <T> void m_140840_(TicketType<T> type, ChunkPos pos, int distance, T value) {
        this.m_140784_(pos.m_45588_(), new Ticket(type, 33 - distance, value));
    }

    public <T> void m_140849_(TicketType<T> type, ChunkPos pos, int distance, T value) {
        Ticket ticket = new Ticket(type, 33 - distance, value);
        this.m_140818_(pos.m_45588_(), ticket);
    }

    private SortedArraySet<Ticket<?>> m_140857_(long p_140857_1_) {
        return (SortedArraySet)this.f_140761_.computeIfAbsent(p_140857_1_, p_140866_0_ -> SortedArraySet.m_14246_((int)4));
    }

    protected void m_140799_(ChunkPos pos, boolean add) {
        Ticket ticket = new Ticket(TicketType.f_9445_, 31, (Object)pos);
        if (add) {
            this.m_140784_(pos.m_45588_(), ticket);
        } else {
            this.m_140818_(pos.m_45588_(), ticket);
        }
    }

    public void m_140802_(SectionPos sectionPosIn, ServerPlayer player) {
        long i = sectionPosIn.m_123251_().m_45588_();
        ((ObjectSet)this.f_140760_.computeIfAbsent(i, p_140862_0_ -> new ObjectOpenHashSet())).add((Object)player);
        this.f_140763_.m_140715_(i, 0, true);
        this.f_140764_.m_140715_(i, 0, true);
    }

    public void m_140828_(SectionPos sectionPosIn, ServerPlayer player) {
        long i = sectionPosIn.m_123251_().m_45588_();
        ObjectSet objectset = (ObjectSet)this.f_140760_.get(i);
        objectset.remove((Object)player);
        if (objectset.isEmpty()) {
            this.f_140760_.remove(i);
            this.f_140763_.m_140715_(i, Integer.MAX_VALUE, false);
            this.f_140764_.m_140715_(i, Integer.MAX_VALUE, false);
        }
    }

    protected String m_140838_(long p_140838_1_) {
        SortedArraySet sortedarrayset = (SortedArraySet)this.f_140761_.get(p_140838_1_);
        String s = sortedarrayset != null && !sortedarrayset.isEmpty() ? ((Ticket)sortedarrayset.m_14262_()).toString() : "no_ticket";
        return s;
    }

    protected void m_140777_(int viewDistance) {
        this.f_140764_.m_140912_(viewDistance);
    }

    public int m_140816_() {
        this.f_140763_.m_6410_();
        return this.f_140763_.f_140886_.size();
    }

    public boolean m_140847_(long chunkPosIn) {
        this.f_140763_.m_6410_();
        return this.f_140763_.f_140886_.containsKey(chunkPosIn);
    }

    public String m_140837_() {
        return this.f_140766_.m_140558_();
    }

    private void m_300335_(String fileNameIn) {
        try (FileOutputStream fileoutputstream = new FileOutputStream(new File(fileNameIn));){
            for (Long2ObjectMap.Entry entry : this.f_140761_.long2ObjectEntrySet()) {
                ChunkPos chunkpos = new ChunkPos(entry.getLongKey());
                for (Ticket ticket : (SortedArraySet)entry.getValue()) {
                    fileoutputstream.write((chunkpos.f_45578_ + "\t" + chunkpos.f_45579_ + "\t" + ticket.m_9428_() + "\t" + ticket.m_9433_() + "\t\n").getBytes(StandardCharsets.UTF_8));
                }
            }
        }
        catch (IOException ioexception) {
            f_140758_.error((Object)ioexception);
        }
    }

    public <T> void registerTicking(TicketType<T> type, ChunkPos pos, int distance, T value) {
        Ticket ticket = (Ticket)Reflector.ForgeTicket_Constructor.newInstance(type, 33 - distance, value, true);
        this.m_140784_(pos.m_45588_(), ticket);
    }

    public <T> void releaseTicking(TicketType<T> type, ChunkPos pos, int distance, T value) {
        Ticket ticket = (Ticket)Reflector.ForgeTicket_Constructor.newInstance(type, 33 - distance, value, true);
        this.m_140818_(pos.m_45588_(), ticket);
    }

    public boolean shouldForceTicks(long chunkPos) {
        SortedArraySet tickets = (SortedArraySet)this.forcedTickets.get(chunkPos);
        return tickets != null && !tickets.isEmpty();
    }

    class PlayerTicketTracker
    extends FixedPlayerDistanceChunkTracker {
        private int f_140905_;
        private final Long2IntMap f_140906_;
        private final LongSet f_140907_;

        protected PlayerTicketTracker(int p_i140908_2_) {
            super(p_i140908_2_);
            this.f_140906_ = Long2IntMaps.synchronize((Long2IntMap)new Long2IntOpenHashMap());
            this.f_140907_ = new LongOpenHashSet();
            this.f_140905_ = 0;
            this.f_140906_.defaultReturnValue(p_i140908_2_ + 2);
        }

        @Override
        protected void m_8002_(long chunkPosIn, int oldLevel, int newLevel) {
            this.f_140907_.add(chunkPosIn);
        }

        public void m_140912_(int viewDistanceIn) {
            for (Long2ByteMap.Entry entry : this.f_140886_.long2ByteEntrySet()) {
                byte b0 = entry.getByteValue();
                long i = entry.getLongKey();
                this.m_140918_(i, b0, this.m_140932_(b0), b0 <= viewDistanceIn - 2);
            }
            this.f_140905_ = viewDistanceIn;
        }

        private void m_140918_(long chunkPosIn, int p_140918_3_, boolean p_140918_4_, boolean p_140918_5_) {
            if (p_140918_4_ != p_140918_5_) {
                Ticket ticket = new Ticket(TicketType.f_9444_, f_140759_, (Object)new ChunkPos(chunkPosIn));
                if (p_140918_5_) {
                    DistanceManager.this.f_140767_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140624_(() -> DistanceManager.this.f_140770_.execute(() -> {
                        if (this.m_140932_(this.m_6172_(chunkPosIn))) {
                            DistanceManager.this.m_140784_(chunkPosIn, ticket);
                            DistanceManager.this.f_140769_.add(chunkPosIn);
                        } else {
                            DistanceManager.this.f_140768_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140628_(() -> {}, (long)chunkPosIn, (boolean)false));
                        }
                    }), (long)chunkPosIn, () -> p_140918_3_));
                } else {
                    DistanceManager.this.f_140768_.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140628_(() -> DistanceManager.this.f_140770_.execute(() -> DistanceManager.this.m_140818_(chunkPosIn, ticket)), (long)chunkPosIn, (boolean)true));
                }
            }
        }

        @Override
        public void m_6410_() {
            super.m_6410_();
            if (!this.f_140907_.isEmpty()) {
                LongIterator longiterator = this.f_140907_.iterator();
                while (longiterator.hasNext()) {
                    int k;
                    long i = longiterator.nextLong();
                    int j = this.f_140906_.get(i);
                    if (j == (k = this.m_6172_(i))) continue;
                    DistanceManager.this.f_140766_.m_6250_(new ChunkPos(i), () -> this.f_140906_.get(i), k, p_140926_3_ -> {
                        if (p_140926_3_ >= this.f_140906_.defaultReturnValue()) {
                            this.f_140906_.remove(i);
                        } else {
                            this.f_140906_.put(i, p_140926_3_);
                        }
                    });
                    this.m_140918_(i, k, this.m_140932_(j), this.m_140932_(k));
                }
                this.f_140907_.clear();
            }
        }

        private boolean m_140932_(int p_140932_1_) {
            return p_140932_1_ <= this.f_140905_ - 2;
        }
    }

    class FixedPlayerDistanceChunkTracker
    extends ChunkTracker {
        protected final Long2ByteMap f_140886_;
        protected final int f_140887_;

        protected FixedPlayerDistanceChunkTracker(int levelCountIn) {
            super(levelCountIn + 2, 2048, 2048);
            this.f_140886_ = new Long2ByteOpenHashMap();
            this.f_140887_ = levelCountIn;
            this.f_140886_.defaultReturnValue((byte)(levelCountIn + 2));
        }

        protected int m_6172_(long sectionPosIn) {
            return this.f_140886_.get(sectionPosIn);
        }

        protected void m_7351_(long sectionPosIn, int level) {
            byte b0 = level > this.f_140887_ ? this.f_140886_.remove(sectionPosIn) : this.f_140886_.put(sectionPosIn, (byte)level);
            this.m_8002_(sectionPosIn, b0, level);
        }

        protected void m_8002_(long chunkPosIn, int oldLevel, int newLevel) {
        }

        protected int m_7031_(long pos) {
            return this.m_140902_(pos) ? 0 : Integer.MAX_VALUE;
        }

        private boolean m_140902_(long chunkPosIn) {
            ObjectSet objectset = (ObjectSet)DistanceManager.this.f_140760_.get(chunkPosIn);
            return objectset != null && !objectset.isEmpty();
        }

        public void m_6410_() {
            this.m_75588_(Integer.MAX_VALUE);
        }

        private void m_300340_(String fileNameIn) {
            try (FileOutputStream fileoutputstream = new FileOutputStream(new File(fileNameIn));){
                for (Long2ByteMap.Entry entry : this.f_140886_.long2ByteEntrySet()) {
                    ChunkPos chunkpos = new ChunkPos(entry.getLongKey());
                    String s = Byte.toString(entry.getByteValue());
                    fileoutputstream.write((chunkpos.f_45578_ + "\t" + chunkpos.f_45579_ + "\t" + s + "\n").getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException ioexception) {
                f_140758_.error((Object)ioexception);
            }
        }
    }

    class ChunkTicketTracker
    extends ChunkTracker {
        public ChunkTicketTracker() {
            super(ChunkMap.f_140127_ + 2, 256, 256);
        }

        protected int m_7031_(long pos) {
            SortedArraySet sortedarrayset = (SortedArraySet)DistanceManager.this.f_140761_.get(pos);
            if (sortedarrayset == null) {
                return Integer.MAX_VALUE;
            }
            return sortedarrayset.isEmpty() ? Integer.MAX_VALUE : ((Ticket)sortedarrayset.m_14262_()).m_9433_();
        }

        protected int m_6172_(long sectionPosIn) {
            ChunkHolder chunkholder;
            if (!DistanceManager.this.m_7009_(sectionPosIn) && (chunkholder = DistanceManager.this.m_7316_(sectionPosIn)) != null) {
                return chunkholder.m_140093_();
            }
            return ChunkMap.f_140127_ + 1;
        }

        protected void m_7351_(long sectionPosIn, int level) {
            int i;
            ChunkHolder chunkholder = DistanceManager.this.m_7316_(sectionPosIn);
            int n = i = chunkholder == null ? ChunkMap.f_140127_ + 1 : chunkholder.m_140093_();
            if (i != level && (chunkholder = DistanceManager.this.m_7288_(sectionPosIn, level, chunkholder, i)) != null) {
                DistanceManager.this.f_140765_.add(chunkholder);
            }
        }

        public int m_140877_(int toUpdateCount) {
            return this.m_75588_(toUpdateCount);
        }
    }
}

