/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.class_1267;
import net.minecraft.class_1276;
import net.minecraft.class_1279;
import net.minecraft.class_128;
import net.minecraft.class_1419;
import net.minecraft.class_148;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1863;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1932;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_1940;
import net.minecraft.class_1966;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_26;
import net.minecraft.class_2632;
import net.minecraft.class_27;
import net.minecraft.class_2761;
import net.minecraft.class_2780;
import net.minecraft.class_2784;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_29;
import net.minecraft.class_2902;
import net.minecraft.class_2910;
import net.minecraft.class_2926;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_2989;
import net.minecraft.class_2991;
import net.minecraft.class_2995;
import net.minecraft.class_3004;
import net.minecraft.class_32;
import net.minecraft.class_3201;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3230;
import net.minecraft.class_3242;
import net.minecraft.class_3262;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_3300;
import net.minecraft.class_3312;
import net.minecraft.class_3324;
import net.minecraft.class_3327;
import net.minecraft.class_3337;
import net.minecraft.class_3481;
import net.minecraft.class_3485;
import net.minecraft.class_3515;
import net.minecraft.class_3517;
import net.minecraft.class_3532;
import net.minecraft.class_3534;
import net.minecraft.class_3536;
import net.minecraft.class_3688;
import net.minecraft.class_3695;
import net.minecraft.class_3696;
import net.minecraft.class_3738;
import net.minecraft.class_3769;
import net.minecraft.class_3902;
import net.minecraft.class_3949;
import net.minecraft.class_3950;
import net.minecraft.class_3990;
import net.minecraft.class_4093;
import net.minecraft.class_4274;
import net.minecraft.class_4521;
import net.minecraft.class_4543;
import net.minecraft.class_4565;
import net.minecraft.class_4567;
import net.minecraft.class_4758;
import net.minecraft.class_5217;
import net.minecraft.class_5218;
import net.minecraft.class_5219;
import net.minecraft.class_5268;
import net.minecraft.class_5285;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5322;
import net.minecraft.class_5350;
import net.minecraft.class_5359;
import net.minecraft.class_5363;
import net.minecraft.class_5415;
import net.minecraft.class_5455;
import net.minecraft.class_5464;
import net.minecraft.class_5513;
import net.minecraft.class_5525;
import net.minecraft.class_5640;
import net.minecraft.class_5961;
import net.minecraft.class_5962;
import net.minecraft.class_5963;
import net.minecraft.class_5971;
import net.minecraft.class_60;
import net.minecraft.class_6396;
import net.minecraft.class_6402;
import net.minecraft.obfuscate.DontObfuscate;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
extends class_4093<class_3738>
implements class_1279,
class_2165,
AutoCloseable {
    static final Logger field_4546 = LogManager.getLogger();
    private static final float field_33212 = 0.8f;
    private static final int field_33213 = 100;
    public static final int field_33206 = 50;
    private static final int field_33214 = 6000;
    private static final int field_33215 = 2000;
    private static final int field_33216 = 15000;
    public static final String field_33207 = "level";
    public static final String field_33208 = "level://";
    private static final long field_33217 = 5000000000L;
    private static final int field_33218 = 12;
    public static final String field_33209 = "resources.zip";
    public static final File field_4588 = new File("usercache.json");
    public static final int field_33210 = 11;
    private static final int field_33219 = 441;
    private static final int field_33220 = 6000;
    private static final int field_33221 = 3;
    public static final int field_33211 = 29999984;
    public static final class_1940 field_17704 = new class_1940("Demo World", class_1934.field_9215, false, class_1267.field_5802, false, new class_1928(), class_5359.field_25393);
    private static final long field_33205 = 50L;
    protected final class_32.class_5143 field_23784;
    protected final class_29 field_24371;
    private final class_1276 field_4582 = new class_1276("server", this, class_156.method_658());
    private final List<Runnable> field_4568 = Lists.newArrayList();
    private class_5962 field_22250 = class_5963.field_29594;
    private class_3695 field_16258 = this.field_22250.method_34774();
    private Consumer<class_3696> field_33975 = class_36962 -> this.method_37322();
    private Consumer<Path> field_33976 = path -> {};
    private boolean field_33977;
    @Nullable
    private class_6414 field_33978;
    private boolean field_33979;
    private final class_3242 field_4563;
    private final class_3950 field_17439;
    private final class_2926 field_4593 = new class_2926();
    private final Random field_4602 = new Random();
    private final DataFixer field_4587;
    private String field_4585;
    private int field_4555 = -1;
    protected final class_5455.class_5457 field_25132;
    private final Map<class_5321<class_1937>, class_3218> field_4589 = Maps.newLinkedHashMap();
    private class_3324 field_4550;
    private volatile boolean field_4544 = true;
    private boolean field_4561;
    private int field_4572;
    protected final Proxy field_4599;
    private boolean field_4543;
    private boolean field_4560;
    private boolean field_4604;
    private boolean field_4554;
    @Nullable
    private String field_4564;
    private int field_4596;
    public final long[] field_4573 = new long[100];
    @Nullable
    private KeyPair field_4552;
    @Nullable
    private String field_4578;
    private boolean field_4549;
    private String field_4607 = "";
    private String field_4584 = "";
    private volatile boolean field_4547;
    private long field_4557;
    private final MinecraftSessionService field_4603;
    @Nullable
    private final GameProfileRepository field_4608;
    @Nullable
    private final class_3312 field_4556;
    private long field_4551;
    private final Thread field_16257;
    private long field_4571 = class_156.method_658();
    private long field_19248;
    private boolean field_19249;
    private final class_3283 field_4595;
    private final class_2995 field_4558 = new class_2995(this);
    @Nullable
    private class_4565 field_20850;
    private final class_3004 field_4548 = new class_3004();
    private final class_2991 field_4591;
    private final class_3517 field_16205 = new class_3517();
    private boolean field_4570;
    private float field_4592;
    private final Executor field_17200;
    @Nullable
    private String field_17601;
    private class_5350 field_25318;
    private final class_3485 field_24370;
    protected final class_5219 field_24372;

    public static <S extends MinecraftServer> S method_29740(Function<Thread, S> function) {
        AtomicReference<MinecraftServer> atomicReference = new AtomicReference<MinecraftServer>();
        Thread \u00e2\u02dc\u01922 = new Thread(() -> ((MinecraftServer)atomicReference.get()).method_29741(), "Server thread");
        \u00e2\u02dc\u01922.setUncaughtExceptionHandler((thread, throwable) -> field_4546.error((Object)throwable));
        MinecraftServer \u00e2\u02dc\u01923 = (MinecraftServer)function.apply(\u00e2\u02dc\u01922);
        atomicReference.set(\u00e2\u02dc\u01923);
        \u00e2\u02dc\u01922.start();
        return (S)\u00e2\u02dc\u01923;
    }

    public MinecraftServer(Thread thread, class_5455.class_5457 class_54572, class_32.class_5143 class_51432, class_5219 class_52192, class_3283 class_32832, Proxy proxy, DataFixer dataFixer, class_5350 class_53502, @Nullable MinecraftSessionService minecraftSessionService, @Nullable GameProfileRepository gameProfileRepository, @Nullable class_3312 class_33122, class_3950 class_39502) {
        super("Server");
        this.field_25132 = class_54572;
        this.field_24372 = class_52192;
        this.field_4599 = proxy;
        this.field_4595 = class_32832;
        this.field_25318 = class_53502;
        this.field_4603 = minecraftSessionService;
        this.field_4608 = gameProfileRepository;
        this.field_4556 = class_33122;
        if (class_33122 != null) {
            class_33122.method_37157(this);
        }
        this.field_4563 = new class_3242(this);
        this.field_17439 = class_39502;
        this.field_23784 = class_51432;
        this.field_24371 = class_51432.method_27427();
        this.field_4587 = dataFixer;
        this.field_4591 = new class_2991(this, class_53502.method_29465());
        this.field_24370 = new class_3485(class_53502.method_29474(), class_51432, dataFixer);
        this.field_16257 = thread;
        this.field_17200 = class_156.method_18349();
    }

    private void method_17976(class_26 class_264) {
        class_264.method_17924(this.method_3845()::method_32704, this.method_3845()::method_32705, "scoreboard");
    }

    protected abstract boolean method_3823() throws IOException;

    public static void method_27725(class_32.class_5143 class_51432) {
        if (class_51432.method_27012()) {
            field_4546.info("Converting map!");
            class_51432.method_27006(new class_3536(){
                private long field_4609 = class_156.method_658();

                @Override
                public void method_15412(class_2561 class_25612) {
                }

                @Override
                public void method_15413(class_2561 class_25612) {
                }

                @Override
                public void method_15410(int n) {
                    if (class_156.method_658() - this.field_4609 >= 1000L) {
                        this.field_4609 = class_156.method_658();
                        field_4546.info("Converting... {}%", (Object)n);
                    }
                }

                @Override
                public void method_15411() {
                }

                @Override
                public void method_15414(class_2561 class_25612) {
                }
            });
        }
    }

    protected void method_3735() {
        this.method_3861();
        this.field_24372.method_24285(this.getServerModName(), this.method_24307().isPresent());
        class_3949 class_39492 = this.field_17439.create(11);
        this.method_3786(class_39492);
        this.method_27731();
        this.method_3774(class_39492);
    }

    protected void method_27731() {
    }

    protected void method_3786(class_3949 class_39492) {
        class_2794 \u00e2\u02dc\u01929;
        class_5268 class_52682 = this.field_24372.method_27859();
        class_5285 \u00e2\u02dc\u01922 = this.field_24372.method_28057();
        boolean \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.method_28033();
        long \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922.method_28028();
        long \u00e2\u02dc\u01925 = class_4543.method_27984(\u00e2\u02dc\u01924);
        ImmutableList \u00e2\u02dc\u01926 = ImmutableList.of((Object)new class_2910(), (Object)new class_3769(), (Object)new class_4274(), (Object)new class_1419(), (Object)new class_3990(class_52682));
        class_2370<class_5363> \u00e2\u02dc\u01927 = \u00e2\u02dc\u01922.method_28609();
        class_5363 \u00e2\u02dc\u01928 = \u00e2\u02dc\u01927.method_29107(class_5363.field_25412);
        if (\u00e2\u02dc\u01928 == null) {
            class_2874 class_28742 = this.field_25132.method_30530(class_2378.field_25095).method_31140(class_2874.field_24753);
            \u00e2\u02dc\u01929 = class_5285.method_28604(this.field_25132.method_30530(class_2378.field_25114), this.field_25132.method_30530(class_2378.field_26374), new Random().nextLong());
        } else {
            class_28742 = \u00e2\u02dc\u01928.method_29570();
            \u00e2\u02dc\u01929 = \u00e2\u02dc\u01928.method_29571();
        }
        class_3218 class_32182 = new class_3218(this, this.field_17200, this.field_23784, class_52682, class_1937.field_25179, class_28742, class_39492, \u00e2\u02dc\u01929, \u00e2\u02dc\u01923, \u00e2\u02dc\u01925, (List<class_5304>)\u00e2\u02dc\u01926, true);
        this.field_4589.put(class_1937.field_25179, class_32182);
        class_26 \u00e2\u02dc\u019210 = class_32182.method_17983();
        this.method_17976(\u00e2\u02dc\u019210);
        this.field_20850 = new class_4565(\u00e2\u02dc\u019210);
        class_2784 \u00e2\u02dc\u019211 = class_32182.method_8621();
        \u00e2\u02dc\u019211.method_17905(class_52682.method_27422());
        if (!class_52682.method_222()) {
            try {
                MinecraftServer.method_27901(class_32182, class_52682, \u00e2\u02dc\u01922.method_28030(), \u00e2\u02dc\u01923);
                class_52682.method_223(true);
                if (\u00e2\u02dc\u01923) {
                    this.method_17977(this.field_24372);
                }
            }
            catch (Throwable throwable) {
                class_128 class_12810 = class_128.method_560(throwable, "Exception initializing level");
                try {
                    class_32182.method_8538(class_12810);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new class_148(class_12810);
            }
            class_52682.method_223(true);
        }
        this.method_3760().method_14591(class_32182);
        if (this.field_24372.method_228() != null) {
            this.method_3837().method_12972(this.field_24372.method_228());
        }
        for (Map.Entry<class_5321<class_5363>, class_5363> entry : \u00e2\u02dc\u01927.method_29722()) {
            class_5321<class_5363> class_53212 = entry.getKey();
            if (class_53212 == class_5363.field_25412) continue;
            class_5321<class_1937> \u00e2\u02dc\u019212 = class_5321.method_29179(class_2378.field_25298, class_53212.method_29177());
            class_2874 \u00e2\u02dc\u019213 = entry.getValue().method_29570();
            class_2794 \u00e2\u02dc\u019214 = entry.getValue().method_29571();
            class_27 \u00e2\u02dc\u019215 = new class_27(this.field_24372, class_52682);
            class_3218 \u00e2\u02dc\u019216 = new class_3218(this, this.field_17200, this.field_23784, \u00e2\u02dc\u019215, \u00e2\u02dc\u019212, \u00e2\u02dc\u019213, class_39492, \u00e2\u02dc\u019214, \u00e2\u02dc\u01923, \u00e2\u02dc\u01925, (List<class_5304>)ImmutableList.of(), false);
            \u00e2\u02dc\u019211.method_11983(new class_2780.class_3976(\u00e2\u02dc\u019216.method_8621()));
            this.field_4589.put(\u00e2\u02dc\u019212, \u00e2\u02dc\u019216);
        }
    }

    private static void method_27901(class_3218 class_32182, class_5268 class_526822, boolean bl3, boolean bl2) {
        boolean bl3;
        class_5268 class_526822;
        int \u00e2\u02dc\u01926;
        if (bl2) {
            class_526822.method_187(class_2338.field_10980.method_10086(80), 0.0f);
            return;
        }
        class_2794 class_27942 = class_32182.method_14178().method_12129();
        class_1966 \u00e2\u02dc\u01922 = class_27942.method_12098();
        Random \u00e2\u02dc\u01923 = new Random(class_32182.method_8412());
        class_2338 \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922.method_8762(0, class_32182.method_8615(), 0, 256, class_19592 -> class_19592.method_30966().method_31082(), \u00e2\u02dc\u01923);
        class_1923 class_19232 = \u00e2\u02dc\u0192 = \u00e2\u02dc\u01924 == null ? new class_1923(0, 0) : new class_1923(\u00e2\u02dc\u01924);
        if (\u00e2\u02dc\u01924 == null) {
            field_4546.warn("Unable to find spawn biome");
        }
        boolean \u00e2\u02dc\u01925 = false;
        for (Object object : class_3481.field_15478.method_15138()) {
            if (!\u00e2\u02dc\u01922.method_8761().contains(((class_2248)object).method_9564())) continue;
            \u00e2\u02dc\u01925 = true;
            break;
        }
        if ((\u00e2\u02dc\u01926 = class_27942.method_12100(class_32182)) < class_32182.method_31607()) {
            Object object;
            object = \u00e2\u02dc\u0192.method_8323();
            \u00e2\u02dc\u01926 = class_32182.method_8624(class_2902.class_2903.field_13202, ((class_2382)object).method_10263() + 8, ((class_2382)object).method_10260() + 8);
        }
        class_526822.method_187(\u00e2\u02dc\u0192.method_8323().method_10069(8, \u00e2\u02dc\u01926, 8), 0.0f);
        int \u00e2\u02dc\u01927 = 0;
        int \u00e2\u02dc\u01928 = 0;
        int \u00e2\u02dc\u01929 = 0;
        int \u00e2\u02dc\u019210 = -1;
        int \u00e2\u02dc\u019211 = 32;
        for (int i = 0; i < 1024; ++i) {
            if (\u00e2\u02dc\u01927 > -16 && \u00e2\u02dc\u01927 <= 16 && \u00e2\u02dc\u01928 > -16 && \u00e2\u02dc\u01928 <= 16 && (\u00e2\u02dc\u0192 = class_5322.method_29196(class_32182, new class_1923(\u00e2\u02dc\u0192.field_9181 + \u00e2\u02dc\u01927, \u00e2\u02dc\u0192.field_9180 + \u00e2\u02dc\u01928), \u00e2\u02dc\u01925)) != null) {
                class_526822.method_187(\u00e2\u02dc\u0192, 0.0f);
                break;
            }
            if (\u00e2\u02dc\u01927 == \u00e2\u02dc\u01928 || \u00e2\u02dc\u01927 < 0 && \u00e2\u02dc\u01927 == -\u00e2\u02dc\u01928 || \u00e2\u02dc\u01927 > 0 && \u00e2\u02dc\u01927 == 1 - \u00e2\u02dc\u01928) {
                \u00e2\u02dc\u0192 = \u00e2\u02dc\u01929;
                \u00e2\u02dc\u01929 = -\u00e2\u02dc\u019210;
                \u00e2\u02dc\u019210 = \u00e2\u02dc\u0192;
            }
            \u00e2\u02dc\u01927 += \u00e2\u02dc\u01929;
            \u00e2\u02dc\u01928 += \u00e2\u02dc\u019210;
        }
        if (bl3) {
            class_2975<?, ?> class_29752 = class_5464.field_25970;
            class_29752.method_12862(class_32182, class_27942, class_32182.field_9229, new class_2338(class_526822.method_215(), class_526822.method_144(), class_526822.method_166()));
        }
    }

    private void method_17977(class_5219 class_52192) {
        class_52192.method_208(class_1267.field_5801);
        class_52192.method_186(true);
        class_5268 class_52682 = class_52192.method_27859();
        class_52682.method_157(false);
        class_52682.method_147(false);
        class_52682.method_167(1000000000);
        class_52682.method_29035(6000L);
        class_52682.method_193(class_1934.field_9219);
    }

    private void method_3774(class_3949 class_39492) {
        class_3218 class_32182 = this.method_30002();
        field_4546.info("Preparing start region for dimension {}", (Object)class_32182.method_27983().method_29177());
        class_2338 \u00e2\u02dc\u01922 = class_32182.method_27911();
        class_39492.method_17669(new class_1923(\u00e2\u02dc\u01922));
        class_3215 \u00e2\u02dc\u01923 = class_32182.method_14178();
        \u00e2\u02dc\u01923.method_17293().method_17304(500);
        this.field_4571 = class_156.method_658();
        \u00e2\u02dc\u01923.method_17297(class_3230.field_14030, new class_1923(\u00e2\u02dc\u01922), 11, class_3902.field_17274);
        while (\u00e2\u02dc\u01923.method_17301() != 441) {
            this.field_4571 = class_156.method_658() + 10L;
            this.method_16208();
        }
        this.field_4571 = class_156.method_658() + 10L;
        this.method_16208();
        for (class_3218 class_32183 : this.field_4589.values()) {
            class_1932 class_19322 = class_32183.method_17983().method_20786(class_1932::method_32350, "chunks");
            if (class_19322 == null) continue;
            LongIterator \u00e2\u02dc\u01924 = class_19322.method_8375().iterator();
            while (\u00e2\u02dc\u01924.hasNext()) {
                long l = \u00e2\u02dc\u01924.nextLong();
                class_1923 \u00e2\u02dc\u01925 = new class_1923(l);
                class_32183.method_14178().method_12124(\u00e2\u02dc\u01925, true);
            }
        }
        this.field_4571 = class_156.method_658() + 10L;
        this.method_16208();
        class_39492.method_17671();
        \u00e2\u02dc\u01923.method_17293().method_17304(5);
        this.method_27729();
    }

    protected void method_3861() {
        File file = this.field_23784.method_27010(class_5218.field_24187).toFile();
        if (file.isFile()) {
            String string = this.field_23784.method_27005();
            try {
                this.method_3843(field_33208 + URLEncoder.encode(string, StandardCharsets.UTF_8.toString()) + "/resources.zip", "");
            }
            catch (UnsupportedEncodingException \u00e2\u02dc\u01922) {
                field_4546.warn("Something went wrong url encoding {}", (Object)string);
            }
        }
    }

    public class_1934 method_3790() {
        return this.field_24372.method_210();
    }

    public boolean method_3754() {
        return this.field_24372.method_152();
    }

    public abstract int method_3798();

    public abstract int method_21714();

    public abstract boolean method_3732();

    public boolean method_3723(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        for (class_3218 class_32182 : this.method_3738()) {
            if (!bl) {
                field_4546.info("Saving chunks for level '{}'/{}", (Object)class_32182, (Object)class_32182.method_27983().method_29177());
            }
            class_32182.method_14176(null, bl2, class_32182.field_13957 && !bl3);
            bl4 = true;
        }
        class_3218 class_32182 = this.method_30002();
        class_5268 class_52682 = this.field_24372.method_27859();
        class_52682.method_27415(class_32182.method_8621().method_27355());
        this.field_24372.method_221(this.method_3837().method_12974());
        this.field_23784.method_27426(this.field_25132, this.field_24372, this.method_3760().method_14567());
        if (bl2) {
            for (class_3218 class_32183 : this.method_3738()) {
                field_4546.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)class_32183.method_14178().field_17254.method_37476());
            }
            field_4546.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return bl4;
    }

    @Override
    public void close() {
        this.method_3782();
    }

    public void method_3782() {
        field_4546.info("Stopping server");
        if (this.method_3787() != null) {
            this.method_3787().method_14356();
        }
        if (this.field_4550 != null) {
            field_4546.info("Saving players");
            this.field_4550.method_14617();
            this.field_4550.method_14597();
        }
        field_4546.info("Saving worlds");
        for (class_3218 class_32182 : this.method_3738()) {
            if (class_32182 == null) continue;
            class_32182.field_13957 = false;
        }
        this.method_3723(false, true, false);
        for (class_3218 class_32182 : this.method_3738()) {
            if (class_32182 == null) continue;
            try {
                class_32182.close();
            }
            catch (IOException iOException) {
                field_4546.error("Exception closing the level", (Throwable)iOException);
            }
        }
        if (this.field_4582.method_5483()) {
            this.field_4582.method_5487();
        }
        this.field_25318.close();
        try {
            this.field_23784.close();
        }
        catch (IOException iOException) {
            field_4546.error("Failed to unlock level {}", (Object)this.field_23784.method_27005(), (Object)iOException);
        }
    }

    public String method_3819() {
        return this.field_4585;
    }

    public void method_3842(String string) {
        this.field_4585 = string;
    }

    public boolean method_3806() {
        return this.field_4544;
    }

    public void method_3747(boolean bl) {
        this.field_4544 = false;
        if (bl) {
            try {
                this.field_16257.join();
            }
            catch (InterruptedException interruptedException) {
                field_4546.error("Error while shutting down", (Throwable)interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void method_29741() {
        try {
            if (this.method_3823()) {
                this.field_4571 = class_156.method_658();
                this.field_4593.method_12684(new class_2585(this.field_4564));
                this.field_4593.method_12679(new class_2926.class_2930(class_155.method_16673().getName(), class_155.method_16673().getProtocolVersion()));
                this.method_3791(this.field_4593);
                while (this.field_4544) {
                    long l = class_156.method_658() - this.field_4571;
                    if (l > 2000L && this.field_4571 - this.field_4557 >= 15000L) {
                        \u00e2\u02dc\u0192 = l / 50L;
                        field_4546.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)l, (Object)\u00e2\u02dc\u0192);
                        this.field_4571 += \u00e2\u02dc\u0192 * 50L;
                        this.field_4557 = this.field_4571;
                    }
                    if (this.field_33979) {
                        this.field_33979 = false;
                        this.field_33978 = new class_6414(class_156.method_648(), this.field_4572);
                    }
                    this.field_4571 += 50L;
                    this.method_24487();
                    this.field_16258.method_15396("tick");
                    this.method_3748(this::method_3866);
                    this.field_16258.method_15405("nextTickWait");
                    this.field_19249 = true;
                    this.field_19248 = Math.max(class_156.method_658() + 50L, this.field_4571);
                    this.method_16208();
                    this.field_16258.method_15407();
                    this.method_24490();
                    this.field_4547 = true;
                }
            } else {
                this.method_3744(null);
            }
        }
        catch (Throwable throwable) {
            field_4546.error("Encountered an unexpected exception", throwable);
            class_128 class_12810 = throwable instanceof class_148 ? ((class_148)throwable).method_631() : new class_128("Exception in server tick loop", throwable);
            this.method_37324(class_12810.method_567());
            File \u00e2\u02dc\u01922 = new File(new File(this.method_3831(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (class_12810.method_569(\u00e2\u02dc\u01922)) {
                field_4546.error("This crash report has been saved to: {}", (Object)\u00e2\u02dc\u01922.getAbsolutePath());
            } else {
                field_4546.error("We were unable to save this crash report to disk.");
            }
            this.method_3744(class_12810);
        }
        finally {
            try {
                this.field_4561 = true;
                this.method_3782();
            }
            catch (Throwable \u00e2\u02dc\u01923) {
                field_4546.error("Exception stopping the server", \u00e2\u02dc\u01923);
            }
            finally {
                this.method_3821();
            }
        }
    }

    private boolean method_3866() {
        return this.method_18860() || class_156.method_658() < (this.field_19249 ? this.field_19248 : this.field_4571);
    }

    protected void method_16208() {
        this.method_5383();
        this.method_18857(() -> !this.method_3866());
    }

    protected class_3738 method_16209(Runnable runnable) {
        return new class_3738(this.field_4572, runnable);
    }

    protected boolean method_19464(class_3738 class_37382) {
        return class_37382.method_16338() + 3 < this.field_4572 || this.method_3866();
    }

    @Override
    public boolean method_16075() {
        boolean bl;
        this.field_19249 = bl = this.method_20415();
        return bl;
    }

    private boolean method_20415() {
        if (super.method_16075()) {
            return true;
        }
        if (this.method_3866()) {
            for (class_3218 class_32182 : this.method_3738()) {
                if (!class_32182.method_14178().method_19492()) continue;
                return true;
            }
        }
        return false;
    }

    protected void method_24306(class_3738 class_37382) {
        this.method_16044().method_24270("runTask");
        super.method_18859(class_37382);
    }

    private void method_3791(class_2926 class_29262) {
        Optional<File> optional = Optional.of(this.method_3758("server-icon.png")).filter(File::isFile);
        if (!optional.isPresent()) {
            optional = this.field_23784.method_27014().map(Path::toFile).filter(File::isFile);
        }
        optional.ifPresent(file -> {
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ByteArrayOutputStream \u00e2\u02dc\u01922 = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "PNG", \u00e2\u02dc\u01922);
                byte[] \u00e2\u02dc\u01923 = Base64.getEncoder().encode(\u00e2\u02dc\u01922.toByteArray());
                class_29262.method_12677("data:image/png;base64," + new String(\u00e2\u02dc\u01923, StandardCharsets.UTF_8));
            }
            catch (Exception exception) {
                field_4546.error("Couldn't load server icon", (Throwable)exception);
            }
        });
    }

    public Optional<Path> method_3725() {
        return this.field_23784.method_27014();
    }

    public File method_3831() {
        return new File(".");
    }

    protected void method_3744(class_128 class_12810) {
    }

    public void method_3821() {
    }

    public void method_3748(BooleanSupplier booleanSupplier) {
        long l = class_156.method_648();
        ++this.field_4572;
        this.method_3813(booleanSupplier);
        if (l - this.field_4551 >= 5000000000L) {
            this.field_4551 = l;
            this.field_4593.method_12681(new class_2926.class_2927(this.method_3802(), this.method_3788()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.method_3788(), 12)];
            int \u00e2\u02dc\u01922 = class_3532.method_15395(this.field_4602, 0, this.method_3788() - gameProfileArray.length);
            for (int i = 0; i < gameProfileArray.length; ++i) {
                gameProfileArray[i] = this.field_4550.method_14571().get(\u00e2\u02dc\u01922 + i).method_7334();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.field_4593.method_12682().method_12686(gameProfileArray);
        }
        if (this.field_4572 % 6000 == 0) {
            field_4546.debug("Autosave started");
            this.field_16258.method_15396("save");
            this.field_4550.method_14617();
            this.method_3723(true, false, false);
            this.field_16258.method_15407();
            field_4546.debug("Autosave finished");
        }
        this.field_16258.method_15396("snooper");
        if (!this.field_4582.method_5483() && this.field_4572 > 100) {
            this.field_4582.method_5482();
        }
        if (this.field_4572 % 6000 == 0) {
            this.field_4582.method_5485();
        }
        this.field_16258.method_15407();
        this.field_16258.method_15396("tallying");
        long l2 = class_156.method_648() - l;
        this.field_4573[this.field_4572 % 100] = l2;
        \u00e2\u02dc\u0192 = l2;
        this.field_4592 = this.field_4592 * 0.8f + (float)\u00e2\u02dc\u0192 / 1000000.0f * 0.19999999f;
        \u00e2\u02dc\u0192 = class_156.method_648();
        this.field_16205.method_15247(\u00e2\u02dc\u0192 - l);
        this.field_16258.method_15407();
    }

    public void method_3813(BooleanSupplier booleanSupplier) {
        this.field_16258.method_15396("commandFunctions");
        this.method_3740().method_18699();
        this.field_16258.method_15405("levels");
        for (class_3218 class_32182 : this.method_3738()) {
            this.field_16258.method_15400(() -> class_32182 + " " + class_32182.method_27983().method_29177());
            if (this.field_4572 % 20 == 0) {
                this.field_16258.method_15396("timeSync");
                this.field_4550.method_14589(new class_2761(class_32182.method_8510(), class_32182.method_8532(), class_32182.method_8450().method_8355(class_1928.field_19396)), class_32182.method_27983());
                this.field_16258.method_15407();
            }
            this.field_16258.method_15396("tick");
            try {
                class_32182.method_18765(booleanSupplier);
            }
            catch (Throwable throwable) {
                class_128 class_12810 = class_128.method_560(throwable, "Exception ticking world");
                class_32182.method_8538(class_12810);
                throw new class_148(class_12810);
            }
            this.field_16258.method_15407();
            this.field_16258.method_15407();
        }
        this.field_16258.method_15405("connection");
        this.method_3787().method_14357();
        this.field_16258.method_15405("players");
        this.field_4550.method_14601();
        if (class_155.field_1125) {
            class_4521.field_20574.method_22228();
        }
        this.field_16258.method_15405("server gui refresh");
        for (int i = 0; i < this.field_4568.size(); ++i) {
            this.field_4568.get(i).run();
        }
        this.field_16258.method_15407();
    }

    public boolean method_3839() {
        return true;
    }

    public void method_3742(Runnable runnable) {
        this.field_4568.add(runnable);
    }

    protected void method_17819(String string) {
        this.field_17601 = string;
    }

    public boolean method_16043() {
        return !this.field_16257.isAlive();
    }

    public File method_3758(String string) {
        return new File(this.method_3831(), string);
    }

    public final class_3218 method_30002() {
        return this.field_4589.get(class_1937.field_25179);
    }

    @Nullable
    public class_3218 method_3847(class_5321<class_1937> class_53212) {
        return this.field_4589.get(class_53212);
    }

    public Set<class_5321<class_1937>> method_29435() {
        return this.field_4589.keySet();
    }

    public Iterable<class_3218> method_3738() {
        return this.field_4589.values();
    }

    public String method_3827() {
        return class_155.method_16673().getName();
    }

    public int method_3788() {
        return this.field_4550.method_14574();
    }

    public int method_3802() {
        return this.field_4550.method_14592();
    }

    public String[] method_3858() {
        return this.field_4550.method_14580();
    }

    @DontObfuscate
    public String getServerModName() {
        return "vanilla";
    }

    public class_6396 method_37324(class_6396 class_63962) {
        if (this.field_4550 != null) {
            class_63962.method_37123("Player Count", () -> this.field_4550.method_14574() + " / " + this.field_4550.method_14592() + "; " + this.field_4550.method_14571());
        }
        class_63962.method_37123("Data Packs", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (class_3288 class_32882 : this.field_4595.method_14444()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(class_32882.method_14463());
                if (class_32882.method_14460().method_14437()) continue;
                stringBuilder.append(" (incompatible)");
            }
            return stringBuilder.toString();
        });
        if (this.field_17601 != null) {
            class_63962.method_37123("Server Id", () -> this.field_17601);
        }
        return this.method_3859(class_63962);
    }

    public abstract class_6396 method_3859(class_6396 var1);

    public abstract Optional<String> method_24307();

    @Override
    public void method_9203(class_2561 class_25612, UUID uUID) {
        field_4546.info(class_25612.getString());
    }

    public KeyPair method_3716() {
        return this.field_4552;
    }

    public int method_3756() {
        return this.field_4555;
    }

    public void method_3779(int n) {
        this.field_4555 = n;
    }

    public String method_3811() {
        return this.field_4578;
    }

    public void method_3849(String string) {
        this.field_4578 = string;
    }

    public boolean method_3724() {
        return this.field_4578 != null;
    }

    protected void method_31400() {
        field_4546.info("Generating keypair");
        try {
            this.field_4552 = class_3515.method_15237();
        }
        catch (class_5525 class_55252) {
            throw new IllegalStateException("Failed to generate key pair", class_55252);
        }
    }

    public void method_3776(class_1267 class_12672, boolean bl) {
        if (!bl && this.field_24372.method_197()) {
            return;
        }
        this.field_24372.method_208(this.field_24372.method_152() ? class_1267.field_5807 : class_12672);
        this.method_27729();
        this.method_3760().method_14571().forEach(this::method_19465);
    }

    public int method_27903(int n) {
        return n;
    }

    private void method_27729() {
        for (class_3218 class_32182 : this.method_3738()) {
            class_32182.method_8424(this.method_3783(), this.method_3796());
        }
    }

    public void method_19467(boolean bl) {
        this.field_24372.method_186(bl);
        this.method_3760().method_14571().forEach(this::method_19465);
    }

    private void method_19465(class_3222 class_32222) {
        class_5217 class_52172 = class_32222.method_14220().method_8401();
        class_32222.field_13987.method_14364(new class_2632(class_52172.method_207(), class_52172.method_197()));
    }

    public boolean method_3783() {
        return this.field_24372.method_207() != class_1267.field_5801;
    }

    public boolean method_3799() {
        return this.field_4549;
    }

    public void method_3730(boolean bl) {
        this.field_4549 = bl;
    }

    public String method_3784() {
        return this.field_4607;
    }

    public String method_3805() {
        return this.field_4584;
    }

    public void method_3843(String string, String string2) {
        this.field_4607 = string;
        this.field_4584 = string2;
    }

    @Override
    public void method_5495(class_1276 class_127622) {
        class_1276 class_127622;
        class_127622.method_5481("whitelist_enabled", false);
        class_127622.method_5481("whitelist_count", 0);
        if (this.field_4550 != null) {
            class_127622.method_5481("players_current", this.method_3788());
            class_127622.method_5481("players_max", this.method_3802());
            class_127622.method_5481("players_seen", this.field_24371.method_263().length);
        }
        class_127622.method_5481("uses_auth", this.field_4543);
        class_127622.method_5481("gui_state", this.method_3727() ? "enabled" : "disabled");
        class_127622.method_5481("run_time", (class_156.method_658() - class_127622.method_5484()) / 60L * 1000L);
        class_127622.method_5481("avg_tick_ms", (int)(class_3532.method_15373(this.field_4573) * 1.0E-6));
        int n = 0;
        for (class_3218 class_32182 : this.method_3738()) {
            if (class_32182 == null) continue;
            class_127622.method_5481("world[" + n + "][dimension]", class_32182.method_27983().method_29177());
            class_127622.method_5481("world[" + n + "][mode]", (Object)this.field_24372.method_210());
            class_127622.method_5481("world[" + n + "][difficulty]", (Object)class_32182.method_8407());
            class_127622.method_5481("world[" + n + "][hardcore]", this.field_24372.method_152());
            class_127622.method_5481("world[" + n + "][height]", class_32182.method_31600());
            class_127622.method_5481("world[" + n + "][chunks_loaded]", class_32182.method_14178().method_14151());
            ++n;
        }
        class_127622.method_5481("worlds", n);
    }

    @Override
    public void method_35034(class_1276 class_12762) {
        class_12762.method_5480("singleplayer", this.method_3724());
        class_12762.method_5480("server_brand", this.getServerModName());
        class_12762.method_5480("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        class_12762.method_5480("dedicated", this.method_3816());
    }

    @Override
    public boolean method_35033() {
        return true;
    }

    public abstract boolean method_3816();

    public abstract int method_30612();

    public boolean method_3828() {
        return this.field_4543;
    }

    public void method_3864(boolean bl) {
        this.field_4543 = bl;
    }

    public boolean method_3775() {
        return this.field_4560;
    }

    public void method_3764(boolean bl) {
        this.field_4560 = bl;
    }

    public boolean method_3796() {
        return true;
    }

    public boolean method_3736() {
        return true;
    }

    public abstract boolean method_3759();

    public boolean method_3852() {
        return this.field_4604;
    }

    public void method_3815(boolean bl) {
        this.field_4604 = bl;
    }

    public boolean method_3718() {
        return this.field_4554;
    }

    public void method_3745(boolean bl) {
        this.field_4554 = bl;
    }

    public abstract boolean method_3812();

    public String method_3818() {
        return this.field_4564;
    }

    public void method_3834(String string) {
        this.field_4564 = string;
    }

    public boolean method_3750() {
        return this.field_4561;
    }

    public class_3324 method_3760() {
        return this.field_4550;
    }

    public void method_3846(class_3324 class_33242) {
        this.field_4550 = class_33242;
    }

    public abstract boolean method_3860();

    public void method_3838(class_1934 class_19342) {
        this.field_24372.method_193(class_19342);
    }

    @Nullable
    public class_3242 method_3787() {
        return this.field_4563;
    }

    public boolean method_3820() {
        return this.field_4547;
    }

    public boolean method_3727() {
        return false;
    }

    public boolean method_3763(@Nullable class_1934 class_19342, boolean bl, int n) {
        return false;
    }

    public int method_3780() {
        return this.field_4572;
    }

    public class_1276 method_3795() {
        return this.field_4582;
    }

    public int method_3841() {
        return 16;
    }

    public boolean method_3785(class_3218 class_32182, class_2338 class_23382, class_1657 class_16572) {
        return false;
    }

    public boolean method_27902() {
        return true;
    }

    public Proxy method_36113() {
        return this.field_4599;
    }

    public int method_3862() {
        return this.field_4596;
    }

    public void method_3803(int n) {
        this.field_4596 = n;
    }

    public MinecraftSessionService method_3844() {
        return this.field_4603;
    }

    public GameProfileRepository method_3719() {
        return this.field_4608;
    }

    public class_3312 method_3793() {
        return this.field_4556;
    }

    public class_2926 method_3765() {
        return this.field_4593;
    }

    public void method_3856() {
        this.field_4551 = 0L;
    }

    public int method_3749() {
        return 29999984;
    }

    @Override
    public boolean method_5384() {
        return super.method_5384() && !this.method_3750();
    }

    @Override
    public Thread method_3777() {
        return this.field_16257;
    }

    public int method_3773() {
        return 256;
    }

    public long method_3826() {
        return this.field_4571;
    }

    public DataFixer method_3855() {
        return this.field_4587;
    }

    public int method_3829(@Nullable class_3218 class_32182) {
        if (class_32182 != null) {
            return class_32182.method_8450().method_8356(class_1928.field_19403);
        }
        return 10;
    }

    public class_2989 method_3851() {
        return this.field_25318.method_29473();
    }

    public class_2991 method_3740() {
        return this.field_4591;
    }

    public CompletableFuture<Void> method_29439(Collection<String> collection) {
        CompletionStage completionStage = ((CompletableFuture)CompletableFuture.supplyAsync(() -> (ImmutableList)collection.stream().map(this.field_4595::method_14449).filter(Objects::nonNull).map(class_3288::method_14458).collect(ImmutableList.toImmutableList()), this).thenCompose(immutableList -> class_5350.method_29466((List<class_3262>)immutableList, this.field_25132, this.method_3816() ? class_2170.class_5364.field_25420 : class_2170.class_5364.field_25421, this.method_21714(), this.field_17200, this))).thenAcceptAsync(class_53502 -> {
            this.field_25318.close();
            this.field_25318 = class_53502;
            this.field_4595.method_14447(collection);
            this.field_24372.method_29590(MinecraftServer.method_29735(this.field_4595));
            class_53502.method_29475();
            this.method_3760().method_14617();
            this.method_3760().method_14572();
            this.field_4591.method_29461(this.field_25318.method_29465());
            this.field_24370.method_29300(this.field_25318.method_29474());
        }, (Executor)this);
        if (this.method_18854()) {
            this.method_18857(((CompletableFuture)completionStage)::isDone);
        }
        return completionStage;
    }

    public static class_5359 method_29736(class_3283 class_328322, class_5359 class_53592, boolean bl) {
        class_328322.method_14445();
        if (bl) {
            class_328322.method_14447(Collections.singleton("vanilla"));
            return new class_5359((List<String>)ImmutableList.of((Object)"vanilla"), (List<String>)ImmutableList.of());
        }
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        for (String string : class_53592.method_29547()) {
            if (class_328322.method_29207(string)) {
                linkedHashSet.add(string);
                continue;
            }
            field_4546.warn("Missing data pack {}", (Object)string);
        }
        for (class_3288 class_32882 : class_328322.method_14441()) {
            String string = class_32882.method_14463();
            if (class_53592.method_29550().contains(string) || linkedHashSet.contains(string)) continue;
            field_4546.info("Found new data pack {}, loading it automatically", (Object)string);
            linkedHashSet.add(string);
        }
        if (linkedHashSet.isEmpty()) {
            field_4546.info("No datapacks selected, forcing vanilla");
            linkedHashSet.add("vanilla");
        }
        class_328322.method_14447(linkedHashSet);
        return MinecraftServer.method_29735(class_328322);
    }

    private static class_5359 method_29735(class_3283 class_32832) {
        Collection<String> collection = class_32832.method_29210();
        ImmutableList \u00e2\u02dc\u01922 = ImmutableList.copyOf(collection);
        List \u00e2\u02dc\u01923 = (List)class_32832.method_29206().stream().filter(string -> !collection.contains(string)).collect(ImmutableList.toImmutableList());
        return new class_5359((List<String>)\u00e2\u02dc\u01922, \u00e2\u02dc\u01923);
    }

    public void method_3728(class_2168 class_21682) {
        if (!this.method_3729()) {
            return;
        }
        class_3324 class_33242 = class_21682.method_9211().method_3760();
        class_3337 \u00e2\u02dc\u01922 = class_33242.method_14590();
        ArrayList \u00e2\u02dc\u01923 = Lists.newArrayList(class_33242.method_14571());
        for (class_3222 class_32222 : \u00e2\u02dc\u01923) {
            if (\u00e2\u02dc\u01922.method_14653(class_32222.method_7334())) continue;
            class_32222.field_13987.method_14367(new class_2588("multiplayer.disconnect.not_whitelisted"));
        }
    }

    public class_3283 method_3836() {
        return this.field_4595;
    }

    public class_2170 method_3734() {
        return this.field_25318.method_29472();
    }

    public class_2168 method_3739() {
        class_3218 class_32182 = this.method_30002();
        return new class_2168(this, class_32182 == null ? class_243.field_1353 : class_243.method_24954(class_32182.method_27911()), class_241.field_1340, class_32182, 4, "Server", new class_2585("Server"), this, null);
    }

    @Override
    public boolean method_9200() {
        return true;
    }

    @Override
    public boolean method_9202() {
        return true;
    }

    @Override
    public abstract boolean method_9201();

    public class_1863 method_3772() {
        return this.field_25318.method_29471();
    }

    public class_5415 method_3801() {
        return this.field_25318.method_29470();
    }

    public class_2995 method_3845() {
        return this.field_4558;
    }

    public class_4565 method_22827() {
        if (this.field_20850 == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.field_20850;
    }

    public class_60 method_3857() {
        return this.field_25318.method_29469();
    }

    public class_4567 method_22828() {
        return this.field_25318.method_29468();
    }

    public class_5640 method_32699() {
        return this.field_25318.method_32703();
    }

    public class_1928 method_3767() {
        return this.method_30002().method_8450();
    }

    public class_3004 method_3837() {
        return this.field_4548;
    }

    public boolean method_3729() {
        return this.field_4570;
    }

    public void method_3731(boolean bl) {
        this.field_4570 = bl;
    }

    public float method_3830() {
        return this.field_4592;
    }

    public int method_3835(GameProfile gameProfile) {
        if (this.method_3760().method_14569(gameProfile)) {
            class_3327 class_33272 = (class_3327)this.method_3760().method_14603().method_14640(gameProfile);
            if (class_33272 != null) {
                return class_33272.method_14623();
            }
            if (this.method_19466(gameProfile)) {
                return 4;
            }
            if (this.method_3724()) {
                return this.method_3760().method_14579() ? 4 : 0;
            }
            return this.method_3798();
        }
        return 0;
    }

    public class_3517 method_15876() {
        return this.field_16205;
    }

    public class_3695 method_16044() {
        return this.field_16258;
    }

    public abstract boolean method_19466(GameProfile var1);

    public void method_37113(Path path) throws IOException {
    }

    private void method_21613(Path path) {
        \u00e2\u02dc\u0192 = path.resolve("levels");
        try {
            for (Map.Entry<class_5321<class_1937>, class_3218> entry : this.field_4589.entrySet()) {
                class_2960 class_29602 = entry.getKey().method_29177();
                Path \u00e2\u02dc\u01922 = \u00e2\u02dc\u0192.resolve(class_29602.method_12836()).resolve(class_29602.method_12832());
                Files.createDirectories(\u00e2\u02dc\u01922, new FileAttribute[0]);
                entry.getValue().method_21625(\u00e2\u02dc\u01922);
            }
            this.method_21615(path.resolve("gamerules.txt"));
            this.method_21616(path.resolve("classpath.txt"));
            this.method_21692(path.resolve("stats.txt"));
            this.method_21713(path.resolve("threads.txt"));
            this.method_37113(path.resolve("server.properties.txt"));
        }
        catch (IOException iOException) {
            field_4546.warn("Failed to save debug report", (Throwable)iOException);
        }
    }

    private void method_21692(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(String.format("pending_tasks: %d\n", this.method_21684()));
            bufferedWriter.write(String.format("average_tick_time: %f\n", Float.valueOf(this.method_3830())));
            bufferedWriter.write(String.format("tick_times: %s\n", Arrays.toString(this.field_4573)));
            bufferedWriter.write(String.format("queue: %s\n", class_156.method_18349()));
        }
    }

    private void method_21615(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList arrayList = Lists.newArrayList();
            final class_1928 \u00e2\u02dc\u01922 = this.method_3767();
            class_1928.method_20744(new class_1928.class_4311(){

                @Override
                public <T extends class_1928.class_4315<T>> void method_20762(class_1928.class_4313<T> class_43132, class_1928.class_4314<T> class_43142) {
                    arrayList.add(String.format("%s=%s\n", class_43132.method_20771(), \u00e2\u02dc\u01922.method_20746(class_43132)));
                }
            });
            for (String string : arrayList) {
                bufferedWriter.write(string);
            }
        }
    }

    private void method_21616(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            String string = System.getProperty("java.class.path");
            \u00e2\u02dc\u0192 = System.getProperty("path.separator");
            for (String string2 : Splitter.on((String)\u00e2\u02dc\u0192).split((CharSequence)string)) {
                bufferedWriter.write(string2);
                bufferedWriter.write("\n");
            }
        }
    }

    private void method_21713(Path path) throws IOException {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] \u00e2\u02dc\u01922 = threadMXBean.dumpAllThreads(true, true);
        Arrays.sort(\u00e2\u02dc\u01922, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter \u00e2\u02dc\u01923 = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ThreadInfo threadInfo : \u00e2\u02dc\u01922) {
                \u00e2\u02dc\u01923.write(threadInfo.toString());
                ((Writer)\u00e2\u02dc\u01923).write(10);
            }
        }
    }

    private void method_24487() {
        if (this.field_33977) {
            this.field_22250 = class_5961.method_37191(new class_6402(class_156.field_1128, this.method_3816()), class_156.field_1128, class_156.method_27958(), new class_5971("server"), this.field_33975, path -> {
                this.method_19537(() -> this.method_21613(path.resolve("server")));
                this.field_33976.accept((Path)path);
            });
            this.field_33977 = false;
        }
        this.field_16258 = class_4758.method_24340(this.field_22250.method_34774(), class_4758.method_24341("Server"));
        this.field_22250.method_34771();
        this.field_16258.method_16065();
    }

    private void method_24490() {
        this.field_16258.method_16066();
        this.field_22250.method_34772();
    }

    public boolean method_37321() {
        return this.field_22250.method_34773();
    }

    public void method_37320(Consumer<class_3696> consumer, Consumer<Path> consumer2) {
        this.field_33975 = class_36962 -> {
            this.method_37322();
            consumer.accept((class_3696)class_36962);
        };
        this.field_33976 = consumer2;
        this.field_33977 = true;
    }

    public void method_37322() {
        this.field_22250 = class_5963.field_29594;
    }

    public void method_37323() {
        this.field_22250.method_34770();
    }

    public Path method_27050(class_5218 class_52182) {
        return this.field_23784.method_27010(class_52182);
    }

    public boolean method_27051() {
        return true;
    }

    public class_3485 method_27727() {
        return this.field_24370;
    }

    public class_5219 method_27728() {
        return this.field_24372;
    }

    public class_5455 method_30611() {
        return this.field_25132;
    }

    public class_5513 method_31371(class_3222 class_32222) {
        return class_5513.field_28862;
    }

    public boolean method_32303() {
        return false;
    }

    public class_3225 method_32816(class_3222 class_32222) {
        return this.method_3799() ? new class_3201(class_32222) : new class_3225(class_32222);
    }

    @Nullable
    public class_1934 method_3761() {
        return null;
    }

    public class_3300 method_34864() {
        return this.field_25318.method_29474();
    }

    @Nullable
    public class_2561 method_36326() {
        return null;
    }

    public boolean method_24488() {
        return this.field_33979 || this.field_33978 != null;
    }

    public void method_3832() {
        this.field_33979 = true;
    }

    public class_3696 method_24489() {
        if (this.field_33978 == null) {
            return class_3688.field_16265;
        }
        class_3696 class_36962 = this.field_33978.method_37330(class_156.method_648(), this.field_4572);
        this.field_33978 = null;
        return class_36962;
    }

    @Override
    public /* synthetic */ void method_18859(Runnable runnable) {
        this.method_24306((class_3738)runnable);
    }

    @Override
    public /* synthetic */ boolean method_18856(Runnable runnable) {
        return this.method_19464((class_3738)runnable);
    }

    @Override
    public /* synthetic */ Runnable method_16211(Runnable runnable) {
        return this.method_16209(runnable);
    }

    static class class_6414 {
        final long field_33980;
        final int field_33981;

        class_6414(long l, int n) {
            this.field_33980 = l;
            this.field_33981 = n;
        }

        class_3696 method_37330(final long l, final int n) {
            return new class_3696(){

                @Override
                public List<class_3534> method_16067(String string) {
                    return Collections.emptyList();
                }

                @Override
                public boolean method_16069(Path path) {
                    return false;
                }

                @Override
                public long method_16068() {
                    return field_33980;
                }

                @Override
                public int method_16072() {
                    return field_33981;
                }

                @Override
                public long method_16073() {
                    return l;
                }

                @Override
                public int method_16070() {
                    return n;
                }

                @Override
                public String method_34970() {
                    return "";
                }
            };
        }
    }
}

