/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.IForgeRenderChunk;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.optifine.BlockPosM;
import net.optifine.Config;
import net.optifine.CustomBlockLayers;
import net.optifine.override.ChunkCacheOF;
import net.optifine.reflect.Reflector;
import net.optifine.render.AabbFrame;
import net.optifine.render.ChunkLayerMap;
import net.optifine.render.ChunkLayerSet;
import net.optifine.render.ICamera;
import net.optifine.render.RenderEnv;
import net.optifine.render.RenderTypes;
import net.optifine.shaders.SVertexBuilder;
import net.optifine.shaders.Shaders;
import net.optifine.util.ChunkUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkRenderDispatcher {
    private static final Logger f_112672_ = LogManager.getLogger();
    private static final int f_316423_ = 4;
    private static final VertexFormat f_284367_ = DefaultVertexFormat.f_85811_;
    private final PriorityQueue<RenderChunk.ChunkCompileTask> f_112673_ = Queues.newPriorityQueue();
    private final Queue<ChunkBufferBuilderPack> f_112674_;
    private final Queue<Runnable> f_112675_ = Queues.newConcurrentLinkedQueue();
    private volatile int f_112676_;
    private volatile int f_112677_;
    final ChunkBufferBuilderPack f_112678_;
    private final ProcessorMailbox<Runnable> f_112679_;
    private final Executor f_112680_;
    Level f_112681_;
    final LevelRenderer f_112682_;
    private Vec3 f_112683_ = Vec3.f_82478_;
    private int countRenderBuilders;
    private List<ChunkBufferBuilderPack> listPausedBuilders = new ArrayList<ChunkBufferBuilderPack>();
    public static final RenderType[] BLOCK_RENDER_LAYERS = RenderType.m_110506_().toArray(new RenderType[0]);
    private static final boolean FORGE = Reflector.ForgeHooksClient.exists();
    private static final boolean FORGE_CAN_RENDER_IN_LAYER_BS = Reflector.ForgeRenderTypeLookup_canRenderInLayerBs.exists();
    private static final boolean FORGE_CAN_RENDER_IN_LAYER_FS = Reflector.ForgeRenderTypeLookup_canRenderInLayerBs.exists();
    private static final boolean FORGE_SET_RENDER_LAYER = Reflector.ForgeHooksClient_setRenderLayer.exists();
    public static int renderChunksUpdated;

    public ChunkRenderDispatcher(Level worldIn, LevelRenderer worldRendererIn, Executor executorIn, boolean java64bit, ChunkBufferBuilderPack fixedBuilderIn) {
        this(worldIn, worldRendererIn, executorIn, java64bit, fixedBuilderIn, -1);
    }

    public ChunkRenderDispatcher(Level worldIn, LevelRenderer worldRendererIn, Executor executorIn, boolean java64bit, ChunkBufferBuilderPack fixedBuilderIn, int countRenderBuildersIn) {
        this.f_112681_ = worldIn;
        this.f_112682_ = worldRendererIn;
        int i = Math.max(1, (int)((double)Runtime.getRuntime().maxMemory() * 0.3) / (RenderType.m_110506_().stream().mapToInt(RenderType::m_110507_).sum() * 4) - 1);
        int j = Runtime.getRuntime().availableProcessors();
        int k = java64bit ? j : Math.min(j, 4);
        int l = Math.max(1, Math.min(k, i));
        if (countRenderBuildersIn > 0) {
            l = countRenderBuildersIn;
        }
        this.f_112678_ = fixedBuilderIn;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)l);
        try {
            for (int i1 = 0; i1 < l; ++i1) {
                list.add(new ChunkBufferBuilderPack());
            }
        }
        catch (OutOfMemoryError outofmemoryerror) {
            f_112672_.warn("Allocated only {}/{} buffers", (Object)list.size(), (Object)l);
            int j1 = Math.min(list.size() * 2 / 3, list.size() - 1);
            for (int k1 = 0; k1 < j1; ++k1) {
                list.remove(list.size() - 1);
            }
            System.gc();
        }
        this.f_112674_ = Queues.newConcurrentLinkedQueue((Iterable)list);
        this.countRenderBuilders = this.f_112677_ = this.f_112674_.size();
        this.f_112680_ = executorIn;
        this.f_112679_ = ProcessorMailbox.m_18751_((Executor)executorIn, (String)"Chunk Renderer");
        this.f_112679_.m_6937_(this::m_112734_);
    }

    public void m_112691_(Level worldIn) {
        this.f_112681_ = worldIn;
    }

    private void m_112734_() {
        RenderChunk.ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask;
        if (!this.f_112674_.isEmpty() && (chunkrenderdispatcher$renderchunk$chunkcompiletask = this.f_112673_.poll()) != null) {
            ChunkBufferBuilderPack chunkbufferbuilderpack = this.f_112674_.poll();
            if (chunkbufferbuilderpack == null) {
                this.f_112673_.add(chunkrenderdispatcher$renderchunk$chunkcompiletask);
                return;
            }
            this.f_112676_ = this.f_112673_.size();
            this.f_112677_ = this.f_112674_.size();
            ((CompletableFuture)CompletableFuture.runAsync(() -> {}, this.f_112680_).thenCompose(voidIn -> chunkrenderdispatcher$renderchunk$chunkcompiletask.m_5869_(chunkbufferbuilderpack))).whenComplete((taskResultIn, throwableIn) -> {
                if (throwableIn != null) {
                    CrashReport crashreport = CrashReport.m_127521_(throwableIn, "Batching chunks");
                    Minecraft.m_91087_().m_91253_(Minecraft.m_91087_().m_91354_(crashreport));
                } else {
                    this.f_112679_.m_6937_(() -> {
                        if (taskResultIn == ChunkTaskResult.SUCCESSFUL) {
                            chunkbufferbuilderpack.m_108838_();
                        } else {
                            chunkbufferbuilderpack.m_108841_();
                        }
                        this.f_112674_.add(chunkbufferbuilderpack);
                        this.f_112677_ = this.f_112674_.size();
                        this.m_112734_();
                    });
                }
            });
        }
    }

    public String m_112719_() {
        return String.format("pC: %03d, pU: %02d, aB: %02d", this.f_112676_, this.f_112675_.size(), this.f_112677_);
    }

    public int m_316427_() {
        return this.f_112676_;
    }

    public int m_316428_() {
        return this.f_112675_.size();
    }

    public int m_316429_() {
        return this.f_112677_;
    }

    public void m_112693_(Vec3 posIn) {
        this.f_112683_ = posIn;
    }

    public Vec3 m_112727_() {
        return this.f_112683_;
    }

    public boolean m_112730_() {
        Runnable runnable;
        boolean flag = false;
        while ((runnable = this.f_112675_.poll()) != null) {
            runnable.run();
            flag = true;
        }
        return flag;
    }

    public void m_112715_(RenderChunk chunkRenderIn) {
        chunkRenderIn.m_112845_();
    }

    public void m_112731_() {
        this.m_112735_();
    }

    public void m_112709_(RenderChunk.ChunkCompileTask renderTaskIn) {
        this.f_112679_.m_6937_(() -> {
            this.f_112673_.offer(renderTaskIn);
            this.f_112676_ = this.f_112673_.size();
            this.m_112734_();
        });
    }

    public CompletableFuture<Void> m_112695_(BufferBuilder bufferBuilderIn, VertexBuffer vertexBufferIn) {
        return CompletableFuture.runAsync(() -> {}, this.f_112675_::add).thenCompose(voidIn -> this.m_112720_(bufferBuilderIn, vertexBufferIn));
    }

    private CompletableFuture<Void> m_112720_(BufferBuilder bufferBuilderIn, VertexBuffer vertexBufferIn) {
        return vertexBufferIn.m_85932_(bufferBuilderIn);
    }

    private void m_112735_() {
        while (!this.f_112673_.isEmpty()) {
            RenderChunk.ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask = this.f_112673_.poll();
            if (chunkrenderdispatcher$renderchunk$chunkcompiletask == null) continue;
            chunkrenderdispatcher$renderchunk$chunkcompiletask.m_6204_();
        }
        this.f_112676_ = 0;
    }

    public boolean m_112732_() {
        return this.f_112676_ == 0 && this.f_112675_.isEmpty();
    }

    public void m_112733_() {
        this.m_112735_();
        this.f_112679_.close();
        this.f_112674_.clear();
    }

    public void pauseChunkUpdates() {
        long timeStartMs = System.currentTimeMillis();
        if (this.listPausedBuilders.size() > 0) {
            return;
        }
        while (this.listPausedBuilders.size() != this.countRenderBuilders) {
            this.m_112730_();
            ChunkBufferBuilderPack builder = this.f_112674_.poll();
            if (builder != null) {
                this.listPausedBuilders.add(builder);
            }
            if (System.currentTimeMillis() <= timeStartMs + 1000L) continue;
            break;
        }
    }

    public void resumeChunkUpdates() {
        this.f_112674_.addAll(this.listPausedBuilders);
        this.listPausedBuilders.clear();
    }

    public boolean updateChunkNow(RenderChunk renderChunk) {
        this.m_112715_(renderChunk);
        return true;
    }

    public boolean updateChunkLater(RenderChunk renderChunk) {
        if (this.f_112674_.isEmpty()) {
            return false;
        }
        renderChunk.m_112820_(this);
        return true;
    }

    public boolean updateTransparencyLater(RenderChunk renderChunk) {
        if (this.f_112674_.isEmpty()) {
            return false;
        }
        return renderChunk.m_112809_((RenderType)((Object)RenderTypes.TRANSLUCENT), this);
    }

    public class RenderChunk
    implements IForgeRenderChunk {
        public static final int f_316431_ = 16;
        public final int f_316432_;
        public final AtomicReference<CompiledChunk> f_112784_ = new AtomicReference<CompiledChunk>(CompiledChunk.f_112748_);
        @Nullable
        private RebuildTask f_112787_;
        @Nullable
        private ResortTransparencyTask f_112788_;
        private final Set<BlockEntity> f_112789_ = Sets.newHashSet();
        private final ChunkLayerMap<VertexBuffer> f_112790_ = new ChunkLayerMap<Object>(renderType -> new VertexBuffer());
        public AABB f_112785_;
        private int f_112791_ = -1;
        private boolean f_112792_ = true;
        final BlockPos.MutableBlockPos f_112793_ = new BlockPos.MutableBlockPos(-1, -1, -1);
        private final BlockPos.MutableBlockPos[] f_112794_ = Util.m_137469_(new BlockPos.MutableBlockPos[6], posArrIn -> {
            for (int i = 0; i < ((BlockPos.MutableBlockPos[])posArrIn).length; ++i) {
                posArrIn[i] = new BlockPos.MutableBlockPos();
            }
        });
        private boolean f_112795_;
        private final boolean isMipmaps = Config.isMipmaps();
        private final boolean fixBlockLayer = !Reflector.BetterFoliageClient.exists();
        private boolean playerUpdate = false;
        private boolean renderRegions = Config.isRenderRegions();
        public int regionX;
        public int regionZ;
        public int regionDX;
        public int regionDY;
        public int regionDZ;
        private final RenderChunk[] renderChunksOfset16 = new RenderChunk[6];
        private boolean renderChunksOffset16Updated = false;
        private LevelChunk chunk;
        private RenderChunk[] renderChunkNeighbours = new RenderChunk[Direction.f_122346_.length];
        private RenderChunk[] renderChunkNeighboursValid = new RenderChunk[Direction.f_122346_.length];
        private boolean renderChunkNeighboursUpated = false;
        private LevelRenderer.RenderChunkInfo renderInfo = new LevelRenderer.RenderChunkInfo(this, null, 0);
        public AabbFrame boundingBoxParent;

        public RenderChunk(int indexIn) {
            this.f_316432_ = indexIn;
        }

        private boolean m_112822_(BlockPos blockPosIn) {
            return ChunkRenderDispatcher.this.f_112681_.m_6522_(SectionPos.m_123171_((int)blockPosIn.m_123341_()), SectionPos.m_123171_((int)blockPosIn.m_123343_()), ChunkStatus.f_62326_, false) != null;
        }

        public boolean m_112798_() {
            int i = 24;
            if (!(this.m_112832_() > 576.0)) {
                return true;
            }
            return this.m_112822_((BlockPos)this.f_112794_[Direction.WEST.ordinal()]) && this.m_112822_((BlockPos)this.f_112794_[Direction.NORTH.ordinal()]) && this.m_112822_((BlockPos)this.f_112794_[Direction.EAST.ordinal()]) && this.m_112822_((BlockPos)this.f_112794_[Direction.SOUTH.ordinal()]);
        }

        public boolean m_112799_(int frameIndexIn) {
            if (this.f_112791_ == frameIndexIn) {
                return false;
            }
            this.f_112791_ = frameIndexIn;
            return true;
        }

        public VertexBuffer m_112807_(RenderType renderTypeIn) {
            return (VertexBuffer)this.f_112790_.get(renderTypeIn);
        }

        public void m_112801_(int x, int y, int z) {
            if (x != this.f_112793_.m_123341_() || y != this.f_112793_.m_123342_() || z != this.f_112793_.m_123343_()) {
                this.m_112846_();
                this.f_112793_.m_122178_(x, y, z);
                if (this.renderRegions) {
                    int bits = 8;
                    this.regionX = x >> bits << bits;
                    this.regionZ = z >> bits << bits;
                    this.regionDX = x - this.regionX;
                    this.regionDY = y;
                    this.regionDZ = z - this.regionZ;
                }
                this.f_112785_ = new AABB((double)x, (double)y, (double)z, (double)(x + 16), (double)(y + 16), (double)(z + 16));
                for (Direction direction : Direction.f_122346_) {
                    this.f_112794_[direction.ordinal()].m_122190_((Vec3i)this.f_112793_).m_122175_(direction, 16);
                }
                this.renderChunksOffset16Updated = false;
                this.renderChunkNeighboursUpated = false;
                for (int i = 0; i < this.renderChunkNeighbours.length; ++i) {
                    RenderChunk neighbour = this.renderChunkNeighbours[i];
                    if (neighbour == null) continue;
                    neighbour.renderChunkNeighboursUpated = false;
                }
                this.chunk = null;
                this.boundingBoxParent = null;
            }
        }

        protected double m_112832_() {
            Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
            double d0 = this.f_112785_.f_82288_ + 8.0 - camera.m_90583_().f_82479_;
            double d1 = this.f_112785_.f_82289_ + 8.0 - camera.m_90583_().f_82480_;
            double d2 = this.f_112785_.f_82290_ + 8.0 - camera.m_90583_().f_82481_;
            return d0 * d0 + d1 * d1 + d2 * d2;
        }

        void m_112805_(BufferBuilder bufferBuilderIn) {
            bufferBuilderIn.m_190458_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        }

        public CompiledChunk m_112835_() {
            return this.f_112784_.get();
        }

        private void m_112846_() {
            this.m_112843_();
            this.f_112784_.set(CompiledChunk.f_112748_);
            this.f_112792_ = true;
        }

        public void m_112838_() {
            this.m_112846_();
            this.f_112790_.values().forEach(VertexBuffer::close);
        }

        public BlockPos m_112839_() {
            return this.f_112793_;
        }

        public void m_112828_(boolean immediate) {
            boolean flag = this.f_112792_;
            this.f_112792_ = true;
            this.f_112795_ = immediate | (flag && this.f_112795_);
            if (this.isWorldPlayerUpdate()) {
                this.playerUpdate = true;
            }
        }

        public void m_112840_() {
            this.f_112792_ = false;
            this.f_112795_ = false;
            this.playerUpdate = false;
        }

        public boolean m_112841_() {
            return this.f_112792_;
        }

        public boolean m_112842_() {
            return this.f_112792_ && this.f_112795_;
        }

        public BlockPos m_112824_(Direction facing) {
            return this.f_112794_[facing.ordinal()];
        }

        public boolean m_112809_(RenderType renderTypeIn, ChunkRenderDispatcher renderDispatcherIn) {
            CompiledChunk chunkrenderdispatcher$compiledchunk = this.m_112835_();
            if (this.f_112788_ != null) {
                this.f_112788_.m_6204_();
            }
            if (!chunkrenderdispatcher$compiledchunk.f_112750_.contains(renderTypeIn)) {
                return false;
            }
            this.f_112788_ = FORGE ? new ResortTransparencyTask(new ChunkPos(this.m_112839_()), this.m_112832_(), chunkrenderdispatcher$compiledchunk) : new ResortTransparencyTask(this.m_112832_(), chunkrenderdispatcher$compiledchunk);
            renderDispatcherIn.m_112709_(this.f_112788_);
            return true;
        }

        protected void m_112843_() {
            if (this.f_112787_ != null) {
                this.f_112787_.m_6204_();
                this.f_112787_ = null;
            }
            if (this.f_112788_ != null) {
                this.f_112788_.m_6204_();
                this.f_112788_ = null;
            }
        }

        public ChunkCompileTask m_112844_() {
            this.m_112843_();
            BlockPos blockpos = this.f_112793_.m_7949_();
            boolean i = true;
            RenderChunkRegion renderchunkregion = null;
            this.f_112787_ = FORGE ? new RebuildTask(new ChunkPos(this.m_112839_()), this.m_112832_(), renderchunkregion) : new RebuildTask(this.m_112832_(), renderchunkregion);
            return this.f_112787_;
        }

        public void m_112820_(ChunkRenderDispatcher dispatcherIn) {
            ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask = this.m_112844_();
            dispatcherIn.m_112709_(chunkrenderdispatcher$renderchunk$chunkcompiletask);
        }

        void m_112826_(Set<BlockEntity> globalEntitiesIn) {
            HashSet set = Sets.newHashSet(globalEntitiesIn);
            HashSet set1 = Sets.newHashSet(this.f_112789_);
            set.removeAll(this.f_112789_);
            set1.removeAll(globalEntitiesIn);
            this.f_112789_.clear();
            this.f_112789_.addAll(globalEntitiesIn);
            ChunkRenderDispatcher.this.f_112682_.m_109762_(set1, set);
        }

        public void m_112845_() {
            ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask = this.m_112844_();
            chunkrenderdispatcher$renderchunk$chunkcompiletask.m_5869_(ChunkRenderDispatcher.this.f_112678_);
        }

        private boolean isWorldPlayerUpdate() {
            if (ChunkRenderDispatcher.this.f_112681_ instanceof ClientLevel) {
                ClientLevel worldClient = (ClientLevel)ChunkRenderDispatcher.this.f_112681_;
                return worldClient.isPlayerUpdate();
            }
            return false;
        }

        public boolean isPlayerUpdate() {
            return this.playerUpdate;
        }

        private RenderType[] getFluidRenderLayers(FluidState fluidState, RenderType[] singleLayer) {
            if (FORGE_CAN_RENDER_IN_LAYER_FS) {
                return BLOCK_RENDER_LAYERS;
            }
            singleLayer[0] = ItemBlockRenderTypes.m_109287_((FluidState)fluidState);
            return singleLayer;
        }

        private RenderType[] getBlockRenderLayers(BlockState blockState, RenderType[] singleLayer) {
            if (FORGE_CAN_RENDER_IN_LAYER_BS) {
                return BLOCK_RENDER_LAYERS;
            }
            singleLayer[0] = ItemBlockRenderTypes.m_109282_((BlockState)blockState);
            return singleLayer;
        }

        private RenderType fixBlockLayer(BlockGetter worldReader, BlockState blockState, BlockPos blockPos, RenderType layer) {
            RenderType layerCustom;
            if (CustomBlockLayers.isActive() && (layerCustom = CustomBlockLayers.getRenderLayer((BlockGetter)worldReader, (BlockState)blockState, (BlockPos)blockPos)) != null) {
                return layerCustom;
            }
            if (!this.fixBlockLayer) {
                return layer;
            }
            if (this.isMipmaps) {
                if (layer == RenderTypes.CUTOUT) {
                    Block block = blockState.m_60734_();
                    if (block instanceof RedStoneWireBlock) {
                        return layer;
                    }
                    if (block instanceof CactusBlock) {
                        return layer;
                    }
                    return RenderTypes.CUTOUT_MIPPED;
                }
            } else if (layer == RenderTypes.CUTOUT_MIPPED) {
                return RenderTypes.CUTOUT;
            }
            return layer;
        }

        private void postRenderOverlays(ChunkBufferBuilderPack regionRenderCacheBuilder, CompiledChunk compiledChunk) {
            this.postRenderOverlay((RenderType)((Object)RenderTypes.CUTOUT), regionRenderCacheBuilder, compiledChunk);
            this.postRenderOverlay((RenderType)((Object)RenderTypes.CUTOUT_MIPPED), regionRenderCacheBuilder, compiledChunk);
            this.postRenderOverlay((RenderType)((Object)RenderTypes.TRANSLUCENT), regionRenderCacheBuilder, compiledChunk);
        }

        private void postRenderOverlay(RenderType layer, ChunkBufferBuilderPack regionRenderCacheBuilder, CompiledChunk compiledchunk) {
            BufferBuilder bufferOverlay = regionRenderCacheBuilder.m_108839_(layer);
            if (bufferOverlay.m_85732_()) {
                compiledchunk.setLayerStarted(layer);
                if (bufferOverlay.getVertexCount() > 0) {
                    compiledchunk.setLayerUsed(layer);
                }
            }
        }

        private ChunkCacheOF makeChunkCacheOF(BlockPos posIn) {
            BlockPos posFrom = posIn.m_224058_(-1, -1, -1);
            BlockPos posTo = posIn.m_224058_(16, 16, 16);
            RenderChunkRegion chunkCache = this.createRegionRenderCache(ChunkRenderDispatcher.this.f_112681_, posFrom, posTo, 1);
            ChunkCacheOF chunkCacheOF = new ChunkCacheOF(chunkCache, posFrom, posTo, 1);
            return chunkCacheOF;
        }

        public RenderChunkRegion createRegionRenderCache(Level world, BlockPos posFrom, BlockPos posTo, int i) {
            return RenderChunkRegion.generateCache(world, posFrom, posTo, i, false);
        }

        public RenderChunk getRenderChunkOffset16(ViewArea viewFrustum, Direction facing) {
            if (!this.renderChunksOffset16Updated) {
                for (int i = 0; i < Direction.f_122346_.length; ++i) {
                    Direction ef = Direction.f_122346_[i];
                    BlockPos posOffset16 = this.m_112824_(ef);
                    this.renderChunksOfset16[i] = viewFrustum.m_110866_(posOffset16);
                }
                this.renderChunksOffset16Updated = true;
            }
            return this.renderChunksOfset16[facing.ordinal()];
        }

        public LevelChunk getChunk() {
            return this.getChunk((BlockPos)this.f_112793_);
        }

        private LevelChunk getChunk(BlockPos posIn) {
            LevelChunk chunkLocal = this.chunk;
            if (chunkLocal != null && ChunkUtils.isLoaded((LevelChunk)chunkLocal)) {
                return chunkLocal;
            }
            this.chunk = chunkLocal = ChunkRenderDispatcher.this.f_112681_.m_46745_(posIn);
            return chunkLocal;
        }

        public boolean isChunkRegionEmpty() {
            return this.isChunkRegionEmpty((BlockPos)this.f_112793_);
        }

        private boolean isChunkRegionEmpty(BlockPos posIn) {
            int yStart = posIn.m_123342_();
            int yEnd = yStart + 15;
            return this.getChunk(posIn).m_5566_(yStart, yEnd);
        }

        public void setRenderChunkNeighbour(Direction facing, RenderChunk neighbour) {
            this.renderChunkNeighbours[facing.ordinal()] = neighbour;
            this.renderChunkNeighboursValid[facing.ordinal()] = neighbour;
        }

        public RenderChunk getRenderChunkNeighbour(Direction facing) {
            if (!this.renderChunkNeighboursUpated) {
                this.updateRenderChunkNeighboursValid();
            }
            return this.renderChunkNeighboursValid[facing.ordinal()];
        }

        public LevelRenderer.RenderChunkInfo getRenderInfo() {
            return this.renderInfo;
        }

        private void updateRenderChunkNeighboursValid() {
            int x = this.m_112839_().m_123341_();
            int z = this.m_112839_().m_123343_();
            int north = Direction.NORTH.ordinal();
            int south = Direction.SOUTH.ordinal();
            int west = Direction.WEST.ordinal();
            int east = Direction.EAST.ordinal();
            this.renderChunkNeighboursValid[north] = this.renderChunkNeighbours[north].m_112839_().m_123343_() == z - 16 ? this.renderChunkNeighbours[north] : null;
            this.renderChunkNeighboursValid[south] = this.renderChunkNeighbours[south].m_112839_().m_123343_() == z + 16 ? this.renderChunkNeighbours[south] : null;
            this.renderChunkNeighboursValid[west] = this.renderChunkNeighbours[west].m_112839_().m_123341_() == x - 16 ? this.renderChunkNeighbours[west] : null;
            this.renderChunkNeighboursValid[east] = this.renderChunkNeighbours[east].m_112839_().m_123341_() == x + 16 ? this.renderChunkNeighbours[east] : null;
            this.renderChunkNeighboursUpated = true;
        }

        public boolean isBoundingBoxInFrustum(ICamera camera, int frameCount) {
            if (this.getBoundingBoxParent().isBoundingBoxInFrustumFully(camera, frameCount)) {
                return true;
            }
            return camera.isBoundingBoxInFrustum(this.f_112785_);
        }

        public AabbFrame getBoundingBoxParent() {
            if (this.boundingBoxParent == null) {
                AabbFrame bbp;
                BlockPos pos = this.m_112839_();
                int x = pos.m_123341_();
                int y = pos.m_123342_();
                int z = pos.m_123343_();
                int bits = 5;
                int xp = x >> bits << bits;
                int yp = y >> bits << bits;
                int zp = z >> bits << bits;
                if ((xp != x || yp != y || zp != z) && (bbp = ChunkRenderDispatcher.this.f_112682_.getRenderChunk(new BlockPos(xp, yp, zp)).getBoundingBoxParent()) != null && bbp.f_82288_ == (double)xp && bbp.f_82289_ == (double)yp && bbp.f_82290_ == (double)zp) {
                    this.boundingBoxParent = bbp;
                }
                if (this.boundingBoxParent == null) {
                    int delta = 1 << bits;
                    this.boundingBoxParent = new AabbFrame(xp, yp, zp, xp + delta, yp + delta, zp + delta);
                }
            }
            return this.boundingBoxParent;
        }

        public Level getWorld() {
            return ChunkRenderDispatcher.this.f_112681_;
        }

        public String toString() {
            return "pos: " + this.m_112839_() + ", frameIndex: " + this.f_112791_;
        }

        class ResortTransparencyTask
        extends ChunkCompileTask {
            private final CompiledChunk f_112886_;

            public ResortTransparencyTask(double distanceSqIn, CompiledChunk compiledChunkIn) {
                this(null, distanceSqIn, compiledChunkIn);
            }

            public ResortTransparencyTask(ChunkPos pos, double distanceSqIn, CompiledChunk compiledChunkIn) {
                super(pos, distanceSqIn);
                this.f_112886_ = compiledChunkIn;
            }

            @Override
            public CompletableFuture<ChunkTaskResult> m_5869_(ChunkBufferBuilderPack builderIn) {
                if (this.f_112848_.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (!RenderChunk.this.m_112798_()) {
                    this.f_112848_.set(true);
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (this.f_112848_.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                Vec3 vec3 = ChunkRenderDispatcher.this.m_112727_();
                float f = (float)vec3.f_82479_;
                float f1 = (float)vec3.f_82480_;
                float f2 = (float)vec3.f_82481_;
                BufferBuilder.SortState bufferbuilder$sortstate = this.f_112886_.f_112754_;
                if (bufferbuilder$sortstate != null && this.f_112886_.f_112749_.contains(RenderType.m_110466_())) {
                    BufferBuilder bufferbuilder = builderIn.m_108839_(RenderType.m_110466_());
                    bufferbuilder.setBlockLayer(RenderType.m_110466_());
                    RenderChunk.this.m_112805_(bufferbuilder);
                    bufferbuilder.m_190454_(bufferbuilder$sortstate);
                    bufferbuilder.m_190426_((float)RenderChunk.this.regionDX + f - (float)RenderChunk.this.f_112793_.m_123341_(), (float)RenderChunk.this.regionDY + f1 - (float)RenderChunk.this.f_112793_.m_123342_(), (float)RenderChunk.this.regionDZ + f2 - (float)RenderChunk.this.f_112793_.m_123343_());
                    this.f_112886_.f_112754_ = bufferbuilder.m_190425_();
                    bufferbuilder.m_85721_();
                    if (this.f_112848_.get()) {
                        return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                    }
                    CompletionStage completablefuture = ChunkRenderDispatcher.this.m_112695_(builderIn.m_108839_(RenderType.m_110466_()), RenderChunk.this.m_112807_(RenderType.m_110466_())).thenApply(voidIn -> ChunkTaskResult.CANCELLED);
                    return ((CompletableFuture)completablefuture).handle((taskResultIn, throwableIn) -> {
                        if (throwableIn != null && !(throwableIn instanceof CancellationException) && !(throwableIn instanceof InterruptedException)) {
                            Minecraft.m_91087_().m_91253_(CrashReport.m_127521_(throwableIn, "Rendering chunk"));
                        }
                        return this.f_112848_.get() ? ChunkTaskResult.CANCELLED : ChunkTaskResult.SUCCESSFUL;
                    });
                }
                return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
            }

            @Override
            public void m_6204_() {
                this.f_112848_.set(true);
            }
        }

        class RebuildTask
        extends ChunkCompileTask {
            @Nullable
            protected RenderChunkRegion f_112858_;

            public RebuildTask(double distanceSqIn, RenderChunkRegion renderCacheIn) {
                this(null, distanceSqIn, renderCacheIn);
            }

            public RebuildTask(ChunkPos pos, @Nullable double distanceSqIn, RenderChunkRegion renderCacheIn) {
                super(pos, distanceSqIn);
                this.f_112858_ = renderCacheIn;
            }

            @Override
            public CompletableFuture<ChunkTaskResult> m_5869_(ChunkBufferBuilderPack builderIn) {
                if (this.f_112848_.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (!RenderChunk.this.m_112798_()) {
                    this.f_112858_ = null;
                    RenderChunk.this.m_112828_(false);
                    this.f_112848_.set(true);
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (this.f_112848_.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                Vec3 vec3 = ChunkRenderDispatcher.this.m_112727_();
                float f = (float)vec3.f_82479_;
                float f1 = (float)vec3.f_82480_;
                float f2 = (float)vec3.f_82481_;
                CompiledChunk chunkrenderdispatcher$compiledchunk = new CompiledChunk();
                Set<BlockEntity> set = this.m_112865_(f, f1, f2, chunkrenderdispatcher$compiledchunk, builderIn);
                RenderChunk.this.m_112826_(set);
                if (this.f_112848_.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                ArrayList list = Lists.newArrayList();
                chunkrenderdispatcher$compiledchunk.f_112750_.forEach(renderTypeIn -> list.add(ChunkRenderDispatcher.this.m_112695_(builderIn.m_108839_(renderTypeIn), RenderChunk.this.m_112807_((RenderType)renderTypeIn))));
                return Util.m_221809_(list).handle((listIn, throwableIn) -> {
                    if (throwableIn != null && !(throwableIn instanceof CancellationException) && !(throwableIn instanceof InterruptedException)) {
                        Minecraft.m_91087_().m_91253_(CrashReport.m_127521_(throwableIn, "Rendering chunk"));
                    }
                    if (this.f_112848_.get()) {
                        return ChunkTaskResult.CANCELLED;
                    }
                    RenderChunk.this.f_112784_.set(chunkrenderdispatcher$compiledchunk);
                    return ChunkTaskResult.SUCCESSFUL;
                });
            }

            private Set<BlockEntity> m_112865_(float xIn, float yIn, float zIn, CompiledChunk compiledChunkIn, ChunkBufferBuilderPack builderIn) {
                boolean i = true;
                BlockPos blockpos = RenderChunk.this.f_112793_.m_7949_();
                BlockPos blockpos1 = blockpos.m_224058_(15, 15, 15);
                VisGraph visgraph = new VisGraph();
                HashSet set = Sets.newHashSet();
                this.f_112858_ = null;
                PoseStack posestack = new PoseStack();
                if (!RenderChunk.this.isChunkRegionEmpty(blockpos)) {
                    ++renderChunksUpdated;
                    ChunkCacheOF renderchunkregion = RenderChunk.this.makeChunkCacheOF(blockpos);
                    renderchunkregion.renderStart();
                    RenderType[] singleLayer = new RenderType[1];
                    boolean shaders = Config.isShaders();
                    boolean shadersMidBlock = shaders && Shaders.useMidBlockAttrib;
                    ModelBlockRenderer.m_111000_();
                    Random random = new Random();
                    BlockRenderDispatcher blockrenderdispatcher = Minecraft.m_91087_().m_91289_();
                    for (BlockPosM blockpos2 : BlockPosM.getAllInBoxMutable((BlockPos)blockpos, (BlockPos)blockpos1)) {
                        RenderEnv renderEnv;
                        int ix;
                        IModelData modelData;
                        BlockEntity blockentity;
                        BlockState blockstate = renderchunkregion.m_8055_((BlockPos)blockpos2);
                        if (blockstate.m_60795_()) continue;
                        if (blockstate.m_60804_((BlockGetter)renderchunkregion, (BlockPos)blockpos2)) {
                            visgraph.m_112971_((BlockPos)blockpos2);
                        }
                        if (blockstate.m_173633_() && (blockentity = renderchunkregion.getTileEntity((BlockPos)blockpos2, LevelChunk.EntityCreationType.CHECK)) != null) {
                            this.m_112877_(compiledChunkIn, set, blockentity);
                        }
                        FluidState fluidstate = blockstate.m_60819_();
                        IModelData iModelData = modelData = FORGE ? this.getModelData((BlockPos)blockpos2) : null;
                        if (!fluidstate.m_76178_()) {
                            RenderType[] fluidLayers = RenderChunk.this.getFluidRenderLayers(fluidstate, singleLayer);
                            for (ix = 0; ix < fluidLayers.length; ++ix) {
                                RenderType rendertype = fluidLayers[ix];
                                if (FORGE_CAN_RENDER_IN_LAYER_FS && !Reflector.callBoolean(Reflector.ForgeRenderTypeLookup_canRenderInLayerFs, fluidstate, rendertype)) continue;
                                if (FORGE_SET_RENDER_LAYER) {
                                    Reflector.callVoid(Reflector.ForgeHooksClient_setRenderLayer, rendertype);
                                }
                                BufferBuilder bufferbuilder = builderIn.m_108839_(rendertype);
                                bufferbuilder.setBlockLayer(rendertype);
                                renderEnv = bufferbuilder.getRenderEnv(blockstate, (BlockPos)blockpos2);
                                renderEnv.setRegionRenderCacheBuilder(builderIn);
                                renderchunkregion.setRenderEnv(renderEnv);
                                if (compiledChunkIn.f_112750_.add(rendertype)) {
                                    RenderChunk.this.m_112805_(bufferbuilder);
                                }
                                if (!blockrenderdispatcher.m_110932_((BlockPos)blockpos2, (BlockAndTintGetter)renderchunkregion, (VertexConsumer)((Object)bufferbuilder), fluidstate)) continue;
                                compiledChunkIn.f_112751_ = false;
                                compiledChunkIn.f_112749_.add(rendertype);
                            }
                        }
                        if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
                            RenderType[] blockLayers = RenderChunk.this.getBlockRenderLayers(blockstate, singleLayer);
                            for (ix = 0; ix < blockLayers.length; ++ix) {
                                RenderType rendertype1 = blockLayers[ix];
                                if (FORGE_CAN_RENDER_IN_LAYER_BS && !Reflector.callBoolean(Reflector.ForgeRenderTypeLookup_canRenderInLayerBs, blockstate, rendertype1)) continue;
                                if (FORGE_SET_RENDER_LAYER) {
                                    Reflector.callVoid(Reflector.ForgeHooksClient_setRenderLayer, rendertype1);
                                }
                                rendertype1 = RenderChunk.this.fixBlockLayer((BlockGetter)renderchunkregion, blockstate, (BlockPos)blockpos2, rendertype1);
                                BufferBuilder bufferbuilder2 = builderIn.m_108839_(rendertype1);
                                bufferbuilder2.setBlockLayer(rendertype1);
                                renderEnv = bufferbuilder2.getRenderEnv(blockstate, (BlockPos)blockpos2);
                                renderEnv.setRegionRenderCacheBuilder(builderIn);
                                renderchunkregion.setRenderEnv(renderEnv);
                                if (compiledChunkIn.f_112750_.add(rendertype1)) {
                                    RenderChunk.this.m_112805_(bufferbuilder2);
                                }
                                posestack.m_85836_();
                                posestack.m_85837_((double)RenderChunk.this.regionDX + (double)(blockpos2.m_123341_() & 0xF), (double)RenderChunk.this.regionDY + (double)(blockpos2.m_123342_() & 0xF), (double)RenderChunk.this.regionDZ + (double)(blockpos2.m_123343_() & 0xF));
                                if (shadersMidBlock) {
                                    bufferbuilder2.setMidBlock(0.5f + (float)RenderChunk.this.regionDX + (float)(blockpos2.m_123341_() & 0xF), 0.5f + (float)RenderChunk.this.regionDY + (float)(blockpos2.m_123342_() & 0xF), 0.5f + (float)RenderChunk.this.regionDZ + (float)(blockpos2.m_123343_() & 0xF));
                                }
                                if (blockrenderdispatcher.renderBatched(blockstate, (BlockPos)blockpos2, (BlockAndTintGetter)renderchunkregion, posestack, (VertexConsumer)((Object)bufferbuilder2), true, random, modelData)) {
                                    compiledChunkIn.f_112751_ = false;
                                    compiledChunkIn.f_112749_.add(rendertype1);
                                    if (renderEnv.isOverlaysRendered()) {
                                        RenderChunk.this.postRenderOverlays(builderIn, compiledChunkIn);
                                        renderEnv.setOverlaysRendered(false);
                                    }
                                }
                                posestack.m_85849_();
                            }
                        }
                        if (!FORGE_SET_RENDER_LAYER) continue;
                        Reflector.callVoid(Reflector.ForgeHooksClient_setRenderLayer, new Object[]{null});
                    }
                    if (compiledChunkIn.f_112749_.contains(RenderType.m_110466_())) {
                        BufferBuilder bufferbuilder1 = builderIn.m_108839_(RenderType.m_110466_());
                        bufferbuilder1.m_190426_((float)RenderChunk.this.regionDX + xIn - (float)blockpos.m_123341_(), (float)RenderChunk.this.regionDY + yIn - (float)blockpos.m_123342_(), (float)RenderChunk.this.regionDZ + zIn - (float)blockpos.m_123343_());
                        compiledChunkIn.f_112754_ = bufferbuilder1.m_190425_();
                    }
                    compiledChunkIn.f_112750_.stream().map(arg_0 -> ((ChunkBufferBuilderPack)builderIn).m_108839_(arg_0)).forEach(BufferBuilder::m_85721_);
                    for (RenderType blockrenderlayer : BLOCK_RENDER_LAYERS) {
                        compiledChunkIn.setAnimatedSprites(blockrenderlayer, null);
                    }
                    for (RenderType blockrenderlayer : compiledChunkIn.f_112750_) {
                        if (Config.isShaders()) {
                            SVertexBuilder.calcNormalChunkLayer((BufferBuilder)builderIn.m_108839_(blockrenderlayer));
                        }
                        BufferBuilder bufferBuilder = builderIn.m_108839_(blockrenderlayer);
                        if (bufferBuilder.animatedSprites == null || bufferBuilder.animatedSprites.isEmpty()) continue;
                        compiledChunkIn.setAnimatedSprites(blockrenderlayer, (BitSet)bufferBuilder.animatedSprites.clone());
                    }
                    renderchunkregion.renderFinish();
                    ModelBlockRenderer.m_111077_();
                }
                compiledChunkIn.f_112753_ = visgraph.m_112958_();
                return set;
            }

            private <E extends BlockEntity> void m_112877_(CompiledChunk compiledChunkIn, Set<BlockEntity> tileEntitiesIn, E tileEntityIn) {
                BlockEntityRenderer<E> blockentityrenderer = Minecraft.m_91087_().m_193404_().m_112265_(tileEntityIn);
                if (blockentityrenderer != null) {
                    if (blockentityrenderer.m_5932_(tileEntityIn)) {
                        tileEntitiesIn.add(tileEntityIn);
                    } else {
                        compiledChunkIn.f_112752_.add(tileEntityIn);
                    }
                }
            }

            @Override
            public void m_6204_() {
                this.f_112858_ = null;
                if (this.f_112848_.compareAndSet(false, true)) {
                    RenderChunk.this.m_112828_(false);
                }
            }
        }

        abstract class ChunkCompileTask
        implements Comparable<ChunkCompileTask> {
            protected final double f_112847_;
            protected final AtomicBoolean f_112848_ = new AtomicBoolean(false);
            protected Map<BlockPos, IModelData> modelData;

            public ChunkCompileTask(double distanceSqIn) {
                this(null, distanceSqIn);
            }

            public ChunkCompileTask(ChunkPos pos, double distanceSqIn) {
                this.f_112847_ = distanceSqIn;
                this.modelData = pos == null ? Collections.emptyMap() : ModelDataManager.getModelData((Level)Minecraft.m_91087_().f_91073_, (ChunkPos)pos);
            }

            public abstract CompletableFuture<ChunkTaskResult> m_5869_(ChunkBufferBuilderPack var1);

            public abstract void m_6204_();

            @Override
            public int compareTo(ChunkCompileTask p_compareTo_1_) {
                return Doubles.compare((double)this.f_112847_, (double)p_compareTo_1_.f_112847_);
            }

            public IModelData getModelData(BlockPos pos) {
                return this.modelData.getOrDefault(pos, EmptyModelData.INSTANCE);
            }
        }
    }

    public static class CompiledChunk {
        public static final CompiledChunk f_112748_ = new CompiledChunk(){

            @Override
            public boolean m_7259_(Direction facing, Direction facing2) {
                return false;
            }

            @Override
            public void setAnimatedSprites(RenderType layer, BitSet animatedSprites) {
                throw new UnsupportedOperationException();
            }
        };
        final ChunkLayerSet f_112749_ = new ChunkLayerSet();
        final Set<RenderType> f_112750_ = new ObjectArraySet();
        boolean f_112751_ = true;
        final List<BlockEntity> f_112752_ = Lists.newArrayList();
        VisibilitySet f_112753_ = new VisibilitySet();
        @Nullable
        BufferBuilder.SortState f_112754_;
        private BitSet[] animatedSprites = new BitSet[RenderType.CHUNK_RENDER_TYPES.length];

        public boolean m_112757_() {
            return this.f_112751_;
        }

        public boolean m_112758_(RenderType renderTypeIn) {
            return !this.f_112749_.contains(renderTypeIn);
        }

        public List<BlockEntity> m_112773_() {
            return this.f_112752_;
        }

        public boolean m_7259_(Direction facing, Direction facing2) {
            return this.f_112753_.m_112983_(facing, facing2);
        }

        public BitSet getAnimatedSprites(RenderType layer) {
            return this.animatedSprites[layer.ordinal()];
        }

        public void setAnimatedSprites(RenderType layer, BitSet animatedSprites) {
            this.animatedSprites[layer.ordinal()] = animatedSprites;
        }

        public boolean isLayerStarted(RenderType renderTypeIn) {
            return this.f_112750_.contains(renderTypeIn);
        }

        public void setLayerStarted(RenderType renderTypeIn) {
            this.f_112750_.add(renderTypeIn);
        }

        public void setLayerUsed(RenderType renderTypeIn) {
            this.f_112749_.add(renderTypeIn);
        }
    }

    static enum ChunkTaskResult {
        SUCCESSFUL,
        CANCELLED;

    }
}

