/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.renderer.texture.AtlasSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.optifine.Config;
import net.optifine.ItemOverrideCache;

public class ItemOverrides {
    public static final ItemOverrides f_111734_ = new ItemOverrides();
    private final BakedOverride[] f_111735_;
    private final ResourceLocation[] f_206865_;
    private ItemOverrideCache itemOverrideCache;
    public static ResourceLocation lastModelLocation = null;

    private ItemOverrides() {
        this.f_111735_ = new BakedOverride[0];
        this.f_206865_ = new ResourceLocation[0];
    }

    public ItemOverrides(ModelBakery modelBakeryIn, BlockModel blockModelIn, Function<ResourceLocation, UnbakedModel> modelGetter, List<ItemOverride> itemOverridesIn) {
        this(modelBakeryIn, (UnbakedModel)blockModelIn, modelGetter, arg_0 -> ((AtlasSet)modelBakeryIn.getSpriteMap()).m_117971_(arg_0), itemOverridesIn);
    }

    public ItemOverrides(ModelBakery modelBakeryIn, UnbakedModel blockModelIn, Function<ResourceLocation, UnbakedModel> modelGetter, Function<Material, TextureAtlasSprite> textureGetter, List<ItemOverride> itemOverridesIn) {
        this.f_206865_ = (ResourceLocation[])itemOverridesIn.stream().flatMap(ItemOverride::m_206847_).map(ItemOverride.Predicate::m_206863_).distinct().toArray(ResourceLocation[]::new);
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        for (int i = 0; i < this.f_206865_.length; ++i) {
            object2intmap.put((Object)this.f_206865_[i], i);
        }
        ArrayList list = Lists.newArrayList();
        for (int j = itemOverridesIn.size() - 1; j >= 0; --j) {
            ItemOverride itemoverride = itemOverridesIn.get(j);
            BakedModel bakedmodel = this.bakeModel(modelBakeryIn, blockModelIn, modelGetter, textureGetter, itemoverride);
            PropertyMatcher[] aitemoverrides$propertymatcher = (PropertyMatcher[])itemoverride.m_206847_().map(arg_0 -> ItemOverrides.lambda$new$1((Object2IntMap)object2intmap, arg_0)).toArray(PropertyMatcher[]::new);
            list.add(new BakedOverride(aitemoverrides$propertymatcher, bakedmodel));
            BakedOverride bo = (BakedOverride)list.get(list.size() - 1);
            bo.location = itemoverride.m_111718_();
        }
        this.f_111735_ = list.toArray(new BakedOverride[0]);
        if (itemOverridesIn.size() > 65) {
            this.itemOverrideCache = ItemOverrideCache.make(itemOverridesIn);
        }
    }

    @Nullable
    private BakedModel bakeModel(ModelBakery modelBakeryIn, UnbakedModel blockModelIn, Function<ResourceLocation, UnbakedModel> unbakedLocatorIn, Function<Material, TextureAtlasSprite> textureGetter, ItemOverride itemOverrideIn) {
        UnbakedModel unbakedmodel = unbakedLocatorIn.apply(itemOverrideIn.m_111718_());
        return Objects.equals(unbakedmodel, blockModelIn) ? null : modelBakeryIn.bake(itemOverrideIn.m_111718_(), (ModelState)BlockModelRotation.X0_Y0, textureGetter);
    }

    @Nullable
    public BakedModel m_206872_(BakedModel modelIn, ItemStack stackIn, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int seedIn) {
        boolean customItems = Config.isCustomItems();
        if (customItems) {
            lastModelLocation = null;
        }
        if (this.f_111735_.length != 0) {
            Integer modelIndex;
            if (this.itemOverrideCache != null && (modelIndex = this.itemOverrideCache.getModelIndex(stackIn, worldIn, entityIn)) != null) {
                int indexCached = modelIndex;
                if (indexCached >= 0 && indexCached < this.f_111735_.length) {
                    BakedModel modelCached;
                    if (customItems) {
                        lastModelLocation = this.f_111735_[indexCached].location;
                    }
                    if ((modelCached = this.f_111735_[indexCached].f_206889_) != null) {
                        return modelCached;
                    }
                }
                return modelIn;
            }
            Item item = stackIn.m_41720_();
            int i = this.f_206865_.length;
            float[] afloat = new float[i];
            for (int j = 0; j < i; ++j) {
                ResourceLocation resourcelocation = this.f_206865_[j];
                ItemPropertyFunction itempropertyfunction = ItemProperties.m_117829_((Item)item, (ResourceLocation)resourcelocation);
                afloat[j] = itempropertyfunction != null ? itempropertyfunction.m_141884_(stackIn, worldIn, entityIn, seedIn) : Float.NEGATIVE_INFINITY;
            }
            for (int ix = 0; ix < this.f_111735_.length; ++ix) {
                BakedOverride itemoverrides$bakedoverride = this.f_111735_[ix];
                if (!itemoverrides$bakedoverride.m_206902_(afloat)) continue;
                BakedModel bakedmodel = itemoverrides$bakedoverride.f_206889_;
                if (customItems) {
                    lastModelLocation = itemoverrides$bakedoverride.location;
                }
                if (this.itemOverrideCache != null) {
                    this.itemOverrideCache.putModelIndex(stackIn, worldIn, entityIn, ix);
                }
                if (bakedmodel == null) {
                    return modelIn;
                }
                return bakedmodel;
            }
        }
        return modelIn;
    }

    private static /* synthetic */ PropertyMatcher lambda$new$1(Object2IntMap object2intmap, ItemOverride.Predicate p_206883_1_) {
        int k = object2intmap.getInt((Object)p_206883_1_.m_206863_());
        return new PropertyMatcher(k, p_206883_1_.m_206864_());
    }

    static class PropertyMatcher {
        public final int f_206904_;
        public final float f_206905_;

        PropertyMatcher(int indexIn, float valueIn) {
            this.f_206904_ = indexIn;
            this.f_206905_ = valueIn;
        }
    }

    static class BakedOverride {
        private final PropertyMatcher[] f_206888_;
        @Nullable
        final BakedModel f_206889_;
        private ResourceLocation location;

        BakedOverride(PropertyMatcher[] matchersIn, @Nullable BakedModel modelIn) {
            this.f_206888_ = matchersIn;
            this.f_206889_ = modelIn;
        }

        boolean m_206902_(float[] valuesIn) {
            for (PropertyMatcher itemoverrides$propertymatcher : this.f_206888_) {
                float f = valuesIn[itemoverrides$propertymatcher.f_206904_];
                if (!(f < itemoverrides$propertymatcher.f_206905_)) continue;
                return false;
            }
            return true;
        }
    }
}

