/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.optifine.Config;
import net.optifine.SmartAnimations;
import net.optifine.reflect.Reflector;
import net.optifine.shaders.Shaders;
import org.apache.commons.lang3.tuple.Pair;

public class ScreenEffectRenderer {
    private static final ResourceLocation f_110714_ = new ResourceLocation("textures/misc/underwater.png");

    public static void m_110718_(Minecraft minecraftIn, PoseStack matrixStackIn) {
        LocalPlayer player = minecraftIn.f_91074_;
        if (!player.f_19794_) {
            if (Reflector.ForgeEventFactory_renderBlockOverlay.exists() && Reflector.ForgeBlockModelShapes_getTexture3.exists()) {
                Object overlayType;
                Pair<BlockState, BlockPos> overlay = ScreenEffectRenderer.getOverlayBlock((Player)player);
                if (overlay != null && !Reflector.ForgeEventFactory_renderBlockOverlay.callBoolean(player, matrixStackIn, overlayType = Reflector.getFieldValue(Reflector.RenderBlockOverlayEvent_OverlayType_BLOCK), overlay.getLeft(), overlay.getRight())) {
                    TextureAtlasSprite sprite = (TextureAtlasSprite)Reflector.call(minecraftIn.m_91289_().m_110907_(), Reflector.ForgeBlockModelShapes_getTexture3, new Object[]{overlay.getLeft(), minecraftIn.f_91073_, overlay.getRight()});
                    ScreenEffectRenderer.m_316308_(sprite, matrixStackIn);
                }
            } else {
                BlockState blockstate = ScreenEffectRenderer.m_110716_((Player)player);
                if (blockstate != null) {
                    ScreenEffectRenderer.m_316308_(minecraftIn.m_91289_().m_110907_().m_110882_(blockstate), matrixStackIn);
                }
            }
        }
        if (!minecraftIn.f_91074_.m_5833_()) {
            if (minecraftIn.f_91074_.m_19941_((Tag)FluidTags.f_13131_) && !Reflector.ForgeEventFactory_renderWaterOverlay.callBoolean(player, matrixStackIn)) {
                ScreenEffectRenderer.m_110725_(minecraftIn, matrixStackIn);
            }
            if (minecraftIn.f_91074_.m_6060_() && !Reflector.ForgeEventFactory_renderFireOverlay.callBoolean(player, matrixStackIn)) {
                ScreenEffectRenderer.m_110728_(minecraftIn, matrixStackIn);
            }
        }
    }

    @Nullable
    private static BlockState m_110716_(Player playerIn) {
        Pair<BlockState, BlockPos> overlay = ScreenEffectRenderer.getOverlayBlock(playerIn);
        return overlay == null ? null : (BlockState)overlay.getLeft();
    }

    private static Pair<BlockState, BlockPos> getOverlayBlock(Player playerIn) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 8; ++i) {
            double d0 = playerIn.m_20185_() + (double)(((float)((i >> 0) % 2) - 0.5f) * playerIn.m_20205_() * 0.8f);
            double d1 = playerIn.m_20188_() + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
            double d2 = playerIn.m_20189_() + (double)(((float)((i >> 2) % 2) - 0.5f) * playerIn.m_20205_() * 0.8f);
            blockpos$mutableblockpos.m_122169_(d0, d1, d2);
            BlockState blockstate = playerIn.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (blockstate.m_60799_() == RenderShape.INVISIBLE || !blockstate.m_60831_((BlockGetter)playerIn.f_19853_, (BlockPos)blockpos$mutableblockpos)) continue;
            return Pair.of((Object)blockstate, (Object)blockpos$mutableblockpos.m_7949_());
        }
        return null;
    }

    private static void m_316308_(TextureAtlasSprite spriteIn, PoseStack matrixStackIn) {
        if (SmartAnimations.isActive()) {
            SmartAnimations.spriteRendered((TextureAtlasSprite)spriteIn);
        }
        RenderSystem.m_256269_((int)0, (ResourceLocation)spriteIn.m_118414_().m_118330_());
        RenderSystem.m_256236_(GameRenderer::m_282215_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        float f = 0.1f;
        float f1 = -1.0f;
        float f2 = 1.0f;
        float f3 = -1.0f;
        float f4 = 1.0f;
        float f5 = -0.5f;
        float f6 = spriteIn.m_118409_();
        float f7 = spriteIn.m_118410_();
        float f8 = spriteIn.m_118411_();
        float f9 = spriteIn.m_118412_();
        Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
        bufferbuilder.m_190458_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferbuilder.m_85982_(matrix4f, -1.0f, -1.0f, -0.5f).m_85950_(0.1f, 0.1f, 0.1f, 1.0f).m_7421_(f7, f9).m_5752_();
        bufferbuilder.m_85982_(matrix4f, 1.0f, -1.0f, -0.5f).m_85950_(0.1f, 0.1f, 0.1f, 1.0f).m_7421_(f6, f9).m_5752_();
        bufferbuilder.m_85982_(matrix4f, 1.0f, 1.0f, -0.5f).m_85950_(0.1f, 0.1f, 0.1f, 1.0f).m_7421_(f6, f8).m_5752_();
        bufferbuilder.m_85982_(matrix4f, -1.0f, 1.0f, -0.5f).m_85950_(0.1f, 0.1f, 0.1f, 1.0f).m_7421_(f7, f8).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_(bufferbuilder);
    }

    private static void m_110725_(Minecraft minecraftIn, PoseStack matrixStackIn) {
        if (Config.isShaders() && !Shaders.isUnderwaterOverlay()) {
            return;
        }
        RenderSystem.m_256236_(GameRenderer::m_282216_);
        RenderSystem.m_69493_();
        RenderSystem.m_256269_((int)0, (ResourceLocation)f_110714_);
        if (SmartAnimations.isActive()) {
            SmartAnimations.textureRendered(minecraftIn.m_91097_().m_118506_(f_110714_).m_117963_());
        }
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        float f = minecraftIn.f_91074_.m_6073_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_256242_((float)f, (float)f, (float)f, (float)0.1f);
        float f1 = 4.0f;
        float f2 = -1.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        float f5 = 1.0f;
        float f6 = -0.5f;
        float f7 = -minecraftIn.f_91074_.m_302838_() / 64.0f;
        float f8 = minecraftIn.f_91074_.m_302839_() / 64.0f;
        Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
        bufferbuilder.m_190458_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix4f, -1.0f, -1.0f, -0.5f).m_7421_(4.0f + f7, 4.0f + f8).m_5752_();
        bufferbuilder.m_85982_(matrix4f, 1.0f, -1.0f, -0.5f).m_7421_(0.0f + f7, 4.0f + f8).m_5752_();
        bufferbuilder.m_85982_(matrix4f, 1.0f, 1.0f, -0.5f).m_7421_(0.0f + f7, 0.0f + f8).m_5752_();
        bufferbuilder.m_85982_(matrix4f, -1.0f, 1.0f, -0.5f).m_7421_(4.0f + f7, 0.0f + f8).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_(bufferbuilder);
        RenderSystem.m_69461_();
    }

    private static void m_110728_(Minecraft minecraftIn, PoseStack matrixStackIn) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_256236_(GameRenderer::m_282215_);
        RenderSystem.m_69456_((int)519);
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69493_();
        TextureAtlasSprite textureatlassprite = ModelBakery.f_119220_.m_119204_();
        if (SmartAnimations.isActive()) {
            SmartAnimations.spriteRendered((TextureAtlasSprite)textureatlassprite);
        }
        RenderSystem.m_256269_((int)0, (ResourceLocation)textureatlassprite.m_118414_().m_118330_());
        float f = textureatlassprite.m_118409_();
        float f1 = textureatlassprite.m_118410_();
        float f2 = (f + f1) / 2.0f;
        float f3 = textureatlassprite.m_118411_();
        float f4 = textureatlassprite.m_118412_();
        float f5 = (f3 + f4) / 2.0f;
        float f6 = textureatlassprite.m_118417_();
        float f7 = Mth.m_14179_(f6, f, f2);
        float f8 = Mth.m_14179_(f6, f1, f2);
        float f9 = Mth.m_14179_(f6, f3, f5);
        float f10 = Mth.m_14179_(f6, f4, f5);
        float f11 = 1.0f;
        for (int i = 0; i < 2; ++i) {
            matrixStackIn.m_85836_();
            float f12 = -0.5f;
            float f13 = 0.5f;
            float f14 = -0.5f;
            float f15 = 0.5f;
            float f16 = -0.5f;
            matrixStackIn.m_85837_((float)(-(i * 2 - 1)) * 0.24f, -0.3f, 0.0);
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_((float)(i * 2 - 1) * 10.0f));
            Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
            bufferbuilder.m_190458_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            bufferbuilder.m_85982_(matrix4f, -0.5f, -0.5f, -0.5f).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_7421_(f8, f10).m_5752_();
            bufferbuilder.m_85982_(matrix4f, 0.5f, -0.5f, -0.5f).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_7421_(f7, f10).m_5752_();
            bufferbuilder.m_85982_(matrix4f, 0.5f, 0.5f, -0.5f).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_7421_(f7, f9).m_5752_();
            bufferbuilder.m_85982_(matrix4f, -0.5f, 0.5f, -0.5f).m_85950_(1.0f, 1.0f, 1.0f, 0.9f).m_7421_(f8, f9).m_5752_();
            bufferbuilder.m_85721_();
            BufferUploader.m_85761_(bufferbuilder);
            matrixStackIn.m_85849_();
        }
        RenderSystem.m_69461_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69456_((int)515);
    }
}

