/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Triple;

public abstract class RenderStateShard {
    private static final float f_316209_ = 0.99975586f;
    protected final String f_110133_;
    private final Runnable f_110131_;
    private final Runnable f_110132_;
    protected static final TransparencyStateShard f_110134_ = new TransparencyStateShard("no_transparency", () -> RenderSystem.m_69461_(), () -> {});
    protected static final TransparencyStateShard f_110135_ = new TransparencyStateShard("additive_transparency", () -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
    }, () -> {
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
    });
    protected static final TransparencyStateShard f_110136_ = new TransparencyStateShard("lightning_transparency", () -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
    }, () -> {
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
    });
    protected static final TransparencyStateShard f_110137_ = new TransparencyStateShard("glint_transparency", () -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.class_4535)GlStateManager.class_4535.SRC_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
    }, () -> {
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
    });
    protected static final TransparencyStateShard f_110138_ = new TransparencyStateShard("crumbling_transparency", () -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.class_4535)GlStateManager.class_4535.DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
    }, () -> {
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
    });
    protected static final TransparencyStateShard f_110139_ = new TransparencyStateShard("translucent_transparency", () -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
    });
    protected static final ShaderStateShard f_282782_ = new ShaderStateShard();
    protected static final ShaderStateShard f_282783_ = new ShaderStateShard(GameRenderer::m_282218_);
    protected static final ShaderStateShard f_282784_ = new ShaderStateShard(GameRenderer::m_282219_);
    protected static final ShaderStateShard f_282785_ = new ShaderStateShard(GameRenderer::m_282221_);
    protected static final ShaderStateShard f_282786_ = new ShaderStateShard(GameRenderer::m_282213_);
    protected static final ShaderStateShard f_282787_ = new ShaderStateShard(GameRenderer::m_282215_);
    protected static final ShaderStateShard f_282788_ = new ShaderStateShard(GameRenderer::m_282216_);
    protected static final ShaderStateShard f_282789_ = new ShaderStateShard(GameRenderer::m_282222_);
    protected static final ShaderStateShard f_282790_ = new ShaderStateShard(GameRenderer::m_282214_);
    protected static final ShaderStateShard f_282791_ = new ShaderStateShard(GameRenderer::m_282128_);
    protected static final ShaderStateShard f_282792_ = new ShaderStateShard(GameRenderer::m_282129_);
    protected static final ShaderStateShard f_282793_ = new ShaderStateShard(GameRenderer::m_282130_);
    protected static final ShaderStateShard f_282794_ = new ShaderStateShard(GameRenderer::m_282131_);
    protected static final ShaderStateShard f_282795_ = new ShaderStateShard(GameRenderer::m_282132_);
    protected static final ShaderStateShard f_282796_ = new ShaderStateShard(GameRenderer::m_282133_);
    protected static final ShaderStateShard f_282797_ = new ShaderStateShard(GameRenderer::m_282134_);
    protected static final ShaderStateShard f_282798_ = new ShaderStateShard(GameRenderer::m_282135_);
    protected static final ShaderStateShard f_282799_ = new ShaderStateShard(GameRenderer::m_282136_);
    protected static final ShaderStateShard f_282800_ = new ShaderStateShard(GameRenderer::m_282137_);
    protected static final ShaderStateShard f_282752_ = new ShaderStateShard(GameRenderer::m_282138_);
    protected static final ShaderStateShard f_282753_ = new ShaderStateShard(GameRenderer::m_282139_);
    protected static final ShaderStateShard f_282754_ = new ShaderStateShard(GameRenderer::m_282140_);
    protected static final ShaderStateShard f_282755_ = new ShaderStateShard(GameRenderer::m_282141_);
    protected static final ShaderStateShard f_282756_ = new ShaderStateShard(GameRenderer::m_282142_);
    protected static final ShaderStateShard f_282757_ = new ShaderStateShard(GameRenderer::m_282143_);
    protected static final ShaderStateShard f_282758_ = new ShaderStateShard(GameRenderer::m_282144_);
    protected static final ShaderStateShard f_282759_ = new ShaderStateShard(GameRenderer::m_282145_);
    protected static final ShaderStateShard f_282760_ = new ShaderStateShard(GameRenderer::m_282146_);
    protected static final ShaderStateShard f_282761_ = new ShaderStateShard(GameRenderer::m_282147_);
    protected static final ShaderStateShard f_282762_ = new ShaderStateShard(GameRenderer::m_282148_);
    protected static final ShaderStateShard f_282763_ = new ShaderStateShard(GameRenderer::m_282149_);
    protected static final ShaderStateShard f_282764_ = new ShaderStateShard(GameRenderer::m_282150_);
    protected static final ShaderStateShard f_282765_ = new ShaderStateShard(GameRenderer::m_282151_);
    protected static final ShaderStateShard f_282766_ = new ShaderStateShard(GameRenderer::m_282152_);
    protected static final ShaderStateShard f_282767_ = new ShaderStateShard(GameRenderer::m_282153_);
    protected static final ShaderStateShard f_282768_ = new ShaderStateShard(GameRenderer::m_282189_);
    protected static final ShaderStateShard f_282769_ = new ShaderStateShard(GameRenderer::m_282190_);
    protected static final ShaderStateShard f_282770_ = new ShaderStateShard(GameRenderer::m_282191_);
    protected static final ShaderStateShard f_282771_ = new ShaderStateShard(GameRenderer::m_282192_);
    protected static final ShaderStateShard f_282772_ = new ShaderStateShard(GameRenderer::m_282193_);
    protected static final ShaderStateShard f_282773_ = new ShaderStateShard(GameRenderer::m_282194_);
    protected static final ShaderStateShard f_282774_ = new ShaderStateShard(GameRenderer::m_282202_);
    protected static final ShaderStateShard f_282775_ = new ShaderStateShard(GameRenderer::m_282195_);
    protected static final ShaderStateShard f_316208_ = new ShaderStateShard(GameRenderer::m_315948_);
    protected static final ShaderStateShard f_282776_ = new ShaderStateShard(GameRenderer::m_282196_);
    protected static final ShaderStateShard f_316210_ = new ShaderStateShard(GameRenderer::m_315949_);
    protected static final ShaderStateShard f_282777_ = new ShaderStateShard(GameRenderer::m_282197_);
    protected static final ShaderStateShard f_282778_ = new ShaderStateShard(GameRenderer::m_282198_);
    protected static final ShaderStateShard f_282779_ = new ShaderStateShard(GameRenderer::m_282199_);
    protected static final ShaderStateShard f_282780_ = new ShaderStateShard(GameRenderer::m_282200_);
    protected static final ShaderStateShard f_282781_ = new ShaderStateShard(GameRenderer::m_282201_);
    protected static final TextureStateShard f_110145_ = new TextureStateShard(TextureAtlas.f_118259_, false, true);
    protected static final TextureStateShard f_110146_ = new TextureStateShard(TextureAtlas.f_118259_, false, false);
    protected static final EmptyTextureStateShard f_110147_ = new EmptyTextureStateShard();
    protected static final TexturingStateShard f_110148_ = new TexturingStateShard("default_texturing", () -> {}, () -> {});
    protected static final TexturingStateShard f_110150_ = new TexturingStateShard("glint_texturing", () -> RenderStateShard.m_110186_(8.0f), () -> RenderSystem.m_256230_());
    protected static final TexturingStateShard f_110151_ = new TexturingStateShard("entity_glint_texturing", () -> RenderStateShard.m_110186_(0.16f), () -> RenderSystem.m_256230_());
    protected static final LightmapStateShard f_110152_ = new LightmapStateShard(true);
    protected static final LightmapStateShard f_110153_ = new LightmapStateShard(false);
    protected static final OverlayStateShard f_110154_ = new OverlayStateShard(true);
    protected static final OverlayStateShard f_110155_ = new OverlayStateShard(false);
    protected static final CullStateShard f_110158_ = new CullStateShard(true);
    protected static final CullStateShard f_110110_ = new CullStateShard(false);
    protected static final DepthTestStateShard f_110111_ = new DepthTestStateShard("always", 519);
    protected static final DepthTestStateShard f_110112_ = new DepthTestStateShard("==", 514);
    protected static final DepthTestStateShard f_110113_ = new DepthTestStateShard("<=", 515);
    protected static final WriteMaskStateShard f_110114_ = new WriteMaskStateShard(true, true);
    protected static final WriteMaskStateShard f_110115_ = new WriteMaskStateShard(true, false);
    protected static final WriteMaskStateShard f_110116_ = new WriteMaskStateShard(false, true);
    protected static final LayeringStateShard f_110117_ = new LayeringStateShard("no_layering", () -> {}, () -> {});
    protected static final LayeringStateShard f_110118_ = new LayeringStateShard("polygon_offset_layering", () -> {
        RenderSystem.m_69863_((float)-1.0f, (float)-10.0f);
        RenderSystem.m_69486_();
    }, () -> {
        RenderSystem.m_69863_((float)0.0f, (float)0.0f);
        RenderSystem.m_69469_();
    });
    protected static final LayeringStateShard f_110119_ = new LayeringStateShard("view_offset_z_layering", () -> {
        PoseStack posestack = RenderSystem.m_255945_();
        posestack.m_85836_();
        posestack.m_85841_(0.99975586f, 0.99975586f, 0.99975586f);
        RenderSystem.m_255902_();
    }, () -> {
        PoseStack posestack = RenderSystem.m_255945_();
        posestack.m_85849_();
        RenderSystem.m_255902_();
    });
    protected static final OutputStateShard f_110123_ = new OutputStateShard("main_target", () -> {}, () -> {});
    protected static final OutputStateShard f_110124_ = new OutputStateShard("outline_target", () -> Minecraft.m_91087_().f_91060_.m_109827_().m_83947_(false), () -> Minecraft.m_91087_().m_91385_().m_83947_(false));
    protected static final OutputStateShard f_110125_ = new OutputStateShard("translucent_target", () -> {
        if (Minecraft.m_91085_()) {
            Minecraft.m_91087_().f_91060_.m_109828_().m_83947_(false);
        }
    }, () -> {
        if (Minecraft.m_91085_()) {
            Minecraft.m_91087_().m_91385_().m_83947_(false);
        }
    });
    protected static final OutputStateShard f_110126_ = new OutputStateShard("particles_target", () -> {
        if (Minecraft.m_91085_()) {
            Minecraft.m_91087_().f_91060_.m_109830_().m_83947_(false);
        }
    }, () -> {
        if (Minecraft.m_91085_()) {
            Minecraft.m_91087_().m_91385_().m_83947_(false);
        }
    });
    protected static final OutputStateShard f_110127_ = new OutputStateShard("weather_target", () -> {
        if (Minecraft.m_91085_()) {
            Minecraft.m_91087_().f_91060_.m_109831_().m_83947_(false);
        }
    }, () -> {
        if (Minecraft.m_91085_()) {
            Minecraft.m_91087_().m_91385_().m_83947_(false);
        }
    });
    protected static final OutputStateShard f_110128_ = new OutputStateShard("clouds_target", () -> {
        if (Minecraft.m_91085_()) {
            Minecraft.m_91087_().f_91060_.m_109832_().m_83947_(false);
        }
    }, () -> {
        if (Minecraft.m_91085_()) {
            Minecraft.m_91087_().m_91385_().m_83947_(false);
        }
    });
    protected static final OutputStateShard f_110129_ = new OutputStateShard("item_entity_target", () -> {
        if (Minecraft.m_91085_()) {
            Minecraft.m_91087_().f_91060_.m_109829_().m_83947_(false);
        }
    }, () -> {
        if (Minecraft.m_91085_()) {
            Minecraft.m_91087_().m_91385_().m_83947_(false);
        }
    });
    protected static final LineStateShard f_110130_ = new LineStateShard(OptionalDouble.of(1.0));

    public RenderStateShard(String nameIn, Runnable setupTaskIn, Runnable clearTaskIn) {
        this.f_110133_ = nameIn;
        this.f_110131_ = setupTaskIn;
        this.f_110132_ = clearTaskIn;
    }

    public void m_110185_() {
        this.f_110131_.run();
    }

    public void m_110188_() {
        this.f_110132_.run();
    }

    public String toString() {
        return this.f_110133_;
    }

    private static void m_110186_(float scaleIn) {
        long i = Util.m_137550_() * 8L;
        float f = (float)(i % 110000L) / 110000.0f;
        float f1 = (float)(i % 30000L) / 30000.0f;
        Matrix4f matrix4f = Matrix4f.m_27653_(-f, f1, 0.0f);
        matrix4f.m_27646_(Vector3f.f_122227_.m_122240_(10.0f));
        matrix4f.m_27644_(Matrix4f.m_27632_(scaleIn, scaleIn, scaleIn));
        RenderSystem.m_256272_((Matrix4f)matrix4f);
    }

    public String getName() {
        return this.f_110133_;
    }

    protected static class WriteMaskStateShard
    extends RenderStateShard {
        private final boolean f_110356_;
        private final boolean f_110357_;

        public WriteMaskStateShard(boolean colorMaskIn, boolean depthMaskIn) {
            super("write_mask_state", () -> {
                if (!depthMaskIn) {
                    RenderSystem.m_69458_((boolean)depthMaskIn);
                }
                if (!colorMaskIn) {
                    RenderSystem.m_69444_((boolean)colorMaskIn, (boolean)colorMaskIn, (boolean)colorMaskIn, (boolean)colorMaskIn);
                }
            }, () -> {
                if (!depthMaskIn) {
                    RenderSystem.m_69458_((boolean)true);
                }
                if (!colorMaskIn) {
                    RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                }
            });
            this.f_110356_ = colorMaskIn;
            this.f_110357_ = depthMaskIn;
        }

        @Override
        public String toString() {
            return this.f_110133_ + "[writeColor=" + this.f_110356_ + ", writeDepth=" + this.f_110357_ + "]";
        }
    }

    protected static class TransparencyStateShard
    extends RenderStateShard {
        public TransparencyStateShard(String nameIn, Runnable setupTaskIn, Runnable clearTaskIn) {
            super(nameIn, setupTaskIn, clearTaskIn);
        }
    }

    protected static class TexturingStateShard
    extends RenderStateShard {
        public TexturingStateShard(String nameIn, Runnable setupTaskIn, Runnable clearTaskIn) {
            super(nameIn, setupTaskIn, clearTaskIn);
        }
    }

    protected static class TextureStateShard
    extends EmptyTextureStateShard {
        private final Optional<ResourceLocation> f_110328_;
        private final boolean f_110329_;
        private final boolean f_110330_;

        public TextureStateShard(ResourceLocation locationIn, boolean blurIn, boolean mipmapIn) {
            super(() -> {
                RenderSystem.m_69493_();
                TextureManager texturemanager = Minecraft.m_91087_().m_91097_();
                texturemanager.m_118506_(locationIn).m_117960_(blurIn, mipmapIn);
                RenderSystem.m_256269_((int)0, (ResourceLocation)locationIn);
            }, () -> {});
            this.f_110328_ = Optional.of(locationIn);
            this.f_110329_ = blurIn;
            this.f_110330_ = mipmapIn;
        }

        @Override
        public String toString() {
            return this.f_110133_ + "[" + this.f_110328_ + "(blur=" + this.f_110329_ + ", mipmap=" + this.f_110330_ + ")]";
        }

        @Override
        protected Optional<ResourceLocation> m_223863_() {
            return this.f_110328_;
        }

        @Override
        public boolean isBlur() {
            return this.f_110329_;
        }

        @Override
        public boolean isMipmap() {
            return this.f_110330_;
        }
    }

    protected static class ShaderStateShard
    extends RenderStateShard {
        private final Optional<Supplier<ShaderInstance>> f_282868_;

        public ShaderStateShard(Supplier<ShaderInstance> shaderIn) {
            super("shader", () -> RenderSystem.m_256236_((Supplier)shaderIn), () -> {});
            this.f_282868_ = Optional.of(shaderIn);
        }

        public ShaderStateShard() {
            super("shader", () -> RenderSystem.m_256236_(() -> null), () -> {});
            this.f_282868_ = Optional.empty();
        }

        @Override
        public String toString() {
            return this.f_110133_ + "[" + this.f_282868_ + "]";
        }
    }

    protected static class OverlayStateShard
    extends BooleanStateShard {
        public OverlayStateShard(boolean enabledIn) {
            super("overlay", () -> {
                if (enabledIn) {
                    Minecraft.m_91087_().f_91063_.m_109155_().m_118087_();
                }
            }, () -> {
                if (enabledIn) {
                    Minecraft.m_91087_().f_91063_.m_109155_().m_118098_();
                }
            }, enabledIn);
        }
    }

    protected static class OutputStateShard
    extends RenderStateShard {
        public OutputStateShard(String nameIn, Runnable setupTaskIn, Runnable clearTaskIn) {
            super(nameIn, setupTaskIn, clearTaskIn);
        }
    }

    protected static final class OffsetTexturingStateShard
    extends TexturingStateShard {
        public OffsetTexturingStateShard(float offsetUIn, float offsetVIn) {
            super("offset_texturing", () -> RenderSystem.m_256272_((Matrix4f)Matrix4f.m_27653_(offsetUIn, offsetVIn, 0.0f)), () -> RenderSystem.m_256230_());
        }
    }

    protected static class MultiTextureStateShard
    extends EmptyTextureStateShard {
        private final Optional<ResourceLocation> f_282839_;

        MultiTextureStateShard(ImmutableList<Triple<ResourceLocation, Boolean, Boolean>> triplesIn) {
            super(() -> {
                int i = 0;
                for (Triple triple : triplesIn) {
                    TextureManager texturemanager = Minecraft.m_91087_().m_91097_();
                    texturemanager.m_118506_((ResourceLocation)triple.getLeft()).m_117960_((Boolean)triple.getMiddle(), (Boolean)triple.getRight());
                    RenderSystem.m_256269_((int)i++, (ResourceLocation)((ResourceLocation)triple.getLeft()));
                }
            }, () -> {});
            this.f_282839_ = triplesIn.stream().findFirst().map(Triple::getLeft);
        }

        @Override
        protected Optional<ResourceLocation> m_223863_() {
            return this.f_282839_;
        }

        public static Builder m_282848_() {
            return new Builder();
        }

        public static final class Builder {
            private final ImmutableList.Builder<Triple<ResourceLocation, Boolean, Boolean>> f_282850_ = new ImmutableList.Builder();

            public Builder m_282853_(ResourceLocation locationIn, boolean blurIn, boolean mipmapIn) {
                this.f_282850_.add((Object)Triple.of((Object)locationIn, (Object)blurIn, (Object)mipmapIn));
                return this;
            }

            public MultiTextureStateShard m_282852_() {
                return new MultiTextureStateShard((ImmutableList<Triple<ResourceLocation, Boolean, Boolean>>)this.f_282850_.build());
            }
        }
    }

    protected static class LineStateShard
    extends RenderStateShard {
        private final OptionalDouble f_110276_;

        public LineStateShard(OptionalDouble widthIn) {
            super("line_width", () -> {
                if (!Objects.equals(widthIn, OptionalDouble.of(1.0))) {
                    if (widthIn.isPresent()) {
                        RenderSystem.m_69832_((float)((float)widthIn.getAsDouble()));
                    } else {
                        RenderSystem.m_69832_((float)Math.max(2.5f, (float)Minecraft.m_91087_().m_91268_().m_85441_() / 1920.0f * 2.5f));
                    }
                }
            }, () -> {
                if (!Objects.equals(widthIn, OptionalDouble.of(1.0))) {
                    RenderSystem.m_69832_((float)1.0f);
                }
            });
            this.f_110276_ = widthIn;
        }

        @Override
        public String toString() {
            return this.f_110133_ + "[" + (this.f_110276_.isPresent() ? Double.valueOf(this.f_110276_.getAsDouble()) : "window_scale") + "]";
        }
    }

    protected static class LightmapStateShard
    extends BooleanStateShard {
        public LightmapStateShard(boolean enabledIn) {
            super("lightmap", () -> {
                if (enabledIn) {
                    Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
                }
            }, () -> {
                if (enabledIn) {
                    Minecraft.m_91087_().f_91063_.m_109154_().m_109891_();
                }
            }, enabledIn);
        }
    }

    protected static class LayeringStateShard
    extends RenderStateShard {
        public LayeringStateShard(String nameIn, Runnable setupTaskIn, Runnable clearTaskIn) {
            super(nameIn, setupTaskIn, clearTaskIn);
        }
    }

    protected static class EmptyTextureStateShard
    extends RenderStateShard {
        public EmptyTextureStateShard(Runnable setupTaskIn, Runnable clearTaskIn) {
            super("texture", setupTaskIn, clearTaskIn);
        }

        EmptyTextureStateShard() {
            super("texture", () -> {}, () -> {});
        }

        protected Optional<ResourceLocation> m_223863_() {
            return Optional.empty();
        }

        public boolean isBlur() {
            return false;
        }

        public boolean isMipmap() {
            return false;
        }
    }

    protected static class DepthTestStateShard
    extends RenderStateShard {
        private final String f_110243_;

        public DepthTestStateShard(String funcNameIn, int funcIn) {
            super("depth_test", () -> {
                if (funcIn != 519) {
                    RenderSystem.m_69482_();
                    RenderSystem.m_69456_((int)funcIn);
                }
            }, () -> {
                if (funcIn != 519) {
                    RenderSystem.m_69465_();
                    RenderSystem.m_69456_((int)515);
                }
            });
            this.f_110243_ = funcNameIn;
        }

        @Override
        public String toString() {
            return this.f_110133_ + "[" + this.f_110243_ + "]";
        }
    }

    protected static class CullStateShard
    extends BooleanStateShard {
        public CullStateShard(boolean enabledIn) {
            super("cull", () -> {
                if (!enabledIn) {
                    RenderSystem.m_69464_();
                }
            }, () -> {
                if (!enabledIn) {
                    RenderSystem.m_69481_();
                }
            }, enabledIn);
        }
    }

    static class BooleanStateShard
    extends RenderStateShard {
        private final boolean f_110227_;

        public BooleanStateShard(String nameIn, Runnable setupTaskIn, Runnable clearTaskIn, boolean enabledIn) {
            super(nameIn, setupTaskIn, clearTaskIn);
            this.f_110227_ = enabledIn;
        }

        @Override
        public String toString() {
            return this.f_110133_ + "[" + this.f_110227_ + "]";
        }
    }
}

