/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model.geom;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntities;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.model.ModelSprite;
import net.optifine.render.BoxVertexPositions;
import net.optifine.render.VertexPosition;
import net.optifine.shaders.Shaders;

public final class ModelPart {
    public float f_104200_;
    public float f_104201_;
    public float f_104202_;
    public float f_104203_;
    public float f_104204_;
    public float f_104205_;
    public boolean f_104207_ = true;
    public final List<Cube> f_104212_;
    public final Map<String, ModelPart> f_104213_;
    public List<ModelPart> childModelsList;
    public List<ModelSprite> spriteList = new ArrayList<ModelSprite>();
    public boolean mirrorV = false;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    private ResourceLocation textureLocation = null;
    private String id = null;
    private ModelUpdater modelUpdater;
    private LevelRenderer renderGlobal = Config.getRenderGlobal();
    public float textureWidth = 64.0f;
    public float textureHeight = 32.0f;
    private int textureOffsetX;
    private int textureOffsetY;
    public boolean mirror;

    public ModelPart setTextureOffset(int x, int y) {
        this.textureOffsetX = x;
        this.textureOffsetY = y;
        return this;
    }

    public ModelPart setTextureSize(int textureWidthIn, int textureHeightIn) {
        this.textureWidth = textureWidthIn;
        this.textureHeight = textureHeightIn;
        return this;
    }

    public ModelPart(List<Cube> cubeListIn, Map<String, ModelPart> childModelsIn) {
        if (cubeListIn instanceof ImmutableList) {
            cubeListIn = new ArrayList<Cube>(cubeListIn);
        }
        this.f_104212_ = cubeListIn;
        this.f_104213_ = childModelsIn;
        this.childModelsList = new ArrayList<ModelPart>(this.f_104213_.values());
    }

    public PartPose m_201598_() {
        return PartPose.m_201696_((float)this.f_104200_, (float)this.f_104201_, (float)this.f_104202_, (float)this.f_104203_, (float)this.f_104204_, (float)this.f_104205_);
    }

    public void m_201624_(PartPose partPoseIn) {
        this.f_104200_ = partPoseIn.f_201678_;
        this.f_104201_ = partPoseIn.f_201679_;
        this.f_104202_ = partPoseIn.f_201680_;
        this.f_104203_ = partPoseIn.f_201681_;
        this.f_104204_ = partPoseIn.f_201682_;
        this.f_104205_ = partPoseIn.f_201683_;
    }

    public void m_104315_(ModelPart modelRendererIn) {
        this.f_104203_ = modelRendererIn.f_104203_;
        this.f_104204_ = modelRendererIn.f_104204_;
        this.f_104205_ = modelRendererIn.f_104205_;
        this.f_104200_ = modelRendererIn.f_104200_;
        this.f_104201_ = modelRendererIn.f_104201_;
        this.f_104202_ = modelRendererIn.f_104202_;
    }

    public ModelPart m_201626_(String nameIn) {
        ModelPart modelpart = this.f_104213_.get(nameIn);
        if (modelpart == null) {
            throw new NoSuchElementException("Can't find part " + nameIn);
        }
        return modelpart;
    }

    public void m_104227_(float rotationPointXIn, float rotationPointYIn, float rotationPointZIn) {
        this.f_104200_ = rotationPointXIn;
        this.f_104201_ = rotationPointYIn;
        this.f_104202_ = rotationPointZIn;
    }

    public void m_201630_(float xRotIn, float yRotIn, float zRotIn) {
        this.f_104203_ = xRotIn;
        this.f_104204_ = yRotIn;
        this.f_104205_ = zRotIn;
    }

    public void m_104301_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn) {
        this.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void m_104306_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (!(!this.f_104207_ || this.f_104212_.isEmpty() && this.f_104213_.isEmpty() && this.spriteList.isEmpty())) {
            RenderType lastRenderType = null;
            MultiBufferSource.BufferSource renderTypeBuffer = null;
            if (this.textureLocation != null) {
                if (this.renderGlobal.renderOverlayEyes) {
                    return;
                }
                renderTypeBuffer = bufferIn.getRenderTypeBuffer();
                if (renderTypeBuffer != null) {
                    VertexConsumer secondaryBuilder = bufferIn.getSecondaryBuilder();
                    lastRenderType = renderTypeBuffer.getLastRenderType();
                    bufferIn = renderTypeBuffer.getBuffer(this.textureLocation, bufferIn);
                    if (secondaryBuilder != null) {
                        bufferIn = VertexMultiConsumer.m_86168_(secondaryBuilder, bufferIn);
                    }
                }
            }
            if (this.modelUpdater != null) {
                this.modelUpdater.update();
            }
            matrixStackIn.m_85836_();
            this.m_104299_(matrixStackIn);
            this.m_104290_(matrixStackIn.m_85850_(), bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            int childModelsSize = this.childModelsList.size();
            for (int ix = 0; ix < childModelsSize; ++ix) {
                ModelPart modelpart = this.childModelsList.get(ix);
                modelpart.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
            int spriteListSize = this.spriteList.size();
            for (int ix = 0; ix < spriteListSize; ++ix) {
                ModelSprite sprite = this.spriteList.get(ix);
                sprite.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
            matrixStackIn.m_85849_();
            if (lastRenderType != null) {
                renderTypeBuffer.m_6299_(lastRenderType);
            }
        }
    }

    public void m_315388_(PoseStack p_315388_1_, Visitor p_315388_2_) {
        this.m_315391_(p_315388_1_, p_315388_2_, "");
    }

    private void m_315391_(PoseStack p_315391_1_, Visitor p_315391_2_, String p_315391_3_) {
        if (!this.f_104212_.isEmpty() || !this.f_104213_.isEmpty()) {
            p_315391_1_.m_85836_();
            this.m_104299_(p_315391_1_);
            PoseStack.Pose posestack$pose = p_315391_1_.m_85850_();
            for (int i = 0; i < this.f_104212_.size(); ++i) {
                p_315391_2_.m_315401_(posestack$pose, p_315391_3_, i, this.f_104212_.get(i));
            }
            String s = p_315391_3_ + "/";
            this.f_104213_.forEach((p_315395_3_, p_315395_4_) -> p_315395_4_.m_315391_(p_315391_1_, p_315391_2_, s + p_315395_3_));
            p_315391_1_.m_85849_();
        }
    }

    public void m_104299_(PoseStack matrixStackIn) {
        matrixStackIn.m_85837_(this.f_104200_ / 16.0f, this.f_104201_ / 16.0f, this.f_104202_ / 16.0f);
        if (this.f_104205_ != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122270_(this.f_104205_));
        }
        if (this.f_104204_ != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122270_(this.f_104204_));
        }
        if (this.f_104203_ != 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122270_(this.f_104203_));
        }
    }

    private void m_104290_(PoseStack.Pose matrixEntryIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        boolean shadersVelocity = Config.isShaders() && Shaders.useVelocityAttrib && Config.isMinecraftThread();
        int cubeListSize = this.f_104212_.size();
        for (int ic = 0; ic < cubeListSize; ++ic) {
            IRandomEntity entity;
            Cube modelpart$cube = this.f_104212_.get(ic);
            VertexPosition[][] boxPos = null;
            if (shadersVelocity && (entity = RandomEntities.getRandomEntityRendered()) != null) {
                boxPos = modelpart$cube.getBoxVertexPositions(entity.getId());
            }
            modelpart$cube.compile(matrixEntryIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, boxPos);
        }
    }

    public Cube m_104328_(Random randomIn) {
        return this.f_104212_.get(randomIn.nextInt(this.f_104212_.size()));
    }

    public boolean m_201629_() {
        return this.f_104212_.isEmpty();
    }

    public Stream<ModelPart> m_201634_() {
        return Stream.concat(Stream.of(this), this.f_104213_.values().stream().flatMap(ModelPart::m_201634_));
    }

    public void addSprite(float posX, float posY, float posZ, int sizeX, int sizeY, int sizeZ, float sizeAdd) {
        this.spriteList.add(new ModelSprite(this, this.textureOffsetX, this.textureOffsetY, posX, posY, posZ, sizeX, sizeY, sizeZ, sizeAdd));
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public void setTextureLocation(ResourceLocation textureLocation) {
        this.textureLocation = textureLocation;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addBox(int[][] faceUvs, float x, float y, float z, float dx, float dy, float dz, float delta) {
        this.f_104212_.add(new Cube(faceUvs, x, y, z, dx, dy, dz, delta, delta, delta, this.mirror, this.textureWidth, this.textureHeight));
    }

    public void addBox(float x, float y, float z, float width, float height, float depth, float delta) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, delta, delta, delta, this.mirror, false);
    }

    private void addBox(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirror, boolean dummyIn) {
        this.f_104212_.add(new Cube(texOffX, texOffY, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, mirror, this.textureWidth, this.textureHeight));
    }

    public ModelPart getChildModelDeep(String name) {
        if (name == null) {
            return null;
        }
        if (this.f_104213_.containsKey(name)) {
            return this.m_201626_(name);
        }
        if (this.f_104213_ != null) {
            Set<String> keys = this.f_104213_.keySet();
            for (String key : keys) {
                ModelPart child = this.f_104213_.get(key);
                ModelPart mr = child.getChildModelDeep(name);
                if (mr == null) continue;
                return mr;
            }
        }
        return null;
    }

    public ModelPart getChild(String id) {
        if (id == null) {
            return null;
        }
        if (this.f_104213_ != null) {
            Set<String> keys = this.f_104213_.keySet();
            for (String key : keys) {
                ModelPart child = this.f_104213_.get(key);
                if (!id.equals(child.getId())) continue;
                return child;
            }
        }
        return null;
    }

    public ModelPart getChildDeep(String id) {
        if (id == null) {
            return null;
        }
        ModelPart mrChild = this.getChild(id);
        if (mrChild != null) {
            return mrChild;
        }
        if (this.f_104213_ != null) {
            Set<String> keys = this.f_104213_.keySet();
            for (String key : keys) {
                ModelPart child = this.f_104213_.get(key);
                ModelPart mr = child.getChildDeep(id);
                if (mr == null) continue;
                return mr;
            }
        }
        return null;
    }

    public void setModelUpdater(ModelUpdater modelUpdater) {
        this.modelUpdater = modelUpdater;
    }

    public void addChildModel(String name, ModelPart part) {
        if (part == null) {
            return;
        }
        this.f_104213_.put(name, part);
        this.childModelsList = new ArrayList<ModelPart>(this.f_104213_.values());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("id: " + this.id + ", boxes: " + (this.f_104212_ != null ? Integer.valueOf(this.f_104212_.size()) : null) + ", submodels: " + (this.f_104213_ != null ? Integer.valueOf(this.f_104213_.size()) : null));
        return sb.toString();
    }

    @FunctionalInterface
    public static interface Visitor {
        public void m_315401_(PoseStack.Pose var1, String var2, int var3, Cube var4);
    }

    static class Vertex {
        public final Vector3f f_104371_;
        public final float f_104372_;
        public final float f_104373_;

        public Vertex(float x, float y, float z, float texU, float texV) {
            this(new Vector3f(x, y, z), texU, texV);
        }

        public Vertex m_104384_(float texU, float texV) {
            return new Vertex(this.f_104371_, texU, texV);
        }

        public Vertex(Vector3f posIn, float texU, float texV) {
            this.f_104371_ = posIn;
            this.f_104372_ = texU;
            this.f_104373_ = texV;
        }
    }

    static class Polygon {
        public final Vertex[] f_104359_;
        public final Vector3f f_104360_;

        public Polygon(Vertex[] positionsIn, float u1, float v1, float u2, float v2, float texWidth, float texHeight, boolean mirrorIn, Direction directionIn) {
            this.f_104359_ = positionsIn;
            float f = 0.0f / texWidth;
            float f1 = 0.0f / texHeight;
            if (Config.isAntialiasing()) {
                f = 0.05f / texWidth;
                f1 = 0.05f / texHeight;
                if (u2 < u1) {
                    f = -f;
                }
                if (v2 < v1) {
                    f1 = -f1;
                }
            }
            positionsIn[0] = positionsIn[0].m_104384_(u2 / texWidth - f, v1 / texHeight + f1);
            positionsIn[1] = positionsIn[1].m_104384_(u1 / texWidth + f, v1 / texHeight + f1);
            positionsIn[2] = positionsIn[2].m_104384_(u1 / texWidth + f, v2 / texHeight - f1);
            positionsIn[3] = positionsIn[3].m_104384_(u2 / texWidth - f, v2 / texHeight - f1);
            if (mirrorIn) {
                int i = positionsIn.length;
                for (int j = 0; j < i / 2; ++j) {
                    Vertex modelpart$vertex = positionsIn[j];
                    positionsIn[j] = positionsIn[i - 1 - j];
                    positionsIn[i - 1 - j] = modelpart$vertex;
                }
            }
            this.f_104360_ = directionIn.m_122432_();
            if (mirrorIn) {
                this.f_104360_.m_122263_(-1.0f, 1.0f, 1.0f);
            }
        }
    }

    public static class Cube {
        private final Polygon[] f_104341_;
        public final float f_104335_;
        public final float f_104336_;
        public final float f_104337_;
        public final float f_104338_;
        public final float f_104339_;
        public final float f_104340_;
        private BoxVertexPositions boxVertexPositions;

        public Cube(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirror, float texWidth, float texHeight) {
            this.f_104335_ = x;
            this.f_104336_ = y;
            this.f_104337_ = z;
            this.f_104338_ = x + width;
            this.f_104339_ = y + height;
            this.f_104340_ = z + depth;
            this.f_104341_ = new Polygon[6];
            float f = x + width;
            float f1 = y + height;
            float f2 = z + depth;
            x -= deltaX;
            y -= deltaY;
            z -= deltaZ;
            f += deltaX;
            f1 += deltaY;
            f2 += deltaZ;
            if (mirror) {
                float f3 = f;
                f = x;
                x = f3;
            }
            Vertex modelpart$vertex7 = new Vertex(x, y, z, 0.0f, 0.0f);
            Vertex modelpart$vertex = new Vertex(f, y, z, 0.0f, 8.0f);
            Vertex modelpart$vertex1 = new Vertex(f, f1, z, 8.0f, 8.0f);
            Vertex modelpart$vertex2 = new Vertex(x, f1, z, 8.0f, 0.0f);
            Vertex modelpart$vertex3 = new Vertex(x, y, f2, 0.0f, 0.0f);
            Vertex modelpart$vertex4 = new Vertex(f, y, f2, 0.0f, 8.0f);
            Vertex modelpart$vertex5 = new Vertex(f, f1, f2, 8.0f, 8.0f);
            Vertex modelpart$vertex6 = new Vertex(x, f1, f2, 8.0f, 0.0f);
            float f4 = texOffX;
            float f5 = (float)texOffX + depth;
            float f6 = (float)texOffX + depth + width;
            float f7 = (float)texOffX + depth + width + width;
            float f8 = (float)texOffX + depth + width + depth;
            float f9 = (float)texOffX + depth + width + depth + width;
            float f10 = texOffY;
            float f11 = (float)texOffY + depth;
            float f12 = (float)texOffY + depth + height;
            this.f_104341_[2] = new Polygon(new Vertex[]{modelpart$vertex4, modelpart$vertex3, modelpart$vertex7, modelpart$vertex}, f5, f10, f6, f11, texWidth, texHeight, mirror, Direction.DOWN);
            this.f_104341_[3] = new Polygon(new Vertex[]{modelpart$vertex1, modelpart$vertex2, modelpart$vertex6, modelpart$vertex5}, f6, f11, f7, f10, texWidth, texHeight, mirror, Direction.UP);
            this.f_104341_[1] = new Polygon(new Vertex[]{modelpart$vertex7, modelpart$vertex3, modelpart$vertex6, modelpart$vertex2}, f4, f11, f5, f12, texWidth, texHeight, mirror, Direction.WEST);
            this.f_104341_[4] = new Polygon(new Vertex[]{modelpart$vertex, modelpart$vertex7, modelpart$vertex2, modelpart$vertex1}, f5, f11, f6, f12, texWidth, texHeight, mirror, Direction.NORTH);
            this.f_104341_[0] = new Polygon(new Vertex[]{modelpart$vertex4, modelpart$vertex, modelpart$vertex1, modelpart$vertex5}, f6, f11, f8, f12, texWidth, texHeight, mirror, Direction.EAST);
            this.f_104341_[5] = new Polygon(new Vertex[]{modelpart$vertex3, modelpart$vertex4, modelpart$vertex5, modelpart$vertex6}, f8, f11, f9, f12, texWidth, texHeight, mirror, Direction.SOUTH);
        }

        public Cube(int[][] faceUvs, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirorIn, float texWidth, float texHeight) {
            this.f_104335_ = x;
            this.f_104336_ = y;
            this.f_104337_ = z;
            this.f_104338_ = x + width;
            this.f_104339_ = y + height;
            this.f_104340_ = z + depth;
            this.f_104341_ = new Polygon[6];
            float f = x + width;
            float f1 = y + height;
            float f2 = z + depth;
            x -= deltaX;
            y -= deltaY;
            z -= deltaZ;
            f += deltaX;
            f1 += deltaY;
            f2 += deltaZ;
            if (mirorIn) {
                float f3 = f;
                f = x;
                x = f3;
            }
            Vertex pos0 = new Vertex(x, y, z, 0.0f, 0.0f);
            Vertex pos1 = new Vertex(f, y, z, 0.0f, 8.0f);
            Vertex pos2 = new Vertex(f, f1, z, 8.0f, 8.0f);
            Vertex pos3 = new Vertex(x, f1, z, 8.0f, 0.0f);
            Vertex pos4 = new Vertex(x, y, f2, 0.0f, 0.0f);
            Vertex pos5 = new Vertex(f, y, f2, 0.0f, 8.0f);
            Vertex pos6 = new Vertex(f, f1, f2, 8.0f, 8.0f);
            Vertex pos7 = new Vertex(x, f1, f2, 8.0f, 0.0f);
            this.f_104341_[2] = this.makeTexturedQuad(new Vertex[]{pos5, pos4, pos0, pos1}, faceUvs[1], true, texWidth, texHeight, mirorIn, Direction.DOWN);
            this.f_104341_[3] = this.makeTexturedQuad(new Vertex[]{pos2, pos3, pos7, pos6}, faceUvs[0], true, texWidth, texHeight, mirorIn, Direction.UP);
            this.f_104341_[1] = this.makeTexturedQuad(new Vertex[]{pos0, pos4, pos7, pos3}, faceUvs[5], false, texWidth, texHeight, mirorIn, Direction.WEST);
            this.f_104341_[4] = this.makeTexturedQuad(new Vertex[]{pos1, pos0, pos3, pos2}, faceUvs[2], false, texWidth, texHeight, mirorIn, Direction.NORTH);
            this.f_104341_[0] = this.makeTexturedQuad(new Vertex[]{pos5, pos1, pos2, pos6}, faceUvs[4], false, texWidth, texHeight, mirorIn, Direction.EAST);
            this.f_104341_[5] = this.makeTexturedQuad(new Vertex[]{pos4, pos5, pos6, pos7}, faceUvs[3], false, texWidth, texHeight, mirorIn, Direction.SOUTH);
        }

        private Polygon makeTexturedQuad(Vertex[] positionTextureVertexs, int[] faceUvs, boolean reverseUV, float textureWidth, float textureHeight, boolean mirrorIn, Direction directionIn) {
            if (faceUvs == null) {
                return null;
            }
            if (reverseUV) {
                return new Polygon(positionTextureVertexs, faceUvs[2], faceUvs[3], faceUvs[0], faceUvs[1], textureWidth, textureHeight, mirrorIn, directionIn);
            }
            return new Polygon(positionTextureVertexs, faceUvs[0], faceUvs[1], faceUvs[2], faceUvs[3], textureWidth, textureHeight, mirrorIn, directionIn);
        }

        public VertexPosition[][] getBoxVertexPositions(int key) {
            if (this.boxVertexPositions == null) {
                this.boxVertexPositions = new BoxVertexPositions();
            }
            return (VertexPosition[][])this.boxVertexPositions.get(key);
        }

        public void m_201649_(PoseStack.Pose matrixEntryIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            this.compile(matrixEntryIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, null);
        }

        public void compile(PoseStack.Pose matrixEntryIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, VertexPosition[][] boxPos) {
            Matrix4f matrix4f = matrixEntryIn.m_85861_();
            Matrix3f matrix3f = matrixEntryIn.m_85864_();
            int quadsSize = this.f_104341_.length;
            for (int iq = 0; iq < quadsSize; ++iq) {
                Polygon modelpart$polygon = this.f_104341_[iq];
                if (modelpart$polygon == null) continue;
                if (boxPos != null) {
                    bufferIn.setQuadVertexPositions(boxPos[iq]);
                }
                Vector3f vector3f = bufferIn.getTempVec3f(modelpart$polygon.f_104360_);
                vector3f.m_122249_(matrix3f);
                float f = vector3f.m_122239_();
                float f1 = vector3f.m_122260_();
                float f2 = vector3f.m_122269_();
                for (Vertex modelpart$vertex : modelpart$polygon.f_104359_) {
                    float f3 = modelpart$vertex.f_104371_.m_122239_() / 16.0f;
                    float f4 = modelpart$vertex.f_104371_.m_122260_() / 16.0f;
                    float f5 = modelpart$vertex.f_104371_.m_122269_() / 16.0f;
                    float xt = matrix4f.getTransformX(f3, f4, f5, 1.0f);
                    float yt = matrix4f.getTransformY(f3, f4, f5, 1.0f);
                    float zt = matrix4f.getTransformZ(f3, f4, f5, 1.0f);
                    bufferIn.m_5954_(xt, yt, zt, red, green, blue, alpha, modelpart$vertex.f_104372_, modelpart$vertex.f_104373_, packedOverlayIn, packedLightIn, f, f1, f2);
                }
            }
        }
    }
}

