/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font.providers;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.RawGlyph;
import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import net.minecraft.client.gui.font.providers.GlyphProviderBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.optifine.util.FontUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BitmapProvider
implements GlyphProvider {
    static final Logger f_95328_ = LogManager.getLogger();
    private final NativeImage f_95329_;
    private final Int2ObjectMap<Glyph> f_95330_;
    private boolean blend = false;
    private float widthSpace = -1.0f;

    BitmapProvider(NativeImage nativeImageIn, Int2ObjectMap<Glyph> mapGlyphInfosIn) {
        this.f_95329_ = nativeImageIn;
        this.f_95330_ = mapGlyphInfosIn;
    }

    public void close() {
        this.f_95329_.close();
    }

    @Nullable
    public RawGlyph m_7823_(int character) {
        return (RawGlyph)this.f_95330_.get(character);
    }

    public IntSet m_6990_() {
        return IntSets.unmodifiable((IntSet)this.f_95330_.keySet());
    }

    public boolean isBlend() {
        return this.blend;
    }

    public float getWidthSpace() {
        return this.widthSpace;
    }

    static final class Glyph
    implements RawGlyph {
        private final float f_95363_;
        private final NativeImage f_95364_;
        private final int f_95365_;
        private final int f_95366_;
        private final int f_95367_;
        private final int f_95368_;
        private final int f_95369_;
        private final int f_95370_;
        private float offsetBold = 1.0f;

        Glyph(float p_i95371_1_, NativeImage p_i95371_2_, int p_i95371_3_, int p_i95371_4_, int p_i95371_5_, int p_i95371_6_, int p_i95371_7_, int p_i95371_8_) {
            this.f_95363_ = p_i95371_1_;
            this.f_95364_ = p_i95371_2_;
            this.f_95365_ = p_i95371_3_;
            this.f_95366_ = p_i95371_4_;
            this.f_95367_ = p_i95371_5_;
            this.f_95368_ = p_i95371_6_;
            this.f_95369_ = p_i95371_7_;
            this.f_95370_ = p_i95371_8_;
        }

        public float m_5621_() {
            return 1.0f / this.f_95363_;
        }

        public int m_5631_() {
            return this.f_95367_;
        }

        public int m_5629_() {
            return this.f_95368_;
        }

        public float m_7403_() {
            return this.f_95369_;
        }

        public float m_299885_() {
            return super.m_299885_() + 7.0f - (float)this.f_95370_;
        }

        public void m_6238_(int xOffset, int yOffset) {
            this.f_95364_.m_85003_(0, xOffset, yOffset, this.f_95365_, this.f_95366_, this.f_95367_, this.f_95368_, false, false);
        }

        public boolean m_5633_() {
            return this.f_95364_.m_85102_().m_85161_() > 1;
        }

        public float m_5619_() {
            return this.offsetBold;
        }
    }

    public static class Builder
    implements GlyphProviderBuilder {
        private ResourceLocation f_95344_;
        private final List<int[]> f_95345_;
        private final int f_95346_;
        private final int f_95347_;

        public Builder(ResourceLocation textureLocationIn, int heightIn, int ascentIn, List<int[]> listCharRowsIn) {
            this.f_95344_ = new ResourceLocation(textureLocationIn.m_135827_(), "textures/" + textureLocationIn.m_135815_());
            this.f_95344_ = FontUtils.getHdFontLocation((ResourceLocation)this.f_95344_);
            this.f_95345_ = listCharRowsIn;
            this.f_95346_ = heightIn;
            this.f_95347_ = ascentIn;
        }

        public static Builder m_95355_(JsonObject jsonIn) {
            int i = GsonHelper.m_13824_((JsonObject)jsonIn, (String)"height", (int)8);
            int j = GsonHelper.m_13927_((JsonObject)jsonIn, (String)"ascent");
            if (j > i) {
                throw new JsonParseException("Ascent " + j + " higher than height " + i);
            }
            ArrayList list = Lists.newArrayList();
            JsonArray jsonarray = GsonHelper.m_13933_((JsonObject)jsonIn, (String)"chars");
            for (int k = 0; k < jsonarray.size(); ++k) {
                int l;
                String s = GsonHelper.m_13805_((JsonElement)jsonarray.get(k), (String)("chars[" + k + "]"));
                int[] aint = s.codePoints().toArray();
                if (k > 0 && aint.length != (l = ((int[])list.get(0)).length)) {
                    throw new JsonParseException("Elements of chars have to be the same length (found: " + aint.length + ", expected: " + l + "), pad with space or \\u0000");
                }
                list.add(aint);
            }
            if (!list.isEmpty() && ((int[])list.get(0)).length != 0) {
                return new Builder(new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonIn, (String)"file")), i, j, list);
            }
            throw new JsonParseException("Expected to find data in chars, found none.");
        }

        @Nullable
        public GlyphProvider m_6762_(ResourceManager resourceManagerIn) {
            try {
                BitmapProvider bitmapprovider;
                try (Resource resource = resourceManagerIn.m_223800_(this.f_95344_);){
                    NativeImage nativeimage = NativeImage.m_85048_(NativeImage.Format.RGBA, resource.m_6679_());
                    int i = nativeimage.m_84982_();
                    int j = nativeimage.m_85084_();
                    int k = i / this.f_95345_.get(0).length;
                    int l = j / this.f_95345_.size();
                    float f = (float)this.f_95346_ / (float)l;
                    Int2ObjectOpenHashMap int2objectmap = new Int2ObjectOpenHashMap();
                    Properties props = FontUtils.readFontProperties((ResourceLocation)this.f_95344_);
                    Int2ObjectMap<Float> mapCustomWidths = FontUtils.readCustomCharWidths(props);
                    Float widthSpace = (Float)mapCustomWidths.get(32);
                    boolean blend = FontUtils.readBoolean(props, "blend", false);
                    float offsetBold = FontUtils.readFloat(props, "offsetBold", -1.0f);
                    if (offsetBold < 0.0f) {
                        offsetBold = k > 8 ? 0.5f : 1.0f;
                    }
                    for (int i1 = 0; i1 < this.f_95345_.size(); ++i1) {
                        int j1 = 0;
                        for (int k1 : this.f_95345_.get(i1)) {
                            Glyph bitmapprovider$glyph;
                            int l1 = j1++;
                            if (k1 == 0 || k1 == 32) continue;
                            float i2 = this.m_95357_(nativeimage, k, l, l1, i1);
                            Float customWidth = (Float)mapCustomWidths.get(k1);
                            if (customWidth != null) {
                                i2 = customWidth.floatValue() * ((float)k / 8.0f);
                            }
                            if ((bitmapprovider$glyph = (Glyph)int2objectmap.put(k1, (Object)new Glyph(f, nativeimage, l1 * k, i1 * l, k, l, (int)(0.5 + (double)(i2 * f)) + 1, this.f_95347_))) != null) {
                                f_95328_.warn("Codepoint '{}' declared multiple times in {}", (Object)Integer.toHexString(k1), (Object)this.f_95344_);
                            }
                            Glyph gi = (Glyph)int2objectmap.get(k1);
                            gi.offsetBold = offsetBold;
                        }
                    }
                    bitmapprovider = new BitmapProvider(nativeimage, (Int2ObjectMap<Glyph>)int2objectmap);
                    bitmapprovider.blend = blend;
                    if (widthSpace != null) {
                        bitmapprovider.widthSpace = widthSpace.floatValue();
                    }
                }
                return bitmapprovider;
            }
            catch (IOException ioexception) {
                throw new RuntimeException(ioexception.getMessage());
            }
        }

        private int m_95357_(NativeImage nativeImageIn, int charWidthIn, int charHeightInsp, int columnIn, int rowIn) {
            int i;
            for (i = charWidthIn - 1; i >= 0; --i) {
                int j = columnIn * charWidthIn + i;
                for (int k = 0; k < charHeightInsp; ++k) {
                    int l = rowIn * charHeightInsp + k;
                    if ((nativeImageIn.m_85087_(j, l) & 0xFF) <= 16) continue;
                    return i + 1;
                }
            }
            return i + 1;
        }
    }
}

