/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_3298;
import net.minecraft.class_5912;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_3268
implements class_3262,
class_5912 {
    public static Path field_14196;
    private static final Logger field_14195;
    public static Class<?> field_14194;
    private static final Map<class_3264, Path> field_17917;
    public final class_3272 field_26938;
    public final Set<String> field_14193;
    private static final boolean ON_WINDOWS;
    private static final boolean FORGE;

    private static Path method_37454(URI p_320781_0_) throws IOException {
        try {
            return Paths.get(p_320781_0_);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
        }
        catch (Throwable throwable) {
            field_14195.warn("Unable to get path for: {}", (Object)p_320781_0_, (Object)throwable);
        }
        try {
            FileSystems.newFileSystem(p_320781_0_, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        return Paths.get(p_320781_0_);
    }

    public class_3268(class_3272 packMetadataIn, String ... resourceNamespacesIn) {
        this.field_26938 = packMetadataIn;
        this.field_14193 = ImmutableSet.copyOf((Object[])resourceNamespacesIn);
    }

    @Override
    public InputStream method_14410(String fileName) throws IOException {
        if (!fileName.contains("/") && !fileName.contains("\\")) {
            Path path;
            if (field_14196 != null && Files.exists(path = field_14196.resolve(fileName), new LinkOption[0])) {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            return this.method_14417(fileName);
        }
        throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
    }

    @Override
    public InputStream method_14405(class_3264 type, class_2960 location) throws IOException {
        InputStream inputstream = this.method_14416(type, location);
        if (inputstream != null) {
            return inputstream;
        }
        throw new FileNotFoundException(location.method_12832());
    }

    @Override
    public Collection<class_2960> method_14408(class_3264 type, String namespaceIn, String pathIn, int maxDepthIn, Predicate<String> filterIn) {
        HashSet set = Sets.newHashSet();
        if (field_14196 != null) {
            try {
                class_3268.method_14418(set, maxDepthIn, namespaceIn, field_14196.resolve(type.method_14413()), pathIn, filterIn);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (type == class_3264.field_14188) {
                Enumeration<URL> enumeration = null;
                try {
                    enumeration = field_14194.getClassLoader().getResources(type.method_14413() + "/");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                while (enumeration != null && enumeration.hasMoreElements()) {
                    try {
                        URI uri = ((URL)enumeration.nextElement()).toURI();
                        if (!"file".equals(uri.getScheme())) continue;
                        class_3268.method_14418(set, maxDepthIn, namespaceIn, Paths.get(uri), pathIn, filterIn);
                    }
                    catch (IOException | URISyntaxException exception) {}
                }
            }
        }
        try {
            Path path = field_17917.get((Object)type);
            if (path != null) {
                class_3268.method_14418(set, maxDepthIn, namespaceIn, path, pathIn, filterIn);
            } else {
                field_14195.error("Can't access assets root for type: {}", (Object)type);
            }
        }
        catch (FileNotFoundException | NoSuchFileException path) {
        }
        catch (IOException ioexception) {
            field_14195.error("Couldn't get a list of all vanilla resources", (Throwable)ioexception);
        }
        return set;
    }

    private static void method_14418(Collection<class_2960> resourceLocationsIn, int maxDepthIn, String namespaceIn, Path pathIn, String pathNameIn, Predicate<String> filterIn) throws IOException {
        Path path = pathIn.resolve(namespaceIn);
        try (Stream<Path> stream = Files.walk(path.resolve(pathNameIn), maxDepthIn, new FileVisitOption[0]);){
            stream.filter(p_10351_1_ -> !p_10351_1_.endsWith(".mcmeta") && Files.isRegularFile(p_10351_1_, new LinkOption[0]) && filterIn.test(p_10351_1_.getFileName().toString())).map(p_10338_2_ -> new class_2960(namespaceIn, path.relativize((Path)p_10338_2_).toString().replaceAll("\\\\", "/"))).forEach(resourceLocationsIn::add);
        }
    }

    @Nullable
    protected InputStream method_14416(class_3264 type, class_2960 location) {
        Path path;
        String s = class_3268.method_20729(type, location);
        InputStream is = ReflectorForge.getOptiFineResourceStream(s);
        if (is != null) {
            return is;
        }
        if (field_14196 != null && Files.exists(path = field_14196.resolve(type.method_14413() + "/" + location.method_12836() + "/" + location.method_12832()), new LinkOption[0])) {
            try {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            URL url = class_3268.class.getResource(s);
            return class_3268.method_20728(s, url) ? (FORGE ? this.getExtraInputStream(type, s) : url.openStream()) : null;
        }
        catch (IOException ioexception) {
            return class_3268.class.getResourceAsStream(s);
        }
    }

    private static String method_20729(class_3264 packTypeIn, class_2960 locationIn) {
        return "/" + packTypeIn.method_14413() + "/" + locationIn.method_12836() + "/" + locationIn.method_12832();
    }

    private static boolean method_20728(String pathIn, @Nullable URL urlIn) throws IOException {
        return urlIn != null && (urlIn.getProtocol().equals("jar") || class_3268.validatePath(new File(urlIn.getFile()), pathIn));
    }

    @Nullable
    protected InputStream method_14417(String pathIn) {
        if (FORGE) {
            return this.getExtraInputStream(class_3264.field_14190, "/" + pathIn);
        }
        return class_3268.class.getResourceAsStream("/" + pathIn);
    }

    @Override
    public boolean method_14411(class_3264 type, class_2960 location) {
        Path path;
        String s = class_3268.method_20729(type, location);
        InputStream is = ReflectorForge.getOptiFineResourceStream(s);
        if (is != null) {
            return true;
        }
        if (field_14196 != null && Files.exists(path = field_14196.resolve(type.method_14413() + "/" + location.method_12836() + "/" + location.method_12832()), new LinkOption[0])) {
            return true;
        }
        try {
            URL url = class_3268.class.getResource(s);
            return class_3268.method_20728(s, url);
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    @Override
    public Set<String> method_14406(class_3264 type) {
        return this.field_14193;
    }

    @Override
    @Nullable
    public <T> T method_14407(class_3270<T> deserializer) throws IOException {
        try {
            T object;
            block9: {
                block8: {
                    try (InputStream inputstream = this.method_14410("pack.mcmeta");){
                        T t;
                        if (inputstream == null || (t = class_3255.method_14392(deserializer, inputstream)) == null) break block8;
                        object = t;
                        break block9;
                    }
                }
                return (T)(deserializer == class_3272.field_14202 ? this.field_26938 : null);
            }
            return object;
        }
        catch (FileNotFoundException | RuntimeException runtimeexception) {
            return (T)(deserializer == class_3272.field_14202 ? this.field_26938 : null);
        }
    }

    @Override
    public String method_14409() {
        return "Default";
    }

    @Override
    public void close() {
    }

    @Override
    public class_3298 method_14486(final class_2960 locationIn) throws IOException {
        return new class_3298(){
            @Nullable
            InputStream field_29185;

            @Override
            public void close() throws IOException {
                if (this.field_29185 != null) {
                    this.field_29185.close();
                }
            }

            @Override
            public class_2960 method_14483() {
                return locationIn;
            }

            @Override
            public InputStream method_14482() {
                try {
                    this.field_29185 = class_3268.this.method_14405(class_3264.field_14188, locationIn);
                }
                catch (IOException ioexception) {
                    throw new UncheckedIOException("Could not get client resource from vanilla pack", ioexception);
                }
                return this.field_29185;
            }

            @Override
            public boolean method_14484() {
                return false;
            }

            @Override
            @Nullable
            public <T> T method_14481(class_3270<T> serializer) {
                return null;
            }

            @Override
            public String method_14480() {
                return locationIn.toString();
            }
        };
    }

    private static boolean validatePath(File file, String path) throws IOException {
        String s = file.getPath();
        if (s.startsWith("file:")) {
            if (ON_WINDOWS) {
                s = s.replace("\\", "/");
            }
            return s.endsWith(path);
        }
        return class_3259.method_14402(file, path);
    }

    private InputStream getExtraInputStream(class_3264 type, String resource) {
        try {
            Path rootDir = field_17917.get((Object)type);
            if (rootDir != null) {
                return Files.newInputStream(rootDir.resolve(resource), new OpenOption[0]);
            }
            return class_3268.class.getResourceAsStream(resource);
        }
        catch (IOException e) {
            return class_3268.class.getResourceAsStream(resource);
        }
    }

    static {
        field_14195 = LogManager.getLogger();
        field_17917 = (Map)class_156.method_656(() -> {
            Class<class_3268> clazz = class_3268.class;
            synchronized (class_3268.class) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (class_3264 packtype : class_3264.values()) {
                    String s = "/" + packtype.method_14413() + "/.mcassetsroot";
                    URL url = class_3268.class.getResource(s);
                    if (url == null) {
                        field_14195.error("File {} does not exist in classpath", (Object)s);
                        continue;
                    }
                    try {
                        URI uri = url.toURI();
                        String s1 = uri.getScheme();
                        if (!"jar".equals(s1) && !"file".equals(s1)) {
                            field_14195.warn("Assets URL '{}' uses unexpected schema", (Object)uri);
                        }
                        Path path = class_3268.method_37454(uri);
                        builder.put((Object)packtype, (Object)path.getParent());
                    }
                    catch (Exception exception) {
                        field_14195.error("Couldn't resolve path to vanilla assets", (Throwable)exception);
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return builder.build();
            }
        });
        ON_WINDOWS = class_156.method_668() == class_156.class_158.field_1133;
        FORGE = Reflector.ForgeHooksClient.exists();
    }
}

