/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_5250;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_318 {
    private static final Logger field_1974 = LogManager.getLogger();
    private static final DateFormat field_1973 = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private int field_32157;
    private final DataOutputStream field_32158;
    private final byte[] field_32159;
    private final int field_32160;
    private final int field_32161;
    private File field_32162;

    public static void method_1659(File gameDirectory, class_276 buffer, Consumer<class_2561> messageConsumer) {
        class_318.method_22690(gameDirectory, null, buffer, messageConsumer);
    }

    public static void method_22690(File gameDirectory, @Nullable String screenshotName, class_276 buffer, Consumer<class_2561> messageConsumer) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> class_318.method_1662(gameDirectory, screenshotName, buffer, messageConsumer));
        } else {
            class_318.method_1662(gameDirectory, screenshotName, buffer, messageConsumer);
        }
    }

    private static void method_1662(File gameDirectory, @Nullable String screenshotName, class_276 buffer, Consumer<class_2561> messageConsumer) {
        boolean resize;
        class_310 mc = Config.getMinecraft();
        class_1041 mainWindow = mc.method_22683();
        class_315 gameSettings = Config.getGameSettings();
        int fbWidth = mainWindow.method_4489();
        int fbHeight = mainWindow.method_4506();
        int guiScaleOld = gameSettings.field_1868;
        int guiScale = mainWindow.method_4476(mc.field_1690.field_1868, mc.field_1690.field_1819);
        int mul = Config.getScreenshotSize();
        boolean bl = resize = GLX.isUsingFBOs() && mul > 1;
        if (resize) {
            gameSettings.field_1868 = guiScale * mul;
            mainWindow.resizeFramebuffer(fbWidth * mul, fbHeight * mul);
            GlStateManager.clear(16640);
            mc.method_1522().method_1235(true);
            GlStateManager._enableTexture();
            RenderSystem.getModelViewStack().method_22903();
            mc.field_1773.method_3192(mc.method_1488(), System.nanoTime(), true);
            RenderSystem.getModelViewStack().method_22909();
            RenderSystem.applyModelViewMatrix();
        }
        class_1011 nativeimage = class_318.method_1663(buffer);
        if (resize) {
            mc.method_1522().method_1240();
            Config.getGameSettings().field_1868 = guiScaleOld;
            mainWindow.resizeFramebuffer(fbWidth, fbHeight);
        }
        File file1 = new File(gameDirectory, "screenshots");
        file1.mkdir();
        File file2 = screenshotName == null ? class_318.method_1660(file1) : new File(file1, screenshotName);
        Object event = null;
        if (Reflector.ForgeHooksClient_onScreenshot.exists()) {
            event = Reflector.call(Reflector.ForgeHooksClient_onScreenshot, nativeimage, file2);
            if (Reflector.callBoolean(event, Reflector.Event_isCanceled, new Object[0])) {
                class_2561 msg = (class_2561)Reflector.call(event, Reflector.ScreenshotEvent_getCancelMessage, new Object[0]);
                messageConsumer.accept(msg);
                return;
            }
            file2 = (File)Reflector.call(event, Reflector.ScreenshotEvent_getScreenshotFile, new Object[0]);
        }
        File target = file2;
        Object eventF = event;
        class_156.method_27958().execute(() -> {
            try {
                nativeimage.method_4325(target);
                class_5250 component = new class_2585(target.getName()).method_27692(class_124.field_1073).method_27694(p_313985_1_ -> p_313985_1_.method_10958(new class_2558(class_2558.class_2559.field_11746, target.getAbsolutePath())));
                if (eventF != null && Reflector.call(eventF, Reflector.ScreenshotEvent_getResultMessage, new Object[0]) != null) {
                    messageConsumer.accept((class_2561)Reflector.call(eventF, Reflector.ScreenshotEvent_getResultMessage, new Object[0]));
                } else {
                    messageConsumer.accept(new class_2588("screenshot.success", component));
                }
            }
            catch (Exception exception) {
                field_1974.warn("Couldn't save screenshot", (Throwable)exception);
                messageConsumer.accept(new class_2588("screenshot.failure", exception.getMessage()));
            }
            finally {
                nativeimage.close();
            }
        });
    }

    public static class_1011 method_1663(class_276 framebufferIn) {
        if (!GLX.isUsingFBOs()) {
            class_1011 nativeimage = new class_1011(framebufferIn.field_1482, framebufferIn.field_1481, false);
            nativeimage.downloadFromFramebuffer(true);
            nativeimage.method_4319();
            return nativeimage;
        }
        int i = framebufferIn.field_1482;
        int j = framebufferIn.field_1481;
        class_1011 nativeimage = new class_1011(i, j, false);
        RenderSystem.bindTexture(framebufferIn.method_30277());
        nativeimage.method_4327(0, true);
        nativeimage.method_4319();
        return nativeimage;
    }

    private static File method_1660(File gameDirectory) {
        String s = field_1973.format(new Date());
        int i = 1;
        File file1;
        while ((file1 = new File(gameDirectory, s + (i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file1;
    }

    public class_318(File fileIn, int widthIn, int heightIn, int rowHeightIn) throws IOException {
        this.field_32160 = widthIn;
        this.field_32161 = heightIn;
        this.field_32157 = rowHeightIn;
        File file1 = new File(fileIn, "screenshots");
        file1.mkdir();
        DateFormat dateformat = field_1973;
        String s = "huge_" + dateformat.format(new Date());
        int i = 1;
        while ((this.field_32162 = new File(file1, s + (i == 1 ? "" : "_" + i) + ".tga")).exists()) {
            ++i;
        }
        byte[] abyte = new byte[18];
        abyte[2] = 2;
        abyte[12] = (byte)(widthIn % 256);
        abyte[13] = (byte)(widthIn / 256);
        abyte[14] = (byte)(heightIn % 256);
        abyte[15] = (byte)(heightIn / 256);
        abyte[16] = 24;
        this.field_32159 = new byte[widthIn * rowHeightIn * 3];
        this.field_32158 = new DataOutputStream(new FileOutputStream(this.field_32162));
        this.field_32158.write(abyte);
    }

    public void method_35711(ByteBuffer p_313988_1_, int p_313988_2_, int p_313988_3_, int p_313988_4_, int p_313988_5_) {
        int i = p_313988_4_;
        int j = p_313988_5_;
        if (p_313988_4_ > this.field_32160 - p_313988_2_) {
            i = this.field_32160 - p_313988_2_;
        }
        if (p_313988_5_ > this.field_32161 - p_313988_3_) {
            j = this.field_32161 - p_313988_3_;
        }
        this.field_32157 = j;
        for (int k = 0; k < j; ++k) {
            p_313988_1_.position((p_313988_5_ - j) * p_313988_4_ * 3 + k * p_313988_4_ * 3);
            int l = (p_313988_2_ + k * this.field_32160) * 3;
            p_313988_1_.get(this.field_32159, l, i * 3);
        }
    }

    public void method_35710() throws IOException {
        this.field_32158.write(this.field_32159, 0, this.field_32160 * 3 * this.field_32157);
    }

    public File method_35712() throws IOException {
        this.field_32158.close();
        return this.field_32162;
    }
}

