/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.fabricmc.fabric.impl.client.indigo.renderer.accessor.AccessChunkRenderer;
import net.fabricmc.fabric.impl.client.indigo.renderer.accessor.AccessChunkRendererData;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoLuminanceFix;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_750;
import net.minecraft.class_761;
import net.minecraft.class_846;
import net.minecraft.class_853;

public class ChunkRenderInfo {
    private final Long2IntOpenHashMap brightnessCache;
    private final Long2FloatOpenHashMap aoLevelCache;
    private final class_2338.class_2339 chunkOrigin = new class_2338.class_2339();
    AccessChunkRendererData chunkData;
    class_846.class_851 chunkRenderer;
    class_750 builders;
    class_1920 blockView;
    private final Object2ObjectOpenHashMap<class_1921, class_287> buffers = new Object2ObjectOpenHashMap();

    ChunkRenderInfo() {
        this.brightnessCache = new Long2IntOpenHashMap();
        this.brightnessCache.defaultReturnValue(Integer.MAX_VALUE);
        this.aoLevelCache = new Long2FloatOpenHashMap();
        this.aoLevelCache.defaultReturnValue(Float.MAX_VALUE);
    }

    void prepare(class_853 blockView, class_846.class_851 chunkRenderer, class_846.class_849 chunkData, class_750 builders) {
        this.blockView = blockView;
        this.chunkOrigin.method_10101((class_2382)chunkRenderer.method_3670());
        this.chunkData = (AccessChunkRendererData)chunkData;
        this.chunkRenderer = chunkRenderer;
        this.builders = builders;
        this.buffers.clear();
        this.brightnessCache.clear();
        this.aoLevelCache.clear();
    }

    void release() {
        this.chunkData = null;
        this.chunkRenderer = null;
        this.buffers.clear();
    }

    public class_287 getInitializedBuffer(class_1921 renderLayer) {
        class_287 result = (class_287)this.buffers.get((Object)renderLayer);
        if (result == null) {
            class_287 builder;
            result = builder = this.builders.method_3154(renderLayer);
            this.chunkData.fabric_markPopulated(renderLayer);
            this.buffers.put((Object)renderLayer, (Object)result);
            if (this.chunkData.fabric_markInitialized(renderLayer)) {
                ((AccessChunkRenderer)this.chunkRenderer).fabric_beginBufferBuilding(builder);
            }
        }
        return result;
    }

    int cachedBrightness(class_2338 pos) {
        long key = pos.method_10063();
        int result = this.brightnessCache.get(key);
        if (result == Integer.MAX_VALUE) {
            result = class_761.method_23793((class_1920)this.blockView, (class_2680)this.blockView.method_8320(pos), (class_2338)pos);
            this.brightnessCache.put(key, result);
        }
        return result;
    }

    float cachedAoLevel(class_2338 pos) {
        long key = pos.method_10063();
        float result = this.aoLevelCache.get(key);
        if (result == Float.MAX_VALUE) {
            result = AoLuminanceFix.INSTANCE.apply((class_1922)this.blockView, pos);
            this.aoLevelCache.put(key, result);
        }
        return result;
    }
}

