/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.systems;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_286;
import net.minecraft.class_289;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3532;
import net.minecraft.class_4573;
import net.minecraft.class_4587;
import net.minecraft.class_5365;
import net.minecraft.class_5944;
import net.minecraft.class_6177;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallbackI;

@class_6177
public class RenderSystem {
    static final Logger LOGGER = LogManager.getLogger();
    private static final ConcurrentLinkedQueue<class_4573> recordingQueue = Queues.newConcurrentLinkedQueue();
    private static final class_289 RENDER_THREAD_TESSELATOR = new class_289();
    private static final int MINIMUM_ATLAS_TEXTURE_SIZE = 1024;
    private static boolean isReplayingQueue;
    @Nullable
    private static Thread gameThread;
    @Nullable
    private static Thread renderThread;
    private static int MAX_SUPPORTED_TEXTURE_SIZE;
    private static boolean isInInit;
    private static double lastDrawTime;
    private static final class_5590 sharedSequential;
    private static final class_5590 sharedSequentialQuad;
    private static final class_5590 sharedSequentialLines;
    private static class_1159 projectionMatrix;
    private static class_1159 savedProjectionMatrix;
    private static class_4587 modelViewStack;
    private static class_1159 modelViewMatrix;
    private static class_1159 textureMatrix;
    private static final int[] shaderTextures;
    private static final float[] shaderColor;
    private static float shaderFogStart;
    private static float shaderFogEnd;
    private static final float[] shaderFogColor;
    private static final class_1160[] shaderLightDirections;
    private static float shaderGameTime;
    private static float shaderLineWidth;
    @Nullable
    private static class_5944 shader;

    public static void initRenderThread() {
        if (renderThread != null || gameThread == Thread.currentThread()) {
            throw new IllegalStateException("Could not initialize render thread");
        }
        renderThread = Thread.currentThread();
    }

    public static boolean isOnRenderThread() {
        return Thread.currentThread() == renderThread;
    }

    public static boolean isOnRenderThreadOrInit() {
        return isInInit || RenderSystem.isOnRenderThread();
    }

    public static void initGameThread(boolean bl) {
        boolean bl2 = \u00e2\u02dc\u0192 = renderThread == Thread.currentThread();
        if (gameThread != null || renderThread == null || \u00e2\u02dc\u0192 == bl) {
            throw new IllegalStateException("Could not initialize tick thread");
        }
        gameThread = Thread.currentThread();
    }

    public static boolean isOnGameThread() {
        return true;
    }

    public static boolean isOnGameThreadOrInit() {
        return isInInit || RenderSystem.isOnGameThread();
    }

    public static void assertThread(Supplier<Boolean> supplier) {
        if (!supplier.get().booleanValue()) {
            throw new IllegalStateException("Rendersystem called from wrong thread");
        }
    }

    public static boolean isInInitPhase() {
        return true;
    }

    public static void recordRenderCall(class_4573 class_45732) {
        recordingQueue.add(class_45732);
    }

    public static void flipFrame(long l) {
        GLFW.glfwPollEvents();
        RenderSystem.replayQueue();
        class_289.method_1348().method_1349().method_1343();
        GLFW.glfwSwapBuffers((long)l);
        GLFW.glfwPollEvents();
    }

    public static void replayQueue() {
        isReplayingQueue = true;
        while (!recordingQueue.isEmpty()) {
            class_4573 class_45732 = recordingQueue.poll();
            class_45732.execute();
        }
        isReplayingQueue = false;
    }

    public static void limitDisplayFPS(int n) {
        double d = lastDrawTime + 1.0 / (double)n;
        \u00e2\u02dc\u0192 = GLFW.glfwGetTime();
        while (\u00e2\u02dc\u0192 < d) {
            GLFW.glfwWaitEventsTimeout((double)(d - \u00e2\u02dc\u0192));
            \u00e2\u02dc\u0192 = GLFW.glfwGetTime();
        }
        lastDrawTime = \u00e2\u02dc\u0192;
    }

    public static void disableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._disableDepthTest();
    }

    public static void enableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._enableDepthTest();
    }

    public static void enableScissor(int n, int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._enableScissorTest();
        GlStateManager._scissorBox(n, n2, n3, n4);
    }

    public static void disableScissor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._disableScissorTest();
    }

    public static void depthFunc(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._depthFunc(n);
    }

    public static void depthMask(boolean bl) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._depthMask(bl);
    }

    public static void enableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._enableBlend();
    }

    public static void disableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._disableBlend();
    }

    public static void blendFunc(GlStateManager.class_4535 class_45352, GlStateManager.class_4534 class_45342) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._blendFunc(class_45352.value, class_45342.value);
    }

    public static void blendFunc(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._blendFunc(n, n2);
    }

    public static void blendFuncSeparate(GlStateManager.class_4535 class_45352, GlStateManager.class_4534 class_45342, GlStateManager.class_4535 class_45353, GlStateManager.class_4534 class_45343) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._blendFuncSeparate(class_45352.value, class_45342.value, class_45353.value, class_45343.value);
    }

    public static void blendFuncSeparate(int n, int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._blendFuncSeparate(n, n2, n3, n4);
    }

    public static void blendEquation(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._blendEquation(n);
    }

    public static void enableCull() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._enableCull();
    }

    public static void disableCull() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._disableCull();
    }

    public static void polygonMode(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._polygonMode(n, n2);
    }

    public static void enablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._enablePolygonOffset();
    }

    public static void disablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._disablePolygonOffset();
    }

    public static void polygonOffset(float f, float f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._polygonOffset(f, f2);
    }

    public static void enableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._enableColorLogicOp();
    }

    public static void disableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._disableColorLogicOp();
    }

    public static void logicOp(GlStateManager.class_1030 class_10302) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._logicOp(class_10302.field_5108);
    }

    public static void activeTexture(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._activeTexture(n);
    }

    public static void enableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._enableTexture();
    }

    public static void disableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._disableTexture();
    }

    public static void texParameter(int n, int n2, int n3) {
        GlStateManager._texParameter(n, n2, n3);
    }

    public static void deleteTexture(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._deleteTexture(n);
    }

    public static void bindTextureForSetup(int n) {
        RenderSystem.bindTexture(n);
    }

    public static void bindTexture(int n) {
        GlStateManager._bindTexture(n);
    }

    public static void viewport(int n, int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._viewport(n, n2, n3, n4);
    }

    public static void colorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._colorMask(bl, bl2, bl3, bl4);
    }

    public static void stencilFunc(int n, int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._stencilFunc(n, n2, n3);
    }

    public static void stencilMask(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._stencilMask(n);
    }

    public static void stencilOp(int n, int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._stencilOp(n, n2, n3);
    }

    public static void clearDepth(double d) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._clearDepth(d);
    }

    public static void clearColor(float f, float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._clearColor(f, f2, f3, f4);
    }

    public static void clearStencil(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._clearStencil(n);
    }

    public static void clear(int n, boolean bl) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._clear(n, bl);
    }

    public static void setShaderFogStart(float f) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        RenderSystem._setShaderFogStart(f);
    }

    private static void _setShaderFogStart(float f) {
        shaderFogStart = f;
    }

    public static float getShaderFogStart() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shaderFogStart;
    }

    public static void setShaderFogEnd(float f) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        RenderSystem._setShaderFogEnd(f);
    }

    private static void _setShaderFogEnd(float f) {
        shaderFogEnd = f;
    }

    public static float getShaderFogEnd() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shaderFogEnd;
    }

    public static void setShaderFogColor(float f, float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        RenderSystem._setShaderFogColor(f, f2, f3, f4);
    }

    public static void setShaderFogColor(float f, float f2, float f3) {
        RenderSystem.setShaderFogColor(f, f2, f3, 1.0f);
    }

    private static void _setShaderFogColor(float f, float f2, float f3, float f4) {
        RenderSystem.shaderFogColor[0] = f;
        RenderSystem.shaderFogColor[1] = f2;
        RenderSystem.shaderFogColor[2] = f3;
        RenderSystem.shaderFogColor[3] = f4;
    }

    public static float[] getShaderFogColor() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shaderFogColor;
    }

    public static void setShaderLights(class_1160 class_11602, class_1160 class_11603) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        RenderSystem._setShaderLights(class_11602, class_11603);
    }

    public static void _setShaderLights(class_1160 class_11602, class_1160 class_11603) {
        RenderSystem.shaderLightDirections[0] = class_11602;
        RenderSystem.shaderLightDirections[1] = class_11603;
    }

    public static void setupShaderLights(class_5944 class_59442) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (class_59442.field_29475 != null) {
            class_59442.field_29475.method_34413(shaderLightDirections[0]);
        }
        if (class_59442.field_29476 != null) {
            class_59442.field_29476.method_34413(shaderLightDirections[1]);
        }
    }

    public static void setShaderColor(float f, float f2, float f3, float f4) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._setShaderColor(f, f2, f3, f4));
        } else {
            RenderSystem._setShaderColor(f, f2, f3, f4);
        }
    }

    private static void _setShaderColor(float f, float f2, float f3, float f4) {
        RenderSystem.shaderColor[0] = f;
        RenderSystem.shaderColor[1] = f2;
        RenderSystem.shaderColor[2] = f3;
        RenderSystem.shaderColor[3] = f4;
    }

    public static float[] getShaderColor() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shaderColor;
    }

    public static void drawElements(int n, int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._drawElements(n, n2, n3, 0L);
    }

    public static void lineWidth(float f) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shaderLineWidth = f;
            });
        } else {
            shaderLineWidth = f;
        }
    }

    public static float getShaderLineWidth() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shaderLineWidth;
    }

    public static void pixelStore(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._pixelStore(n, n2);
    }

    public static void readPixels(int n, int n2, int n3, int n4, int n5, int n6, ByteBuffer byteBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._readPixels(n, n2, n3, n4, n5, n6, byteBuffer);
    }

    public static void getString(int n, Consumer<String> consumer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        consumer.accept(GlStateManager._getString(n));
    }

    public static String getBackendDescription() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return String.format("LWJGL version %s", GLX._getLWJGLVersion());
    }

    public static String getApiDescription() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return GLX.getOpenGLVersionString();
    }

    public static LongSupplier initBackendSystem() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return GLX._initGlfw();
    }

    public static void initRenderer(int n, boolean bl) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLX._init(n, bl);
    }

    public static void setErrorCallback(GLFWErrorCallbackI gLFWErrorCallbackI) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLX._setGlfwErrorCallback(gLFWErrorCallbackI);
    }

    public static void renderCrosshair(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GLX._renderCrosshair(n, true, true, true);
    }

    public static String getCapsString() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        return "Using framebuffer using OpenGL 3.2";
    }

    public static void setupDefaultState(int n, int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GlStateManager._enableTexture();
        GlStateManager._clearDepth(1.0);
        GlStateManager._enableDepthTest();
        GlStateManager._depthFunc(515);
        projectionMatrix.method_22668();
        savedProjectionMatrix.method_22668();
        modelViewMatrix.method_22668();
        textureMatrix.method_22668();
        GlStateManager._viewport(n, n2, n3, n4);
    }

    public static int maxSupportedTextureSize() {
        if (MAX_SUPPORTED_TEXTURE_SIZE == -1) {
            RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
            int n = GlStateManager._getInteger(3379);
            for (\u00e2\u02dc\u0192 = Math.max(32768, n); \u00e2\u02dc\u0192 >= 1024; \u00e2\u02dc\u0192 >>= 1) {
                GlStateManager._texImage2D(32868, 0, 6408, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, 0, 6408, 5121, null);
                \u00e2\u02dc\u0192 = GlStateManager._getTexLevelParameter(32868, 0, 4096);
                if (\u00e2\u02dc\u0192 == 0) continue;
                MAX_SUPPORTED_TEXTURE_SIZE = \u00e2\u02dc\u0192;
                return \u00e2\u02dc\u0192;
            }
            MAX_SUPPORTED_TEXTURE_SIZE = Math.max(n, 1024);
            LOGGER.info("Failed to determine maximum texture size by probing, trying GL_MAX_TEXTURE_SIZE = {}", (Object)MAX_SUPPORTED_TEXTURE_SIZE);
        }
        return MAX_SUPPORTED_TEXTURE_SIZE;
    }

    public static void glBindBuffer(int n, IntSupplier intSupplier) {
        GlStateManager._glBindBuffer(n, intSupplier.getAsInt());
    }

    public static void glBindVertexArray(Supplier<Integer> supplier) {
        GlStateManager._glBindVertexArray(supplier.get());
    }

    public static void glBufferData(int n, ByteBuffer byteBuffer, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager._glBufferData(n, byteBuffer, n2);
    }

    public static void glDeleteBuffers(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glDeleteBuffers(n);
    }

    public static void glDeleteVertexArrays(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glDeleteVertexArrays(n);
    }

    public static void glUniform1i(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform1i(n, n2);
    }

    public static void glUniform1(int n, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform1(n, intBuffer);
    }

    public static void glUniform2(int n, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform2(n, intBuffer);
    }

    public static void glUniform3(int n, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform3(n, intBuffer);
    }

    public static void glUniform4(int n, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform4(n, intBuffer);
    }

    public static void glUniform1(int n, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform1(n, floatBuffer);
    }

    public static void glUniform2(int n, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform2(n, floatBuffer);
    }

    public static void glUniform3(int n, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform3(n, floatBuffer);
    }

    public static void glUniform4(int n, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform4(n, floatBuffer);
    }

    public static void glUniformMatrix2(int n, boolean bl, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniformMatrix2(n, bl, floatBuffer);
    }

    public static void glUniformMatrix3(int n, boolean bl, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniformMatrix3(n, bl, floatBuffer);
    }

    public static void glUniformMatrix4(int n, boolean bl, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniformMatrix4(n, bl, floatBuffer);
    }

    public static void setupOverlayColor(IntSupplier intSupplier, int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        \u00e2\u02dc\u0192 = intSupplier.getAsInt();
        RenderSystem.setShaderTexture(1, \u00e2\u02dc\u0192);
    }

    public static void teardownOverlayColor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        RenderSystem.setShaderTexture(1, 0);
    }

    public static void setupLevelDiffuseLighting(class_1160 class_11602, class_1160 class_11603, class_1159 class_11592) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.setupLevelDiffuseLighting(class_11602, class_11603, class_11592);
    }

    public static void setupGuiFlatDiffuseLighting(class_1160 class_11602, class_1160 class_11603) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.setupGuiFlatDiffuseLighting(class_11602, class_11603);
    }

    public static void setupGui3DDiffuseLighting(class_1160 class_11602, class_1160 class_11603) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.setupGui3DDiffuseLighting(class_11602, class_11603);
    }

    public static void beginInitialization() {
        isInInit = true;
    }

    public static void finishInitialization() {
        isInInit = false;
        if (!recordingQueue.isEmpty()) {
            RenderSystem.replayQueue();
        }
        if (!recordingQueue.isEmpty()) {
            throw new IllegalStateException("Recorded to render queue during initialization");
        }
    }

    public static void glGenBuffers(Consumer<Integer> consumer) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> consumer.accept(GlStateManager._glGenBuffers()));
        } else {
            consumer.accept(GlStateManager._glGenBuffers());
        }
    }

    public static void glGenVertexArrays(Consumer<Integer> consumer) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> consumer.accept(GlStateManager._glGenVertexArrays()));
        } else {
            consumer.accept(GlStateManager._glGenVertexArrays());
        }
    }

    public static class_289 renderThreadTesselator() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return RENDER_THREAD_TESSELATOR;
    }

    public static void defaultBlendFunc() {
        RenderSystem.blendFuncSeparate(GlStateManager.class_4535.SRC_ALPHA, GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, GlStateManager.class_4535.ONE, GlStateManager.class_4534.ZERO);
    }

    @Deprecated
    public static void runAsFancy(Runnable runnable) {
        boolean bl = class_310.method_29611();
        if (!bl) {
            runnable.run();
            return;
        }
        class_315 \u00e2\u02dc\u01922 = class_310.method_1551().field_1690;
        class_5365 \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.field_25444;
        \u00e2\u02dc\u01922.field_25444 = class_5365.field_25428;
        runnable.run();
        \u00e2\u02dc\u01922.field_25444 = \u00e2\u02dc\u01923;
    }

    public static void setShader(Supplier<class_5944> supplier) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shader = (class_5944)supplier.get();
            });
        } else {
            shader = supplier.get();
        }
    }

    @Nullable
    public static class_5944 getShader() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shader;
    }

    public static int getTextureId(int n) {
        return GlStateManager._getTextureId(n);
    }

    public static void setShaderTexture(int n, class_2960 class_29602) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._setShaderTexture(n, class_29602));
        } else {
            RenderSystem._setShaderTexture(n, class_29602);
        }
    }

    public static void _setShaderTexture(int n, class_2960 class_29602) {
        if (n >= 0 && n < shaderTextures.length) {
            class_1060 class_10602 = class_310.method_1551().method_1531();
            class_1044 \u00e2\u02dc\u01922 = class_10602.method_4619(class_29602);
            RenderSystem.shaderTextures[n] = \u00e2\u02dc\u01922.method_4624();
        }
    }

    public static void setShaderTexture(int n, int n2) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._setShaderTexture(n, n2));
        } else {
            RenderSystem._setShaderTexture(n, n2);
        }
    }

    public static void _setShaderTexture(int n, int n2) {
        if (n >= 0 && n < shaderTextures.length) {
            RenderSystem.shaderTextures[n] = n2;
        }
    }

    public static int getShaderTexture(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (n >= 0 && n < shaderTextures.length) {
            return shaderTextures[n];
        }
        return 0;
    }

    public static void setProjectionMatrix(class_1159 class_11592) {
        \u00e2\u02dc\u0192 = class_11592.method_22673();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                projectionMatrix = \u00e2\u02dc\u0192;
            });
        } else {
            projectionMatrix = \u00e2\u02dc\u0192;
        }
    }

    public static void setTextureMatrix(class_1159 class_11592) {
        \u00e2\u02dc\u0192 = class_11592.method_22673();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                textureMatrix = \u00e2\u02dc\u0192;
            });
        } else {
            textureMatrix = \u00e2\u02dc\u0192;
        }
    }

    public static void resetTextureMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> textureMatrix.method_22668());
        } else {
            textureMatrix.method_22668();
        }
    }

    public static void applyModelViewMatrix() {
        class_1159 class_11592 = modelViewStack.method_23760().method_23761().method_22673();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                modelViewMatrix = class_11592;
            });
        } else {
            modelViewMatrix = class_11592;
        }
    }

    public static void backupProjectionMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._backupProjectionMatrix());
        } else {
            RenderSystem._backupProjectionMatrix();
        }
    }

    private static void _backupProjectionMatrix() {
        savedProjectionMatrix = projectionMatrix;
    }

    public static void restoreProjectionMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._restoreProjectionMatrix());
        } else {
            RenderSystem._restoreProjectionMatrix();
        }
    }

    private static void _restoreProjectionMatrix() {
        projectionMatrix = savedProjectionMatrix;
    }

    public static class_1159 getProjectionMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return projectionMatrix;
    }

    public static class_1159 getModelViewMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return modelViewMatrix;
    }

    public static class_4587 getModelViewStack() {
        return modelViewStack;
    }

    public static class_1159 getTextureMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return textureMatrix;
    }

    public static class_5590 getSequentialBuffer(class_293.class_5596 class_55962, int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        class_5590 class_55902 = class_55962 == class_293.class_5596.field_27382 ? sharedSequentialQuad : (class_55962 == class_293.class_5596.field_27377 ? sharedSequentialLines : sharedSequential);
        class_55902.method_31920(n);
        return class_55902;
    }

    public static void setShaderGameTime(long l, float f) {
        \u00e2\u02dc\u0192 = ((float)(l % 24000L) + f) / 24000.0f;
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shaderGameTime = \u00e2\u02dc\u0192;
            });
        } else {
            shaderGameTime = \u00e2\u02dc\u0192;
        }
    }

    public static float getShaderGameTime() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shaderGameTime;
    }

    private static /* synthetic */ void lambda$setupGui3DDiffuseLighting$57(class_1160 class_11602, class_1160 class_11603) {
        GlStateManager.setupGui3DDiffuseLighting(class_11602, class_11603);
    }

    private static /* synthetic */ void lambda$setupGuiFlatDiffuseLighting$56(class_1160 class_11602, class_1160 class_11603) {
        GlStateManager.setupGuiFlatDiffuseLighting(class_11602, class_11603);
    }

    private static /* synthetic */ void lambda$setupLevelDiffuseLighting$55(class_1160 class_11602, class_1160 class_11603, class_1159 class_11592) {
        GlStateManager.setupLevelDiffuseLighting(class_11602, class_11603, class_11592);
    }

    private static /* synthetic */ void lambda$teardownOverlayColor$54() {
        RenderSystem.setShaderTexture(1, 0);
    }

    private static /* synthetic */ void lambda$setupOverlayColor$53(IntSupplier intSupplier) {
        int n = intSupplier.getAsInt();
        RenderSystem.setShaderTexture(1, n);
    }

    private static /* synthetic */ void lambda$glUniformMatrix4$52(int n, boolean bl, FloatBuffer floatBuffer) {
        GlStateManager._glUniformMatrix4(n, bl, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniformMatrix3$51(int n, boolean bl, FloatBuffer floatBuffer) {
        GlStateManager._glUniformMatrix3(n, bl, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniformMatrix2$50(int n, boolean bl, FloatBuffer floatBuffer) {
        GlStateManager._glUniformMatrix2(n, bl, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform4$49(int n, FloatBuffer floatBuffer) {
        GlStateManager._glUniform4(n, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform3$48(int n, FloatBuffer floatBuffer) {
        GlStateManager._glUniform3(n, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform2$47(int n, FloatBuffer floatBuffer) {
        GlStateManager._glUniform2(n, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform1$46(int n, FloatBuffer floatBuffer) {
        GlStateManager._glUniform1(n, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform4$45(int n, IntBuffer intBuffer) {
        GlStateManager._glUniform4(n, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform3$44(int n, IntBuffer intBuffer) {
        GlStateManager._glUniform3(n, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform2$43(int n, IntBuffer intBuffer) {
        GlStateManager._glUniform2(n, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform1$42(int n, IntBuffer intBuffer) {
        GlStateManager._glUniform1(n, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform1i$41(int n, int n2) {
        GlStateManager._glUniform1i(n, n2);
    }

    private static /* synthetic */ void lambda$glDeleteVertexArrays$40(int n) {
        GlStateManager._glDeleteVertexArrays(n);
    }

    private static /* synthetic */ void lambda$glDeleteBuffers$39(int n) {
        GlStateManager._glDeleteBuffers(n);
    }

    private static /* synthetic */ void lambda$glBindVertexArray$38(Supplier supplier) {
        GlStateManager._glBindVertexArray((Integer)supplier.get());
    }

    private static /* synthetic */ void lambda$glBindBuffer$37(int n, IntSupplier intSupplier) {
        GlStateManager._glBindBuffer(n, intSupplier.getAsInt());
    }

    private static /* synthetic */ void lambda$renderCrosshair$36(int n) {
        GLX._renderCrosshair(n, true, true, true);
    }

    private static /* synthetic */ void lambda$getString$35(int n, Consumer consumer) {
        String string = GlStateManager._getString(n);
        consumer.accept(string);
    }

    private static /* synthetic */ void lambda$readPixels$34(int n, int n2, int n3, int n4, int n5, int n6, ByteBuffer byteBuffer) {
        GlStateManager._readPixels(n, n2, n3, n4, n5, n6, byteBuffer);
    }

    private static /* synthetic */ void lambda$pixelStore$33(int n, int n2) {
        GlStateManager._pixelStore(n, n2);
    }

    private static /* synthetic */ void lambda$drawElements$31(int n, int n2, int n3) {
        GlStateManager._drawElements(n, n2, n3, 0L);
    }

    private static /* synthetic */ void lambda$setShaderLights$29(class_1160 class_11602, class_1160 class_11603) {
        RenderSystem._setShaderLights(class_11602, class_11603);
    }

    private static /* synthetic */ void lambda$setShaderFogColor$28(float f, float f2, float f3, float f4) {
        RenderSystem._setShaderFogColor(f, f2, f3, f4);
    }

    private static /* synthetic */ void lambda$setShaderFogEnd$27(float f) {
        RenderSystem._setShaderFogEnd(f);
    }

    private static /* synthetic */ void lambda$setShaderFogStart$26(float f) {
        RenderSystem._setShaderFogStart(f);
    }

    private static /* synthetic */ void lambda$clear$25(int n, boolean bl) {
        GlStateManager._clear(n, bl);
    }

    private static /* synthetic */ void lambda$clearStencil$24(int n) {
        GlStateManager._clearStencil(n);
    }

    private static /* synthetic */ void lambda$clearColor$23(float f, float f2, float f3, float f4) {
        GlStateManager._clearColor(f, f2, f3, f4);
    }

    private static /* synthetic */ void lambda$clearDepth$22(double d) {
        GlStateManager._clearDepth(d);
    }

    private static /* synthetic */ void lambda$stencilOp$21(int n, int n2, int n3) {
        GlStateManager._stencilOp(n, n2, n3);
    }

    private static /* synthetic */ void lambda$stencilMask$20(int n) {
        GlStateManager._stencilMask(n);
    }

    private static /* synthetic */ void lambda$stencilFunc$19(int n, int n2, int n3) {
        GlStateManager._stencilFunc(n, n2, n3);
    }

    private static /* synthetic */ void lambda$colorMask$18(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        GlStateManager._colorMask(bl, bl2, bl3, bl4);
    }

    private static /* synthetic */ void lambda$viewport$17(int n, int n2, int n3, int n4) {
        GlStateManager._viewport(n, n2, n3, n4);
    }

    private static /* synthetic */ void lambda$bindTexture$16(int n) {
        GlStateManager._bindTexture(n);
    }

    private static /* synthetic */ void lambda$deleteTexture$15(int n) {
        GlStateManager._deleteTexture(n);
    }

    private static /* synthetic */ void lambda$texParameter$14(int n, int n2, int n3) {
        GlStateManager._texParameter(n, n2, n3);
    }

    private static /* synthetic */ void lambda$activeTexture$13(int n) {
        GlStateManager._activeTexture(n);
    }

    private static /* synthetic */ void lambda$logicOp$12(GlStateManager.class_1030 class_10302) {
        GlStateManager._logicOp(class_10302.field_5108);
    }

    private static /* synthetic */ void lambda$polygonOffset$11(float f, float f2) {
        GlStateManager._polygonOffset(f, f2);
    }

    private static /* synthetic */ void lambda$polygonMode$10(int n, int n2) {
        GlStateManager._polygonMode(n, n2);
    }

    private static /* synthetic */ void lambda$blendEquation$9(int n) {
        GlStateManager._blendEquation(n);
    }

    private static /* synthetic */ void lambda$blendFuncSeparate$8(int n, int n2, int n3, int n4) {
        GlStateManager._blendFuncSeparate(n, n2, n3, n4);
    }

    private static /* synthetic */ void lambda$blendFuncSeparate$7(GlStateManager.class_4535 class_45352, GlStateManager.class_4534 class_45342, GlStateManager.class_4535 class_45353, GlStateManager.class_4534 class_45343) {
        GlStateManager._blendFuncSeparate(class_45352.value, class_45342.value, class_45353.value, class_45343.value);
    }

    private static /* synthetic */ void lambda$blendFunc$6(int n, int n2) {
        GlStateManager._blendFunc(n, n2);
    }

    private static /* synthetic */ void lambda$blendFunc$5(GlStateManager.class_4535 class_45352, GlStateManager.class_4534 class_45342) {
        GlStateManager._blendFunc(class_45352.value, class_45342.value);
    }

    private static /* synthetic */ void lambda$depthMask$4(boolean bl) {
        GlStateManager._depthMask(bl);
    }

    private static /* synthetic */ void lambda$depthFunc$3(int n) {
        GlStateManager._depthFunc(n);
    }

    private static /* synthetic */ void lambda$enableScissor$2(int n, int n2, int n3, int n4) {
        GlStateManager._enableScissorTest();
        GlStateManager._scissorBox(n, n2, n3, n4);
    }

    static {
        MAX_SUPPORTED_TEXTURE_SIZE = -1;
        lastDrawTime = Double.MIN_VALUE;
        sharedSequential = new class_5590(1, 1, java.util.function.IntConsumer::accept);
        sharedSequentialQuad = new class_5590(4, 6, (intConsumer, n) -> {
            intConsumer.accept(n + 0);
            intConsumer.accept(n + 1);
            intConsumer.accept(n + 2);
            intConsumer.accept(n + 2);
            intConsumer.accept(n + 3);
            intConsumer.accept(n + 0);
        });
        sharedSequentialLines = new class_5590(4, 6, (intConsumer, n) -> {
            intConsumer.accept(n + 0);
            intConsumer.accept(n + 1);
            intConsumer.accept(n + 2);
            intConsumer.accept(n + 3);
            intConsumer.accept(n + 2);
            intConsumer.accept(n + 1);
        });
        projectionMatrix = new class_1159();
        savedProjectionMatrix = new class_1159();
        modelViewStack = new class_4587();
        modelViewMatrix = new class_1159();
        textureMatrix = new class_1159();
        shaderTextures = new int[12];
        shaderColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        shaderFogEnd = 1.0f;
        shaderFogColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        shaderLightDirections = new class_1160[2];
        shaderLineWidth = 1.0f;
        projectionMatrix.method_22668();
        savedProjectionMatrix.method_22668();
        modelViewMatrix.method_22668();
        textureMatrix.method_22668();
    }

    public static final class class_5590 {
        private final int field_27332;
        private final int field_27333;
        private final class_5591 field_27334;
        private int field_27335;
        private class_293.class_5595 field_27336 = class_293.class_5595.field_27371;
        private int field_27337;

        class_5590(int n, int n2, class_5591 class_55912) {
            this.field_27332 = n;
            this.field_27333 = n2;
            this.field_27334 = class_55912;
        }

        void method_31920(int n2) {
            int n2;
            if (n2 <= this.field_27337) {
                return;
            }
            n2 = class_3532.method_28139(n2 * 2, this.field_27333);
            LOGGER.debug("Growing IndexBuffer: Old limit {}, new limit {}.", (Object)this.field_27337, (Object)n2);
            if (this.field_27335 == 0) {
                this.field_27335 = GlStateManager._glGenBuffers();
            }
            class_293.class_5595 class_55952 = class_293.class_5595.method_31972(n2);
            int \u00e2\u02dc\u01922 = class_3532.method_28139(n2 * class_55952.field_27375, 4);
            GlStateManager._glBindBuffer(34963, this.field_27335);
            GlStateManager._glBufferData(34963, \u00e2\u02dc\u01922, 35048);
            ByteBuffer \u00e2\u02dc\u01923 = GlStateManager._glMapBuffer(34963, 35001);
            if (\u00e2\u02dc\u01923 == null) {
                throw new RuntimeException("Failed to map GL buffer");
            }
            this.field_27336 = class_55952;
            IntConsumer \u00e2\u02dc\u01924 = this.method_31922(\u00e2\u02dc\u01923);
            for (int i = 0; i < n2; i += this.field_27333) {
                this.field_27334.accept(\u00e2\u02dc\u01924, i * this.field_27332 / this.field_27333);
            }
            GlStateManager._glUnmapBuffer(34963);
            GlStateManager._glBindBuffer(34963, 0);
            this.field_27337 = n2;
            class_286.method_34423();
        }

        private IntConsumer method_31922(ByteBuffer byteBuffer) {
            switch (this.field_27336) {
                case field_27371: {
                    return n -> byteBuffer.put((byte)n);
                }
                case field_27372: {
                    return n -> byteBuffer.putShort((short)n);
                }
            }
            return byteBuffer::putInt;
        }

        public int method_31919() {
            return this.field_27335;
        }

        public class_293.class_5595 method_31924() {
            return this.field_27336;
        }

        static interface class_5591 {
            public void accept(IntConsumer var1, int var2);
        }
    }
}

